/*
SimuLab
Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package simu;

import java.util.Vector;


/**
 * Gestion du temps.
 */
public class Chronos implements Runnable {
    
    Thread thr = null;
    SimuApplet applet;
    TypeAffichage typeAff;
    ListeValeurs in;
    boolean boucle;
    
    public Chronos(SimuApplet applet, TypeAffichage typeAff, boolean boucle) {
        this.applet = applet;
        this.typeAff = typeAff;
        this.boucle = boucle;
    }
    
    public void initCalculLive(ListeValeurs in) throws SimuException {
        this.in = in;
        applet.params.initCalculLive(in);
    }
    
    public void start() {
        if (thr == null) {
            thr = new Thread(this);
            thr.start();
        }
    }

    public void stop() {
        if (thr != null) {
            Thread thr2 = thr;
            thr = null;
            try {
                thr2.join();
            } catch (InterruptedException ex) {
            }
        }
    }
    
    public void fin() {
        if (thr != null)
            thr = null;
        typeAff.fin();
    }
    
    public void recopie(ListeValeurs out) throws SimuException {
        ListeValeurs in2 = new ListeValeurs();
        Vector vin = in.noms();
        for (int i=0; i<vin.size(); i++) {
            String nom = (String)vin.elementAt(i);
            String vout = null;
            try {
                vout = out.lireString(nom);
            } catch (SimuException ex) {
            }
            String v2;
            if (vout != null)
                v2 = vout;
            else
                v2 = in.lireString(nom);
            in2.ajouterString(nom, v2);
        }
        in = in2;
    }
    
    public void run() {
        Thread threadcourant=Thread.currentThread();
        try {
            boolean simu = true;
            while (thr==threadcourant && simu) {
                ListeValeurs out = applet.params.calculLive();
                String sfin = null;
                if (out != null) {
                    try {
                        sfin = out.lireString("fin");
                    } catch (Exception ex) {
                    }
                }
                if (out == null || "simulation".equals(sfin)) {
                    fin();
                    simu = false;
                } else if ("trajectoire".equals(sfin)) {
                    if (boucle)
                        recopie(out);
                    applet.params.initCalculLive(in);
                    typeAff.avantLancement();
                    threadcourant.yield();
                } else if ("courbe".equals(sfin)) {
                    typeAff.update(out);
                    typeAff.avantLancement();
                    threadcourant.yield();
                } else {
                    typeAff.update(out);
                    threadcourant.yield();
                }
            }
            if (boucle)
                applet.changerValeurs(in);
        }  catch (SimuException ex) {
                System.err.println("SimuException: " + ex.getMessage());
        }
    }
}
