/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package simu;

import java.awt.image.IndexColorModel;
import java.util.Vector;

/**
 * une possibilit d'affichage des rsultats, avec diverses options
 */
public class Affichage {
    /** type d'affichage (plot | plotlive | image | tableau | multiplot) */
    public String type;
    
    /** titre affich */
    public String titre;
    
    /** nom de l'affichage, optionnel mais utile pour l'identifier */
    public String label;
    
    /**
     * liste des noms des paramtres de sortie utiliss pour les diffrents
     * tracs de la sortie graphique
     */
    public String[][] params;
    
    /** abscisse de dbut de l'affichage */
    public String xdebut = null;
    
    /** abscisse de fin de l'affichage */
    public String xfin = null;
    
    /** ordonne de dbut de l'affichage */
    public String ydebut = null;
    
    /** ordonne de fin de l'affichage */
    public String yfin = null;
    
    /** chelle logarithmique pour les abcisses d'un graphe */
    public boolean xlog = false;
    
    /** chelle logarithmique pour les ordonnes d'un graphe */
    public boolean ylog = false;
    
    /** nom du fichier image  mettre en fond d'un graphe, au format GIF */
    public String fond = null;
    
    /** abscisse de dbut de l'image de fond */
    public String xdebutfond = null;
    
    /** abscisse de fin de l'image de fond */
    public String xfinfond = null;
    
    /** ordonne de dbut de l'image de fond */
    public String ydebutfond = null;
    
    /** ordonne de fin de l'image de fond */
    public String yfinfond = null;
    
    /**
     * option de zoom de l'image de fond.
     * La valeur par dfaut est false : il n'y a pas de zoom de l'image de fond.
     * Mettre  true dans la classe de la simulation pour permettre un zoom
     * de l'image de fond
     */
    public boolean zooming=false;

    /** dimension x de l'image pour AffImage */
    public int imgdimx = 100;
    
    /** dimension y de l'image pour AffImage */
    public int imgdimy = 100;
    
    /** palette de couleurs pour AffImage */
    public IndexColorModel palette = null;
    
    /** option pour connecter les points d'un graphe */
    public boolean connecter = false;
    
    /** sous-affichages pour afficher plusieurs plotlive en mme temps */
    public Affichage[] sousAff = null;
    
    /** ordre dans lequel les sous-affichages sont affichs. Valeurs possibles: "x" ou "y". Dfaut: "x"
        qui signifie de la gauche vers la droite puis de haut en bas. S'il y a deux affichages, ils seront
        cte  cte avec "x", et l'un au-dessus de l'autre avec "y". */
    public String ordreSousAff = "x";
    
    /**
     * Option de recopie des valeurs de sortie vers les valeurs d'entre.
     * Valeur par dfaut: false.
     * Quand cette option est active, les nouvelles valeurs d'entre aprs
     * l'affichage d'une trajectoire dans plotlive prennent les valeurs des
     * paramtres de sortie correspondants aprs le calcul.
     */
     public boolean boucle = false;
     
     /**
      * Affichage des points d'un graphe: "none", "points", "dots", ou "various".
      * Dfaut : "points"
      */
     public String points = "points";
     
     /**
      * Utilisation de couleurs pour tracer les courbes des graphes.
      * true (activ) par dfaut.
      */
     public boolean couleurs = true;
     
     /**
      * Pour afficher un histogramme
      */
     public boolean histogramme = false;
     
     /**
      * Pour effacer le graphique automatiquement  chaque fois
      */
     public boolean effacer = false;
     
     /**
      * Pour ajuster le graphique automatiquement  chaque fois
      */
     public boolean ajuster = false;
     
     /**
      * Pour recadrer le graphique  chaque fois  partir des valeur xmin... de l'affichage
      */
     public boolean recadrer = false;
     
     /**
      * Pour obtenir une zone carre pour un graphe
      */
     public boolean carre = false;
}
