/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package simu;

import java.awt.*;
import java.applet.*;
import java.util.Vector;
import COM.Subrahmanyam.table.*;

/**
 * Affichage d'un tableau  partir d'un ensemble de points, dont la position est
 * calcule avec un appel  SimuParams.calcul().
 */
public class AffPlotTab extends TypeAffichage {

    Affichage aff;
    Vector outp;
    SimuApplet applet;
    Table table;
    boolean sousaff;

    public AffPlotTab(SimuApplet applet, Affichage aff, boolean sousaff) {
        this.applet = applet;
        this.aff = aff;
        this.sousaff = sousaff;
    }
    
    public Panel initPanel(Vector outp) throws SimuException {
        table = new Table();
        table.setSize(400,300);
        table.showHorizontalSeparator(true);
        table.showVerticalSeparator(true);
        table.setHiliteMode(Table.HILITE_ROW);
        table.setClickMode(Table.DOUBLE_CLICK);
        table.setColors(Color.black, new Color((float)1.0,(float)1.0,(float)0.6),
            Color.black, Color.white,
            Color.black, new Color((float)0.6,(float)1.0,(float)0.6));
        return(table);
    }
    
    public boolean estLive() {
        return(false);
    }
    
    public void avantLancement() {
        table.clearAll();
    }
    
    public void affiche(ListeValeurs in, Vector outp) throws SimuException {
        this.outp = outp;
        
        avantLancement();
        
        ListeValeurs out = applet.params.calcul(in);
        update(out);
    }
    
    public void update(ListeValeurs out) throws SimuException {
        if (aff.params == null) {
            System.err.println(Messages.get("aucun_parametre_tableau"));
            return;
        }
        for (int ip=0; ip<aff.params[0].length; ip++) {
            String lp = aff.params[0][ip];
            for (int i=0; i<outp.size(); i++) {
                ParamOut par = (ParamOut)outp.elementAt(i);
                if (lp.equals(par.label)) {
                    Object o = out.lire(par.label);
                    if (o instanceof Vector) {
                        Vector outx = (Vector)o;
                        String[] valeurs = new String[outx.size()];
                        for (int j=0; j<outx.size(); j++) {
                            Object o2 = (Object)outx.elementAt(j);
                            if (o2 instanceof Double)
                                valeurs[j] = joliFormattage(((Double)o2).doubleValue(), 8);
                            else
                                valeurs[j] = o2.toString();
                        }
                        table.addColumn(par.label, valeurs);
                    } else {
                        String[] valeurs = new String[1];
                        valeurs[0] = o.toString();
                        table.addColumn(par.label, valeurs);
                    }
                }
            }
        }
    }
    
    public String joliFormattage(double d, int precision) {
        double facteur_precision = Math.pow(10, precision);
        int exposant = (int)Math.floor(Math.log(Math.abs(d))/Math.log(10));
        double mantisse = d / (Math.pow(10,exposant));
        String s;
        if (exposant == 0) {
            mantisse = Math.round(mantisse*facteur_precision)/facteur_precision;
            s = ""+mantisse;
        } else if (exposant == 1) {
            mantisse = Math.round(mantisse*facteur_precision)/(facteur_precision/10);
            s = ""+mantisse;
        } else if (exposant == -1) {
            String signe;
            if (mantisse < 0)
                signe = "-";
            else
                signe = "";
            mantisse = Math.abs(Math.round(mantisse*facteur_precision));
            s = signe + "0."+(int)mantisse;
        } else {
            mantisse = Math.round(mantisse*facteur_precision)/facteur_precision;
            s = mantisse + "E" + exposant;
        }
        return(s);
    }
    
}
