/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package simu;

import java.awt.*;
import java.awt.event.*;
import java.util.Vector;
import ptolemy.plot.*;

/**
 * Affichage d'un ensemble de PlotLive, calculs simultanment. Appelle
 * SimuParams.initCalculLive() au dbut, puis SimuParams.calculLive()  chaque
 * itration.
 */
public class AffPlotLive extends TypeAffichage implements ActionListener {

    SimuPlot plot;
    SimuApplet applet;
    Affichage aff;
    Vector outp;
    int nd; // numro dataset, pour changer la couleur quand aff.params.length = 1
    boolean couleurs;
    boolean appel1;// pour viter que le dernier point d'1 trajectoire se connecte avec le premier de la trajectoire suivante
    Label info;
    Button bstop;
    Button bstart;
    Chronos chrono;
    boolean sousaff;

    public AffPlotLive(SimuApplet applet, Affichage aff, boolean sousaff) {
        this.applet = applet;
        this.aff = aff;
        this.sousaff = sousaff;
        nd = -1;
    }
    
    public Panel initPanel(Vector outp) throws SimuException {
        this.outp = outp;
        
        Panel pc = new Panel(new BorderLayout()); // boutons + plots + info
        if (plot == null)
            plot = new SimuPlot(applet, aff);
        pc.add(BorderLayout.CENTER, plot);
        
        boolean avecinfo = false;
        for (int i=0; i<outp.size(); i++) {
            ParamOut par = (ParamOut)outp.elementAt(i);
            if ("string".equals(par.type))
                avecinfo = true;
        }
        if (avecinfo) {
            info = new Label(" ");
            pc.add(BorderLayout.SOUTH, info);
        } else
            info = null;
        
        initPlot();
        
        if (!sousaff)
            ajouterBoutons(pc);
        
        if (aff.params.length == 1)
            couleurs = true;
        else
            couleurs = false;
        
        return(pc);
    }
    
    public boolean estLive() {
        return(true);
    }
    
    public void setChronos(Chronos chrono) {
        this.chrono = chrono;
    }
    
    public void affiche(ListeValeurs in, Vector outp) throws SimuException {
        this.outp = outp;
        
        avantLancement();
        
        start();
    }
    
    public void avantLancement() {
        appel1 = true;
        
        if (couleurs) {
            nd++;
            plot.setConnected(aff.connecter, nd);
            plot.setMarksStyle(aff.points, nd);
        }
    }
    
    protected void initPlot() {
        String[] titres = applet.titresAxes(aff, outp);
        plot.setButtons(false);
        //plot.setVisible(true);
        
        //plot.setSize(400, 300);
        /*int nbplotsx, nbplotsy;
        nbplotsx = (int)Math.ceil(Math.sqrt(plots.length));
        if (nbplotsx*(nbplotsx-1) < plots.length)
            nbplotsy = nbplotsx;
        else
            nbplotsy = nbplotsx - 1;
        Dimension appsize = applet.getSize();
        plot.setSize((appsize.width - 250) / nbplotsx,
            (appsize.height - 100) / nbplotsy);
        */ // utilisation d'un GridLayout  la place du FlowLayout
        
        if (aff.ydebut != null && aff.yfin != null)
            plot.setYRange(SimuApplet.getDouble(aff.ydebut), SimuApplet.getDouble(aff.yfin));
        else
            plot.setYRange(0,10);
        if (aff.xdebut != null && aff.xfin != null)
            plot.setXRange(SimuApplet.getDouble(aff.xdebut), SimuApplet.getDouble(aff.xfin));
        else
            plot.setXRange(0,10);
        
        plot.setTitle(aff.titre);
        plot.setXLabel(titres[0]);
        plot.setYLabel(titres[1]);
        plot.setConnected(aff.connecter);
        plot.setColor(aff.couleurs);
        if (aff.histogramme) {
            plot.setMarksStyle("none");
            plot.setBars(true);
        } else
            plot.setMarksStyle(aff.points);
    }
    
    protected void ajouterBoutons(Panel p) {
        Panel bpan = new Panel();
        bpan.setLayout(new FlowLayout());
        bstart = new Button(Messages.get("continuer"));
        bstart.setActionCommand("start");
        bstart.addActionListener(this);
        bpan.add(bstart);
        bstop = new Button(Messages.get("stop"));
        bstop.setActionCommand("stop");
        bstop.addActionListener(this);
        bpan.add(bstop);
        Button bouton = new Button(Messages.get("ajuster"));
        bouton.setActionCommand("ajuster");
        bouton.addActionListener(this);
        bpan.add(bouton);
        bouton = new Button(Messages.get("effacer"));
        bouton.setActionCommand("effacer");
        bouton.addActionListener(this);
        bpan.add(bouton);
        p.add(BorderLayout.NORTH, bpan);
    }
    
    public void start() {
        bstop.setEnabled(true);
        bstart.setEnabled(false);
        chrono.start();
    }
    
    public void stop() {
        if (bstop != null)
            bstop.setEnabled(false);
        if (bstart != null)
            bstart.setEnabled(true);
        if (chrono != null)
            chrono.stop();
    }
    
    public void fin() {
        bstop.setEnabled(false);
        bstart.setEnabled(false);
    }
    
    public void update(ListeValeurs out) throws SimuException {
        if (aff.effacer)
            effacer();
        for (int ip=0; ip<aff.params.length; ip++) {
            if (!couleurs)
                nd = ip;
            String sx = aff.params[ip][0];
            String sy = aff.params[ip][1];
            double x=0,y=0;
            Vector vx = null; // pour permettre l'envoi de plusieurs valeurs d'un coup
            Vector vy = null;
            for (int i=0; i<outp.size(); i++) {
                ParamOut par = (ParamOut)outp.elementAt(i);
                Object o = out.lire(par.label);
                if (o instanceof Double) {
                    double d;
                    Double dd = (Double)o;
                    d = dd.doubleValue();
                    if (sx.equals(par.label))
                        x = d;
                    else if (sy.equals(par.label))
                        y = d;
                } else if (o instanceof Vector) {
                    if (sx.equals(par.label))
                        vx = (Vector)o;
                    else if (sy.equals(par.label))
                        vy = (Vector)o;
                } else if (!sousaff && o instanceof String && info != null) {
                    if (!o.equals(info.getText()))
                        info.setText((String)o);
                    // gros pb avec Safari : cela cause un repaint de tout le graphe !
                } else if (o == null) {
                    //throw new SimuException("Paramtre non spcifi: " + par.label);
                }// else
                 //   throw new SimuException("AffPlotLive n'accepte que des double comme valeurs " +
                 //       "de paramtres de sortie");
            }
            if (vx != null && vy != null) { // cas avec plusieurs points affichs d'un coup
                if (vx.size() != vy.size())
                    throw new SimuException(Messages.get("meme_nombre"));
                for (int i=0; i<vx.size(); i++) {
                    x = ((Double)vx.elementAt(i)).doubleValue();
                    y = ((Double)vy.elementAt(i)).doubleValue();
                    boolean connection = aff.connecter && (!appel1 || i > 0);
                    plot.addPoint(nd, x, y, connection);
                }
            } else
                plot.addPoint(nd, x, y, aff.connecter && !appel1);
        }
        if (aff.ajuster)
            ajuster();
        else if (aff.recadrer) {
            if (aff.ydebut != null && aff.yfin != null)
                plot.setYRange(SimuApplet.getDouble(aff.ydebut), SimuApplet.getDouble(aff.yfin));
            if (aff.xdebut != null && aff.xfin != null)
                plot.setXRange(SimuApplet.getDouble(aff.xdebut), SimuApplet.getDouble(aff.xfin));
        }
        appel1 = false;
    }
    
    public void effacer() {
        plot.clear(false);
        plot.repaint();
    }
    
    public void ajuster() {
        plot.fillPlot();
    }
    
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("start"))
            start();
        else if (cmd.equals("stop"))
            stop();
        else if (cmd.equals("ajuster"))
            ajuster();
        else if (cmd.equals("effacer"))
            effacer();
    }
}
