/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package simu;

import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.util.Vector;
import ptolemy.plot.*;

/**
 * Affichage d'un graphe  partir d'un ensemble de points.
 * Appelle SimuParams.calcul() au dbut pour le calcul des positions des points.
 */
public class AffPlot extends TypeAffichage implements ActionListener {

    SimuPlot plot;
    SimuApplet applet;
    Vector outp;
    Affichage aff;
    int nd; // numro dataset, pour changer la couleur quand aff.params.length = 1 et !effacer
    Label info;
    boolean sousaff;

    public AffPlot(SimuApplet applet, Affichage aff, boolean sousaff) {
        this.applet = applet;
        this.aff = aff;
        this.sousaff = sousaff;
        nd = -1;
    }
    
    public Panel initPanel(Vector outp) throws SimuException {
        this.outp = outp;
        
        Panel pc = new Panel(new BorderLayout());
        
        plot = new SimuPlot(applet, aff);
        pc.add(BorderLayout.CENTER, plot);

        boolean avecinfo = false;
        for (int i=0; i<outp.size(); i++) {
            ParamOut par = (ParamOut)outp.elementAt(i);
            if ("string".equals(par.type))
                avecinfo = true;
        }
        if (avecinfo) {
            info = new Label(" ");
            pc.add(BorderLayout.SOUTH, info);
        } else
            info = null;
        
        initPlot();
        
        if (!sousaff)
            ajouterBoutons(pc);
        
        return(pc);
    }
    
    public boolean estLive() {
        return(false);
    }
    
    public void affiche(ListeValeurs in, Vector outp) throws SimuException {
        this.outp = outp;
        
        ListeValeurs out =  applet.params.calcul(in);
        update(out);
    }
    
    public void update(ListeValeurs out) throws SimuException {
        if (aff.effacer) {
            effacer();
            nd = 0;
        } else if (aff.params.length == 1)
            nd++;
        for (int ip=0; ip<aff.params.length; ip++) {
            if (aff.params.length != 1)
                nd = ip;
            String lsx = aff.params[ip][0];
            String lsy = aff.params[ip][1];
            Vector outx=null, outy=null;
            for (int i=0; i<outp.size(); i++) {
                ParamOut par = (ParamOut)outp.elementAt(i);
                if (lsx.equals(par.label)) {
                    Object o = out.lire(par.label);
                    if (o == null)
                        outx = null;
                    else if (o instanceof Vector)
                        outx = (Vector)o;
                    else if (o instanceof Double) {
                        // cas o la courbe est rduite  un point
                        outx = new Vector();
                        outx.addElement(o);
                    } else {
                        outx = null;
                        System.err.println("Type trange pour la coordonne x d'un plot : " + o.getClass().getName());
                    }
                } else if (lsy.equals(par.label)) {
                    Object o = out.lire(par.label);
                    if (o == null)
                        outy = null;
                    else if (o instanceof Vector)
                        outy = (Vector)o;
                    else if (o instanceof Double) {
                        outy = new Vector();
                        outy.addElement(o);
                    } else {
                        outy = null;
                        System.err.println("Type trange pour la coordonne y d'un plot : " + o.getClass().getName());
                    }
                }
                else if (!sousaff && info != null && "string".equals(par.type) &&
                        out.lire(par.label) instanceof String)
                    info.setText((String)out.lire(par.label));
            }
            if (outx == null || outy == null) {
                System.err.println(Messages.get("aucun_resultat"));
                return;
            }
            double x=0,y=0;
            for (int i=0; i<outx.size(); i++) {
                Double dd = (Double)outx.elementAt(i);
                x = dd.doubleValue();
                dd = (Double)outy.elementAt(i);
                y = dd.doubleValue();
                plot.addPoint(nd, x, y, aff.connecter && (i > 0));
            }
        }
        if (aff.ajuster)
            ajuster();
        else if (aff.recadrer) {
            if (aff.ydebut != null && aff.yfin != null)
                plot.setYRange(SimuApplet.getDouble(aff.ydebut), SimuApplet.getDouble(aff.yfin));
            if (aff.xdebut != null && aff.xfin != null)
                plot.setXRange(SimuApplet.getDouble(aff.xdebut), SimuApplet.getDouble(aff.xfin));
        }
    }

    protected void initPlot() {
        String[] titres = applet.titresAxes(aff, outp);
        //plot.setVisible(true);
        plot.setSize(400, 300);
        plot.setTitle(aff.titre);
        if (aff.ydebut != null && aff.yfin != null)
            plot.setYRange(SimuApplet.getDouble(aff.ydebut), SimuApplet.getDouble(aff.yfin));
        else
            plot.setYRange(0,10);
        if (aff.xdebut != null && aff.xfin != null)
            plot.setXRange(SimuApplet.getDouble(aff.xdebut), SimuApplet.getDouble(aff.xfin));
        else
            plot.setXRange(0,10);
        plot.setXLabel(titres[0]);
        plot.setYLabel(titres[1]);
        if (aff.histogramme) {
            plot.setMarksStyle("none");
            plot.setBars(true);
        } else
            plot.setMarksStyle(aff.points);
        plot.setConnected(aff.connecter);
        plot.setColor(aff.couleurs);
    }
    
    protected void ajouterBoutons(Panel p) {
        Panel bpan = new Panel();
        bpan.setLayout(new FlowLayout());
        Button bouton = new Button(Messages.get("ajuster"));
        bouton.setActionCommand("ajuster");
        bouton.addActionListener(this);
        bpan.add(bouton);
        bouton = new Button(Messages.get("effacer"));
        bouton.setActionCommand("effacer");
        bouton.addActionListener(this);
        bpan.add(bouton);
        p.add(BorderLayout.NORTH, bpan);
    }
    
    public void effacer() {
        plot.clear(false);
        plot.repaint();
    }
    
    public void ajuster() {
        plot.fillPlot();
    }
    
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("ajuster"))
            ajuster();
        else if (cmd.equals("effacer"))
            effacer();
    }
}
