/*
SimuLab

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package simu;

import java.awt.*;
import java.awt.event.*;
import java.util.Vector;

/**
 * Affichage d'un ensemble d'affichages, calculs simultanment.
 */
public class AffMulti extends TypeAffichage implements ActionListener {

    TypeAffichage[] typesaff;
    SimuApplet applet;
    Affichage aff;
    Vector outp;
    Label info;
    Button bstop;
    Button bstart;
    Chronos chrono;
    boolean live;
    boolean sousaff;

    public AffMulti(SimuApplet applet, Affichage aff, boolean sousaff) {
        this.applet = applet;
        this.aff = aff;
        this.sousaff = sousaff;
        
        if (aff.sousAff == null)
            System.err.println(Messages.get("multiplot_sans_affichage"));
        
        try {
            if (aff.sousAff == null) {
                typesaff = new TypeAffichage[1];
                typesaff[0] = applet.creationTypeAffichage(aff, true);
            } else {
                typesaff = new TypeAffichage[aff.sousAff.length];
                for (int i=0; i<aff.sousAff.length; i++)
                    typesaff[i] = applet.creationTypeAffichage(aff.sousAff[i], true);
            }
        } catch (SimuException ex) {
            applet.handleException(ex);
        }
        live = false;
        if (aff.sousAff == null)
            live = typesaff[0].estLive();
        else {
            live = false;
            for (int i=0; i<typesaff.length; i++)
                live = live || typesaff[i].estLive();
        }
    }
    
    public boolean estLive() {
        return(live);
    }
    
    public Panel initPanel(Vector outp) throws SimuException {
        this.outp = outp;
        Panel pc = new Panel(new BorderLayout()); // boutons + plots + info
        
        if (aff.sousAff == null)
            pc.add(BorderLayout.CENTER, typesaff[0].initPanel(outp));
        else {
            int nbplotsx, nbplotsy;
            if (!"y".equals(aff.ordreSousAff)) {
                // plus long en x
                nbplotsx = (int)Math.ceil(Math.sqrt(typesaff.length));
                if (nbplotsx*(nbplotsx-1) < typesaff.length)
                    nbplotsy = nbplotsx;
                else
                    nbplotsy = nbplotsx - 1;
            } else {
                nbplotsy = (int)Math.ceil(Math.sqrt(typesaff.length));
                if (nbplotsy*(nbplotsy-1) < typesaff.length)
                    nbplotsx = nbplotsy;
                else
                    nbplotsx = nbplotsy - 1;
            }
            Panel ppane = new Panel(new GridLayout(nbplotsy, nbplotsx));
            for (int i=0; i<typesaff.length; i++)
                ppane.add(typesaff[i].initPanel(outp));
            pc.add(BorderLayout.CENTER, ppane);
        }
        
        boolean avecinfo = false;
        for (int i=0; i<outp.size(); i++) {
            ParamOut par = (ParamOut)outp.elementAt(i);
            if ("string".equals(par.type))
                avecinfo = true;
        }
        if (avecinfo) {
            info = new Label(" ");
            pc.add(BorderLayout.SOUTH, info);
        } else
            info = null;
        
        if (!sousaff)
            ajouterBoutons(pc);
        
        return(pc);
    }
    
    public void setChronos(Chronos chrono) {
        this.chrono = chrono;
    }
    
    public void avantLancement() {
        for (int i=0; i<typesaff.length; i++)
            typesaff[i].avantLancement();
    }
    
    public void affiche(ListeValeurs in, Vector outp) throws SimuException {
        this.outp = outp;
        avantLancement();
        
        if (live)
            start();
        else {
            ListeValeurs out =  applet.params.calcul(in);
            update(out);
        }
    }
    
    protected void ajouterBoutons(Panel p) {
        Panel bpan = new Panel();
        bpan.setLayout(new FlowLayout());
        if (live) {
            bstart = new Button(Messages.get("continuer"));
            bstart.setActionCommand("start");
            bstart.addActionListener(this);
            bpan.add(bstart);
            bstop = new Button(Messages.get("stop"));
            bstop.setActionCommand("stop");
            bstop.addActionListener(this);
            bpan.add(bstop);
        }
        Button bouton = new Button(Messages.get("ajuster"));
        bouton.setActionCommand("ajuster");
        bouton.addActionListener(this);
        bpan.add(bouton);
        bouton = new Button(Messages.get("effacer"));
        bouton.setActionCommand("effacer");
        bouton.addActionListener(this);
        bpan.add(bouton);
        p.add(BorderLayout.NORTH, bpan);
    }
    
    public void start() {
        bstop.setEnabled(true);
        bstart.setEnabled(false);
        if (chrono != null)
            chrono.start();
    }

    public void stop() {
        // bstop et bstart sont null s'il y a eu une erreur dans initCalculLive
        if (bstop != null)
            bstop.setEnabled(false);
        if (bstart != null)
            bstart.setEnabled(true);
        if (chrono != null)
            chrono.stop();
    }
    
    public void fin() {
        bstop.setEnabled(false);
        bstart.setEnabled(false);
        chrono = null;
    }
    
    public void update(ListeValeurs out) throws SimuException {
        for (int i=0; i<typesaff.length; i++)
            typesaff[i].update(out);
        for (int i=0; i<outp.size(); i++) {
            ParamOut par = (ParamOut)outp.elementAt(i);
            Object o = out.lire(par.label);
            if (o instanceof String && info != null) {
                if (!o.equals(info.getText()))
                    info.setText((String)o);
            }
        }
    }
    
    public void effacer() {
        for (int i=0; i<typesaff.length; i++)
            typesaff[i].effacer();
    }
    
    public void ajuster() {
        for (int i=0; i<typesaff.length; i++)
            typesaff[i].ajuster();
    }
    
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("start"))
            start();
        else if (cmd.equals("stop"))
            stop();
        else if (cmd.equals("ajuster"))
            ajuster();
        else if (cmd.equals("effacer"))
            effacer();
    }
}
