/*
SimuApplet

Copyright (C) 2002 Observatoire de Paris-Meudon

Ce programme est un logiciel libre ; vous pouvez le redistribuer et/ou le modifier conformment aux dispositions de la Licence Publique Gnrale GNU, telle que publie par la Free Software Foundation ; version 2 de la licence, ou encore ( votre choix) toute version ultrieure.

Ce programme est distribu dans l'espoir qu'il sera utile, mais SANS AUCUNE GARANTIE ; sans mme la garantie implicite de COMMERCIALISATION ou D'ADAPTATION A UN OBJET PARTICULIER. Pour plus de dtail, voir la Licence Publique Gnrale GNU .

Vous devez avoir reu un exemplaire de la Licence Publique Gnrale GNU en mme temps que ce programme ; si ce n'est pas le cas, crivez  la Free Software Foundation Inc., 675 Mass Ave, Cambridge, MA 02139, Etats-Unis.
*/

package simu;

import java.awt.*;
import java.awt.event.*;
import java.applet.*;
import java.util.Vector;
import java.awt.image.*;

/**
 * Affichage d'une animation. Appelle SimuParams.initCalculLive() au dbut,
 * puis SimuParams.calculLive()  chaque itration. Le paramtre de sortie
 * de l'algorithme doit tre un tableau avec l'intensit des pixels de l'image
 *  chaque itration, ou un tableau avec des entres de la palette de couleurs.
 */
public class AffImage extends TypeAffichage implements ActionListener {

    SimuApplet applet;
    Affichage aff;
    ImageCanvas ic = null;
    Label info;
    Chronos chrono;
    Button bstop;
    Button bstart;
    Vector outp;
    boolean sousaff;
    boolean live;
    Panel pc;

    public AffImage(SimuApplet applet, Affichage aff, boolean sousaff, boolean live) {
        this.applet = applet;
        this.aff = aff;
        this.sousaff = sousaff;
        this.live = live;
    }
    
    public Panel initPanel(Vector outp) throws SimuException {
        this.outp = outp;
        
        pc = new Panel(new BorderLayout());
        if (ic == null)
            ic = new ImageCanvas(aff.imgdimx, aff.imgdimy, aff.palette);
        pc.add(BorderLayout.CENTER, ic);
        
        boolean avecinfo = false;
        for (int i=0; i<outp.size(); i++) {
            ParamOut par = (ParamOut)outp.elementAt(i);
            if ("string".equals(par.type))
                avecinfo = true;
        }
        if (avecinfo) {
            info = new Label(" ");
            pc.add(BorderLayout.SOUTH, info);
        } else
            info = null;

        if (!sousaff && live) {
            Panel bpan = new Panel();
            bpan.setLayout(new FlowLayout());
            bstart = new Button(Messages.get("continuer"));
            bstart.setActionCommand("start");
            bstart.addActionListener(this);
            bpan.add(bstart);
            bstop = new Button(Messages.get("stop"));
            bstop.setActionCommand("stop");
            bstop.addActionListener(this);
            bpan.add(bstop);
            pc.add(BorderLayout.NORTH, bpan);
        }

        return(pc);
    }
    
    public boolean estLive() {
        return(live);
    }
    
    public void setChronos(Chronos chrono) {
        this.chrono = chrono;
    }
    
    public void avantLancement() {
        Dimension vdim = ic.getMinimumSize();
        if (vdim.width != aff.imgdimx || vdim.height != aff.imgdimy) {
            // la dimension de l'image a chang, il faut recrer l'objet et mettre  jour l'affichage
            pc.remove(ic);
            ic = new ImageCanvas(aff.imgdimx, aff.imgdimy, aff.palette);
            pc.add(BorderLayout.CENTER, ic);
            pc.validate();
        }
    }
    
    public void affiche(ListeValeurs in, Vector outp) throws SimuException {
        this.outp = outp;
        avantLancement();
        
        if (live)
            start(); // affichage au fur et  mesure dans l'image
        else {
            ListeValeurs out =  applet.params.calcul(in);
            update(out);
        }
    }
    
    public void start() {
        bstop.setEnabled(true);
        bstart.setEnabled(false);
        chrono.start();
    }

    public void stop() {
        if (bstop != null)
            bstop.setEnabled(false);
        if (bstart != null)
            bstart.setEnabled(true);
        chrono.stop();
    }
    
    public void fin() {
        bstop.setEnabled(false);
        bstart.setEnabled(false);
    }

    public void update(ListeValeurs out) throws SimuException {
        boolean trouve = false;
        for (int ip=0; ip<aff.params[0].length; ip++) {
            String lp = aff.params[0][ip];
            for (int i=0; i<outp.size(); i++) {
                ParamOut par = (ParamOut)outp.elementAt(i);
                if (lp.equals(par.label)) {
                    if ("tableau".equals(par.type)) {
                        Object o = out.lire(par.label);
                        if (o instanceof double[][]) {
                            ic.updateImage((double[][])o);
                            trouve = true;
                        } else
                            throw new SimuException(Messages.get("mauvaise_sortie") + ": " +
                                o.getClass().getName());
                    } else if ("image".equals(par.type)) {
                        Object o = out.lire(par.label);
                        if (o instanceof Image) {
                            ic.updateImage((Image)o);
                            trouve = true;
                        } else
                            throw new SimuException(Messages.get("mauvaise_sortie") + ": " +
                                o.getClass().getName());
                    } else if (!sousaff && "string".equals(par.type) && info != null)
                        info.setText(out.lireString(par.label));
                }
            }
        }
        if (!trouve)
            throw new SimuException(Messages.get("aucune_sortie"));
    }
    
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("start"))
            start();
        else if (cmd.equals("stop"))
            stop();
    }
    
}
