<?xml version="1.0" encoding='ISO-8859-1' ?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd" encoding="ISO-8859-1"/>

<!-- affichage des commentaires dans les pages web: oui ou non -->
<xsl:param name="commentaires">non</xsl:param>

<xsl:template match="APPLET_SIMULAB">
    <html>
    <head>
        <title><xsl:value-of select="TITRE"/></title>
        <style type="text/css">
body {
    font-family : "Times New Roman", Times, serif;
    background-color: #FFFFFF;
}
h1 {
    text-align: center;
}
h1,h2,h3,h4,h5,h6 {
    color: #000070;
}
.titrepara {
    font-weight: bold;
    margin-bottom: 0.5em;
}
.paragraphe {
    text-indent: 1em;
    text-align: justify;
    margin-bottom: 1em;
}
.introconlu {
    background: #F2FDFF;
    border: ridge #F0F0FF;
    padding: 0em 0.7em 0.7em 0.7em;
    margin-bottom: 1em;
}
.fondclair {
    background-color: #F0F5FF;
    border: ridge #F0F0FF;
    padding: 0em 0.5em 0.5em 0.5em;
    margin-bottom: 1em;
}
.legende {
    font-family: Arial, Helvetica, sans-serif;
    font-size: 83%;
    font-weight: bold;
    color: #0000ff;
    text-decoration: none;
}
ul {
    text-indent: 0em;
    padding-left: 1em;
}
ol {
    text-indent: 0em;
    padding-left: 1em;
}
li {
    margin-bottom: 0.5em;
}
dl {
    text-indent: 0em;
}
.titretable {
    font-family: Arial, Helvetica, sans-serif;
    font-weight: bold;
    color: #0000FF;
}
.entete {
    border: 1pt #C8C8FF outset;
    background: #E0E0FF;
    font-family: Arial, Helvetica, sans-serif;
    font-size: 100%;
    font-weight: bold;
}
.tableaux1 {
    border: 1pt #C8C8FF outset;
    background: #F5F5FF;
    font-family: Arial, Helvetica, sans-serif;
    font-size: 100%;
}
.tableaux2 {
    border: 1pt #C8C8FF outset;
    background: #E9E9FF;
    font-family: Arial, Helvetica, sans-serif;
    font-size: 100%;
}
img.maths {
    vertical-align: middle;
}
        </style>
    </head>
    <body>
        <xsl:apply-templates select="TITRE|AUTEUR|DATECRE|DATEMAJ"/>
        <xsl:call-template name="table-des-matieres"/>
        <xsl:apply-templates select="CHAMP|LISTEPARAMS|INTRODUCTION|OBJECTIFS|RAPPEL|EXPLICATIONS|FONCTIONNEMENT|EXCOMMENTE"/>
    </body>
    </html>
</xsl:template>

<xsl:template name="table-des-matieres">
    <h3>Table des matires</h3>
    <ul>
        <xsl:for-each select="LISTEPARAMS|INTRODUCTION|OBJECTIFS|RAPPEL|EXPLICATIONS|FONCTIONNEMENT|EXCOMMENTE">
            <xsl:choose>
                <xsl:when test="self::LISTEPARAMS"><li><a href="#listeparams">Liste des paramtres de l'applet</a></li></xsl:when>
                <xsl:when test="self::INTRODUCTION"><li><a href="#intro">Introduction</a></li></xsl:when>
                <xsl:when test="self::OBJECTIFS"><li><a href="#objectifs">Objectifs</a></li></xsl:when>
                <xsl:when test="self::RAPPEL"><li><a href="#rappel">Rappels de cours</a></li></xsl:when>
                <xsl:when test="self::EXPLICATIONS"><li><a href="#explications">Explications</a>
                    <xsl:if test="SECTION">
                        <ul>
                            <xsl:for-each select="SECTION">
                                <li><a href="#{@label}"><xsl:value-of select="@titre"/></a></li>
                            </xsl:for-each>
                        </ul>
                    </xsl:if>
                    </li>
                </xsl:when>
                <xsl:when test="self::FONCTIONNEMENT"><li><a href="#fonctionnement">Mode d'emploi de l'applet</a>
                    <xsl:if test="SECTION">
                        <ul>
                            <xsl:for-each select="SECTION">
                                <li><a href="#{@label}"><xsl:value-of select="@titre"/></a></li>
                            </xsl:for-each>
                        </ul>
                    </xsl:if>
                    </li>
                </xsl:when>
                <xsl:when test="self::EXCOMMENTE"><li><a href="#excommente{count(preceding-sibling::EXCOMMENTE)+1}">
                    <xsl:choose>
                        <xsl:when test="@titre!=''">Exemple: <xsl:value-of select="@titre"/></xsl:when>
                        <xsl:otherwise>Exemple d'utilisation</xsl:otherwise>
                    </xsl:choose>
                </a></li></xsl:when>
            </xsl:choose>
        </xsl:for-each>
    </ul>
    <br/>
</xsl:template>

<xsl:template match="TITRE">
    <h1><xsl:apply-templates/></h1>
</xsl:template>

<xsl:template match="AUTEUR">
    <xsl:choose>
        <xsl:when test="count(../AUTEUR)=1">
            <b>Auteur: <i><xsl:value-of select="."/></i></b><br/>
        </xsl:when>
        <xsl:when test="count(../AUTEUR)&gt;1 and count(preceding::AUTEUR)=0">
            <xsl:call-template name="auteurs"/>
        </xsl:when>
    </xsl:choose>
</xsl:template>

<xsl:template name="auteurs">
    <b>Auteurs: 
    <i><xsl:for-each select="../AUTEUR">
        <xsl:value-of select="."/>
        <xsl:if test="position()!=last()">, </xsl:if>
    </xsl:for-each></i></b>
    <br/>
</xsl:template>

<xsl:template match="DATECRE">
    <div align="right">Date de cration&#xA0;:
    <i><xsl:apply-templates/></i></div><br/>
</xsl:template>

<xsl:template match="DATEMAJ">
    <div align="right">Date de mise  jour&#xA0;:
    <i><xsl:apply-templates/></i></div><br/>
</xsl:template>

<xsl:template match="LISTEPARAMS">
    <a name="listeparams"/>
    <h3>Liste des paramtres d'entre de l'applet</h3>
    <ul><xsl:apply-templates select="PARAMETRE_ENTREE"/></ul>
    <h3>Liste des paramtres de sortie de l'applet</h3>
    <ul><xsl:apply-templates select="PARAMETRE_SORTIE"/></ul>
</xsl:template>

<xsl:template match="PARAMETRE_ENTREE|PARAMETRE_SORTIE">
    <li>
        <xsl:if test="@titre!=''">
            <b>titre&#xA0;: </b><xsl:value-of select="@titre"/><br/>
        </xsl:if>
        <b>label&#xA0;: </b><xsl:value-of select="@label"/><br/>
        <xsl:if test="@unite!=''">
            <b>units&#xA0;: </b><xsl:value-of select="@unite"/><br/>
        </xsl:if>
        <xsl:apply-templates/>
    </li>
</xsl:template>

<xsl:template match="DESCRIPTION">
    <xsl:apply-templates/><br/>
</xsl:template>

<xsl:template match="VALEURS">
    Valeurs possibles : <xsl:apply-templates/><br/>
</xsl:template>

<xsl:template match="CHOIX">
    <xsl:value-of select="@valeur"/><xsl:text> </xsl:text>
</xsl:template>

<xsl:template match="INTRODUCTION">
    <div class="introconlu">
        <h3><a name="intro"></a>Introduction</h3>
        <xsl:apply-templates/>
    </div>
</xsl:template>

<xsl:template match="FONCTIONNEMENT">
    <a name="fonctionnement"></a><h2>Mode d'emploi de l'applet</h2>
    <xsl:apply-templates/>
    <hr/>
</xsl:template>

<xsl:template match="EXCOMMENTE">
    <a name="excommente{count(preceding-sibling::EXCOMMENTE)+1}"></a>
    <h2>
        <xsl:choose>
            <xsl:when test="@titre!=''">Exemple: <xsl:value-of select="@titre"/></xsl:when>
            <xsl:otherwise>Exemple d'utilisation</xsl:otherwise>
        </xsl:choose>
    </h2>
    <xsl:apply-templates/>
    <hr/>
</xsl:template>

<xsl:template match="REFCOURS">
    <br/><i>Module&#xA0;: </i> <xsl:value-of select="./@module"/> ; <i>cours&#xA0;: </i> <xsl:value-of select="./@cours"/><br/>
</xsl:template>

<xsl:template match="CHAMP">
    <h3>Champ</h3>
    <div class="paragraphe"><xsl:apply-templates/></div>
</xsl:template>

<xsl:template match="OBJECTIFS">
    <a name="objectifs"></a>
    <div class="fondclair">
        <h3>Objectifs</h3>
        <xsl:apply-templates/>
    </div>
</xsl:template>

<xsl:template match="RAPPEL">
    <br/><a name="rappel"></a><h2>Rappels de cours</h2>
    <xsl:apply-templates/>
    <hr/>
</xsl:template>

<xsl:template match="EXPLICATIONS">
    <a name="explications"></a><h2>Explications</h2>
    <xsl:apply-templates/>
    <hr/>
</xsl:template>

<xsl:template match="SECTION">
    <xsl:if test="@label!=''">
        <a name="{@label}"/>
    </xsl:if>
    <xsl:if test="@titre!=''">
        <xsl:element name="h{3 + count(ancestor::SECTION)}">
            <xsl:value-of select="@titre"/>
        </xsl:element>
    </xsl:if>
    <div class="section">
        <xsl:apply-templates/>
    </div>
</xsl:template>

<xsl:template match="PARAGRAPHE">
    <xsl:if test="@label!=''">
        <a name="{@label}"/>
    </xsl:if>
    <xsl:if test="@titre!=''">
        <div class="titrepara"><xsl:value-of select="@titre"/></div>
    </xsl:if>
    <div class="paragraphe">
        <xsl:apply-templates/>
        <br/>
    </div>
</xsl:template>

<xsl:template match="DEMONSTRATION">
    <div class="fondclair">
        <h3>Dmonstration</h3>
        <xsl:apply-templates/>
    </div>
</xsl:template>

<xsl:template match="DEFINITION">
    <div class="fondclair">
        <h3>Dfinition</h3>
        <xsl:apply-templates/>
    </div>
    <br/>
</xsl:template>

<xsl:template match="LISTEPOINTS">
    <xsl:if test="@titre!=''">
        <h3><xsl:value-of select="@titre"/></h3>
    </xsl:if>
    <ul>
        <xsl:apply-templates/>
    </ul>
</xsl:template>


<xsl:template match="LISTENUM">
    <xsl:if test="@titre!=''">
        <h3><xsl:value-of select="@titre"/></h3>
    </xsl:if>
    <ol type="1">
        <xsl:apply-templates/>
    </ol>
</xsl:template>


<xsl:template match="LISTEDEF">
    <xsl:if test="@titre!=''">
        <h3><xsl:value-of select="@titre"/></h3>
    </xsl:if>
    <dl>
        <xsl:apply-templates/>
    </dl>
</xsl:template>


<xsl:template match="ITEM">
    <li><xsl:apply-templates/></li>
</xsl:template>

<xsl:template match="ITEMDEF">
    <dt><b><xsl:value-of select="@nom"/></b></dt>
    <dd><xsl:apply-templates/></dd>
</xsl:template>

<xsl:template match="EXEMPLE">
    <div class="fondclair">
        <h3>Exemple</h3>
        <xsl:apply-templates/>
    </div>
</xsl:template>

<xsl:template match="REMARQUE">
    <br/><b><i>Remarque&#xA0;:</i></b>
    <xsl:apply-templates/><br/>
</xsl:template>

<xsl:template match="BIBLIOGRAPHIE">
    <a name="bibliographie"></a><h3>Bibliographie</h3>
    <xsl:apply-templates/>
</xsl:template>

<xsl:template match="LIEN">
    <xsl:choose>
        <xsl:when test="@type='http'">
            <a href="{@label}"><xsl:apply-templates/></a>
        </xsl:when>
        <xsl:otherwise>
            <a href="#{@label}"><xsl:apply-templates/></a>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="APPLET">
    <br/>
    <xsl:if test="@label!=''">
        <a name="{@label}"/>
    </xsl:if>
    <xsl:if test="@titre!=''">
        <b class="titretable"><xsl:value-of select="@titre"/></b><br/>
    </xsl:if>
    <applet code="{@classe}" archive="{@archive}" width="{@largeur}" height="{@hauteur}">
        <xsl:apply-templates select="PARAM"/>
    </applet>
    <xsl:apply-templates select="LEGENDE"/>
    <br/>
</xsl:template>

<xsl:template match="PARAM">
    <param name="{@nom}" value="{@valeur}"/>
</xsl:template>

<xsl:template match="LEGENDE">
    <xsl:variable name="alignement"><xsl:choose>
        <xsl:when test="../@localisation='page' or parent::APPLET or parent::TABLEAU">left</xsl:when>
        <xsl:otherwise>center</xsl:otherwise>
    </xsl:choose></xsl:variable>
    <br/>
    <div align="{$alignement}" class="legende">
        <b><xsl:apply-templates/></b>
    </div>
</xsl:template>

<xsl:template match="FIGURE">
    <br/>
    <xsl:if test="@label!=''"><a name="{@label}"/></xsl:if>
    <div align="center">
        <xsl:if test="@titre!=''">
            <b class="titretable"><xsl:value-of select="@titre"/></b><br/>
        </xsl:if>
        <xsl:apply-templates/>
    </div>
    <br/>
</xsl:template>

<xsl:template match="FICHIER">
    <xsl:if test="@label!=''"><a name="{@label}"/></xsl:if>
    <img src="{@nom}" border="0" alt="{@alt}"/>
    <xsl:apply-templates/>
</xsl:template>

<xsl:template match="SYMBOLE">
    <xsl:variable name="nomlettre" select="substring-after(substring-after(@nom, '/'), '/')"/>
    <xsl:variable name="nomsansext" select="substring-before($nomlettre,'.')"/>
    <xsl:choose>
        <xsl:when test="$nomsansext='Alpha'">&#x391;</xsl:when>
        <xsl:when test="$nomsansext='Beta'">&#x392;</xsl:when>
        <xsl:when test="$nomsansext='Gamma'">&#x393;</xsl:when>
        <xsl:when test="$nomsansext='Delta'">&#x394;</xsl:when>
        <xsl:when test="$nomsansext='Epsilon'">&#x395;</xsl:when>
        <xsl:when test="$nomsansext='Zeta'">&#x396;</xsl:when>
        <xsl:when test="$nomsansext='Eta'">&#x397;</xsl:when>
        <xsl:when test="$nomsansext='Theta'">&#x398;</xsl:when>
        <xsl:when test="$nomsansext='Iota'">&#x399;</xsl:when>
        <xsl:when test="$nomsansext='Kappa'">&#x39A;</xsl:when>
        <xsl:when test="$nomsansext='Lambda'">&#x39B;</xsl:when>
        <xsl:when test="$nomsansext='Mu'">&#x39C;</xsl:when>
        <xsl:when test="$nomsansext='Nu'">&#x39D;</xsl:when>
        <xsl:when test="$nomsansext='Xi'">&#x39E;</xsl:when>
        <xsl:when test="$nomsansext='Omicron'">&#x39F;</xsl:when>
        <xsl:when test="$nomsansext='Pi'">&#x3A0;</xsl:when>
        <xsl:when test="$nomsansext='Rho'">&#x3A1;</xsl:when>
        <xsl:when test="$nomsansext='Sigma'">&#x3A3;</xsl:when>
        <xsl:when test="$nomsansext='Tau'">&#x3A4;</xsl:when>
        <xsl:when test="$nomsansext='Upsilon'">&#x3A5;</xsl:when>
        <xsl:when test="$nomsansext='Phi'">&#x3A6;</xsl:when>
        <xsl:when test="$nomsansext='Chi'">&#x3A7;</xsl:when>
        <xsl:when test="$nomsansext='Psi'">&#x3A8;</xsl:when>
        <xsl:when test="$nomsansext='Omega'">&#x3A9;</xsl:when>
        <xsl:when test="$nomsansext='alpha'">&#x3B1;</xsl:when>
        <xsl:when test="$nomsansext='beta'">&#x3B2;</xsl:when>
        <xsl:when test="$nomsansext='gamma'">&#x3B3;</xsl:when>
        <xsl:when test="$nomsansext='delta'">&#x3B4;</xsl:when>
        <xsl:when test="$nomsansext='epsilon'">&#x3B5;</xsl:when>
        <xsl:when test="$nomsansext='zeta'">&#x3B6;</xsl:when>
        <xsl:when test="$nomsansext='eta'">&#x3B7;</xsl:when>
        <xsl:when test="$nomsansext='theta'">&#x3B8;</xsl:when>
        <xsl:when test="$nomsansext='iota'">&#x3B9;</xsl:when>
        <xsl:when test="$nomsansext='kappa'">&#x3BA;</xsl:when>
        <xsl:when test="$nomsansext='lambda'">&#x3BB;</xsl:when>
        <xsl:when test="$nomsansext='mu'">&#x3BC;</xsl:when>
        <xsl:when test="$nomsansext='nu'">&#x3BD;</xsl:when>
        <xsl:when test="$nomsansext='xi'">&#x3BE;</xsl:when>
        <xsl:when test="$nomsansext='omicron'">&#x3BF;</xsl:when>
        <xsl:when test="$nomsansext='pi'">&#x3C0;</xsl:when>
        <xsl:when test="$nomsansext='rho'">&#x3C1;</xsl:when>
        <!--<xsl:when test="$nomsansext='sigmaf'">&#x3C2;</xsl:when> pas toujours bien affich -->
        <xsl:when test="$nomsansext='sigma'">&#x3C3;</xsl:when>
        <xsl:when test="$nomsansext='tau'">&#x3C4;</xsl:when>
        <xsl:when test="$nomsansext='upsilon'">&#x3C5;</xsl:when>
        <!--<xsl:when test="$nomsansext='phi'">&#x3C6;</xsl:when> phi = unicode 03A6 != 03D5, invers dans Safari -->
        <xsl:when test="$nomsansext='chi'">&#x3C7;</xsl:when>
        <xsl:when test="$nomsansext='psi'">&#x3C8;</xsl:when>
        <xsl:when test="$nomsansext='omega'">&#x3C9;</xsl:when>
        <!--<xsl:when test="$nomsansext='thetasym'">&#x3D1;</xsl:when> pas toujours bien affich -->
        <!--<xsl:when test="$nomsansext='upsih'">&#x3D2;</xsl:when> pas toujours bien affich -->
        <!--<xsl:when test="$nomsansext='piv'">&#x3D6;</xsl:when> pas toujours bien affich -->
        
        <xsl:when test="$nomsansext='asymp'">&#x2248;</xsl:when>
        <xsl:when test="$nomsansext='cap'">&#x2229;</xsl:when>
        <xsl:when test="$nomsansext='cup'">&#x222A;</xsl:when>
        <xsl:when test="$nomsansext='exist'">&#x2203;</xsl:when>
        <xsl:when test="$nomsansext='forall'">&#x2200;</xsl:when>
        <xsl:when test="$nomsansext='ge'">&#x2265;</xsl:when>
        <xsl:when test="$nomsansext='harr'">&#x2194;</xsl:when>
        <xsl:when test="$nomsansext='hdarr'">&#x21D4;</xsl:when>
        <xsl:when test="$nomsansext='infin'">&#x221E;</xsl:when>
        <xsl:when test="$nomsansext='isin'">&#x2208;</xsl:when>
        <xsl:when test="$nomsansext='larr'">&#x2190;</xsl:when>
        <!-- ldarr = symbole HTML lArr ne s'affiche pas avec IE 6 -->
        <xsl:when test="$nomsansext='le'">&#x2264;</xsl:when>
        <xsl:when test="$nomsansext='nabla'">&#x2207;</xsl:when>
        <xsl:when test="$nomsansext='ne'">&#x2260;</xsl:when>
        <xsl:when test="$nomsansext='not'">&#xAC;</xsl:when>
        <xsl:when test="$nomsansext='part'">&#x2202;</xsl:when>
        <xsl:when test="$nomsansext='plusmn'">&#xB1;</xsl:when>
        <xsl:when test="$nomsansext='rarr'">&#x2192;</xsl:when>
        <xsl:when test="$nomsansext='rdarr'">&#x21D2;</xsl:when>
        <!-- sim ne s'affiche pas avec IE 6 -->
        <xsl:when test="$nomsansext='sub'">&#x2282;</xsl:when>
        
        <xsl:otherwise>
            <img src="{@nom}" border="0" alt="{$nomsansext}"/>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="EQUATION | EQUATEX">
    <xsl:if test="@label"><a name="{@label}"/></xsl:if>
    <img src="{@image}" border="0" alt="{@texte}" class="maths"/>
</xsl:template>

<xsl:template match="TABLEAU">
    <br/><br/>
    <xsl:if test="@label">
        <a name="{normalize-space(@label)}"/>
    </xsl:if>
    <xsl:if test="@titre!=''">
        <b class="titretable"><xsl:value-of select="@titre"/></b><br/>
    </xsl:if>
    <xsl:apply-templates select="TABLE"/><br/>
    <div class="legende">
        <xsl:value-of select="LEGENDE"/>
    </div>
    <br/><br/>
</xsl:template>

<xsl:template match="TABLE">
    <table border="1" cellspacing="0" cellpadding="2"  class="tableaux1">
        <xsl:apply-templates select="TR"/>
    </table>
</xsl:template>

<xsl:template match="TR">
    <tr><xsl:apply-templates/></tr>
</xsl:template>

<xsl:template match="TH" >
    <th class="entete"><xsl:apply-templates/></th>
</xsl:template>

<xsl:template match="TD" >
    <xsl:variable name="trpos"><xsl:number from="TABLE" count="TR"/></xsl:variable>
    <td class="tableaux{1+($trpos mod 2)}">
    <xsl:if test="@colspan"><xsl:attribute name="colspan"><xsl:value-of select="@colspan"/></xsl:attribute></xsl:if>
    <xsl:if test="@rowspan"><xsl:attribute name="rowspan"><xsl:value-of select="@rowspan"/></xsl:attribute></xsl:if>
    <xsl:if test="@align"><xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute></xsl:if>
    <xsl:apply-templates/></td>
</xsl:template>

<xsl:template match="COMMENTAIRE">
    <xsl:if test="$commentaires='oui'">
        <div style="color: #FF0000">
            <xsl:apply-templates/>
            <br/>
        </div>
    </xsl:if>
</xsl:template>

<xsl:template match="SUP">
    <sup><xsl:apply-templates/></sup>
</xsl:template>


<xsl:template match="SUB">
    <sub><xsl:apply-templates/></sub>
</xsl:template>

<xsl:template match="EM">
    <em><xsl:apply-templates/></em>
</xsl:template>

<xsl:template match="I">
    <i><xsl:apply-templates/></i>
</xsl:template>

<xsl:template match="B">
    <b><xsl:apply-templates/></b>
</xsl:template>

<xsl:template match="NBSP">&#xA0;</xsl:template>

<xsl:template match="BR">
    <br/>
</xsl:template>

</xsl:stylesheet>
