/*
 * Decompiled with CFR 0.152.
 */
package COM.Subrahmanyam.table;

import COM.Subrahmanyam.table.THeadObject;
import COM.Subrahmanyam.table.TObject;
import COM.Subrahmanyam.table.TSeparatorObject;
import COM.Subrahmanyam.table.Table;
import COM.Subrahmanyam.table.TableComponent;
import java.awt.Cursor;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.event.MouseEvent;

class TableHead
extends TableComponent {
    private int onJ = -1;
    private int _onJ = -1;
    private int dragC = -1;
    private boolean allowDrag = true;

    TableHead(Table table, Font font) {
        this.parent = table;
        this.noRows = 0;
        this.noColumns = 0;
        this.setFont(font);
    }

    void addColumn(String string) {
        ++this.noColumns;
        this.noRows = 1;
        if (this.tObjects == null) {
            this.tObjects = new TObject[1][1];
            this.tObjects[0][0] = new THeadObject(string, 0, 0, this.colors);
        } else if (this.tObjects != null) {
            TObject[][] tObjectArray = new TObject[1][this.tObjects[0].length + 2];
            for (int i = 0; i < this.tObjects[0].length; ++i) {
                tObjectArray[0][i] = this.tObjects[0][i];
            }
            tObjectArray[0][tObjectArray[0].length - 2] = new TSeparatorObject(0, tObjectArray[0].length - 2, this.colors);
            tObjectArray[0][tObjectArray[0].length - 1] = new THeadObject(string, 0, tObjectArray[0].length - 1, this.colors);
            this.tObjects = null;
            this.tObjects = tObjectArray;
        }
        this.setXGrid(this.getSize().width);
        this.setYGrid();
        this.repaint();
    }

    void addColumn(int n, String string) {
        if (n >= this.noColumns) {
            this.addColumn(string);
        } else {
            int n2;
            TObject[][] tObjectArray = new TObject[1][this.tObjects[0].length + 2];
            for (n2 = 0; n2 < 2 * n; ++n2) {
                tObjectArray[0][n2] = this.tObjects[0][n2];
            }
            tObjectArray[0][2 * n] = new THeadObject(string, 0, 2 * n, this.colors);
            tObjectArray[0][2 * n + 1] = new TSeparatorObject(0, 2 * n + 1, this.colors);
            for (n2 = 2 * n + 2; n2 < tObjectArray[0].length; ++n2) {
                tObjectArray[0][n2] = this.tObjects[0][n2 - 2];
                tObjectArray[0][n2].setIndices(0, n2);
            }
            this.tObjects = null;
            this.tObjects = tObjectArray;
            ++this.noColumns;
            this.setXGrid(this.getSize().width);
            this.setYGrid();
            this.repaint();
        }
    }

    String deleteColumn(int n) {
        String string = null;
        if (n < this.noColumns) {
            if (this.noColumns == 1) {
                string = this.tObjects[0][0].getName();
                this.tObjects[0][0] = null;
                this.tObjects = null;
            } else {
                int n2;
                TObject[][] tObjectArray = new TObject[1][this.tObjects[0].length - 2];
                if (n == 0) {
                    for (n2 = 2; n2 < this.tObjects[0].length; ++n2) {
                        tObjectArray[0][n2 - 2] = this.tObjects[0][n2];
                        tObjectArray[0][n2 - 2].setIndices(0, n2 - 2);
                    }
                } else {
                    for (n2 = 0; n2 < 2 * n - 1; ++n2) {
                        tObjectArray[0][n2] = this.tObjects[0][n2];
                    }
                    string = this.tObjects[0][2 * n].getName();
                    for (n2 = 2 * n + 1; n2 < this.tObjects[0].length; ++n2) {
                        tObjectArray[0][n2 - 2] = this.tObjects[0][n2];
                        tObjectArray[0][n2 - 2].setIndices(0, n2 - 2);
                    }
                }
                for (n2 = 0; n2 < this.tObjects[0].length; ++n2) {
                    this.tObjects[0][n2] = null;
                }
                this.tObjects[0] = null;
                this.tObjects = null;
                this.tObjects = tObjectArray;
            }
            --this.noColumns;
            this.setXGrid(this.getSize().width);
            this.setYGrid();
            this.repaint();
        }
        return string;
    }

    public void paint(Graphics graphics) {
        if (this.tObjects != null) {
            graphics.setFont(this.font);
            for (int i = 0; i < this.tObjects.length; ++i) {
                for (int j = 0; j < this.tObjects[0].length; ++j) {
                    this.tObjects[i][j].allowDrag(this.allowDrag);
                    this.tObjects[i][j].paint(graphics, this.grid);
                }
            }
        }
    }

    void clear() {
        while (this.noColumns > 0) {
            this.deleteColumn(0);
        }
    }

    void callSync() {
        this.parent.setSyncXGrid(this.grid.getXArr());
    }

    void allowDrag(boolean bl) {
        this.allowDrag = bl;
        try {
            for (int i = 0; i < this.tObjects.length; ++i) {
                this.tObjects[0][i].allowDrag(bl);
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void mouseEntered(MouseEvent mouseEvent) {
        if (this.grid.findInFocus(mouseEvent.getX(), mouseEvent.getY()) && this.tObjects[this.grid.getIFocus()][this.grid.getJFocus()].mouseEnter()) {
            this.onJ = this.grid.getJFocus();
            for (int i = 0; i < this.tObjects[0].length; ++i) {
                this.tObjects[0][i].unhilite();
            }
            this.tObjects[0][this.onJ].hilite();
        }
    }

    public void mouseExited(MouseEvent mouseEvent) {
        for (int i = 0; i < this.tObjects[0].length; ++i) {
            this.tObjects[0][i].unhilite();
        }
    }

    public void mousePressed(MouseEvent mouseEvent) {
        if (this.grid.findInFocus(mouseEvent.getX(), mouseEvent.getY())) {
            this.tObjects[this.grid.getIFocus()][this.grid.getJFocus()].mouseDown();
        }
    }

    public void mouseReleased(MouseEvent mouseEvent) {
        if (this.dragC > -1) {
            this.parent.hiliteColumn(this.dragC, false);
        }
        this.parent.repaint();
    }

    public void mouseMoved(MouseEvent mouseEvent) {
        this._onJ = this.onJ;
        if (this.grid.findInFocus(mouseEvent.getX(), mouseEvent.getY())) {
            this.onJ = this.grid.getJFocus();
            if (this.tObjects[0][this.onJ].mouseMove()) {
                if (this.tObjects[0][this.onJ].isDraggable()) {
                    this.setCursor(new Cursor(11));
                } else {
                    this.setCursor(new Cursor(0));
                }
            } else {
                this.setCursor(new Cursor(0));
            }
        }
    }

    public void mouseDragged(MouseEvent mouseEvent) {
        if (this.tObjects[this.grid.getIFocus()][this.grid.getJFocus()].mouseDrag(mouseEvent.getX(), mouseEvent.getY(), this.grid)) {
            this.parent.hiliteColumn(this.grid.getJFocus(), true);
            this.dragC = this.grid.getJFocus();
            this.parent.setSyncXGrid(this.grid.getXArr());
            this.parent.repaint();
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (this.tObjects != null) {
            switch (mouseEvent.getID()) {
                case 501: {
                    this.mousePressed(mouseEvent);
                    break;
                }
                case 502: {
                    this.mouseReleased(mouseEvent);
                    break;
                }
                case 504: {
                    this.mouseEntered(mouseEvent);
                    break;
                }
                case 505: {
                    this.mouseExited(mouseEvent);
                }
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.tObjects != null) {
            switch (mouseEvent.getID()) {
                case 503: {
                    this.mouseMoved(mouseEvent);
                    break;
                }
                case 506: {
                    this.mouseDragged(mouseEvent);
                }
            }
        }
        super.processMouseMotionEvent(mouseEvent);
    }
}

