/*
 * Decompiled with CFR 0.152.
 */
package COM.Subrahmanyam.table;

import COM.Subrahmanyam.table.TElement;
import COM.Subrahmanyam.table.TElementObject;
import COM.Subrahmanyam.table.TFillerObject;
import COM.Subrahmanyam.table.TObject;
import COM.Subrahmanyam.table.Table;
import COM.Subrahmanyam.table.TableComponent;
import java.awt.Color;
import java.awt.Font;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

class TableData
extends TableComponent {
    static final int HILITE_ROW = 0;
    static final int HILITE_COLUMN = 1;
    static final int HILITE_ELEMENT = 2;
    static final int SINGLE_CLICK = 10;
    static final int DOUBLE_CLICK = 20;
    static final int OUT_OF_FOCUS = -1;
    private static final double BRIGHTER_FACTOR = 0.25;
    private static final double DARKER_FACTOR = 0.75;
    private float lineSpacing = 1.0f;
    private int scrollY = 0;
    private int focussedRow = -1;
    private int _focussedRow = -1;
    private int focussedColumn = -1;
    private int _focussedColumn = -1;
    private boolean horizontalSeparator;
    private boolean verticalSeparator;
    private int hiliteMode = 0;
    private int clickMode = 10;
    private boolean first = true;
    private boolean allowMultipleSelections = false;
    private Vector mouseListeners;
    private Vector mouseMotionListeners;

    TableData(Table table, Font font) {
        this.parent = table;
        this.noRows = 0;
        this.noColumns = 0;
        this.verticalSeparator = false;
        this.horizontalSeparator = false;
        this.allowMultipleSelections = false;
        this.setFont(font);
        this.mouseListeners = new Vector();
        this.mouseMotionListeners = new Vector();
    }

    TableData(Table table, Font font, boolean bl) {
        this.parent = table;
        this.noRows = 0;
        this.noColumns = 0;
        this.verticalSeparator = false;
        this.horizontalSeparator = false;
        this.allowMultipleSelections = bl;
        this.setFont(font);
    }

    void addRow(String[] stringArray) {
        this.hilite(this.focussedRow, this.focussedColumn, false);
        if (this.tObjects == null) {
            int n;
            this.tObjects = new TObject[1][2 * this.noColumns - 1];
            for (n = 0; n < this.noColumns; ++n) {
                this.tObjects[0][2 * n] = new TElementObject(stringArray[n], 0, 2 * n, this.colors);
            }
            for (n = 0; n < this.noColumns - 1; ++n) {
                this.tObjects[0][2 * n + 1] = new TFillerObject(0, 2 * n + 1, this.colors);
            }
        } else {
            int n;
            TObject[][] tObjectArray = new TObject[this.tObjects.length + 1][this.tObjects[0].length];
            for (n = 0; n < this.tObjects.length; ++n) {
                for (int i = 0; i < this.tObjects[n].length; ++i) {
                    tObjectArray[n][i] = this.tObjects[n][i];
                }
            }
            for (n = 0; n < this.noColumns; ++n) {
                tObjectArray[tObjectArray.length - 1][2 * n] = new TElementObject(stringArray[n], tObjectArray.length - 1, 2 * n, this.colors);
            }
            for (n = 0; n < this.noColumns - 1; ++n) {
                tObjectArray[tObjectArray.length - 1][2 * n + 1] = new TFillerObject(tObjectArray.length - 1, 2 * n + 1, this.colors);
            }
            this.tObjects = null;
            this.tObjects = tObjectArray;
            tObjectArray = null;
        }
        ++this.noRows;
        this.showHorizontalSeparator(this.horizontalSeparator);
        this.showVerticalSeparator(this.verticalSeparator);
        this.setYGrid();
        this.hilite(this.focussedRow, this.focussedColumn, true);
    }

    void addRow(int n, String[] stringArray) {
        if (n >= this.noRows) {
            this.addRow(stringArray);
        } else {
            int n2;
            int n3;
            this.hilite(this.focussedRow, this.focussedColumn, false);
            TObject[][] tObjectArray = new TObject[this.tObjects.length + 1][this.tObjects[0].length];
            for (n3 = 0; n3 < n; ++n3) {
                for (n2 = 0; n2 < this.tObjects[0].length; ++n2) {
                    tObjectArray[n3][n2] = this.tObjects[n3][n2];
                }
            }
            for (n3 = 0; n3 < this.noColumns; ++n3) {
                tObjectArray[n][2 * n3] = new TElementObject(stringArray[n3], n, 2 * n3, this.colors);
            }
            for (n3 = 0; n3 < this.noColumns - 1; ++n3) {
                tObjectArray[n][2 * n3 + 1] = new TFillerObject(n, 2 * n3 + 1, this.colors);
            }
            for (n3 = n + 1; n3 < tObjectArray.length; ++n3) {
                for (n2 = 0; n2 < tObjectArray[0].length; ++n2) {
                    tObjectArray[n3][n2] = this.tObjects[n3 - 1][n2];
                    tObjectArray[n3][n2].setIndices(n3, n2);
                }
            }
            this.tObjects = null;
            this.tObjects = tObjectArray;
            tObjectArray = null;
            ++this.noRows;
            this.showHorizontalSeparator(this.horizontalSeparator);
            this.showVerticalSeparator(this.verticalSeparator);
            this.setYGrid();
            this.hilite(this.focussedRow, this.focussedColumn, true);
        }
    }

    void addColumn(String[] stringArray) {
        if (stringArray == null || stringArray.length < 1) {
            return;
        }
        this.hilite(this.focussedRow, this.focussedColumn, false);
        if (this.tObjects == null) {
            this.tObjects = new TObject[stringArray.length][1];
            for (int i = 0; i < stringArray.length; ++i) {
                this.tObjects[i][0] = new TElementObject(stringArray[i], i, 0, this.colors);
            }
            this.noRows = stringArray.length;
            this.noColumns = 1;
        } else {
            int n;
            int n2 = this.tObjects.length;
            int n3 = this.tObjects[0].length;
            TObject[][] tObjectArray = new TObject[n2][n3 + 2];
            for (n = 0; n < this.tObjects.length; ++n) {
                for (int i = 0; i < this.tObjects[n].length; ++i) {
                    tObjectArray[n][i] = this.tObjects[n][i];
                }
            }
            for (n = 0; n < this.tObjects.length; ++n) {
                tObjectArray[n][n3] = new TFillerObject(n, n3, this.colors);
                tObjectArray[n][n3 + 1] = new TElementObject(stringArray[n], n, n3 + 1, this.colors);
            }
            this.tObjects = null;
            this.tObjects = tObjectArray;
            tObjectArray = null;
            ++this.noColumns;
        }
        this.showHorizontalSeparator(this.horizontalSeparator);
        this.showVerticalSeparator(this.verticalSeparator);
        this.setXGrid(this.getSize().width);
        this.setYGrid();
        this.hilite(this.focussedRow, this.focussedColumn, true);
    }

    void addColumn(int n, String[] stringArray) {
        if (stringArray == null || stringArray.length < 1) {
            return;
        }
        if (n >= this.noColumns || this.tObjects == null) {
            this.addColumn(stringArray);
        } else {
            int n2;
            int n3;
            this.hilite(this.focussedRow, this.focussedColumn, false);
            TObject[][] tObjectArray = new TObject[this.tObjects.length][this.tObjects[0].length + 2];
            for (n3 = 0; n3 < this.tObjects.length; ++n3) {
                for (n2 = 0; n2 < 2 * n; ++n2) {
                    tObjectArray[n3][n2] = this.tObjects[n3][n2];
                }
            }
            for (n3 = 0; n3 < this.tObjects.length; ++n3) {
                tObjectArray[n3][2 * n] = new TElementObject(stringArray[n3], n3, 2 * n, this.colors);
                tObjectArray[n3][2 * n + 1] = new TFillerObject(n3, 2 * n + 1, this.colors);
            }
            for (n3 = 0; n3 < this.tObjects.length; ++n3) {
                for (n2 = 2 * n + 2; n2 < tObjectArray[0].length; ++n2) {
                    tObjectArray[n3][n2] = this.tObjects[n3][n2 - 2];
                    tObjectArray[n3][n2].setIndices(n3, n2);
                }
            }
            this.tObjects = null;
            this.tObjects = tObjectArray;
            ++this.noColumns;
            this.showHorizontalSeparator(this.horizontalSeparator);
            this.showVerticalSeparator(this.verticalSeparator);
            this.setXGrid(this.getSize().width);
            this.setYGrid();
            this.hilite(this.focussedRow, this.focussedColumn, true);
        }
    }

    String[] deleteRow(int n) {
        String[] stringArray = null;
        try {
            int n2;
            int n3;
            TObject[][] tObjectArray = new TObject[this.tObjects.length - 1][this.tObjects[0].length];
            for (n3 = 0; n3 < n; ++n3) {
                for (n2 = 0; n2 < this.tObjects[n3].length; ++n2) {
                    tObjectArray[n3][n2] = this.tObjects[n3][n2];
                }
            }
            stringArray = new String[this.noColumns];
            for (n3 = n + 1; n3 < this.tObjects.length; ++n3) {
                for (n2 = 0; n2 < this.tObjects[n3].length; ++n2) {
                    tObjectArray[n3 - 1][n2] = this.tObjects[n3][n2];
                    tObjectArray[n3 - 1][n2].setIndices(n3 - 1, n2);
                }
            }
            for (n3 = 0; n3 < this.noColumns; ++n3) {
                stringArray[n3] = this.tObjects[n][2 * n3].getName();
            }
            this.tObjects = null;
            this.tObjects = tObjectArray;
            tObjectArray = null;
            --this.noRows;
            if (this.noRows == 0) {
                this.tObjects = null;
            }
            this.setYGrid();
            this.repaint();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return stringArray;
    }

    String[] deleteColumn(int n) {
        String[] stringArray = null;
        if (n < this.noColumns) {
            stringArray = new String[this.noRows];
            if (this.noColumns == 1) {
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = this.tObjects[i][0].getName();
                }
                this.tObjects = null;
                this.grid = null;
            } else {
                try {
                    int n2;
                    int n3;
                    TObject[][] tObjectArray = new TObject[this.tObjects.length][this.tObjects[0].length - 2];
                    if (n == 0) {
                        for (n3 = 0; n3 < this.tObjects.length; ++n3) {
                            for (n2 = 2; n2 < this.tObjects[0].length; ++n2) {
                                tObjectArray[n3][n2 - 2] = this.tObjects[n3][n2];
                                tObjectArray[n3][n2 - 2].setIndices(n3, n2 - 2);
                            }
                        }
                    } else {
                        for (n3 = 0; n3 < this.tObjects.length; ++n3) {
                            for (n2 = 0; n2 < 2 * n - 1; ++n2) {
                                tObjectArray[n3][n2] = this.tObjects[n3][n2];
                            }
                        }
                        for (n3 = 0; n3 < stringArray.length; ++n3) {
                            stringArray[n3] = this.tObjects[n3][2 * n].getName();
                        }
                        for (n3 = 0; n3 < this.tObjects.length; ++n3) {
                            for (n2 = 2 * n + 1; n2 < this.tObjects[0].length; ++n2) {
                                tObjectArray[n3][n2 - 2] = this.tObjects[n3][n2];
                                tObjectArray[n3][n2 - 2].setIndices(n3, n2 - 2);
                            }
                        }
                    }
                    for (n3 = 0; n3 < stringArray.length; ++n3) {
                        stringArray[n3] = this.tObjects[n3][n].getName();
                    }
                    this.tObjects = null;
                    this.tObjects = tObjectArray;
                }
                catch (NullPointerException nullPointerException) {
                    // empty catch block
                }
            }
            if (this.noColumns > 0) {
                --this.noColumns;
            }
            this.setXGrid(this.getSize().width);
            this.setYGrid();
            this.repaint();
        } else if (this.noColumns > 0) {
            --this.noColumns;
        }
        return stringArray;
    }

    String getElement(int n, int n2) {
        try {
            return this.tObjects[n][2 * n2].getName();
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
        return null;
    }

    void setElement(int n, int n2, String string) {
        try {
            this.tObjects[n][2 * n2].setName(string);
            Graphics graphics = this.getGraphics();
            this.tObjects[n][2 * n2].paint(graphics, this.grid);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    void setElement(TElement tElement) {
        try {
            this.tObjects[tElement.getRow()][2 * tElement.getColumn()].setName(tElement.getData());
            Graphics graphics = this.getGraphics();
            this.tObjects[tElement.getRow()][2 * tElement.getColumn()].paint(graphics, this.grid);
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
            // empty catch block
        }
    }

    public void paint(Graphics graphics) {
        this.update(graphics);
    }

    public void update(Graphics graphics) {
        try {
            int n;
            int n2;
            graphics.translate(0, -1 * this.scrollY * (this.grid.getY(1) - this.grid.getY(0)));
            graphics.setFont(this.font);
            try {
                n2 = this.getBottomRow() + 1;
                for (n = this.getTopRow(); n <= n2; ++n) {
                    for (int i = 0; i < this.tObjects[0].length; ++i) {
                        this.tObjects[n][i].paint(graphics, this.grid);
                    }
                }
            }
            catch (NullPointerException nullPointerException) {
            }
            catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                // empty catch block
            }
            n2 = this.noRows * (this.grid.getY(1) - this.grid.getY(0));
            n = this.getSize().width;
            graphics.setColor(this.colors.getNormalBG());
            graphics.fillRect(0, n2, n, this.getSize().height);
        }
        catch (NullPointerException nullPointerException) {
            graphics.translate(0, 0);
            graphics.setColor(this.colors.getNormalBG());
            graphics.fillRect(0, 0, this.getSize().width, this.getSize().height);
        }
    }

    void borderPaint(Graphics graphics) {
        Color color = null;
        Color color2 = null;
        Color color3 = this.colors.getNormalBG();
        graphics.setColor(color3);
        Rectangle rectangle = new Rectangle(0, 0, this.getSize().width, this.getSize().height);
        color = this.brighterShade(color3);
        color2 = this.darkerShade(color3);
        int n = 2;
        for (int i = 0; i < n; ++i) {
            Color color4 = color2;
            Color color5 = color;
            graphics.setColor(color4);
            graphics.drawLine(rectangle.x + i, rectangle.y + i, rectangle.x + i, rectangle.y + (rectangle.height - 1 - i));
            graphics.drawLine(rectangle.x + i, rectangle.y + i, rectangle.x + (rectangle.width - 1 - i), rectangle.y + i);
            if (i == n - 1 && i == 0) {
                graphics.setColor(this.darkerShade(color5));
            } else {
                graphics.setColor(color5);
            }
            graphics.drawLine(rectangle.x + i, rectangle.y + (rectangle.height - 1 - i), rectangle.x + (rectangle.width - 1 - i), rectangle.y + (rectangle.height - 1 - i));
            graphics.drawLine(rectangle.x + (rectangle.width - 1 - i), rectangle.y + i, rectangle.x + (rectangle.width - 1 - i), rectangle.y + (rectangle.height - 1 - i));
        }
    }

    private Color brighterShade(Color color) {
        Color color2 = new Color(Math.min((int)((double)color.getRed() * 4.0), 255), Math.min((int)((double)color.getGreen() * 4.0), 255), Math.min((int)((double)color.getBlue() * 4.0), 255));
        if (color2.equals(color)) {
            return Color.white;
        }
        return color2;
    }

    private Color darkerShade(Color color) {
        Color color2 = new Color(Math.max((int)((double)color.getRed() * 0.75), 0), Math.max((int)((double)color.getGreen() * 0.75), 0), Math.max((int)((double)color.getBlue() * 0.75), 0));
        if (color2.equals(color)) {
            return Color.black;
        }
        return color2;
    }

    void setScrollY(int n) {
        this.scrollY = n;
    }

    void hiliteRow(int n, boolean bl) {
        try {
            if (n < this.tObjects.length) {
                for (int i = 0; i < this.tObjects[n].length; ++i) {
                    if (bl) {
                        this.tObjects[n][i].hilite();
                        continue;
                    }
                    this.tObjects[n][i].unhilite();
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    void hiliteRow(int n) {
        try {
            if (n < this.tObjects.length) {
                for (int i = 0; i < this.tObjects[n].length; ++i) {
                    this.tObjects[n][i].toggleHilite();
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    void hiliteColumn(int n, boolean bl) {
        try {
            if (n < this.tObjects[0].length) {
                for (int i = 0; i < this.tObjects.length; ++i) {
                    if (bl) {
                        this.tObjects[i][n].hilite();
                        continue;
                    }
                    this.tObjects[i][n].unhilite();
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void hiliteColumn(int n) {
        try {
            if (n < this.tObjects[0].length) {
                for (int i = 0; i < this.tObjects.length; ++i) {
                    this.tObjects[i][n].toggleHilite();
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void hilite(int n, int n2, boolean bl) {
        try {
            if (this.hiliteMode == 0) {
                this.hiliteRow(n, bl);
            } else if (this.hiliteMode == 1) {
                this.hiliteColumn(n2, bl);
            } else if (this.hiliteMode == 2) {
                if (bl) {
                    this.tObjects[n][n2].hilite();
                } else {
                    this.tObjects[n][n2].unhilite();
                }
            }
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void hilite() {
        block20: {
            if (this.focussedRow < this.getNoRows() && this._focussedRow < this.getNoRows()) {
                if (this.hiliteMode == 2) {
                    try {
                        if (this.focussedRow == this._focussedRow && this.focussedColumn == this._focussedColumn) {
                            this.tObjects[this.focussedRow][this.focussedColumn].toggleHilite();
                            break block20;
                        }
                        try {
                            this.tObjects[this.focussedRow][this.focussedColumn].toggleHilite();
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                            // empty catch block
                        }
                        try {
                            if (!this.allowMultipleSelections) {
                                this.tObjects[this._focussedRow][this._focussedColumn].unhilite();
                            }
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                        }
                    }
                    catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                } else if (this.hiliteMode == 0) {
                    if (this.focussedRow == this._focussedRow) {
                        this.hiliteRow(this.focussedRow);
                    } else {
                        this.hiliteRow(this.focussedRow);
                        if (!this.allowMultipleSelections) {
                            this.hiliteRow(this._focussedRow, false);
                        }
                    }
                } else if (this.hiliteMode == 1) {
                    if (this.focussedColumn == this._focussedColumn) {
                        this.hiliteColumn(this.focussedColumn);
                    } else {
                        this.hiliteColumn(this.focussedColumn);
                        if (!this.allowMultipleSelections) {
                            this.hiliteColumn(this._focussedColumn, false);
                        }
                    }
                }
            }
        }
    }

    void showHorizontalSeparator(boolean bl) {
        this.horizontalSeparator = bl;
        try {
            for (int i = 0; i < this.tObjects.length; ++i) {
                for (int j = 0; j < this.tObjects[0].length; ++j) {
                    this.tObjects[i][j].showHorizontalSeparator(bl);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void showVerticalSeparator(boolean bl) {
        this.verticalSeparator = bl;
        try {
            for (int i = 0; i < this.tObjects.length; ++i) {
                for (int j = 0; j < this.tObjects[0].length; ++j) {
                    this.tObjects[i][j].showVerticalSeparator(bl);
                }
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void clear() {
        this.focussedRow = -1;
        this._focussedRow = -1;
        this.focussedColumn = -1;
        this._focussedColumn = -1;
        while (this.noRows > 0) {
            this.deleteRow(0);
        }
        this.repaint();
    }

    int rowInFocus() {
        return this.focussedRow;
    }

    public void setSize(int n, int n2) {
        super.setSize(n, n2);
    }

    void setHiliteMode(int n) {
        this.hiliteMode = n;
        try {
            for (int i = 0; i < this.tObjects.length; ++i) {
                for (int j = 0; j < this.tObjects[i].length; ++j) {
                    this.tObjects[i][j].unhilite();
                }
            }
            this.repaint();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    int getHiliteMode() {
        return this.hiliteMode;
    }

    int getClickMode() {
        return this.clickMode;
    }

    void setClickMode(int n) {
        this.clickMode = n;
        try {
            for (int i = 0; i < this.tObjects.length; ++i) {
                for (int j = 0; j < this.tObjects[i].length; ++j) {
                    this.tObjects[i][j].unhilite();
                }
            }
            this.repaint();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void setSyncXGrid(int[] nArray) {
        this.grid.setXArr(nArray);
    }

    int getSelRowIndex() {
        return this.focussedRow;
    }

    int getSelColumnIndex() {
        int n = this.focussedColumn / 2;
        return n;
    }

    TElement[] getSelection() {
        try {
            int n;
            int n2 = 0;
            for (int i = 0; i < this.tObjects.length; ++i) {
                for (n = 0; n < this.tObjects[i].length; n += 2) {
                    if (!this.tObjects[i][n].getHilite()) continue;
                    ++n2;
                }
            }
            if (n2 == 0) {
                return null;
            }
            TElement[] tElementArray = new TElement[n2];
            n2 = 0;
            for (n = 0; n < this.tObjects.length; ++n) {
                for (int i = 0; i < this.tObjects[n].length; i += 2) {
                    if (!this.tObjects[n][i].getHilite()) continue;
                    tElementArray[n2++] = new TElement(n, i / 2, this.tObjects[n][i].getName());
                }
            }
            return tElementArray;
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            return null;
        }
    }

    void allowMultipleSelections(boolean bl) {
        this.allowMultipleSelections = this.clickMode == 20 ? bl : false;
    }

    void selectRow(int n) {
        if (n < this.noRows) {
            this._focussedRow = this.focussedRow;
            this.focussedRow = n;
            this.hilite();
            this.repaint();
        }
    }

    void selectColumn(int n) {
        if (n < this.noColumns) {
            this._focussedColumn = this.focussedColumn;
            this.focussedColumn = 2 * n;
            this.hilite();
            this.repaint();
        }
    }

    boolean isElementSelected(int n, int n2) {
        try {
            return this.tObjects[n][2 * n2].getHilite();
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return false;
    }

    void setNoColumns(int n) {
        this.noColumns = n;
    }

    int getTopRow() {
        if (this.getNoRows() == 0) {
            return -1;
        }
        return this.scrollY;
    }

    int getBottomRow() {
        int n = this.getTopRow() + this.getPageHeight() - 1;
        if (n > this.getNoRows()) {
            return this.getNoRows() - 1;
        }
        return n;
    }

    int getPageHeight() {
        int n = 0;
        if (this.getLineHeight() > 0) {
            n = (int)((float)this.getSize().height / (float)this.getLineHeight());
        }
        return n;
    }

    void setLineSpacing(double d) {
        this.grid.setLineSpacing(d);
    }

    void mouseEntered(MouseEvent mouseEvent) {
        if (this.clickMode == 10) {
            this._focussedRow = this.focussedRow;
            this._focussedColumn = this.focussedColumn;
            if (this.grid.findInFocus(mouseEvent.getX(), mouseEvent.getY()) && this.tObjects[this.grid.getIFocus()][this.grid.getJFocus()].mouseEnter()) {
                this.focussedRow = this.scrollY + this.grid.getIFocus();
                this.focussedColumn = this.grid.getJFocus();
            }
            this.hilite();
            if (this._focussedRow != this.focussedRow || this._focussedColumn != this.focussedColumn) {
                this.repaint();
            }
        }
    }

    void mouseExited(MouseEvent mouseEvent) {
        if (this.clickMode == 10) {
            this._focussedRow = this.focussedRow;
            this._focussedColumn = this.focussedColumn;
            this.focussedRow = -1;
            this.focussedColumn = -1;
            this.hilite();
            this.repaint();
        }
    }

    void mouseClicked(MouseEvent mouseEvent) {
        if (this.clickMode == 20) {
            if (this.grid.findInFocus(mouseEvent.getX(), mouseEvent.getY())) {
                this._focussedRow = this.focussedRow;
                this._focussedColumn = this.focussedColumn;
                if (this.tObjects[this.grid.getIFocus()][this.grid.getJFocus()].mouseDown()) {
                    this.focussedRow = this.scrollY + this.grid.getIFocus();
                    this.focussedColumn = this.grid.getJFocus();
                    this.hilite();
                    this.repaint();
                    if (mouseEvent.getClickCount() == 1) {
                        try {
                            boolean bl = this.tObjects[this.focussedRow][this.focussedColumn].getHilite();
                            this.parent.fireSelectionEvent(bl);
                        }
                        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {}
                    } else if (mouseEvent.getClickCount() == 2) {
                        this.parent.fireActionEvent();
                    }
                }
            }
        } else if (this.clickMode == 10) {
            this.parent.fireActionEvent();
        }
    }

    void mouseMoved(MouseEvent mouseEvent) {
        if (this.clickMode == 10) {
            this._focussedRow = this.focussedRow;
            this._focussedColumn = this.focussedColumn;
            if (this.grid.findInFocus(mouseEvent.getX(), mouseEvent.getY())) {
                if (this.tObjects[this.grid.getIFocus()][this.grid.getJFocus()].mouseMove()) {
                    this.focussedRow = this.scrollY + this.grid.getIFocus();
                    this.focussedColumn = this.grid.getJFocus();
                }
            } else {
                this.focussedRow = -1;
                this.focussedColumn = -1;
            }
            if (this.hiliteMode == 2 && (this.focussedRow != this._focussedRow || this.focussedColumn != this._focussedColumn) || this.hiliteMode == 0 && this.focussedRow != this._focussedRow || this.hiliteMode == 1 && this.focussedColumn != this._focussedColumn) {
                this.hilite();
                try {
                    boolean bl = this.tObjects[this.focussedRow][this.focussedColumn].getHilite();
                    this.parent.fireSelectionEvent(bl);
                }
                catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
                    // empty catch block
                }
                this.repaint();
            }
        }
    }

    public void processMouseEvent(MouseEvent mouseEvent) {
        if (this.tObjects != null) {
            switch (mouseEvent.getID()) {
                case 504: {
                    this.mouseEntered(mouseEvent);
                    break;
                }
                case 505: {
                    this.mouseExited(mouseEvent);
                    break;
                }
                case 500: {
                    this.mouseClicked(mouseEvent);
                }
            }
        }
        switch (mouseEvent.getID()) {
            case 504: {
                for (int i = 0; i < this.mouseListeners.size(); ++i) {
                    ((MouseListener)this.mouseListeners.elementAt(i)).mouseEntered(mouseEvent);
                }
                break;
            }
            case 505: {
                for (int i = 0; i < this.mouseListeners.size(); ++i) {
                    ((MouseListener)this.mouseListeners.elementAt(i)).mouseExited(mouseEvent);
                }
                break;
            }
            case 500: {
                for (int i = 0; i < this.mouseListeners.size(); ++i) {
                    ((MouseListener)this.mouseListeners.elementAt(i)).mouseClicked(mouseEvent);
                }
                break;
            }
            case 501: {
                for (int i = 0; i < this.mouseListeners.size(); ++i) {
                    ((MouseListener)this.mouseListeners.elementAt(i)).mouseReleased(mouseEvent);
                }
                break;
            }
            case 502: {
                for (int i = 0; i < this.mouseListeners.size(); ++i) {
                    ((MouseListener)this.mouseListeners.elementAt(i)).mouseReleased(mouseEvent);
                }
                break;
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    public void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (this.tObjects != null) {
            switch (mouseEvent.getID()) {
                case 503: {
                    this.mouseMoved(mouseEvent);
                }
            }
        }
        switch (mouseEvent.getID()) {
            case 503: {
                for (int i = 0; i < this.mouseMotionListeners.size(); ++i) {
                    ((MouseMotionListener)this.mouseMotionListeners.elementAt(i)).mouseMoved(mouseEvent);
                }
                break;
            }
            case 506: {
                for (int i = 0; i < this.mouseMotionListeners.size(); ++i) {
                    ((MouseMotionListener)this.mouseMotionListeners.elementAt(i)).mouseDragged(mouseEvent);
                }
                break;
            }
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.mouseListeners.addElement(mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListeners.addElement(mouseMotionListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.mouseListeners.removeElement(mouseListener);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.mouseMotionListeners.removeElement(mouseMotionListener);
    }
}

