/*
 * Decompiled with CFR 0.152.
 */
package COM.Subrahmanyam.table;

import COM.Subrahmanyam.table.TColors;
import COM.Subrahmanyam.table.TElement;
import COM.Subrahmanyam.table.TableData;
import COM.Subrahmanyam.table.TableHead;
import java.awt.BorderLayout;
import java.awt.Canvas;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.ItemSelectable;
import java.awt.Panel;
import java.awt.Scrollbar;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ComponentEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.util.Vector;

public class Table
extends Panel
implements ItemSelectable {
    public static final int HILITE_ROW = 0;
    public static final int HILITE_COLUMN = 1;
    public static final int HILITE_ELEMENT = 2;
    public static final int SINGLE_CLICK = 10;
    public static final int DOUBLE_CLICK = 20;
    public static final int OUT_OF_FOCUS = -1;
    private TableHead tableHead;
    TableData tableData;
    private Scrollbar scrollBar;
    private Canvas dummy;
    private int ydiff;
    private int noRows;
    private int noColumns;
    Font font = new Font("Helvetica", 1, 14);
    private boolean first = true;
    private Dimension _size;
    private boolean allowMultipleSelections = false;
    private int clickMode = 10;
    private boolean allowDrag = true;
    private boolean isEnabled = true;
    private Vector itemListeners;
    private Vector actionListeners;
    private Panel top;

    public Table() {
        this.tableHead = new TableHead(this, this.font);
        this.font = new Font("Helvetica", 0, 14);
        this.tableData = new TableData(this, this.font);
        this.scrollBar = new Scrollbar(1, 0, 1, 0, 1);
        this.scrollBar.addAdjustmentListener(new TableScroll());
        this.dummy = new Canvas();
        this.setLayout(new BorderLayout(0, 0));
        this.top = new Panel();
        this.top.setLayout(new BorderLayout(0, 0));
        this.top.add("Center", this.tableHead);
        this.add("North", this.top);
        this.add("Center", this.tableData);
        this.validate();
        this.allowMultipleSelections = false;
        this.tableData.allowMultipleSelections(this.allowMultipleSelections);
        this.setColors();
        this.itemListeners = new Vector();
        this.actionListeners = new Vector();
        this.enableEvents(1L);
    }

    public Table(boolean bl) {
        this();
        this.allowMultipleSelections = bl;
        this.tableData.allowMultipleSelections(this.allowMultipleSelections);
        this.tableData.setClickMode(this.clickMode);
        this.setColors();
    }

    public Table(boolean bl, int n) {
        this(bl);
        if (n != 10) {
            this.tableData.allowMultipleSelections(this.allowMultipleSelections);
        } else {
            this.tableData.allowMultipleSelections(false);
        }
        this.setColors();
    }

    public void addActionListener(ActionListener actionListener) {
        this.actionListeners.addElement(actionListener);
    }

    public void addColumn(String string, String[] stringArray) {
        this.addColumn(this.getNoColumns(), string, stringArray);
    }

    public void addColumn(int n, String string, String[] stringArray) {
        this.tableHead.addColumn(n, string);
        if (this.tableHead.getNoColumns() - this.tableData.getNoColumns() == 1) {
            try {
                if (stringArray.length < this.tableData.getNoRows()) {
                    int n2;
                    String[] stringArray2 = new String[this.tableData.getNoRows()];
                    for (n2 = 0; n2 < stringArray.length; ++n2) {
                        stringArray2[n2] = stringArray[n2];
                    }
                    for (n2 = stringArray.length; n2 < stringArray2.length; ++n2) {
                        stringArray2[n2] = new String("");
                    }
                    this.tableData.addColumn(n, stringArray2);
                } else {
                    this.tableData.addColumn(n, stringArray);
                }
                this.updateUI();
                this.repaint();
            }
            catch (NullPointerException nullPointerException) {
                this.tableData.setNoColumns(this.tableHead.getNoColumns());
                this.tableHead.callSync();
                this.updateUI();
                this.tableData.repaint();
            }
        } else {
            this.tableData.setNoColumns(this.tableHead.getNoColumns());
        }
    }

    public void addItemListener(ItemListener itemListener) {
        this.itemListeners.addElement(itemListener);
    }

    public void addMouseListener(MouseListener mouseListener) {
        this.tableData.addMouseListener(mouseListener);
    }

    public void addMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.tableData.addMouseMotionListener(mouseMotionListener);
    }

    public void addRow(String[] stringArray) {
        this.addRow(this.getNoRows(), stringArray);
    }

    public void addRow(int n, String[] stringArray) {
        if (stringArray.length < this.tableHead.getNoColumns()) {
            int n2;
            String[] stringArray2 = new String[this.tableHead.getNoColumns()];
            for (n2 = 0; n2 < stringArray.length; ++n2) {
                stringArray2[n2] = stringArray[n2];
            }
            for (n2 = stringArray.length; n2 < stringArray2.length; ++n2) {
                stringArray2[n2] = new String("");
            }
            this.tableData.addRow(n, stringArray2);
        } else {
            this.tableData.addRow(n, stringArray);
        }
        this.tableData.setNoColumns(this.tableHead.getNoColumns());
        this.tableHead.callSync();
        this.updateUI();
        this.repaint();
    }

    public void allowDrag(boolean bl) {
        this.allowDrag = bl;
        this.tableHead.allowDrag(bl);
    }

    public void allowMultipleSelections(boolean bl) {
        this.tableData.allowMultipleSelections(bl);
    }

    public void clear() {
        this.scrollBar.setValue(0);
        this.selectRow(0);
        this.tableData.clear();
        this.updateUI();
        this.repaint();
    }

    public void clearAll() {
        this.clear();
        this.tableHead.clear();
        this.updateUI();
        this.repaint();
    }

    public String[] deleteColumn(int n) {
        String[] stringArray = null;
        if (n < this.tableHead.getNoColumns()) {
            this.tableHead.deleteColumn(n);
            stringArray = this.tableData.deleteColumn(n);
            this.updateUI();
            this.repaint();
        }
        return stringArray;
    }

    public String[] deleteRow(int n) {
        String[] stringArray = null;
        if (n < this.tableData.getNoRows()) {
            stringArray = this.tableData.deleteRow(n);
            this.updateUI();
            this.repaint();
        }
        return stringArray;
    }

    public int getClickMode() {
        return this.tableData.getClickMode();
    }

    public String getElement(int n, int n2) {
        return this.tableData.getElement(n, n2);
    }

    public Font[] getFonts() {
        Font[] fontArray = new Font[]{this.tableHead.getFont(), this.tableData.getFont()};
        return fontArray;
    }

    public int getHiliteMode() {
        return this.tableData.getHiliteMode();
    }

    public int getNoColumns() {
        return this.tableHead.getNoColumns();
    }

    public int getNoRows() {
        return this.tableData.getNoRows();
    }

    public int[] getScale() {
        return this.tableHead.getScale();
    }

    public int getSelColumnIndex() {
        return this.tableData.getSelColumnIndex();
    }

    public Object[] getSelectedObjects() {
        return this.tableData.getSelection();
    }

    public int getSelRowIndex() {
        return this.tableData.getSelRowIndex();
    }

    public TElement[] getSelection() {
        return this.tableData.getSelection();
    }

    public int getBottomRowIndex() {
        return this.tableData.getBottomRow();
    }

    public int getPageHeight() {
        return this.tableData.getPageHeight();
    }

    public int getTopRowIndex() {
        return this.tableData.getTopRow();
    }

    public boolean isElementSelected(int n, int n2) {
        return this.tableData.isElementSelected(n, n2);
    }

    public boolean isEnabled() {
        return this.isEnabled;
    }

    public final void processComponentEvent(ComponentEvent componentEvent) {
        super.processComponentEvent(componentEvent);
        if (componentEvent.getID() == 101 || componentEvent.getID() == 102) {
            this.updateUI();
        }
    }

    public void removeActionListener(ActionListener actionListener) {
        this.actionListeners.removeElement(actionListener);
    }

    public void removeItemListener(ItemListener itemListener) {
        this.itemListeners.removeElement(itemListener);
    }

    public void removeMouseListener(MouseListener mouseListener) {
        this.tableData.removeMouseListener(mouseListener);
    }

    public void removeMouseMotionListener(MouseMotionListener mouseMotionListener) {
        this.tableData.removeMouseMotionListener(mouseMotionListener);
    }

    public final void repaint() {
        this.tableHead.resetGrid();
        this.tableData.resetGrid();
        super.repaint();
        this.tableHead.repaint();
        this.tableData.repaint();
        this.dummy.repaint();
    }

    public final void setSize(int n, int n2) {
        super.setSize(n, n2);
        if (this.scrollBar.isShowing()) {
            this.dummy.setSize(this.scrollBar.getSize().width, this.dummy.getSize().height);
            this.tableHead.setSize(n - this.scrollBar.getSize().width, this.tableHead.getLineHeight());
            this.tableData.setSize(n - this.scrollBar.getSize().width, n2 - this.tableData.getLineHeight());
            int n3 = this.scrollBar.getValue();
            this.scrollBar.setValues(0, this.tableData.getPageHeight() - 1, 0, this.tableData.getNoRows());
            this.scrollBar.setUnitIncrement(1);
            this.scrollBar.setValue(n3);
        } else {
            this.tableHead.setSize(n, this.tableHead.getLineHeight());
            this.tableData.setSize(n, n2 - this.tableData.getLineHeight());
        }
    }

    public void selectColumn(int n) {
        this.tableData.selectColumn(n);
    }

    public void selectRow(int n) {
        int n2 = this.tableData.getPageHeight();
        int n3 = this.tableData.getTopRow();
        int n4 = this.tableData.getBottomRow();
        if (this.getNoRows() > n2) {
            if (n < n3) {
                this.tableData.setScrollY(n);
                if (this.scrollBar.isShowing()) {
                    this.scrollBar.setValue(n);
                }
            } else if (n > this.tableData.getBottomRow()) {
                this.tableData.setScrollY(n - n4 + n3);
                if (this.scrollBar.isShowing()) {
                    this.scrollBar.setValue(n - n4 + n3);
                }
            }
        }
        this.tableData.selectRow(n);
    }

    public void setClickMode(int n) {
        this.tableData.setClickMode(n);
        if (n == 10) {
            this.tableData.allowMultipleSelections(false);
        }
    }

    public void setColors(Color color, Color color2, Color color3, Color color4, Color color5, Color color6) {
        TColors tColors = new TColors(color, color2, null, null);
        this.tableHead.setColors(tColors);
        TColors tColors2 = new TColors(color3, color4, color5, color6);
        this.tableData.setColors(tColors2);
    }

    public void setColors(int n, int n2, Color color, Color color2, Color color3, Color color4) {
        TColors tColors = new TColors(color, color2, color3, color4);
        this.tableData.setColors(n, n2, tColors);
    }

    public void setColumnColors(int n, Color color, Color color2, Color color3, Color color4) {
        TColors tColors = new TColors(color, color2, color3, color4);
        this.tableData.setColors(-1, n, tColors);
    }

    public void setElement(int n, int n2, String string) {
        this.tableData.setElement(n, n2, string);
    }

    public void setElement(TElement tElement) {
        this.tableData.setElement(tElement);
    }

    public void setEnabled(boolean bl) {
        this.tableHead.setEnabled(bl);
        this.tableData.setEnabled(bl);
        this.isEnabled = bl;
    }

    public void setFonts(Font font, Font font2) {
        this.tableHead.setFont(font);
        this.tableData.setFont(font2);
        if (this.scrollBar.isShowing()) {
            this.tableHead.setSize(this.getSize().width - this.scrollBar.getSize().width, this.tableHead.getLineHeight());
            this.tableData.setSize(this.getSize().width - this.scrollBar.getSize().width, this.getSize().height - this.tableData.getLineHeight());
            this.dummy.setSize(this.scrollBar.getSize().width, this.tableHead.getSize().height);
        } else {
            this.tableHead.setSize(this.getSize().width, this.tableHead.getLineHeight());
            this.tableData.setSize(this.getSize().width, this.getSize().height - this.tableData.getLineHeight());
        }
        this.validate();
        this.updateUI();
        this.repaint();
    }

    public void setHiliteMode(int n) {
        this.tableData.setHiliteMode(n);
    }

    public void setLineSpacing(double d) {
        this.tableData.setLineSpacing(d);
    }

    public void setRowColors(int n, Color color, Color color2, Color color3, Color color4) {
        TColors tColors = new TColors(color, color2, color3, color4);
        this.tableData.setColors(n, -1, tColors);
    }

    public void setScale(int[] nArray) throws IllegalArgumentException {
        try {
            if (nArray.length != this.getNoColumns()) {
                throw new IllegalArgumentException();
            }
            this.tableHead.setScale(nArray);
            this.tableData.setScale(nArray);
            this.tableHead.callSync();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public void showHorizontalSeparator(boolean bl) {
        if (this.tableData != null) {
            this.tableData.showHorizontalSeparator(bl);
        }
    }

    public void showVerticalSeparator(boolean bl) {
        if (this.tableData != null) {
            this.tableData.showVerticalSeparator(bl);
        }
    }

    void hiliteColumn(int n, boolean bl) {
        this.tableData.hiliteColumn(n, bl);
    }

    void setSyncXGrid(int[] nArray) {
        this.tableData.setSyncXGrid(nArray);
        this.dummy.repaint();
    }

    private void setColors() {
        this.setColors(Color.black, Color.gray, Color.black, Color.white, Color.white, Color.black);
    }

    void fireActionEvent() {
        ActionEvent actionEvent = new ActionEvent(this, 1001, null);
        for (int i = 0; i < this.actionListeners.size(); ++i) {
            ((ActionListener)this.actionListeners.elementAt(i)).actionPerformed(actionEvent);
        }
    }

    void fireSelectionEvent(boolean bl) {
        int n = bl ? 1 : 2;
        ItemEvent itemEvent = new ItemEvent(this, 0, null, n);
        for (int i = 0; i < this.itemListeners.size(); ++i) {
            ((ItemListener)this.itemListeners.elementAt(i)).itemStateChanged(itemEvent);
        }
    }

    void updateUI() {
        if (this.getNoRows() > 0) {
            if (this.getPageHeight() < this.getNoRows() && !this.scrollBar.isShowing()) {
                this.top.add("East", this.dummy);
                this.add("East", this.scrollBar);
                this.validate();
                this.tableHead.setSize(this.getSize().width - this.scrollBar.getSize().width, this.tableHead.getLineHeight());
                this.tableData.setSize(this.getSize().width - this.scrollBar.getSize().width, this.getSize().height - this.tableData.getLineHeight());
                this.dummy.setSize(this.scrollBar.getSize().width, this.tableHead.getSize().height);
            } else if (this.getPageHeight() >= this.getNoRows() && this.scrollBar.isShowing()) {
                this.top.remove(this.dummy);
                this.remove(this.scrollBar);
                this.validate();
                this.dummy.setSize(this.scrollBar.getSize().width, this.tableHead.getSize().height);
                this.tableHead.setSize(this.getSize().width, this.tableHead.getLineHeight());
                this.tableData.setSize(this.getSize().width, this.getSize().height - this.tableData.getLineHeight());
            }
            this.tableData.resetGrid();
            this.tableHead.resetGrid();
            int n = this.scrollBar.getValue();
            this.scrollBar.setValues(0, this.tableData.getPageHeight() - 1, 0, this.tableData.getNoRows());
            this.scrollBar.setUnitIncrement(1);
            this.scrollBar.setValue(n);
        }
    }

    class TableScroll
    implements AdjustmentListener {
        TableScroll() {
        }

        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
            Table.this.tableData.setScrollY(adjustmentEvent.getValue());
            Table.this.repaint();
        }
    }
}

