/*
 * Decompiled with CFR 0.152.
 */
package COM.Subrahmanyam.table;

import COM.Subrahmanyam.table.TColors;
import COM.Subrahmanyam.table.TGrid;
import COM.Subrahmanyam.table.TObject;
import java.awt.Graphics;
import java.awt.Rectangle;

class TFillerObject
extends TObject {
    private boolean reverse = false;
    private boolean horizontalSeparator = false;
    private boolean verticalSeparator = false;

    public TFillerObject(int n, int n2) {
        super(n, n2);
    }

    public TFillerObject(int n, int n2, TColors tColors) {
        super(n, n2, tColors);
    }

    public void paint(Graphics graphics, TGrid tGrid) {
        Rectangle rectangle = this.getRectangle(tGrid);
        if (!this.reverse) {
            graphics.setColor(this.colors.getNormalBG());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(this.colors.getNormalFG());
            if (this.horizontalSeparator) {
                graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width, rectangle.y + rectangle.height - 1);
            }
            if (this.verticalSeparator) {
                graphics.drawLine(rectangle.x + (int)((double)rectangle.width * 0.5), rectangle.y, rectangle.x + (int)((double)rectangle.width * 0.5), rectangle.y + rectangle.height - 1);
            }
        } else {
            graphics.setColor(this.colors.getReverseBG());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        }
    }

    public void toggleHilite() {
        this.reverse = !this.reverse;
    }

    public void hilite() {
        this.reverse = true;
    }

    public void unhilite() {
        this.reverse = false;
    }

    public boolean getHilite() {
        return this.reverse;
    }

    public void showHorizontalSeparator(boolean bl) {
        this.horizontalSeparator = bl;
    }

    public void showVerticalSeparator(boolean bl) {
        this.verticalSeparator = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("TFillerObject: ");
        stringBuffer.append(this.iIndex + " " + this.jIndex + "\n");
        return stringBuffer.toString();
    }
}

