/*
 * Decompiled with CFR 0.152.
 */
package COM.Subrahmanyam.table;

import COM.Subrahmanyam.table.TColors;
import COM.Subrahmanyam.table.TGrid;
import COM.Subrahmanyam.table.TObject;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Rectangle;
import java.awt.Toolkit;

class TElementObject
extends TObject {
    private static String FILL = "J";
    private int xpos;
    private int ypos;
    private boolean reverse = false;
    private boolean horizontalSeparator = false;

    TElementObject(String string, int n, int n2) {
        super(string, n, n2);
    }

    TElementObject(String string, int n, int n2, TColors tColors) {
        super(string, n, n2, tColors);
    }

    public void paint(Graphics graphics, TGrid tGrid) {
        Rectangle rectangle = this.getRectangle(tGrid);
        FontMetrics fontMetrics = Toolkit.getDefaultToolkit().getFontMetrics(graphics.getFont());
        int n = fontMetrics.getHeight();
        int n2 = fontMetrics.getMaxAscent();
        int n3 = fontMetrics.getLeading();
        int n4 = (rectangle.height - n) / 2;
        this.xpos = rectangle.x + fontMetrics.stringWidth(FILL);
        this.ypos = rectangle.y + n4 + n2 + n3;
        Rectangle rectangle2 = graphics.getClipBounds();
        graphics.setClip(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        graphics.clipRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
        if (!this.reverse) {
            graphics.setColor(this.colors.getNormalBG());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(this.colors.getNormalFG());
            graphics.drawString(this.name, this.xpos, this.ypos);
            if (this.horizontalSeparator) {
                graphics.drawLine(rectangle.x, rectangle.y + rectangle.height - 1, rectangle.x + rectangle.width, rectangle.y + rectangle.height - 1);
            }
        } else {
            graphics.setColor(this.colors.getReverseBG());
            graphics.fillRect(rectangle.x, rectangle.y, rectangle.width, rectangle.height);
            graphics.setColor(this.colors.getReverseFG());
            graphics.drawString(this.name, this.xpos, this.ypos);
        }
        graphics.setClip(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
        graphics.clipRect(rectangle2.x, rectangle2.y, rectangle2.width, rectangle2.height);
    }

    public boolean mouseEnter() {
        return true;
    }

    public boolean mouseMove() {
        return true;
    }

    public boolean mouseExit() {
        return true;
    }

    public boolean mouseDown() {
        return true;
    }

    public void toggleHilite() {
        this.reverse = !this.reverse;
    }

    public void hilite() {
        this.reverse = true;
    }

    public void unhilite() {
        this.reverse = false;
    }

    public boolean getHilite() {
        return this.reverse;
    }

    public void showHorizontalSeparator(boolean bl) {
        this.horizontalSeparator = bl;
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer("");
        stringBuffer.append("TElementObject: ");
        stringBuffer.append(this.iIndex + " " + this.jIndex + "\n");
        return stringBuffer.toString();
    }
}

