/*
 * Decompiled with CFR 0.152.
 */
package pluginsjaxe;

import com.cqs.ftp.FTP;
import com.cqs.ftp.RemoteFile;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JDialog;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.text.BadLocationException;
import javax.swing.text.JTextComponent;
import jaxe.DialogueChamps;
import jaxe.Fonction;
import jaxe.JaxeDocument;
import org.w3c.dom.Element;

public class EnvoiContrib
implements Fonction {
    static String[] fichiers_ignores = new String[]{".DS_Store", "Thumbs.db"};
    static String[] dossiers_ignores = new String[]{"equations_jaxe", "equations_tex"};
    Element fctdef = null;
    String serveur = null;
    String dossier = null;
    DialogueLog dlglog = null;
    FTP ftp = null;
    String nom_contrib = null;

    public EnvoiContrib(Element element) {
        this.fctdef = element;
    }

    public boolean appliquer(JaxeDocument jaxeDocument, int n, int n2) {
        this.serveur = jaxeDocument.cfg.valeurParametreFonction(this.fctdef, "serveur", this.serveur);
        this.dossier = jaxeDocument.cfg.valeurParametreFonction(this.fctdef, "dossier", this.dossier);
        if (jaxeDocument.fsave == null) {
            JOptionPane.showMessageDialog(jaxeDocument.jframe, "Erreur: le fichier doit \u00eatre sauvegard\u00e9.", "Erreur", 0);
            return false;
        }
        File file = jaxeDocument.fsave.getParentFile();
        if (!jaxeDocument.fsave.getName().equals(file.getName() + ".xml")) {
            JOptionPane.showMessageDialog(jaxeDocument.jframe, "Erreur: le fichier XML doit avoir le m\u00eame nom que le dossier de la contribution.", "Erreur", 0);
            return false;
        }
        this.nom_contrib = file.getName();
        String[] stringArray = new String[]{"login", "mot de passe"};
        JComponent[] jComponentArray = new JTextComponent[]{new JTextField(10), new JPasswordField(20)};
        DialogueChamps dialogueChamps = new DialogueChamps(jaxeDocument.jframe, "Authentification", stringArray, jComponentArray);
        if (!dialogueChamps.afficher()) {
            return false;
        }
        String string = ((JTextComponent)jComponentArray[0]).getText();
        String string2 = ((JTextComponent)jComponentArray[1]).getText();
        new ThreadUpload(jaxeDocument, file, string, string2).start();
        return true;
    }

    protected void logEtTestErreur(String string, int n) throws FTPException {
        this.dlglog.ajouterString(string + "...\n");
        if (this.ftp.lastCode() != n) {
            throw new FTPException("Erreur de l'op\u00e9ration FTP '" + string + "'");
        }
    }

    protected void cd(String string) throws FTPException {
        this.ftp.cd(string);
        this.logEtTestErreur("changement vers le r\u00e9pertoire '" + string + "'", 250);
    }

    protected void mkdir(String string) throws FTPException {
        this.ftp.makedir(string);
        this.logEtTestErreur("cr\u00e9ation du r\u00e9pertoire '" + string + "'", 257);
    }

    protected void delete(String string) throws FTPException {
        this.ftp.delete(string);
        this.logEtTestErreur("effacement du fichier '" + string + "'", 250);
    }

    protected void removedir(String string) throws FTPException {
        this.ftp.removedir(string);
        this.logEtTestErreur("effacement du dossier '" + string + "'", 250);
    }

    protected void upload(File file) throws FTPException {
        for (int i = 0; i < fichiers_ignores.length; ++i) {
            if (!file.getName().equals(fichiers_ignores[i]) && !file.getName().equals(this.nom_contrib + ".html")) continue;
            return;
        }
        this.ftp.upload(file.getAbsolutePath(), file.getName());
        this.logEtTestErreur("envoi du fichier '" + file.getName() + "' sur le serveur", 226);
    }

    protected void uploadRecursif(File file) throws FTPException {
        for (int i = 0; i < dossiers_ignores.length; ++i) {
            if (!file.getName().equals(dossiers_ignores[i])) continue;
            return;
        }
        this.mkdir(file.getName());
        this.cd(file.getName());
        File[] fileArray = file.listFiles();
        for (int i = 0; i < fileArray.length; ++i) {
            if (fileArray[i].isDirectory()) {
                this.uploadRecursif(fileArray[i]);
                continue;
            }
            this.upload(fileArray[i]);
        }
        this.cd("..");
    }

    protected void effacementRecursif(String string) throws FTPException {
        this.cd(string);
        this.ftp.list();
        this.logEtTestErreur("listing repertoire", 226);
        RemoteFile[] remoteFileArray = this.ftp.getDirectoryList();
        for (int i = 0; i < remoteFileArray.length; ++i) {
            if (remoteFileArray[i].isDirectory) {
                this.effacementRecursif(remoteFileArray[i].name);
                continue;
            }
            this.delete(remoteFileArray[i].name);
        }
        this.cd("..");
        this.removedir(string);
    }

    class DialogueLog
    extends JDialog {
        JTextArea tarea;

        public DialogueLog(Frame frame) {
            super(frame, "log", false);
            JPanel jPanel = new JPanel(new BorderLayout());
            this.setContentPane(jPanel);
            this.tarea = new JTextArea(null, 15, 60);
            this.tarea.setEditable(false);
            JScrollPane jScrollPane = new JScrollPane(this.tarea, 22, 31);
            jPanel.add((Component)jScrollPane, "Center");
            jPanel.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
            this.pack();
            if (frame != null) {
                Rectangle rectangle = frame.getBounds();
                this.setLocation(rectangle.x + rectangle.width / 4, rectangle.y + rectangle.height / 4);
            } else {
                Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                this.setLocation((dimension.width - this.getSize().width) / 3, (dimension.height - this.getSize().height) / 3);
            }
            this.setVisible(true);
        }

        public void ajouterString(String string) {
            this.tarea.append(string);
            try {
                this.tarea.scrollRectToVisible(this.tarea.modelToView(this.tarea.getDocument().getLength()));
            }
            catch (BadLocationException badLocationException) {
                // empty catch block
            }
        }
    }

    class ThreadUpload
    extends Thread {
        JaxeDocument doc;
        File dossierContrib;
        String login;
        String password;

        public ThreadUpload(JaxeDocument jaxeDocument, File file, String string, String string2) {
            this.dossierContrib = file;
            this.doc = jaxeDocument;
            this.login = string;
            this.password = string2;
        }

        public void run() {
            EnvoiContrib.this.dlglog = new DialogueLog(this.doc.jframe);
            EnvoiContrib.this.ftp = null;
            try {
                int n;
                EnvoiContrib.this.ftp = new FTP(EnvoiContrib.this.serveur);
                EnvoiContrib.this.ftp.connect();
                EnvoiContrib.this.logEtTestErreur("connexion au serveur " + EnvoiContrib.this.serveur, 220);
                EnvoiContrib.this.ftp.login(this.login, this.password);
                EnvoiContrib.this.logEtTestErreur("authentification (login/mot de passe)", 230);
                EnvoiContrib.this.ftp.setMode(1);
                EnvoiContrib.this.cd(EnvoiContrib.this.dossier);
                EnvoiContrib.this.ftp.list();
                EnvoiContrib.this.logEtTestErreur("listing repertoire", 226);
                RemoteFile[] remoteFileArray = EnvoiContrib.this.ftp.getDirectoryList();
                boolean bl = false;
                for (n = 0; n < remoteFileArray.length; ++n) {
                    if (!this.dossierContrib.getName().equals(remoteFileArray[n].name)) continue;
                    bl = true;
                    break;
                }
                if (bl) {
                    n = JOptionPane.showConfirmDialog(this.doc.jframe, "Le dossier existe d\u00e9j\u00e0 sur le serveur. Mettre \u00e0 jour la contribution ?", "Ecrasement", 2);
                    if (n == 2) {
                        throw new FTPException("Copie annul\u00e9e.");
                    }
                    EnvoiContrib.this.effacementRecursif(this.dossierContrib.getName());
                }
                EnvoiContrib.this.uploadRecursif(this.dossierContrib);
                EnvoiContrib.this.ftp.disconnect();
                EnvoiContrib.this.logEtTestErreur("d\u00e9connexion", 221);
            }
            catch (FTPException fTPException) {
                if (EnvoiContrib.this.ftp != null && EnvoiContrib.this.ftp.isConnected()) {
                    EnvoiContrib.this.ftp.disconnect();
                }
                JOptionPane.showMessageDialog(this.doc.jframe, fTPException.getMessage(), "Erreur", 0);
                EnvoiContrib.this.dlglog.setVisible(false);
                EnvoiContrib.this.dlglog = null;
                return;
            }
            JOptionPane.showMessageDialog(this.doc.jframe, "La copie s'est effectu\u00e9e avec succ\u00e8s.", "Succ\u00e8s", 1);
            EnvoiContrib.this.dlglog.setVisible(false);
            EnvoiContrib.this.dlglog = null;
        }
    }

    class FTPException
    extends Exception {
        public FTPException(String string) {
            super(string);
        }
    }
}

