/*
 * Decompiled with CFR 0.152.
 */
package simu;

import java.applet.Applet;
import java.awt.Image;
import java.awt.MediaTracker;
import ptolemy.plot.Plot;
import simu.Affichage;
import simu.ZoomImage;

public class SimuPlot
extends Plot {
    Applet applet;
    String fond;
    boolean zooming;
    int tailleX;
    int tailleY;
    double echImgX;
    double echImgY;
    double minImgX;
    double maxImgX;
    double minImgY;
    double maxImgY;
    Image img;

    public SimuPlot(Applet applet, Affichage affichage) {
        this.applet = applet;
        this.fond = affichage.fond;
        this.zooming = affichage.zooming;
        this.setTitle("SimuPlot");
        this.setPointsPersistence(0);
        this.setMarksStyle("points");
        this.setSquareArea(affichage.carre);
        this.setXLog(affichage.xlog);
        this.setYLog(affichage.ylog);
        if (this.fond != null) {
            this.img = this.applet.getImage(this.applet.getDocumentBase(), this.fond);
            if (this.img != null) {
                this.img = SimuPlot.chargementImage(this.applet, this.img);
            }
            if (this.img == null) {
                this.img = this.applet.getImage(this.applet.getClass().getResource(this.fond));
                if (this.img != null) {
                    this.img = SimuPlot.chargementImage(this.applet, this.img);
                }
            }
            if (this.img == null) {
                System.err.println("erreur au chargement de l'image " + this.fond);
            } else {
                this.tailleY = this.img.getHeight(null);
                this.tailleX = this.img.getWidth(null);
                this.setBackgroundImage(this.img);
            }
        } else if (this.zooming) {
            System.err.println("erreur: zoomimg ne peut \u00eatre activ\u00e9 car aucune image de fond n'a \u00e9t\u00e9 sp\u00e9cifi\u00e9");
            this.zooming = false;
        }
        if (this.zooming) {
            if (affichage.xdebut == null) {
                System.err.println("xdebut n'a pas \u00e9t\u00e9 initialis\u00e9 + zooming = bug");
            }
            if (affichage.xdebutfond != null && affichage.xfinfond != null && affichage.ydebutfond != null && affichage.yfinfond != null) {
                this.minImgX = new Double(affichage.xdebutfond);
                this.maxImgX = new Double(affichage.xfinfond);
                this.minImgY = new Double(affichage.ydebutfond);
                this.maxImgY = new Double(affichage.yfinfond);
            } else {
                double d = new Double(affichage.xdebut);
                double d2 = new Double(affichage.xfin);
                this.minImgX = d - (d2 - d) * 0.05;
                this.maxImgX = d2 + (d2 - d) * 0.05;
                double d3 = new Double(affichage.ydebut);
                double d4 = new Double(affichage.yfin);
                this.minImgY = d3 - (d4 - d3) * 0.05;
                this.maxImgY = d4 + (d4 - d3) * 0.05;
            }
            this.echImgX = (double)this.tailleX / (this.maxImgX - this.minImgX);
            this.echImgY = (double)this.tailleY / (this.maxImgY - this.minImgY);
        }
    }

    public static Image chargementImage(Applet applet, Image image) {
        MediaTracker mediaTracker = new MediaTracker(applet);
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForAll();
        }
        catch (InterruptedException interruptedException) {
            return null;
        }
        if (mediaTracker.isErrorAny()) {
            return null;
        }
        return image;
    }

    public void addPoint(int n, double d, double d2, boolean bl) {
        super.addPoint(n, d, d2, bl);
    }

    public void setXRange(double d, double d2) {
        super.setXRange(d, d2);
        if (this.zooming) {
            this.setImage();
        }
    }

    public void setImage() {
        Image image;
        int n;
        double d;
        int n2;
        double d2;
        int n3;
        double d3;
        int n4;
        double d4;
        if (this.minImgX > this._xMin) {
            d4 = (this.minImgX - this._xMin) / (this._xMax - this._xMin);
            n4 = 0;
        } else {
            d4 = 0.0;
            n4 = (int)Math.round((this._xMin - this.minImgX) * this.echImgX);
        }
        if (this.minImgX > this._xMin && this.maxImgX < this._xMax) {
            d3 = (this.maxImgX - this.minImgX) / (this._xMax - this._xMin);
            n3 = this.tailleX;
        } else if (this.minImgX <= this._xMin && this.maxImgX < this._xMax) {
            d3 = (this.maxImgX - this._xMin) / (this._xMax - this._xMin);
            n3 = (int)Math.round((this.maxImgX - this._xMin) * this.echImgX);
        } else if (this.minImgX > this._xMin && this.maxImgX >= this._xMax) {
            d3 = (this._xMax - this.minImgX) / (this._xMax - this._xMin);
            n3 = (int)Math.round((this._xMax - this.minImgX) * this.echImgX);
        } else {
            d3 = 1.0;
            n3 = (int)Math.round((this._xMax - this._xMin) * this.echImgX);
        }
        if (this.maxImgY < this._yMax) {
            d2 = (this._yMax - this.maxImgY) / (this._yMax - this._yMin);
            n2 = 0;
        } else {
            d2 = 0.0;
            n2 = (int)Math.round((this.maxImgY - this._yMax) * this.echImgY);
        }
        if (this.minImgY > this._yMin && this.maxImgY < this._yMax) {
            d = (this.maxImgY - this.minImgY) / (this._yMax - this._yMin);
            n = this.tailleY;
        } else if (this.minImgY <= this._yMin && this.maxImgY < this._yMax) {
            d = (this.maxImgY - this._yMin) / (this._yMax - this._yMin);
            n = (int)Math.round((this.maxImgY - this._yMin) * this.echImgY);
        } else if (this.minImgY > this._yMin && this.maxImgY >= this._yMax) {
            d = (this._yMax - this.minImgY) / (this._yMax - this._yMin);
            n = (int)Math.round((this._yMax - this.minImgY) * this.echImgY);
        } else {
            d = 1.0;
            n = (int)Math.round((this._yMax - this._yMin) * this.echImgY);
        }
        if (n3 == 0) {
            n3 = 1;
            if (n4 == this.tailleX) {
                n4 = this.tailleX - 1;
            }
        }
        if (n == 0) {
            n = 1;
            if (n2 == this.tailleY) {
                n2 = this.tailleY - 1;
            }
        }
        if (this._xMin > this.maxImgX || this._xMax < this.minImgX || this._yMin > this.maxImgY || this._yMax < this.minImgY) {
            image = null;
            d4 = 0.0;
            d2 = 0.0;
            d3 = 0.0;
            d = 0.0;
        } else {
            image = n4 != 0 || n2 != 0 || n3 != this.tailleX || n != this.tailleY ? ZoomImage.ajusterImage(this.img, n4, n2, n3, n, this.applet, this.tailleX, this.tailleY) : this.img;
        }
        this.setBackgroundImage(image, d4, d2, d3, d);
    }

    public void setYRange(double d, double d2) {
        super.setYRange(d, d2);
        if (this.zooming) {
            this.setImage();
        }
    }

    public synchronized void zoom(double d, double d2, double d3, double d4) {
        super.zoom(d, d2, d3, d4);
        if (this.zooming) {
            this.setImage();
        }
    }

    public synchronized void fillPlot() {
        super.fillPlot();
        if (this.zooming) {
            this.setImage();
        }
    }
}

