/*
 * Decompiled with CFR 0.152.
 */
package simu;

import java.applet.Applet;
import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Canvas;
import java.awt.Checkbox;
import java.awt.Choice;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.LayoutManager;
import java.awt.Panel;
import java.awt.Point;
import java.awt.ScrollPane;
import java.awt.Scrollbar;
import java.awt.TextArea;
import java.awt.TextComponent;
import java.awt.TextField;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.AdjustmentEvent;
import java.awt.event.AdjustmentListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;
import simu.AffImage;
import simu.AffMulti;
import simu.AffPlot;
import simu.AffPlotLive;
import simu.AffPlotTab;
import simu.Affichage;
import simu.Chronos;
import simu.ListeValeurs;
import simu.Messages;
import simu.ParamIn;
import simu.ParamOut;
import simu.SimuException;
import simu.SimuParams;
import simu.TypeAffichage;
import xml.Parser_XML;
import xml.XMLTree;

public abstract class SimuApplet
extends Applet
implements ActionListener,
ItemListener,
SimuParams {
    SimuParams params;
    Vector champs;
    int noaff;
    TypeAffichage za;
    Choice chxens = null;
    String selens = null;
    String nomFichierXML = null;
    XMLTree xmlDoc = null;
    ScrollPane scrollp = null;
    protected Vector inparams = new Vector();
    protected Vector outparams = new Vector();
    protected Vector affichages = new Vector();
    protected ListeValeurs ensembles = new ListeValeurs();
    protected String titreEnsembles = Messages.get("Ensembles");

    public void setParams() {
        this.params = this;
    }

    public void init() {
        super.init();
        this.initParams();
    }

    public Panel makeInputPanel(ListeValeurs listeValeurs) {
        Object object;
        Object object2;
        Object object3;
        Vector vector = this.params.getInParams();
        Panel panel = new Panel();
        int n = vector.size() + 1;
        if (this.ensembles.taille() > 0) {
            ++n;
        }
        panel.setLayout(new GridLayout(n, 1));
        this.champs = new Vector();
        try {
            object3 = null;
            if (this.ensembles.taille() > 0) {
                Panel panel2 = new Panel();
                panel2.setLayout(new FlowLayout(0));
                panel2.add(new Label(this.titreEnsembles + ":"));
                this.chxens = new Choice();
                object2 = this.ensembles.noms();
                for (int i = 0; i < ((Vector)object2).size(); ++i) {
                    object = (String)((Vector)object2).elementAt(i);
                    this.chxens.add((String)object);
                    if (object3 != null) continue;
                    object3 = (ListeValeurs)this.ensembles.lire((String)object);
                }
                if (this.selens != null) {
                    this.chxens.select(this.selens);
                    object3 = (ListeValeurs)this.ensembles.lire(this.selens);
                }
                this.chxens.addItemListener(this);
                panel2.add(this.chxens);
                panel.add(panel2);
            }
            for (int i = 0; i < vector.size(); ++i) {
                Serializable serializable;
                String string;
                object2 = (ParamIn)vector.elementAt(i);
                Panel panel3 = new Panel();
                object = null;
                if (this.verifExistenceAide((ParamIn)object2)) {
                    object = new Button(Messages.get("?"));
                    ((Button)object).addActionListener(this);
                    ((Button)object).setActionCommand("help" + i);
                }
                if ((string = ((ParamIn)object2).titre) == null) {
                    string = ((ParamIn)object2).label;
                }
                if (((ParamIn)object2).unit != null) {
                    string = string + " (" + ((ParamIn)object2).unit + ")";
                }
                String string2 = null;
                if (listeValeurs != null) {
                    string2 = listeValeurs.lireString(((ParamIn)object2).label);
                } else if (object3 != null) {
                    try {
                        string2 = ((ListeValeurs)object3).lireString(((ParamIn)object2).label);
                    }
                    catch (SimuException simuException) {
                        // empty catch block
                    }
                }
                if (string2 == null && ((ParamIn)object2).defaut != null) {
                    string2 = ((ParamIn)object2).defaut;
                }
                if ("champ".equals(((ParamIn)object2).acquisition)) {
                    panel3.setLayout(new FlowLayout(0));
                    if (object != null) {
                        panel3.add((Component)object);
                    }
                    panel3.add(new Label(string + ":"));
                    serializable = new TextField(10);
                    if (string2 != null) {
                        ((TextComponent)serializable).setText(string2);
                    }
                    this.champs.addElement(serializable);
                    panel3.add((Component)serializable);
                } else if ("choix".equals(((ParamIn)object2).acquisition)) {
                    panel3.setLayout(new FlowLayout(0));
                    if (object != null) {
                        panel3.add((Component)object);
                    }
                    panel3.add(new Label(string + ":"));
                    serializable = new Choice();
                    for (int j = 0; j < ((ParamIn)object2).choix.length; ++j) {
                        ((Choice)serializable).add(((ParamIn)object2).choix[j]);
                    }
                    if (string2 != null) {
                        ((Choice)serializable).select(string2);
                    }
                    this.champs.addElement(serializable);
                    panel3.add((Component)serializable);
                } else if ("curseur".equals(((ParamIn)object2).acquisition)) {
                    Component component;
                    serializable = new GridBagLayout();
                    GridBagConstraints gridBagConstraints = new GridBagConstraints();
                    gridBagConstraints.anchor = 18;
                    gridBagConstraints.gridwidth = 0;
                    gridBagConstraints.weightx = 1.0;
                    gridBagConstraints.weighty = 1.0;
                    panel3.setLayout((LayoutManager)((Object)serializable));
                    if (object != null) {
                        component = new Panel();
                        ((Container)component).add((Component)object);
                        ((Container)component).add(new Label(string + ":"));
                        ((GridBagLayout)serializable).setConstraints(component, gridBagConstraints);
                        panel3.add(component);
                    } else {
                        component = new Label(string + ":");
                        ((GridBagLayout)serializable).setConstraints(component, gridBagConstraints);
                        panel3.add(component);
                    }
                    component = new Panel();
                    ((Container)component).setLayout(new BorderLayout());
                    Canvas canvas = new Canvas();
                    canvas.setSize(250, 1);
                    ((Container)component).add("North", canvas);
                    Scrollbar scrollbar = new Scrollbar(0, 0, 10, 0, 110);
                    final Label label = new Label();
                    if (string2 != null) {
                        scrollbar.setValue(new Double(string2).intValue());
                        label.setText(" = " + string2 + "  ");
                    } else {
                        scrollbar.setValue(0);
                        label.setText(" = 0   ");
                    }
                    scrollbar.addAdjustmentListener(new AdjustmentListener(){

                        public void adjustmentValueChanged(AdjustmentEvent adjustmentEvent) {
                            label.setText(" = " + Integer.toString(adjustmentEvent.getValue()));
                        }
                    });
                    ((Container)component).add("East", label);
                    ((Container)component).add("Center", scrollbar);
                    this.champs.addElement(scrollbar);
                    ((GridBagLayout)serializable).setConstraints(component, gridBagConstraints);
                    panel3.add(component);
                } else if ("case".equals(((ParamIn)object2).acquisition)) {
                    panel3.setLayout(new FlowLayout(0));
                    if (object != null) {
                        panel3.add((Component)object);
                    }
                    serializable = new Checkbox(string);
                    if (string2 != null && "on".equals(string2)) {
                        ((Checkbox)serializable).setState(true);
                    }
                    panel3.add((Component)serializable);
                    this.champs.addElement(serializable);
                } else {
                    this.champs.addElement(null);
                }
                panel.add(panel3);
            }
        }
        catch (SimuException simuException) {
            this.handleException(simuException);
            return null;
        }
        object3 = new Panel();
        ((Container)object3).setLayout(new FlowLayout(0));
        Vector vector2 = this.params.getAffichage();
        if (this.noaff == -1) {
            for (int i = 0; i < vector2.size(); ++i) {
                Affichage affichage = (Affichage)vector2.elementAt(i);
                object = new Button(affichage.titre);
                ((Button)object).setActionCommand("OK" + i);
                ((Button)object).addActionListener(this);
                ((Container)object3).add((Component)object);
            }
        } else {
            object2 = (Affichage)vector2.elementAt(this.noaff);
            Button button = new Button(Messages.get("Relancer"));
            button.setActionCommand("Relancer");
            button.addActionListener(this);
            ((Container)object3).add(button);
        }
        panel.add((Component)object3);
        if (vector.size() > 15) {
            this.scrollp = new ScrollPane();
            this.scrollp.add(panel);
            Panel panel4 = new Panel();
            panel4.setLayout(new BorderLayout(0, 0));
            panel4.add("Center", this.scrollp);
            return panel4;
        }
        this.scrollp = null;
        Panel panel5 = new Panel();
        panel5.setLayout(new BorderLayout(0, 0));
        panel5.add("North", panel);
        return panel5;
    }

    public void initParams() {
        if (!this.inparams.isEmpty() && this.xmlDoc == null) {
            if (this.nomFichierXML != null) {
                this.lireXML();
            }
        } else if (this.xmlDoc == null) {
            this.lireParametres();
        }
        this.removeAll();
        this.setParams();
        this.setLayout(new BorderLayout(0, 0));
        this.noaff = -1;
        this.za = null;
        Panel panel = this.makeInputPanel(null);
        if (panel != null) {
            this.add("North", panel);
        }
        if (this.scrollp != null) {
            this.scrollp.setSize(this.scrollp.getComponent((int)0).getPreferredSize().width + this.scrollp.getVScrollbarWidth(), this.getSize().height);
            this.validate();
            this.scrollp.invalidate();
        }
        this.validate();
    }

    public void lireParametres() {
        if (this.xmlDoc == null) {
            this.lireXML();
        }
        XMLTree xMLTree = null;
        xMLTree = "APPLET_SIMULAB".equals(this.xmlDoc.tag) ? this.xmlDoc : this.xmlDoc.getNode("APPLETDOC");
        if (xMLTree == null) {
            System.err.println(Messages.get("sans_appletdoc"));
        } else {
            XMLTree xMLTree2 = xMLTree.getNode("LISTEPARAMS");
            if (xMLTree2 == null) {
                System.err.println(Messages.get("sans_listeparams"));
            } else {
                XMLTree xMLTree3 = xMLTree2.first_child;
                while (xMLTree3 != null) {
                    Object object;
                    Object object2;
                    if (xMLTree3.tag.equals("PARAMETRE")) {
                        object2 = new ParamIn();
                        object = null;
                        object = xMLTree3.getAttVal("acquisition");
                        if (object != null) {
                            ((ParamIn)object2).acquisition = object;
                        }
                        if ((object = xMLTree3.getAttVal("defaut")) != null) {
                            ((ParamIn)object2).defaut = object;
                        }
                        if ((object = xMLTree3.getAttVal("label")) != null) {
                            ((ParamIn)object2).label = object;
                        }
                        if ((object = xMLTree3.getAttVal("titre")) != null) {
                            ((ParamIn)object2).titre = object;
                        }
                        if ((object = xMLTree3.getAttVal("type")) != null) {
                            ((ParamIn)object2).type = object;
                        }
                        if ((object = xMLTree3.getAttVal("unite")) != null) {
                            ((ParamIn)object2).unit = object;
                        }
                        if (xMLTree3.val != null && !"".equals(xMLTree3.val)) {
                            ((ParamIn)object2).description = xMLTree3.val;
                        }
                        this.addParamIn((ParamIn)object2);
                    }
                    if (xMLTree3.tag.equals("PARAMETRE_ENTREE")) {
                        object2 = new ParamIn();
                        object = null;
                        object = xMLTree3.getAttVal("acquisition");
                        if (object != null) {
                            ((ParamIn)object2).acquisition = object;
                            if (((String)object).equals("choix")) {
                                XMLTree xMLTree4 = xMLTree3.getNode("VALEURS");
                                if (xMLTree4 == null) {
                                    System.err.println("Erreur: acquisition choix sans \u00e9l\u00e9ment VALEURS sous PARAMETRE_ENTREE");
                                } else {
                                    String[] stringArray = new String[xMLTree4.getChildrenCount()];
                                    for (int i = 0; i < xMLTree4.getChildrenCount(); ++i) {
                                        XMLTree xMLTree5 = xMLTree4.getChildAt(i);
                                        object = xMLTree5.getAttVal("valeur");
                                        stringArray[i] = object != null ? object : "";
                                    }
                                    ((ParamIn)object2).choix = stringArray;
                                }
                            }
                        }
                        if ((object = xMLTree3.getAttVal("defaut")) != null) {
                            ((ParamIn)object2).defaut = object;
                        }
                        if ((object = xMLTree3.getAttVal("label")) != null) {
                            ((ParamIn)object2).label = object;
                        }
                        if ((object = xMLTree3.getAttVal("titre")) != null) {
                            ((ParamIn)object2).titre = object;
                        }
                        if ((object = xMLTree3.getAttVal("type")) != null) {
                            ((ParamIn)object2).type = object;
                        }
                        if ((object = xMLTree3.getAttVal("unite")) != null) {
                            ((ParamIn)object2).unit = object;
                        }
                        if (xMLTree3.getNode("DESCRIPTION") != null) {
                            ((ParamIn)object2).description = xMLTree3.getNode((String)"DESCRIPTION").val;
                        }
                        this.addParamIn((ParamIn)object2);
                    }
                    if (xMLTree3.tag.equals("PARAMETRE_SORTIE")) {
                        object2 = new ParamOut();
                        object = null;
                        object = xMLTree3.getAttVal("label");
                        if (object != null) {
                            ((ParamOut)object2).label = object;
                        }
                        if ((object = xMLTree3.getAttVal("type")) != null) {
                            ((ParamOut)object2).type = object;
                        }
                        if ((object = xMLTree3.getAttVal("titre")) != null) {
                            ((ParamOut)object2).titre = object;
                        }
                        if ((object = xMLTree3.getAttVal("unite")) != null) {
                            ((ParamOut)object2).unit = object;
                        }
                        this.addParamOut((ParamOut)object2);
                    }
                    if (xMLTree3.tag.equals("AFFICHAGE")) {
                        this.addAffichage(this.lireAffichage(xMLTree3));
                    }
                    if (xMLTree3.tag.equals("ENSEMBLE")) {
                        object2 = new ListeValeurs();
                        object = xMLTree3.first_child;
                        while (object != null) {
                            ((ListeValeurs)object2).ajouterString(((XMLTree)object).getAttVal("label"), ((XMLTree)object).getAttVal("valeur"));
                            object = ((XMLTree)object).next_brother;
                        }
                        this.addEnsemble(xMLTree3.getAttVal("titre"), (ListeValeurs)object2);
                    }
                    xMLTree3 = xMLTree3.next_brother;
                }
            }
        }
    }

    public Affichage lireAffichage(XMLTree xMLTree) {
        Affichage affichage = new Affichage();
        this.parcourirParametreAffichage(xMLTree, affichage);
        this.lireListeRefParams(xMLTree, affichage);
        Vector<Affichage> vector = new Vector<Affichage>();
        XMLTree xMLTree2 = xMLTree.first_child;
        while (xMLTree2 != null) {
            if ("AFFICHAGE".equals(xMLTree2.tag)) {
                vector.addElement(this.lireAffichage(xMLTree2));
            }
            xMLTree2 = xMLTree2.next_brother;
        }
        if (vector.size() > 0) {
            affichage.sousAff = new Affichage[vector.size()];
            vector.copyInto(affichage.sousAff);
        }
        return affichage;
    }

    public void lireListeRefParams(XMLTree xMLTree, Affichage affichage) {
        Vector<String[]> vector = new Vector<String[]>();
        int n = 0;
        XMLTree xMLTree2 = xMLTree.first_child;
        while (xMLTree2 != null) {
            if ("LISTEREFPARAMS".equals(xMLTree2.tag)) {
                String[] stringArray = new String[xMLTree2.getChildrenCount()];
                for (int i = 0; i < stringArray.length; ++i) {
                    stringArray[i] = xMLTree2.getChildAt(i).getAttVal("nom");
                }
                vector.addElement(stringArray);
                if (n == 0) {
                    n = stringArray.length;
                } else if (n != stringArray.length) {
                    System.err.println("Erreur: pas le m\u00eame nombre de r\u00e9f\u00e9rences dans toutes les listes de r\u00e9f\u00e9rences de param\u00e8tres");
                }
            }
            xMLTree2 = xMLTree2.next_brother;
        }
        if (vector.size() > 0) {
            affichage.params = new String[vector.size()][n];
            vector.copyInto((Object[])affichage.params);
        }
    }

    public void parcourirParametreAffichage(XMLTree xMLTree, Affichage affichage) {
        String string = null;
        string = xMLTree.getAttVal("type");
        if (string != null) {
            affichage.type = string;
        }
        if ((string = xMLTree.getAttVal("titre")) != null) {
            affichage.titre = string;
        }
        if ((string = xMLTree.getAttVal("label")) != null) {
            affichage.label = string;
        }
        if ((string = xMLTree.getAttVal("xdebut")) != null) {
            affichage.xdebut = string;
        }
        if ((string = xMLTree.getAttVal("xfin")) != null) {
            affichage.xfin = string;
        }
        if ((string = xMLTree.getAttVal("ydebut")) != null) {
            affichage.ydebut = string;
        }
        if ((string = xMLTree.getAttVal("yfin")) != null) {
            affichage.yfin = string;
        }
        if ((string = xMLTree.getAttVal("xlog")) != null) {
            affichage.xlog = Boolean.valueOf(string);
        }
        if ((string = xMLTree.getAttVal("ylog")) != null) {
            affichage.ylog = Boolean.valueOf(string);
        }
        if ((string = xMLTree.getAttVal("fond")) != null) {
            affichage.fond = string;
        }
        if ((string = xMLTree.getAttVal("xdebutfond")) != null) {
            affichage.xdebutfond = string;
        }
        if ((string = xMLTree.getAttVal("xfinfond")) != null) {
            affichage.xfinfond = string;
        }
        if ((string = xMLTree.getAttVal("ydebutfond")) != null) {
            affichage.ydebutfond = string;
        }
        if ((string = xMLTree.getAttVal("yfinfond")) != null) {
            affichage.yfinfond = string;
        }
        if ((string = xMLTree.getAttVal("zooming")) != null) {
            affichage.zooming = Boolean.valueOf(string);
        }
        if ((string = xMLTree.getAttVal("imgdimx")) != null) {
            affichage.imgdimx = Integer.parseInt(string);
        }
        if ((string = xMLTree.getAttVal("imgdimy")) != null) {
            affichage.imgdimy = Integer.parseInt(string);
        }
        if ((string = xMLTree.getAttVal("connecter")) != null) {
            affichage.connecter = Boolean.valueOf(string);
        }
        if ((string = xMLTree.getAttVal("ordreSousAff")) != null) {
            affichage.ordreSousAff = string;
        }
        if ((string = xMLTree.getAttVal("boucle")) != null) {
            affichage.boucle = Boolean.valueOf(string);
        }
        if ((string = xMLTree.getAttVal("points")) != null) {
            affichage.points = string;
        }
        if ((string = xMLTree.getAttVal("couleurs")) != null) {
            affichage.couleurs = Boolean.valueOf(string);
        }
        if ((string = xMLTree.getAttVal("histogramme")) != null) {
            affichage.histogramme = Boolean.valueOf(string);
        }
        if ((string = xMLTree.getAttVal("effacer")) != null) {
            affichage.effacer = Boolean.valueOf(string);
        }
        if ((string = xMLTree.getAttVal("ajuster")) != null) {
            affichage.ajuster = Boolean.valueOf(string);
        }
        if ((string = xMLTree.getAttVal("recadrer")) != null) {
            affichage.recadrer = Boolean.valueOf(string);
        }
        if ((string = xMLTree.getAttVal("carre")) != null) {
            affichage.carre = Boolean.valueOf(string);
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.startsWith("OK")) {
            this.noaff = 0;
            try {
                this.noaff = Integer.valueOf(string.substring(2));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            this.startSimu(true);
        } else if ("Reset".equals(string)) {
            if (this.za != null && this.za.estLive()) {
                this.za.stop();
            }
            this.initParams();
        } else if ("Relancer".equals(string)) {
            if (this.za != null && this.za.estLive()) {
                this.za.stop();
            }
            this.startSimu(false);
        } else if (string.startsWith("help")) {
            int n = Integer.valueOf(string.substring(4));
            this.aideParam(n);
        }
    }

    public void changerValeurs(ListeValeurs listeValeurs) throws SimuException {
        Vector vector = this.params.getInParams();
        for (int i = 0; i < vector.size(); ++i) {
            String string;
            ParamIn paramIn = (ParamIn)vector.elementAt(i);
            try {
                string = listeValeurs.lireString(paramIn.label);
            }
            catch (SimuException simuException) {
                continue;
            }
            Object e = this.champs.elementAt(i);
            if (e instanceof TextField) {
                ((TextComponent)((TextField)e)).setText(string);
                continue;
            }
            if (e instanceof Scrollbar) {
                ((Scrollbar)e).setValue(new Double(string).intValue());
                continue;
            }
            if (e instanceof Choice) {
                ((Choice)e).select(string);
                continue;
            }
            if (!(e instanceof Checkbox)) continue;
            ((Checkbox)e).setState("on".equals(string));
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        String string = this.chxens.getSelectedItem();
        try {
            ListeValeurs listeValeurs = (ListeValeurs)this.ensembles.lire(string);
            this.changerValeurs(listeValeurs);
        }
        catch (SimuException simuException) {
            this.handleException(simuException);
            return;
        }
    }

    public void handleException(SimuException simuException) {
        System.err.println("SimuException: " + simuException.getMessage());
        this.removeAll();
        this.setLayout(new BorderLayout());
        this.add("North", new Label(Messages.get("Erreur") + ": " + simuException.getMessage()));
        Button button = new Button(Messages.get("Reinitialiser"));
        button.setActionCommand("Reset");
        button.addActionListener(this);
        this.add("South", button);
        this.validate();
    }

    public ListeValeurs lireChamps() throws SimuException {
        ListeValeurs listeValeurs = new ListeValeurs();
        Vector vector = this.params.getInParams();
        for (int i = 0; i < vector.size(); ++i) {
            Component component;
            ParamIn paramIn = (ParamIn)vector.elementAt(i);
            String string = null;
            if (this.champs.elementAt(i) instanceof TextField) {
                component = (TextField)this.champs.elementAt(i);
                string = ((TextComponent)component).getText();
                if ("nombre".equals(paramIn.type)) {
                    try {
                        Double d = new Double(string);
                    }
                    catch (NumberFormatException numberFormatException) {
                        throw new SimuException(string + " " + Messages.get("pas_un_nombre"));
                    }
                }
            } else if (this.champs.elementAt(i) instanceof Choice) {
                component = (Choice)this.champs.elementAt(i);
                string = ((Choice)component).getSelectedItem();
            } else if (this.champs.elementAt(i) instanceof Scrollbar) {
                component = (Scrollbar)this.champs.elementAt(i);
                string = Integer.toString(((Scrollbar)component).getValue());
            } else if (this.champs.elementAt(i) instanceof Checkbox) {
                component = (Checkbox)this.champs.elementAt(i);
                string = ((Checkbox)component).getState() ? "on" : "off";
            }
            listeValeurs.ajouterString(paramIn.label, string);
        }
        if (this.chxens != null) {
            this.selens = this.chxens.getSelectedItem();
        }
        return listeValeurs;
    }

    protected void verifParametres(Affichage affichage, Vector vector) {
        int n;
        if (affichage.params != null) {
            for (n = 0; n < affichage.params.length; ++n) {
                for (int i = 0; i < affichage.params[n].length; ++i) {
                    String string = affichage.params[n][i];
                    boolean bl = false;
                    for (int j = 0; j < vector.size(); ++j) {
                        if (string == null || !string.equals(((ParamOut)vector.elementAt((int)j)).label)) continue;
                        bl = true;
                    }
                    if (bl) continue;
                    System.err.println(Messages.get("parametre_affichage") + " " + string + " " + Messages.get("pas_declare"));
                }
            }
        }
        if (affichage.sousAff != null) {
            for (n = 0; n < affichage.sousAff.length; ++n) {
                this.verifParametres(affichage.sousAff[n], vector);
            }
        }
    }

    public void startSimu(boolean bl) {
        Object object;
        ListeValeurs listeValeurs;
        try {
            listeValeurs = this.lireChamps();
        }
        catch (SimuException simuException) {
            this.handleException(simuException);
            return;
        }
        Vector vector = this.params.getOutParams();
        Vector vector2 = this.params.getAffichage();
        Affichage affichage = (Affichage)vector2.elementAt(this.noaff);
        if (bl) {
            this.verifParametres(affichage, vector);
            object = this.makeInputPanel(listeValeurs);
            this.removeAll();
            this.setLayout(new BorderLayout());
            this.add("West", (Component)object);
        }
        try {
            if (affichage == null) {
                throw new SimuException(Messages.get("affichage_non_defini"));
            }
            if (bl || this.za == null) {
                this.za = this.creationTypeAffichage(affichage, false);
            }
            object = null;
            if (this.za.estLive()) {
                object = new Chronos(this, this.za, affichage.boucle);
                this.za.setChronos((Chronos)object);
                ((Chronos)object).initCalculLive(listeValeurs);
            }
            if (bl) {
                this.add("Center", this.za.initPanel(vector));
            }
            this.za.affiche(listeValeurs, vector);
        }
        catch (SimuException simuException) {
            this.handleException(simuException);
            return;
        }
        if (bl) {
            object = new Button(Messages.get("Reinitialiser"));
            ((Button)object).setActionCommand("Reset");
            ((Button)object).addActionListener(this);
            this.add("South", (Component)object);
            if (this.scrollp != null) {
                this.scrollp.setSize(this.scrollp.getComponent((int)0).getPreferredSize().width + this.scrollp.getVScrollbarWidth(), this.getSize().height - ((Component)object).getSize().height);
                this.validate();
                this.scrollp.invalidate();
            }
            this.validate();
        }
    }

    public TypeAffichage creationTypeAffichage(Affichage affichage, boolean bl) throws SimuException {
        TypeAffichage typeAffichage;
        if ("plotlive".equals(affichage.type)) {
            typeAffichage = new AffPlotLive(this, affichage, bl);
        } else if ("plot".equals(affichage.type)) {
            typeAffichage = new AffPlot(this, affichage, bl);
        } else if ("tableau".equals(affichage.type)) {
            typeAffichage = new AffPlotTab(this, affichage, bl);
        } else if ("image".equals(affichage.type)) {
            typeAffichage = new AffImage(this, affichage, bl, true);
        } else if ("imagestatique".equals(affichage.type)) {
            typeAffichage = new AffImage(this, affichage, bl, false);
        } else if ("multiplot".equals(affichage.type)) {
            typeAffichage = new AffMulti(this, affichage, bl);
        } else {
            throw new SimuException(Messages.get("affichage_inconnu") + ": " + affichage.type);
        }
        return typeAffichage;
    }

    public static String[] titresAxes(Affichage affichage, Vector vector) {
        if (affichage == null) {
            return null;
        }
        if (affichage.params == null) {
            return null;
        }
        String string = null;
        String string2 = null;
        String string3 = affichage.params[0][0];
        String string4 = affichage.params[0][1];
        string = string3;
        string2 = string4;
        for (int i = 0; i < vector.size(); ++i) {
            ParamOut paramOut = (ParamOut)vector.elementAt(i);
            if (string3.equals(paramOut.label) && paramOut.titre != null) {
                string = paramOut.titre;
            }
            if (!string4.equals(paramOut.label) || paramOut.titre == null) continue;
            string2 = paramOut.titre;
        }
        String[] stringArray = new String[]{string, string2};
        return stringArray;
    }

    protected String lireAideParam(ParamIn paramIn) {
        if (paramIn.description != null) {
            return paramIn.description;
        }
        if (this.xmlDoc == null) {
            return null;
        }
        String string = null;
        XMLTree xMLTree = null;
        xMLTree = "APPLET_SIMULAB".equals(this.xmlDoc.tag) ? this.xmlDoc : this.xmlDoc.getNode("APPLETDOC");
        if (xMLTree == null) {
            System.err.println(Messages.get("sans_appletdoc"));
        } else {
            XMLTree xMLTree2 = xMLTree.getNode("LISTEPARAMS");
            if (xMLTree2 == null) {
                System.err.println(Messages.get("sans_listeparams"));
            } else {
                XMLTree xMLTree3 = xMLTree2.first_child;
                while (xMLTree3 != null) {
                    if (xMLTree3.tag.equals("PARAMETRE")) {
                        if (xMLTree3.getAttVal("label").equals(paramIn.label)) {
                            string = xMLTree3.val;
                        }
                    } else if (xMLTree3.tag.equals("PARAMETRE_ENTREE") && xMLTree3.getAttVal("label").equals(paramIn.label) && xMLTree3.getNode("DESCRIPTION") != null) {
                        string = xMLTree3.getNode((String)"DESCRIPTION").val;
                    }
                    xMLTree3 = xMLTree3.next_brother;
                }
            }
        }
        if (string != null) {
            paramIn.description = string;
        }
        return string;
    }

    public void aideParam(int n) {
        if (this.xmlDoc == null) {
            this.lireXML();
        }
        ParamIn paramIn = (ParamIn)this.params.getInParams().elementAt(n);
        String string = this.lireAideParam(paramIn);
        String string2 = paramIn.label;
        if (string == null) {
            System.err.println(Messages.get("sans_parametre") + " '" + string2 + "' " + Messages.get("dans_xml"));
        }
        if (string != null) {
            InfoWindow infoWindow = new InfoWindow(Messages.get("parametre") + " " + string2, string);
            Point point = this.getLocationOnScreen();
            ((Component)infoWindow).setLocation(point.x + 50, point.y + 50);
            ((Component)infoWindow).setVisible(true);
        }
    }

    protected boolean verifExistenceAide(ParamIn paramIn) {
        String string = this.lireAideParam(paramIn);
        return string != null && !"".equals(string);
    }

    public static double getDouble(String string) {
        double d = new Double(string);
        return d;
    }

    public void dormir(long l) {
        try {
            Thread.currentThread();
            Thread.sleep(l);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    public Vector getInParams() {
        return this.inparams;
    }

    public Vector getOutParams() {
        return this.outparams;
    }

    public Vector getAffichage() {
        return this.affichages;
    }

    public Affichage getAffichage(String string) {
        int n;
        if (string == null) {
            return null;
        }
        for (n = 0; n < this.affichages.size(); ++n) {
            if (!string.equals(((Affichage)this.affichages.elementAt((int)n)).label)) continue;
            return (Affichage)this.affichages.elementAt(n);
        }
        for (n = 0; n < this.affichages.size(); ++n) {
            Affichage affichage = (Affichage)this.affichages.elementAt(n);
            if (affichage.sousAff == null) continue;
            for (int i = 0; i < affichage.sousAff.length; ++i) {
                if (!string.equals(affichage.sousAff[i].label)) continue;
                return affichage.sousAff[i];
            }
        }
        return null;
    }

    public Affichage getAffichageChoisi() {
        if (this.noaff == -1) {
            return null;
        }
        return (Affichage)this.affichages.elementAt(this.noaff);
    }

    public void addParamIn(ParamIn paramIn) {
        this.getInParams().addElement(paramIn);
    }

    public void addParamOut(ParamOut paramOut) {
        this.getOutParams().addElement(paramOut);
    }

    public void addAffichage(Affichage affichage) {
        this.getAffichage().addElement(affichage);
    }

    public void addEnsemble(String string, ListeValeurs listeValeurs) {
        this.ensembles.ajouter(string, listeValeurs);
    }

    public void setTitreEnsembles(String string) {
        this.titreEnsembles = string;
    }

    public void appletDoc(String string) {
        this.nomFichierXML = string;
    }

    public void lireXML() {
        InputStream inputStream;
        XMLTree xMLTree;
        block7: {
            URL uRL;
            xMLTree = new XMLTree(null, "", null, "");
            URL uRL2 = null;
            try {
                uRL2 = this.getDocumentBase();
            }
            catch (Exception exception) {
                System.err.println("Erreur: getDocumentBase() d\u00e9conne !");
                return;
            }
            try {
                uRL = new URL(uRL2, this.nomFichierXML);
            }
            catch (MalformedURLException malformedURLException) {
                System.err.println("MalformedURLException: " + malformedURLException.getMessage());
                return;
            }
            inputStream = null;
            try {
                inputStream = uRL.openStream();
            }
            catch (IOException iOException) {
                inputStream = this.getClass().getClassLoader().getResourceAsStream(this.nomFichierXML);
                if (inputStream != null) break block7;
                System.err.println(Messages.get("ressource_introuvable") + ": " + this.nomFichierXML);
                return;
            }
        }
        Parser_XML parser_XML = new Parser_XML(inputStream, (OutputStream)System.out, xMLTree);
        parser_XML.parse(0);
        if (!"DEADOC".equals(xMLTree.tag) && !"APPLET_SIMULAB".equals(xMLTree.tag)) {
            System.err.println(Messages.get("mauvais_xml"));
            return;
        }
        this.xmlDoc = xMLTree;
    }

    public void initCalculLive(ListeValeurs listeValeurs) throws SimuException {
    }

    public ListeValeurs calculLive() throws SimuException {
        throw new SimuException(Messages.get("calculLive_necessaire"));
    }

    public ListeValeurs calcul(ListeValeurs listeValeurs) throws SimuException {
        throw new SimuException(Messages.get("calcul_necessaire"));
    }

    class InfoWindow
    extends Frame
    implements ActionListener {
        public InfoWindow(String string, String string2) {
            super(string);
            this.setLayout(new BorderLayout());
            int n = 5;
            if (string2.length() > 200) {
                n = 10;
            }
            TextArea textArea = new TextArea(string2, n, 60, 1);
            textArea.setEditable(false);
            this.add("Center", textArea);
            Button button = new Button(Messages.get("OK"));
            button.addActionListener(this);
            Panel panel = new Panel();
            panel.add(button);
            this.add("South", panel);
            this.pack();
            this.addWindowListener(new WindowAdapter(){

                public void windowClosing(WindowEvent windowEvent) {
                    ((Component)InfoWindow.this).setVisible(false);
                    InfoWindow.this.dispose();
                }
            });
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ((Component)this).setVisible(false);
            this.dispose();
        }
    }
}

