/*
 * Decompiled with CFR 0.152.
 */
package simu;

import java.util.Hashtable;
import java.util.Vector;
import simu.Messages;
import simu.SimuException;

public class ListeValeurs {
    Hashtable valeurs = new Hashtable();
    Vector vNoms = new Vector();

    public void ajouter(String string, Object object) {
        if (this.valeurs.containsKey(string)) {
            Object v = this.valeurs.get(string);
            if (v instanceof Vector) {
                ((Vector)v).addElement(object);
            } else {
                Vector<Object> vector = new Vector<Object>();
                vector.addElement(v);
                vector.addElement(object);
                this.valeurs.put(string, vector);
            }
        } else {
            this.valeurs.put(string, object);
            this.vNoms.addElement(string);
        }
    }

    public void ajouterString(String string, String string2) {
        this.ajouter(string, string2);
    }

    public void ajouterDouble(String string, double d) {
        this.ajouter(string, new Double(d));
    }

    public void ajouterEntier(String string, int n) {
        this.ajouter(string, new Integer(n));
    }

    public void ajouterBooleen(String string, boolean bl) {
        this.ajouter(string, new Boolean(bl));
    }

    public Object lire(String string) throws SimuException {
        Object v = this.valeurs.get(string);
        if (v == null) {
            throw new SimuException(Messages.get("aucune_valeur") + ": " + string);
        }
        return v;
    }

    public String lireString(String string) throws SimuException {
        Object object = this.lire(string);
        return String.valueOf(object);
    }

    public double lireDouble(String string) throws SimuException {
        Object object = this.lire(string);
        Double d = object instanceof String ? new Double((String)object) : (Double)object;
        return d;
    }

    public int lireEntier(String string) throws SimuException {
        Object object = this.lire(string);
        Integer n = object instanceof String ? new Integer((String)object) : (Integer)object;
        return n;
    }

    public boolean lireBooleen(String string) throws SimuException {
        Object object = this.lire(string);
        Boolean bl = object instanceof String ? new Boolean((String)object) : (Boolean)object;
        return bl;
    }

    public int taille() {
        return this.valeurs.size();
    }

    public Vector noms() {
        return this.vNoms;
    }
}

