/*
 * Decompiled with CFR 0.152.
 */
package simu;

import java.awt.Canvas;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.image.ColorModel;
import java.awt.image.IndexColorModel;
import java.awt.image.MemoryImageSource;
import simu.Messages;
import simu.SimuException;

public class ImageCanvas
extends Canvas {
    Dimension size;
    int w;
    int h;
    Image image = null;
    int[] pix = null;
    byte[] bpix = null;
    long delai = 100L;
    long time1;
    MemoryImageSource source;
    IndexColorModel palette;

    public ImageCanvas(int n, int n2, IndexColorModel indexColorModel) {
        this.w = n;
        this.h = n2;
        this.palette = indexColorModel;
        this.size = new Dimension(this.w + 2, this.h + 2);
        this.setSize(this.size);
        this.time1 = System.currentTimeMillis();
        this.source = null;
    }

    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    public synchronized Dimension getMinimumSize() {
        return this.size;
    }

    public void paint(Graphics graphics) {
        if (this.image != null) {
            graphics.drawImage(this.image, 1, 1, null);
        }
        graphics.drawRect(0, 0, this.w + 1, this.h + 1);
    }

    public void update(Graphics graphics) {
        this.paint(graphics);
    }

    public void updateImage(double[][] dArray) throws SimuException {
        if (this.pix == null && this.bpix == null) {
            if (this.palette == null) {
                this.pix = new int[this.w * this.h];
            } else {
                this.bpix = new byte[this.w * this.h];
            }
        }
        if (dArray.length != this.w) {
            throw new SimuException(Messages.get("longueur_image") + " " + dArray.length + " != " + this.w);
        }
        if (dArray[0].length != this.h) {
            throw new SimuException(Messages.get("largeur_image") + " " + dArray[0].length + " != " + this.h);
        }
        int n = 0;
        if (this.palette == null) {
            for (int i = 0; i < this.h; ++i) {
                for (int j = 0; j < this.w; ++j) {
                    int n2 = (int)Math.round(dArray[j][i]);
                    this.pix[n++] = 0xFF000000 | n2 << 16 | n2 << 8 | n2;
                }
            }
        } else {
            for (int i = 0; i < this.h; ++i) {
                for (int j = 0; j < this.w; ++j) {
                    this.bpix[n++] = (byte)Math.round(dArray[j][i]);
                }
            }
        }
        this.verifDelai();
        if (this.source == null) {
            this.source = this.palette == null ? new MemoryImageSource(this.w, this.h, this.pix, 0, this.w) : new MemoryImageSource(this.w, this.h, (ColorModel)this.palette, this.bpix, 0, this.w);
            this.source.setAnimated(true);
            this.image = this.createImage(this.source);
        } else {
            this.source.newPixels();
        }
        this.repaint();
    }

    public void updateImage(Image image) throws SimuException {
        if (image.getWidth(null) != this.w) {
            throw new SimuException("Longueur image " + image.getWidth(null) + " != " + this.w);
        }
        if (image.getHeight(null) != this.h) {
            throw new SimuException("Largeur image " + image.getHeight(null) + " != " + this.h);
        }
        this.image = image;
        this.repaint();
        this.verifDelai();
    }

    protected void verifDelai() {
        long l = System.currentTimeMillis();
        if (l - this.time1 < this.delai) {
            try {
                Thread.currentThread();
                Thread.sleep(this.delai - (l - this.time1));
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        this.time1 = System.currentTimeMillis();
    }
}

