/*
 * Decompiled with CFR 0.152.
 */
package simu;

import COM.Subrahmanyam.table.Table;
import java.awt.Color;
import java.awt.Panel;
import java.util.Vector;
import simu.Affichage;
import simu.ListeValeurs;
import simu.Messages;
import simu.ParamOut;
import simu.SimuApplet;
import simu.SimuException;
import simu.TypeAffichage;

public class AffPlotTab
extends TypeAffichage {
    Affichage aff;
    Vector outp;
    SimuApplet applet;
    Table table;
    boolean sousaff;

    public AffPlotTab(SimuApplet simuApplet, Affichage affichage, boolean bl) {
        this.applet = simuApplet;
        this.aff = affichage;
        this.sousaff = bl;
    }

    public Panel initPanel(Vector vector) throws SimuException {
        this.table = new Table();
        this.table.setSize(400, 300);
        this.table.showHorizontalSeparator(true);
        this.table.showVerticalSeparator(true);
        this.table.setHiliteMode(0);
        this.table.setClickMode(20);
        this.table.setColors(Color.black, new Color(1.0f, 1.0f, 0.6f), Color.black, Color.white, Color.black, new Color(0.6f, 1.0f, 0.6f));
        return this.table;
    }

    public boolean estLive() {
        return false;
    }

    public void avantLancement() {
        this.table.clearAll();
    }

    public void affiche(ListeValeurs listeValeurs, Vector vector) throws SimuException {
        this.outp = vector;
        this.avantLancement();
        ListeValeurs listeValeurs2 = this.applet.params.calcul(listeValeurs);
        this.update(listeValeurs2);
    }

    public void update(ListeValeurs listeValeurs) throws SimuException {
        if (this.aff.params == null) {
            System.err.println(Messages.get("aucun_parametre_tableau"));
            return;
        }
        for (int i = 0; i < this.aff.params[0].length; ++i) {
            String string = this.aff.params[0][i];
            for (int j = 0; j < this.outp.size(); ++j) {
                String[] stringArray;
                ParamOut paramOut = (ParamOut)this.outp.elementAt(j);
                if (!string.equals(paramOut.label)) continue;
                Object object = listeValeurs.lire(paramOut.label);
                if (object instanceof Vector) {
                    stringArray = (String[])object;
                    String[] stringArray2 = new String[stringArray.size()];
                    for (int k = 0; k < stringArray.size(); ++k) {
                        Object e = stringArray.elementAt(k);
                        stringArray2[k] = e instanceof Double ? this.joliFormattage((Double)e, 8) : e.toString();
                    }
                    this.table.addColumn(paramOut.label, stringArray2);
                    continue;
                }
                stringArray = new String[]{object.toString()};
                this.table.addColumn(paramOut.label, stringArray);
            }
        }
    }

    public String joliFormattage(double d, int n) {
        String string;
        double d2 = Math.pow(10.0, n);
        int n2 = (int)Math.floor(Math.log(Math.abs(d)) / Math.log(10.0));
        double d3 = d / Math.pow(10.0, n2);
        if (n2 == 0) {
            d3 = (double)Math.round(d3 * d2) / d2;
            string = "" + d3;
        } else if (n2 == 1) {
            d3 = (double)Math.round(d3 * d2) / (d2 / 10.0);
            string = "" + d3;
        } else if (n2 == -1) {
            String string2 = d3 < 0.0 ? "-" : "";
            d3 = Math.abs(Math.round(d3 * d2));
            string = string2 + "0." + (int)d3;
        } else {
            d3 = (double)Math.round(d3 * d2) / d2;
            string = d3 + "E" + n2;
        }
        return string;
    }
}

