/*
 * Decompiled with CFR 0.152.
 */
package simu;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import simu.Affichage;
import simu.Chronos;
import simu.ListeValeurs;
import simu.Messages;
import simu.ParamOut;
import simu.SimuApplet;
import simu.SimuException;
import simu.SimuPlot;
import simu.TypeAffichage;

public class AffPlotLive
extends TypeAffichage
implements ActionListener {
    SimuPlot plot;
    SimuApplet applet;
    Affichage aff;
    Vector outp;
    int nd;
    boolean couleurs;
    boolean appel1;
    Label info;
    Button bstop;
    Button bstart;
    Chronos chrono;
    boolean sousaff;

    public AffPlotLive(SimuApplet simuApplet, Affichage affichage, boolean bl) {
        this.applet = simuApplet;
        this.aff = affichage;
        this.sousaff = bl;
        this.nd = -1;
    }

    public Panel initPanel(Vector vector) throws SimuException {
        this.outp = vector;
        Panel panel = new Panel(new BorderLayout());
        if (this.plot == null) {
            this.plot = new SimuPlot(this.applet, this.aff);
        }
        panel.add("Center", this.plot);
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            ParamOut paramOut = (ParamOut)vector.elementAt(i);
            if (!"string".equals(paramOut.type)) continue;
            bl = true;
        }
        if (bl) {
            this.info = new Label(" ");
            panel.add("South", this.info);
        } else {
            this.info = null;
        }
        this.initPlot();
        if (!this.sousaff) {
            this.ajouterBoutons(panel);
        }
        this.couleurs = this.aff.params.length == 1;
        return panel;
    }

    public boolean estLive() {
        return true;
    }

    public void setChronos(Chronos chronos) {
        this.chrono = chronos;
    }

    public void affiche(ListeValeurs listeValeurs, Vector vector) throws SimuException {
        this.outp = vector;
        this.avantLancement();
        this.start();
    }

    public void avantLancement() {
        this.appel1 = true;
        if (this.couleurs) {
            ++this.nd;
            this.plot.setConnected(this.aff.connecter, this.nd);
            this.plot.setMarksStyle(this.aff.points, this.nd);
        }
    }

    protected void initPlot() {
        String[] stringArray = SimuApplet.titresAxes(this.aff, this.outp);
        this.plot.setButtons(false);
        if (this.aff.ydebut != null && this.aff.yfin != null) {
            this.plot.setYRange(SimuApplet.getDouble(this.aff.ydebut), SimuApplet.getDouble(this.aff.yfin));
        } else {
            this.plot.setYRange(0.0, 10.0);
        }
        if (this.aff.xdebut != null && this.aff.xfin != null) {
            this.plot.setXRange(SimuApplet.getDouble(this.aff.xdebut), SimuApplet.getDouble(this.aff.xfin));
        } else {
            this.plot.setXRange(0.0, 10.0);
        }
        this.plot.setTitle(this.aff.titre);
        this.plot.setXLabel(stringArray[0]);
        this.plot.setYLabel(stringArray[1]);
        this.plot.setConnected(this.aff.connecter);
        this.plot.setColor(this.aff.couleurs);
        if (this.aff.histogramme) {
            this.plot.setMarksStyle("none");
            this.plot.setBars(true);
        } else {
            this.plot.setMarksStyle(this.aff.points);
        }
    }

    protected void ajouterBoutons(Panel panel) {
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout());
        this.bstart = new Button(Messages.get("continuer"));
        this.bstart.setActionCommand("start");
        this.bstart.addActionListener(this);
        panel2.add(this.bstart);
        this.bstop = new Button(Messages.get("stop"));
        this.bstop.setActionCommand("stop");
        this.bstop.addActionListener(this);
        panel2.add(this.bstop);
        Button button = new Button(Messages.get("ajuster"));
        button.setActionCommand("ajuster");
        button.addActionListener(this);
        panel2.add(button);
        button = new Button(Messages.get("effacer"));
        button.setActionCommand("effacer");
        button.addActionListener(this);
        panel2.add(button);
        panel.add("North", panel2);
    }

    public void start() {
        this.bstop.setEnabled(true);
        this.bstart.setEnabled(false);
        this.chrono.start();
    }

    public void stop() {
        if (this.bstop != null) {
            this.bstop.setEnabled(false);
        }
        if (this.bstart != null) {
            this.bstart.setEnabled(true);
        }
        if (this.chrono != null) {
            this.chrono.stop();
        }
    }

    public void fin() {
        this.bstop.setEnabled(false);
        this.bstart.setEnabled(false);
    }

    public void update(ListeValeurs listeValeurs) throws SimuException {
        if (this.aff.effacer) {
            this.effacer();
        }
        for (int i = 0; i < this.aff.params.length; ++i) {
            int n;
            if (!this.couleurs) {
                this.nd = i;
            }
            String string = this.aff.params[i][0];
            String string2 = this.aff.params[i][1];
            double d = 0.0;
            double d2 = 0.0;
            Vector vector = null;
            Vector vector2 = null;
            for (n = 0; n < this.outp.size(); ++n) {
                ParamOut paramOut = (ParamOut)this.outp.elementAt(n);
                Object object = listeValeurs.lire(paramOut.label);
                if (object instanceof Double) {
                    Double d3 = (Double)object;
                    double d4 = d3;
                    if (string.equals(paramOut.label)) {
                        d = d4;
                        continue;
                    }
                    if (!string2.equals(paramOut.label)) continue;
                    d2 = d4;
                    continue;
                }
                if (object instanceof Vector) {
                    if (string.equals(paramOut.label)) {
                        vector = (Vector)object;
                        continue;
                    }
                    if (!string2.equals(paramOut.label)) continue;
                    vector2 = (Vector)object;
                    continue;
                }
                if (!this.sousaff && object instanceof String && this.info != null) {
                    if (object.equals(this.info.getText())) continue;
                    this.info.setText((String)object);
                    continue;
                }
                if (object != null) continue;
            }
            if (vector != null && vector2 != null) {
                if (vector.size() != vector2.size()) {
                    throw new SimuException(Messages.get("meme_nombre"));
                }
                for (n = 0; n < vector.size(); ++n) {
                    d = (Double)vector.elementAt(n);
                    d2 = (Double)vector2.elementAt(n);
                    boolean bl = this.aff.connecter && (!this.appel1 || n > 0);
                    this.plot.addPoint(this.nd, d, d2, bl);
                }
                continue;
            }
            this.plot.addPoint(this.nd, d, d2, this.aff.connecter && !this.appel1);
        }
        if (this.aff.ajuster) {
            this.ajuster();
        } else if (this.aff.recadrer) {
            if (this.aff.ydebut != null && this.aff.yfin != null) {
                this.plot.setYRange(SimuApplet.getDouble(this.aff.ydebut), SimuApplet.getDouble(this.aff.yfin));
            }
            if (this.aff.xdebut != null && this.aff.xfin != null) {
                this.plot.setXRange(SimuApplet.getDouble(this.aff.xdebut), SimuApplet.getDouble(this.aff.xfin));
            }
        }
        this.appel1 = false;
    }

    public void effacer() {
        this.plot.clear(false);
        this.plot.repaint();
    }

    public void ajuster() {
        this.plot.fillPlot();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("start")) {
            this.start();
        } else if (string.equals("stop")) {
            this.stop();
        } else if (string.equals("ajuster")) {
            this.ajuster();
        } else if (string.equals("effacer")) {
            this.effacer();
        }
    }
}

