/*
 * Decompiled with CFR 0.152.
 */
package simu;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.FlowLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import simu.Affichage;
import simu.ListeValeurs;
import simu.Messages;
import simu.ParamOut;
import simu.SimuApplet;
import simu.SimuException;
import simu.SimuPlot;
import simu.TypeAffichage;

public class AffPlot
extends TypeAffichage
implements ActionListener {
    SimuPlot plot;
    SimuApplet applet;
    Vector outp;
    Affichage aff;
    int nd;
    Label info;
    boolean sousaff;

    public AffPlot(SimuApplet simuApplet, Affichage affichage, boolean bl) {
        this.applet = simuApplet;
        this.aff = affichage;
        this.sousaff = bl;
        this.nd = -1;
    }

    public Panel initPanel(Vector vector) throws SimuException {
        this.outp = vector;
        Panel panel = new Panel(new BorderLayout());
        this.plot = new SimuPlot(this.applet, this.aff);
        panel.add("Center", this.plot);
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            ParamOut paramOut = (ParamOut)vector.elementAt(i);
            if (!"string".equals(paramOut.type)) continue;
            bl = true;
        }
        if (bl) {
            this.info = new Label(" ");
            panel.add("South", this.info);
        } else {
            this.info = null;
        }
        this.initPlot();
        if (!this.sousaff) {
            this.ajouterBoutons(panel);
        }
        return panel;
    }

    public boolean estLive() {
        return false;
    }

    public void affiche(ListeValeurs listeValeurs, Vector vector) throws SimuException {
        this.outp = vector;
        ListeValeurs listeValeurs2 = this.applet.params.calcul(listeValeurs);
        this.update(listeValeurs2);
    }

    public void update(ListeValeurs listeValeurs) throws SimuException {
        if (this.aff.effacer) {
            this.effacer();
            this.nd = 0;
        } else if (this.aff.params.length == 1) {
            ++this.nd;
        }
        for (int i = 0; i < this.aff.params.length; ++i) {
            if (this.aff.params.length != 1) {
                this.nd = i;
            }
            String string = this.aff.params[i][0];
            String string2 = this.aff.params[i][1];
            Vector<Object> vector = null;
            Vector<Object> vector2 = null;
            for (int j = 0; j < this.outp.size(); ++j) {
                Object object;
                ParamOut paramOut = (ParamOut)this.outp.elementAt(j);
                if (string.equals(paramOut.label)) {
                    object = listeValeurs.lire(paramOut.label);
                    if (object == null) {
                        vector = null;
                        continue;
                    }
                    if (object instanceof Vector) {
                        vector = (Vector)object;
                        continue;
                    }
                    if (object instanceof Double) {
                        vector = new Vector<Object>();
                        vector.addElement(object);
                        continue;
                    }
                    vector = null;
                    System.err.println("Type \u00e9trange pour la coordonn\u00e9e x d'un plot : " + object.getClass().getName());
                    continue;
                }
                if (string2.equals(paramOut.label)) {
                    object = listeValeurs.lire(paramOut.label);
                    if (object == null) {
                        vector2 = null;
                        continue;
                    }
                    if (object instanceof Vector) {
                        vector2 = (Vector)object;
                        continue;
                    }
                    if (object instanceof Double) {
                        vector2 = new Vector<Object>();
                        vector2.addElement(object);
                        continue;
                    }
                    vector2 = null;
                    System.err.println("Type \u00e9trange pour la coordonn\u00e9e y d'un plot : " + object.getClass().getName());
                    continue;
                }
                if (this.sousaff || this.info == null || !"string".equals(paramOut.type) || !(listeValeurs.lire(paramOut.label) instanceof String)) continue;
                this.info.setText((String)listeValeurs.lire(paramOut.label));
            }
            if (vector == null || vector2 == null) {
                System.err.println(Messages.get("aucun_resultat"));
                return;
            }
            double d = 0.0;
            double d2 = 0.0;
            for (int j = 0; j < vector.size(); ++j) {
                Double d3 = (Double)vector.elementAt(j);
                d = d3;
                d3 = (Double)vector2.elementAt(j);
                d2 = d3;
                this.plot.addPoint(this.nd, d, d2, this.aff.connecter && j > 0);
            }
        }
        if (this.aff.ajuster) {
            this.ajuster();
        } else if (this.aff.recadrer) {
            if (this.aff.ydebut != null && this.aff.yfin != null) {
                this.plot.setYRange(SimuApplet.getDouble(this.aff.ydebut), SimuApplet.getDouble(this.aff.yfin));
            }
            if (this.aff.xdebut != null && this.aff.xfin != null) {
                this.plot.setXRange(SimuApplet.getDouble(this.aff.xdebut), SimuApplet.getDouble(this.aff.xfin));
            }
        }
    }

    protected void initPlot() {
        String[] stringArray = SimuApplet.titresAxes(this.aff, this.outp);
        this.plot.setSize(400, 300);
        this.plot.setTitle(this.aff.titre);
        if (this.aff.ydebut != null && this.aff.yfin != null) {
            this.plot.setYRange(SimuApplet.getDouble(this.aff.ydebut), SimuApplet.getDouble(this.aff.yfin));
        } else {
            this.plot.setYRange(0.0, 10.0);
        }
        if (this.aff.xdebut != null && this.aff.xfin != null) {
            this.plot.setXRange(SimuApplet.getDouble(this.aff.xdebut), SimuApplet.getDouble(this.aff.xfin));
        } else {
            this.plot.setXRange(0.0, 10.0);
        }
        this.plot.setXLabel(stringArray[0]);
        this.plot.setYLabel(stringArray[1]);
        if (this.aff.histogramme) {
            this.plot.setMarksStyle("none");
            this.plot.setBars(true);
        } else {
            this.plot.setMarksStyle(this.aff.points);
        }
        this.plot.setConnected(this.aff.connecter);
        this.plot.setColor(this.aff.couleurs);
    }

    protected void ajouterBoutons(Panel panel) {
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout());
        Button button = new Button(Messages.get("ajuster"));
        button.setActionCommand("ajuster");
        button.addActionListener(this);
        panel2.add(button);
        button = new Button(Messages.get("effacer"));
        button.setActionCommand("effacer");
        button.addActionListener(this);
        panel2.add(button);
        panel.add("North", panel2);
    }

    public void effacer() {
        this.plot.clear(false);
        this.plot.repaint();
    }

    public void ajuster() {
        this.plot.fillPlot();
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("ajuster")) {
            this.ajuster();
        } else if (string.equals("effacer")) {
            this.effacer();
        }
    }
}

