/*
 * Decompiled with CFR 0.152.
 */
package simu;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import simu.Affichage;
import simu.Chronos;
import simu.ListeValeurs;
import simu.Messages;
import simu.ParamOut;
import simu.SimuApplet;
import simu.SimuException;
import simu.TypeAffichage;

public class AffMulti
extends TypeAffichage
implements ActionListener {
    TypeAffichage[] typesaff;
    SimuApplet applet;
    Affichage aff;
    Vector outp;
    Label info;
    Button bstop;
    Button bstart;
    Chronos chrono;
    boolean live;
    boolean sousaff;

    public AffMulti(SimuApplet simuApplet, Affichage affichage, boolean bl) {
        int n;
        this.applet = simuApplet;
        this.aff = affichage;
        this.sousaff = bl;
        if (affichage.sousAff == null) {
            System.err.println(Messages.get("multiplot_sans_affichage"));
        }
        try {
            if (affichage.sousAff == null) {
                this.typesaff = new TypeAffichage[1];
                this.typesaff[0] = simuApplet.creationTypeAffichage(affichage, true);
            } else {
                this.typesaff = new TypeAffichage[affichage.sousAff.length];
                for (n = 0; n < affichage.sousAff.length; ++n) {
                    this.typesaff[n] = simuApplet.creationTypeAffichage(affichage.sousAff[n], true);
                }
            }
        }
        catch (SimuException simuException) {
            simuApplet.handleException(simuException);
        }
        this.live = false;
        if (affichage.sousAff == null) {
            this.live = this.typesaff[0].estLive();
        } else {
            this.live = false;
            for (n = 0; n < this.typesaff.length; ++n) {
                this.live = this.live || this.typesaff[n].estLive();
            }
        }
    }

    public boolean estLive() {
        return this.live;
    }

    public Panel initPanel(Vector vector) throws SimuException {
        Object object;
        int n;
        int n2;
        this.outp = vector;
        Panel panel = new Panel(new BorderLayout());
        if (this.aff.sousAff == null) {
            panel.add("Center", this.typesaff[0].initPanel(vector));
        } else {
            if (!"y".equals(this.aff.ordreSousAff)) {
                n2 = (int)Math.ceil(Math.sqrt(this.typesaff.length));
                n = n2 * (n2 - 1) < this.typesaff.length ? n2 : n2 - 1;
            } else {
                n = (int)Math.ceil(Math.sqrt(this.typesaff.length));
                n2 = n * (n - 1) < this.typesaff.length ? n : n - 1;
            }
            object = new Panel(new GridLayout(n, n2));
            for (int i = 0; i < this.typesaff.length; ++i) {
                ((Container)object).add(this.typesaff[i].initPanel(vector));
            }
            panel.add("Center", (Component)object);
        }
        n2 = 0;
        for (n = 0; n < vector.size(); ++n) {
            object = (ParamOut)vector.elementAt(n);
            if (!"string".equals(((ParamOut)object).type)) continue;
            n2 = 1;
        }
        if (n2 != 0) {
            this.info = new Label(" ");
            panel.add("South", this.info);
        } else {
            this.info = null;
        }
        if (!this.sousaff) {
            this.ajouterBoutons(panel);
        }
        return panel;
    }

    public void setChronos(Chronos chronos) {
        this.chrono = chronos;
    }

    public void avantLancement() {
        for (int i = 0; i < this.typesaff.length; ++i) {
            this.typesaff[i].avantLancement();
        }
    }

    public void affiche(ListeValeurs listeValeurs, Vector vector) throws SimuException {
        this.outp = vector;
        this.avantLancement();
        if (this.live) {
            this.start();
        } else {
            ListeValeurs listeValeurs2 = this.applet.params.calcul(listeValeurs);
            this.update(listeValeurs2);
        }
    }

    protected void ajouterBoutons(Panel panel) {
        Panel panel2 = new Panel();
        panel2.setLayout(new FlowLayout());
        if (this.live) {
            this.bstart = new Button(Messages.get("continuer"));
            this.bstart.setActionCommand("start");
            this.bstart.addActionListener(this);
            panel2.add(this.bstart);
            this.bstop = new Button(Messages.get("stop"));
            this.bstop.setActionCommand("stop");
            this.bstop.addActionListener(this);
            panel2.add(this.bstop);
        }
        Button button = new Button(Messages.get("ajuster"));
        button.setActionCommand("ajuster");
        button.addActionListener(this);
        panel2.add(button);
        button = new Button(Messages.get("effacer"));
        button.setActionCommand("effacer");
        button.addActionListener(this);
        panel2.add(button);
        panel.add("North", panel2);
    }

    public void start() {
        this.bstop.setEnabled(true);
        this.bstart.setEnabled(false);
        if (this.chrono != null) {
            this.chrono.start();
        }
    }

    public void stop() {
        if (this.bstop != null) {
            this.bstop.setEnabled(false);
        }
        if (this.bstart != null) {
            this.bstart.setEnabled(true);
        }
        if (this.chrono != null) {
            this.chrono.stop();
        }
    }

    public void fin() {
        this.bstop.setEnabled(false);
        this.bstart.setEnabled(false);
        this.chrono = null;
    }

    public void update(ListeValeurs listeValeurs) throws SimuException {
        int n;
        for (n = 0; n < this.typesaff.length; ++n) {
            this.typesaff[n].update(listeValeurs);
        }
        for (n = 0; n < this.outp.size(); ++n) {
            ParamOut paramOut = (ParamOut)this.outp.elementAt(n);
            Object object = listeValeurs.lire(paramOut.label);
            if (!(object instanceof String) || this.info == null || object.equals(this.info.getText())) continue;
            this.info.setText((String)object);
        }
    }

    public void effacer() {
        for (int i = 0; i < this.typesaff.length; ++i) {
            this.typesaff[i].effacer();
        }
    }

    public void ajuster() {
        for (int i = 0; i < this.typesaff.length; ++i) {
            this.typesaff[i].ajuster();
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("start")) {
            this.start();
        } else if (string.equals("stop")) {
            this.stop();
        } else if (string.equals("ajuster")) {
            this.ajuster();
        } else if (string.equals("effacer")) {
            this.effacer();
        }
    }
}

