/*
 * Decompiled with CFR 0.152.
 */
package simu;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Image;
import java.awt.Label;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Vector;
import simu.Affichage;
import simu.Chronos;
import simu.ImageCanvas;
import simu.ListeValeurs;
import simu.Messages;
import simu.ParamOut;
import simu.SimuApplet;
import simu.SimuException;
import simu.TypeAffichage;

public class AffImage
extends TypeAffichage
implements ActionListener {
    SimuApplet applet;
    Affichage aff;
    ImageCanvas ic = null;
    Label info;
    Chronos chrono;
    Button bstop;
    Button bstart;
    Vector outp;
    boolean sousaff;
    boolean live;
    Panel pc;

    public AffImage(SimuApplet simuApplet, Affichage affichage, boolean bl, boolean bl2) {
        this.applet = simuApplet;
        this.aff = affichage;
        this.sousaff = bl;
        this.live = bl2;
    }

    public Panel initPanel(Vector vector) throws SimuException {
        this.outp = vector;
        this.pc = new Panel(new BorderLayout());
        if (this.ic == null) {
            this.ic = new ImageCanvas(this.aff.imgdimx, this.aff.imgdimy, this.aff.palette);
        }
        this.pc.add("Center", this.ic);
        boolean bl = false;
        for (int i = 0; i < vector.size(); ++i) {
            ParamOut paramOut = (ParamOut)vector.elementAt(i);
            if (!"string".equals(paramOut.type)) continue;
            bl = true;
        }
        if (bl) {
            this.info = new Label(" ");
            this.pc.add("South", this.info);
        } else {
            this.info = null;
        }
        if (!this.sousaff && this.live) {
            Panel panel = new Panel();
            panel.setLayout(new FlowLayout());
            this.bstart = new Button(Messages.get("continuer"));
            this.bstart.setActionCommand("start");
            this.bstart.addActionListener(this);
            panel.add(this.bstart);
            this.bstop = new Button(Messages.get("stop"));
            this.bstop.setActionCommand("stop");
            this.bstop.addActionListener(this);
            panel.add(this.bstop);
            this.pc.add("North", panel);
        }
        return this.pc;
    }

    public boolean estLive() {
        return this.live;
    }

    public void setChronos(Chronos chronos) {
        this.chrono = chronos;
    }

    public void avantLancement() {
        Dimension dimension = this.ic.getMinimumSize();
        if (dimension.width != this.aff.imgdimx || dimension.height != this.aff.imgdimy) {
            this.pc.remove(this.ic);
            this.ic = new ImageCanvas(this.aff.imgdimx, this.aff.imgdimy, this.aff.palette);
            this.pc.add("Center", this.ic);
            this.pc.validate();
        }
    }

    public void affiche(ListeValeurs listeValeurs, Vector vector) throws SimuException {
        this.outp = vector;
        this.avantLancement();
        if (this.live) {
            this.start();
        } else {
            ListeValeurs listeValeurs2 = this.applet.params.calcul(listeValeurs);
            this.update(listeValeurs2);
        }
    }

    public void start() {
        this.bstop.setEnabled(true);
        this.bstart.setEnabled(false);
        this.chrono.start();
    }

    public void stop() {
        if (this.bstop != null) {
            this.bstop.setEnabled(false);
        }
        if (this.bstart != null) {
            this.bstart.setEnabled(true);
        }
        this.chrono.stop();
    }

    public void fin() {
        this.bstop.setEnabled(false);
        this.bstart.setEnabled(false);
    }

    public void update(ListeValeurs listeValeurs) throws SimuException {
        boolean bl = false;
        for (int i = 0; i < this.aff.params[0].length; ++i) {
            String string = this.aff.params[0][i];
            for (int j = 0; j < this.outp.size(); ++j) {
                Object object;
                ParamOut paramOut = (ParamOut)this.outp.elementAt(j);
                if (!string.equals(paramOut.label)) continue;
                if ("tableau".equals(paramOut.type)) {
                    object = listeValeurs.lire(paramOut.label);
                    if (object instanceof double[][]) {
                        this.ic.updateImage((double[][])object);
                        bl = true;
                        continue;
                    }
                    throw new SimuException(Messages.get("mauvaise_sortie") + ": " + object.getClass().getName());
                }
                if ("image".equals(paramOut.type)) {
                    object = listeValeurs.lire(paramOut.label);
                    if (object instanceof Image) {
                        this.ic.updateImage((Image)object);
                        bl = true;
                        continue;
                    }
                    throw new SimuException(Messages.get("mauvaise_sortie") + ": " + object.getClass().getName());
                }
                if (this.sousaff || !"string".equals(paramOut.type) || this.info == null) continue;
                this.info.setText(listeValeurs.lireString(paramOut.label));
            }
        }
        if (!bl) {
            throw new SimuException(Messages.get("aucune_sortie"));
        }
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if (string.equals("start")) {
            this.start();
        } else if (string.equals("stop")) {
            this.stop();
        }
    }
}

