/*
 * Decompiled with CFR 0.152.
 */
package COM.Subrahmanyam.table;

class TGrid {
    public static final int OUT_OF_FOCUS = -1;
    private final int sepWidth = 1;
    private int[] x;
    private int[] y;
    private int[] w;
    private int fx;
    private int fy;
    private int lineHeight;
    private double lineSpacing = 1.2f;

    TGrid() {
    }

    boolean findInFocus(int n, int n2) {
        int n3;
        this.fy = -1;
        int[] nArray = new int[this.x.length];
        for (n3 = 0; n3 < nArray.length; ++n3) {
            nArray[n3] = this.x[n3];
        }
        for (n3 = 1; n3 < nArray.length; n3 += 2) {
            nArray[n3] = nArray[n3] - 2;
        }
        for (n3 = 2; n3 < nArray.length; n3 += 2) {
            nArray[n3] = nArray[n3] + 2;
        }
        for (n3 = 0; n3 < this.x.length; ++n3) {
            if (n <= nArray[n3]) continue;
            this.fy = n3;
        }
        this.fx = -1;
        for (n3 = 0; n3 < this.y.length; ++n3) {
            if (n2 <= this.y[n3]) continue;
            this.fx = n3;
        }
        if (n > this.x[this.x.length - 1] || n2 > this.y[this.y.length - 1]) {
            this.fy = -1;
            this.fx = -1;
        }
        return this.fx != -1 && this.fy != -1;
    }

    int getIFocus() {
        this.fx = this.fx < this.y.length - 1 ? this.fx : this.y.length - 1;
        this.fx = this.fx == -1 ? 0 : this.fx;
        return this.fx;
    }

    int getJFocus() {
        this.fy = this.fy < this.x.length - 1 ? this.fy : this.x.length - 2;
        this.fy = this.fy == -1 ? 0 : this.fy;
        return this.fy;
    }

    int getXLength() {
        return this.x.length;
    }

    int getYLength() {
        return this.y.length;
    }

    int getX(int n) {
        return this.x[n];
    }

    int getY(int n) {
        return this.y[n];
    }

    void setX(int n, int n2) {
        this.x[n] = n2;
    }

    void setY(int n, int n2) {
        this.y[n] = n2;
    }

    int getSepWidth() {
        return 1;
    }

    void setXArr(int[] nArray) {
        this.x = nArray;
    }

    void setYArr(int[] nArray) {
        this.y = nArray;
    }

    int[] getXArr() {
        return this.x;
    }

    int[] getYArr() {
        return this.x;
    }

    void setLineHeight(int n) {
        this.lineHeight = n;
    }

    int getLineHeight() {
        int n = (int)((double)new Integer(this.lineHeight).floatValue() * this.lineSpacing);
        return n;
    }

    double getLineSpacing() {
        return this.lineSpacing;
    }

    void scaleX(float f) {
        try {
            int n;
            for (n = 0; n < this.x.length; ++n) {
                this.x[n] = (int)((float)this.x[n] * f);
            }
            for (n = 1; n < this.x.length - 2; n += 2) {
                this.x[n] = this.x[n + 1] - 1;
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    public String toString() {
        try {
            int n;
            StringBuffer stringBuffer = new StringBuffer("TGrid\n");
            stringBuffer.append("x - [ ");
            for (n = 0; n < this.x.length; ++n) {
                stringBuffer.append(this.x[n] + ",");
            }
            stringBuffer.append("] \n");
            stringBuffer.append("y - [ ");
            for (n = 0; n < this.y.length; ++n) {
                stringBuffer.append(this.y[n] + ", ");
            }
            stringBuffer.append("] \n");
            return stringBuffer.toString();
        }
        catch (NullPointerException nullPointerException) {
            return null;
        }
    }

    int getHeight() {
        return this.getY(this.getYLength() - 1) - this.getY(0);
    }

    void computeWeights() {
        try {
            this.w = new int[this.x.length / 2 + 1];
            for (int i = 0; i < this.w.length; ++i) {
                this.w[i] = this.x[2 * i + 1] - this.x[2 * i];
            }
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void setXWidth(int n) {
        try {
            int n2 = this.x[this.x.length - 1];
            float f = (float)n / (float)n2;
            this.scaleX(f);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void weightX() {
        try {
            int n;
            int n2;
            int n3 = this.x[this.x.length - 1];
            this.x[0] = 0;
            int n4 = 0;
            for (n2 = 0; n2 < this.w.length; ++n2) {
                n4 += this.w[n2];
            }
            n2 = this.x.length / 2;
            this.x[0] = 0;
            for (n = 1; n < n2; ++n) {
                int n5 = (int)((double)this.w[n - 1] * (double)n3 / (double)n4);
                this.x[2 * n] = this.x[2 * n - 2] + n5;
            }
            for (n = 0; n < n2 - 1; ++n) {
                this.x[2 * n + 1] = this.x[2 * n + 2] - this.getSepWidth();
            }
            this.x[this.x.length - 1] = n3;
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (ArrayIndexOutOfBoundsException arrayIndexOutOfBoundsException) {
            // empty catch block
        }
    }

    void setWeights(int[] nArray) {
        try {
            this.w = nArray;
            this.weightX();
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
    }

    void setLineSpacing(double d) {
        this.lineSpacing = d;
    }

    int[] getWeights() {
        return this.w;
    }
}

