package moulinette;

import java.awt.*;
import java.awt.image.*;
import java.awt.geom.AffineTransform;
import java.io.*;
import com.sixlegs.image.png.PngImage;

import com.keypoint.*;

public class PNGImage implements ImAnim {
	Image img = null;
	
	// debugging
	public static void main(String[] args) {
		if (args.length != 4) {
			System.err.println("il faut 4 arguments (forig fdest largeur hauteur)");
			return;
		}
		File forig = new File(args[0]);
		if (!forig.exists()) {
			System.err.println("le fichier n'existe pas");
			return;
		}
		File fdest = new File(args[1]);
		int largeur;
		int hauteur;
		try {
			largeur = (new Integer(args[2])).intValue();
			hauteur = (new Integer(args[3])).intValue();
		} catch (Exception ex) {
			ex.printStackTrace();
			return;
		}
		PNGImage image = new PNGImage();
		try {
			image.open(forig);
			image.rescale(fdest, largeur, hauteur);
		} catch (IOException ex) {
			System.err.println("IOException : " + ex.getMessage());
			return;
		}
	}
	
	public void open(File f) throws IOException {
		//img = Toolkit.getDefaultToolkit().getImage(f.getPath());
		// bug Java avec la lecture des images PNG avec moins de 256 couleurs
		// -> utilisation du package sixlegs
		PngImage producer = new PngImage(f.getPath());
		img = Toolkit.getDefaultToolkit().createImage(producer);
		
		// load image
		WaitingObserver wobs = new WaitingObserver();
		if (img.getWidth(wobs) == -1)
			wobs.attendre();
		wobs = new WaitingObserver();
		if (img.getHeight(wobs) == -1)
			wobs.attendre();
		if (img.getWidth(null) == -1 || img.getHeight(null) == -1)
			throw new IOException("Erreur  la lecture de " + f.getPath());
	}
	
	public int getWidth() {
		if (img == null)
			return(-1);
		else
			return(img.getWidth(null));
	}
	
	public int getHeight() {
		if (img == null)
			return(-1);
		else
			return(img.getHeight(null));
	}
	
	public int getImageCount() {
		if (img == null)
			return(0);
		else
			return(1);
	}
	
	public Image getImage(int n) {
		if (n != 0)
			return(null);
		else
			return(img);
	}
	
	public void rescale(File newf, int width, int height) throws IOException {
		int width1 = img.getWidth(null);
		int height1 = img.getHeight(null);
		System.out.println("rescale " + newf.getName() + " " + width1 + " " + height1 + " -> " + width + " " + height);
		
		//Image newimg = img.getScaledInstance(width, height, Image.SCALE_SMOOTH);
		
		Image newimg =  Toolkit.getDefaultToolkit().createImage(
			new FilteredImageSource(img.getSource(), new AreaAveragingScaleFilter(width, height)));
		BufferedImage buffImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
		Graphics2D g2 = buffImage.createGraphics();
		WaitingObserver wobs = new WaitingObserver();
		if (!g2.drawImage(newimg, 0, 0, wobs)) {
			wobs.attendre();
			g2.drawImage(newimg, 0, 0, null);
		}
		g2.dispose();
		
		/*
		BufferedImage buffImage = new BufferedImage(width1, height1, BufferedImage.TYPE_INT_ARGB);
		Graphics2D g2 = buffImage.createGraphics();
		WaitingObserver wobs = new WaitingObserver();
		if (!g2.drawImage(img, 0, 0, wobs)) {
			wobs.attendre();
			g2.drawImage(img, 0, 0, null);
		}
		g2.dispose();
		double scalew = (1.0 * width) / width1;
		double scaleh = (1.0 * height) / height1;
		AffineTransformOp aop = new AffineTransformOp(AffineTransform.getScaleInstance(scalew, scaleh), 
			new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC));
		BufferedImage buff2 = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
		aop.filter(buffImage, buff2);
		*/
		
		byte[] pngbytes;
		PngEncoder png =  new PngEncoder( buffImage, PngEncoderB.ENCODE_ALPHA, PngEncoderB.FILTER_NONE, 9 );
		FileOutputStream outfile = new FileOutputStream( newf );
		pngbytes = png.pngEncode();
		if (pngbytes == null)
			throw new IOException("PNG encoding " + newf.getPath());
		else
			outfile.write( pngbytes );
		outfile.flush();
		outfile.close();
	}

	class WaitingObserver implements ImageObserver {
		boolean stillwaiting = true;
		public void attendre() {
			while (stillwaiting) {
				try {
					Thread.currentThread().sleep(100);
				} catch (InterruptedException ex) {
					System.err.println("InterruptedException: " + ex.getMessage());
				}
			}
		}
		public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
			/*System.out.print("imageUpdate ");
			if ((infoflags & ImageObserver.ABORT) != 0)
				System.out.print("ABORT ");
			if ((infoflags & ImageObserver.ALLBITS) != 0)
				System.out.print("ALLBITS ");
			if ((infoflags & ImageObserver.ERROR) != 0)
				System.out.print("ERROR ");
			if ((infoflags & ImageObserver.FRAMEBITS) != 0)
				System.out.print("FRAMEBITS ");
			if ((infoflags & ImageObserver.HEIGHT) != 0)
				System.out.print("HEIGHT ");
			if ((infoflags & ImageObserver.PROPERTIES) != 0)
				System.out.print("PROPERTIES ");
			if ((infoflags & ImageObserver.SOMEBITS) != 0)
				System.out.print("SOMEBITS ");
			if ((infoflags & ImageObserver.WIDTH) != 0)
				System.out.print("WIDTH ");
			System.out.println();*/
			if ((infoflags & ImageObserver.ALLBITS) != 0) {
				stillwaiting = false;
				return false;
			}
			if ((infoflags & ImageObserver.ERROR) != 0) {
				System.err.println("imageUpdate: ERROR");
				stillwaiting = false;
				return false;
			}
			if ((infoflags & ImageObserver.ABORT) != 0) {
				System.err.println("ABORT");
				stillwaiting = false;
				return false;
			}
			return true;
		}
	}
}
