package moulinette;

import java.awt.*;
import java.awt.geom.AffineTransform;
import java.awt.image.*;
import java.io.*;
import java.util.Hashtable;
import java.util.zip.CRC32;

import com.keypoint.*;
import MNGDecoder.*;

public class MNGAnim implements ImAnim {
	
	private static final int PROFILE_TRANS   = 0x00000008;

	private MNGLib mng=null;
	private MNGParam param=null;
	private Image screen=null;
    private int nbimages = -1;
	
	// debugging
	public static void main(String[] args) {
		if (args.length != 4) {
			System.err.println("il faut 4 arguments");
			return;
		}
		File forig = new File(args[0]);
		if (!forig.exists()) {
			System.err.println("le fichier n'existe pas");
			return;
		}
		File fdest = new File(args[1]);
		int largeur;
		int hauteur;
		try {
			largeur = (new Integer(args[2])).intValue();
			hauteur = (new Integer(args[3])).intValue();
		} catch (Exception ex) {
			ex.printStackTrace();
			return;
		}
		MNGAnim anim = new MNGAnim();
		try {
			anim.open(forig);
			anim.rescale(fdest, largeur, hauteur);
		} catch (IOException ex) {
			System.err.println("IOException : " + ex.getMessage());
			return;
		}
	}
	
	public void open(File f) throws IOException {
		if(!MNGLib.checkSignature(f)) {
			throw new IOException("Ce n'est pas la signature d'un MNG");
		}
		mng = new MNGLib(f);

		mng.openStream();
		if(!mng.existsStream()) {
			throw new IOException("!mng.existsStream()");
		}

		if(!mng.readInfo()) {
			mng.closeStream();
			throw new IOException("!mng.readInfo()");
		}
		param = mng.getInfo();
	}
	
	public void close() throws IOException {
        mng.closeStream();
    }
    
	public int getWidth() {
		if (param == null)
			return(-1);
		else
			return(param.width);
	}
	
	public int getHeight() {
		if (param == null)
			return(-1);
		else
			return(param.height);
	}
	
	public int getImageCount() {
        if (nbimages != -1)
            return(nbimages);
		if (param == null)
			return(0);
		else if (param.frames != 0) {
            nbimages = param.frames;
			return(nbimages);
        } else {
            int n = 0;
            // c'est long mais je ne vois pas d'autre moyen...
            try {
                while(!mng.isEOS()) {
                    MNGObject mng_obj = mng.getMNGObject();
                    param = mng.getInfo();
                    if(mng_obj == null)
                        break;
                    
                    Image img = mng_obj.getImage();
                    if (img == null)
                        break;
                    n++;
                    img.getWidth(null); // indispensable pour passer  l'image suivante !
                }
                mng.reopenStream();
            } catch (IOException ex) {
                System.err.println("IOException: " + ex.getMessage());
            }
            nbimages = n;
            return(nbimages);
        }
	}
	
	public Image getImage(int n) throws IOException {
		BufferedImage offimg = new BufferedImage(getWidth(), getHeight(), BufferedImage.TYPE_INT_RGB);
		Graphics2D offg = offimg.createGraphics();
		for (int i=0; i<n && !mng.isEOS(); i++) {
			MNGObject mng_obj = mng.getMNGObject();
			param = mng.getInfo();
			if (mng_obj == null)
				break;

			Image img = mng_obj.getImage();
			if (img == null)
				break;
            
            int xloc = param.x_location;
            int yloc = param.y_location;
            
            offg.drawImage(img, xloc, yloc, null);
		}
        offg.dispose();
		mng.reopenStream();
		return(offimg);
	}
	
	public Image rescaleImage(Image img, int width, int height) {
		return(img.getScaledInstance(width, height, Image.SCALE_SMOOTH));
	}
	
	// getScaledInstance et AreaAveragingScaleFilter ne marchent pas avec Java 1.4 / Mac
	// -> il faut faire tout le travail
	public BufferedImage getMyScaledBufferedImage(Image img, int width1, int height1, int width, int height,
			IndexColorModel icm) {
		
		double scalew = (width*1.0)/width1;
		double scaleh =  (height*1.0)/height1;
		
		BufferedImage buffImage;
		buffImage = new BufferedImage(width1, height1, BufferedImage.TYPE_INT_ARGB);
		Graphics2D g2 = buffImage.createGraphics();
		g2.drawImage(img, 0, 0, null);
		g2.dispose();
		
		int transrgb2 = 0;
		boolean yatrans = false;
        int indtrans = -1;
		if (icm != null) {
			indtrans = icm.getTransparentPixel();
			if (indtrans == -1)
				System.out.println("pas de transparence(2)!");
			else {
				transrgb2 = icm.getRGB(indtrans);
				yatrans = true;
			}
		}
		BufferedImage buff2;
		int[] icmrgbs = null;
		Hashtable cachepalette = null;
		if (icm == null)
			buff2 = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
		else {
			buff2 = new BufferedImage(width, height, BufferedImage.TYPE_BYTE_INDEXED, icm);
			icmrgbs = new int[icm.getMapSize()];
			icm.getRGBs(icmrgbs);
			cachepalette = new Hashtable();
		}
		int[] rgbs = buffImage.getRGB(0, 0, width1, height1, null, 0, width1);
		int[] rgbs2 = new int[width*height];
		for (int ix=0; ix<width; ix++)
			for (int iy=0; iy<height; iy++) {
				double xm = (ix + 0.5) / scalew - 0.5;
				double ym = (iy + 0.5) / scaleh - 0.5;
				double dx1 = xm - 1/(2*scalew);
				double dx2 = xm + 1/(2*scalew);
				double dy1 = ym - 1/(2*scaleh);
				double dy2 = ym + 1/(2*scaleh);
				int x1 = (int)Math.floor(dx1 + 0.5);
				if (x1 < 0)
					x1 = 0;
				int x2 = (int)Math.floor(dx2 + 0.5);
				if (x2 > width1-1)
					x2 = width1-1;
				int y1 = (int)Math.floor(dy1 + 0.5);
				if (y1 < 0)
					y1 = 0;
				int y2 = (int)Math.floor(dy2 + 0.5);
				if (y2 > height1-1)
					y2 = height1-1;
				double bx1 = x1 + 0.5 - dx1;
				double bx2 = dx2 - x2 + 0.5;
				double by1 = y1 + 0.5 - dy1;
				double by2 = dy2 - y2 + 0.5;
		//System.out.println("x1="+x1+" x2="+x2+" y1="+y1+" y2="+y2);
				double tred=0;
				double tgreen=0;
				double tblue=0;
				double tnb=0;
				int rgb;
				double f;
				for (int ix2=x1; ix2<=x2; ix2++)
					for (int iy2=y1; iy2<=y2; iy2++) {
						rgb = rgbs[iy2*width1 + ix2];
						f = 1;
						if (ix2 == x1)
							f *= bx1;
						if (ix2 == x2)
							f *= bx2;
						if (iy2 == y1)
							f *= by1;
						if (iy2 == y2)
							f *= by2;
						tred += f * ((rgb >> 16) & 0xFF);
						tgreen += f * ((rgb >> 8) & 0xFF);
						tblue += f * (rgb & 0xFF);
						tnb += f;
					}
				tred = tred / tnb;
				tgreen = tgreen / tnb;
				tblue = tblue / tnb;
		//System.out.println(ix+","+iy+" : tnb="+tnb+" tred="+tred+" tgreen="+tgreen+" tblue="+tblue);
				int r = (int)tred;
				int g = (int)tgreen;
				int b = (int)tblue;
				rgb = 0xFF000000 | (r << 16) | (g << 8) | b;
				if (icm != null) {
					// recherche de la couleur la plus proche dans la palette
					Integer cachei = (Integer)cachepalette.get(new Integer(rgb));
					if (cachei != null)
						rgb = cachei.intValue();
					else {
						int besti = -1;
						long bestdiff = -1;
						for (int i=0; i<icmrgbs.length; i++)
                            if (!yatrans || i != indtrans) {
                                int rgbi = icmrgbs[i];
                                int ri = (rgbi >> 16) & 0xFF;
                                int gi = (rgbi >> 8) & 0xFF;
                                int bi = rgbi & 0xFF;
                                long diff = (ri - r)*(ri - r) + (gi - g)*(gi - g) + (bi - b)*(bi - b);
                                if (besti == -1 || diff < bestdiff) {
                                    besti = i;
                                    bestdiff = diff;
                                }
                            }
						if (besti != -1) {
							cachepalette.put(new Integer(rgb), new Integer(icmrgbs[besti]));
							rgb = icmrgbs[besti];
						}
					}
				}
				int rgbm = rgbs[(int)Math.round(ym)*width1 + (int)Math.round(xm)];
				if ((rgbm & 0xFF000000) == 0) {
					if (yatrans)
						rgb = transrgb2;
					else
						rgb = rgb & 0x00FFFFFF;
				}
				rgbs2[iy*width + ix] = rgb;
			}
		buff2.setRGB(0, 0, width, height, rgbs2, 0, width);
		return(buff2);
	}
	
	public BufferedImage getScaledBufferedImage(Image img, int width1, int height1, int width, int height,
		double scalew, double scaleh, IndexColorModel icm) {
		
		BufferedImage buffImage;
		buffImage = new BufferedImage(width1, height1, BufferedImage.TYPE_INT_ARGB);
		Graphics2D g2 = buffImage.createGraphics();
		WaitingObserver wobs = new WaitingObserver();
		if (!g2.drawImage(img, 0, 0, wobs)) {
			wobs.attendre();
			g2.setComposite(AlphaComposite.Src);
			g2.drawImage(img, 0, 0, null);
		}
		g2.dispose();
		
		AffineTransformOp aop = new AffineTransformOp(AffineTransform.getScaleInstance(scalew, scaleh), 
			new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC));
		//AffineTransformOp aop = new AffineTransformOp(AffineTransform.getScaleInstance(scalew, scaleh), 
		//	AffineTransformOp.TYPE_NEAREST_NEIGHBOR);
		BufferedImage buff2;
		if (icm == null)
			buff2 = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
		else
			buff2 = new BufferedImage(width, height, BufferedImage.TYPE_BYTE_INDEXED, icm);
		aop.filter(buffImage, buff2);
		return buff2;
		
		/*
		Image newimg =  Toolkit.getDefaultToolkit().createImage(
			new FilteredImageSource(img.getSource(), new AreaAveragingScaleFilter(width, height)));
		BufferedImage buffImage;
		if (icm == null)
			buffImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
		else
			buffImage = new BufferedImage(width, height, BufferedImage.TYPE_BYTE_INDEXED, icm);
		Graphics2D g2 = buffImage.createGraphics();
		WaitingObserver wobs = new WaitingObserver();
		if (!g2.drawImage(newimg, 0, 0, wobs)) {
			wobs.attendre();
			g2.drawImage(newimg, 0, 0, null);
		}
		g2.dispose();
		return buffImage;
		*/
	}
	
	class WaitingObserver implements ImageObserver {
		boolean stillwaiting = true;
		public void attendre() {
			while (stillwaiting) {
				try {
					Thread.currentThread().sleep(100);
				} catch (InterruptedException ex) {
					System.err.println("InterruptedException: " + ex.getMessage());
				}
			}
		}
		public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
			if ((infoflags & ImageObserver.ALLBITS) != 0) {
				stillwaiting = false;
				return false;
			}
			if ((infoflags & ImageObserver.ERROR) != 0)
				System.err.println("imageUpdate: ERROR");
			if ((infoflags & ImageObserver.ABORT) != 0) {
				System.err.println("imageUpdate: ABORT");
				stillwaiting = false;
				return false;
			}
			return true;
		}
	}

	public void rescale(File newf, int width, int height) throws IOException {
		System.out.println("rescale " + newf.getName() + " " + width + " " + height);
		CRC32 crc = new CRC32();
		boolean compression = true;
		try {
			DataOutputStream outfile = new DataOutputStream( new FileOutputStream( newf ) );
			
			// signature MNG (8 bytes)
			outfile.writeByte( 0x8A );
			outfile.writeBytes("MNG\r\n");
			outfile.writeByte( 0x1A );
			outfile.writeByte( '\n' );
			
			// pour savoir les dimensions et la temporisation, on lit la premire image:
			int n = getImageCount();
			//System.out.println(n + " images");
			int tps = param.tps;
			//System.out.println("tempo: " + tps + " images/s");
			int oldwidth = getWidth();
			int oldheight = getHeight();
			boolean arriere_plan = (param.f_mode == 3);
			//System.out.println("revenir sur l'arrire-plan: " + arriere_plan);
			boolean palette_globale = (param.p_len > 0);
			System.out.println("palette globale: " + palette_globale);
			
			// bordel de CRC
			pngBytes = new byte[1000];
			bytePos = 0;
			
			// MHDR  (header)
			
			outfile.writeInt( 28 ); // header size: 28 bytes
			writeString("MHDR");
			writeInt4( width ); // Frame_width (4 bytes)
			writeInt4( height ); // Frame_height (4 bytes)
			writeInt4( tps ); // Ticks_per_second (4 bytes)
			writeInt4( 0 ); // Nominal_layer_count (4 bytes)
			writeInt4( n ); // Nominal_frame_count (4 bytes)
			writeInt4( 0 ); // Nominal_play_time (4 bytes)
			if (arriere_plan || compression)
				writeInt4( 459 ); // Simplicity_profile (4 bytes)  MNG-LC
			else
				writeInt4( 457 ); // Simplicity_profile (4 bytes)  MNG-VLC
			
			outfile.write( pngBytes, 0, bytePos );
			crc.reset();
			crc.update( pngBytes, 0, bytePos );
			outfile.writeInt( (int)crc.getValue() ); // CRC (4 bytes)
			
			// TERM chunk
			bytePos = 0;
			outfile.writeInt( 10 ); // TERM chunk size: 10 bytes
			writeString("TERM");
			writeByte( param.action ); // Termination_action (1 byte)
			writeByte( param.after ); // Action_after_iterations (1 byte)
			writeInt4( param.delay ); // Delay (4 bytes)
			writeInt4( param.limit ); // Iteration_max (4 bytes)
			
			outfile.write( pngBytes, 0, bytePos );
			crc.reset();
			crc.update( pngBytes, 0, bytePos );
			outfile.writeInt( (int)crc.getValue() ); // CRC (4 bytes)
			
			IndexColorModel icm = null;
			// palette
			if (palette_globale) {
				writePLTE(outfile, param.pallet);
				if (param.t_len > 0) {
					System.out.print("couleur trans: " + (param.t_len-1) + "  ");
					icm = new IndexColorModel(8, param.pallet[0].length, param.pallet[0], param.pallet[1],
						param.pallet[2], param.t_len-1);
					System.out.println("rgb=" + Long.toString(icm.getRGB(param.t_len-1) & 0xFFFFFFFFL, 16).toUpperCase());
					writetRNS(outfile, param.trans, param.t_len);
				} else {
					icm = new IndexColorModel(8, param.pallet[0].length, param.pallet[0], param.pallet[1],
						param.pallet[2]);
					if (compression) {
						System.out.println("Cration d'une palette avec un pixel transparent...");
						icm = icmTrans(icm);
						int indtrans = icm.getTransparentPixel();
						if (indtrans == -1)
							System.err.println("Erreur: impossible de trouver un volontaire pour devenir transparent");
						else {
							int t_len = indtrans+1;
							byte[] trans = new byte[t_len];
							for (int i=0; i<t_len-1; i++)
								trans[i] = (byte)0xFF;
							trans[t_len-1] = 0;
							writetRNS(outfile, trans, t_len);
						}
					}
				}
			}
			
			if (arriere_plan && !compression) {
				writeFRAMmode(outfile, 3);
			}
			
			boolean encode_alpha = ((param.profile & PROFILE_TRANS)  != 0);
			System.out.println("encode_alpha: " + encode_alpha);
			if (compression)
				encode_alpha = true;
			
			BufferedImage oldframe = null;
			int backrgb = 0;
			if (compression && param.back != null && param.back.length == 3) {
				int red   = (param.back[0] >> 8) & 0xFF;
				int green = (param.back[1] >> 8) & 0xFF;
				int blue  = (param.back[2] >> 8) & 0xFF;
				backrgb = (red << 16) | (green << 8) | blue;
				System.out.println("backrgb: " + Long.toString(backrgb & 0xFFFFFFFFL, 16).toUpperCase());
			}
			BufferedImage offimg = new BufferedImage(oldwidth, oldheight, BufferedImage.TYPE_INT_RGB);
			Graphics2D offg = offimg.createGraphics();
			/*Color tmpc = offg.getColor();
			offg.setColor(new Color(backrgb));
			offg.fillRect(0, 0, oldwidth, oldheight);
			offg.setColor(tmpc);*/
			
			int vdelay = -1;
			
			while(!mng.isEOS()) {
				MNGObject mng_obj = mng.getMNGObject();
				param = mng.getInfo();
				if(mng_obj == null)
					break;
	
				Image img = mng_obj.getImage();
				if(img == null)
					continue;
				
				System.out.print(".");
				double wratio = (width * 1.0)/param.width;
				double hratio = (height * 1.0)/param.height;
				
				int xloc = param.x_location;
				int yloc = param.y_location;
				/*
				int width1 = img.getWidth(null);
				int height1 = img.getHeight(null);
				int width2 = (int)Math.round(width1*wratio);
				int height2 = (int)Math.round(height1*hratio);
				if (xloc != 0 || yloc != 0) {
					xloc = (int)Math.round(xloc*wratio);
					yloc = (int)Math.round(yloc*hratio);
				}
				BufferedImage frame = getScaledBufferedImage(img, width1, height1, width2, height2, wratio, hratio, icm);
				*/
				
				offg.drawImage(img, xloc, yloc, null);
				
				//BufferedImage frame = getScaledBufferedImage(offimg, param.width, param.height, width, height, wratio, hratio, icm);
				BufferedImage frame = getMyScaledBufferedImage(offimg, param.width, param.height, width, height, icm);
				//Image img2 = rescaleImage(offimg, width, height);
				//BufferedImage frame = getBufferedImage(img2, icm);
				
				/*if (xloc != 0 || yloc != 0) {
					writeDEFI(outfile, xloc, yloc);
					compression = false;
				}*/
				
				if (param.f_delay != 0 && param.f_delay != vdelay) {
					writeFRAMdelay(outfile, (arriere_plan && !compression) ? 3 : 1, param.f_delay);
					vdelay = param.f_delay;
				}
				
				if (compression) {
					BufferedImage frame2 = optimiser(frame, oldframe, backrgb, icm, false, outfile);
					oldframe = frame;
					frame = frame2;
				}
				
				byte[] pngbytes;
				PngEncoderB png =  new PngEncoderB( frame, encode_alpha, PngEncoderB.FILTER_NONE, 9 );
				png.setPasDePalette(palette_globale);
				pngbytes = png.pngEncode();
				
				if (pngbytes == null)
					System.out.println("image vide");
				else
					outfile.write( pngbytes, 8, pngbytes.length - 8 ); // IHDR -> IEND
			}
			System.out.println();
			
			// MEND chunk
			outfile.writeInt( 0 ); // MEND chunk size: 0 bytes
			bytePos = 0;
			writeString("MEND");
			outfile.write( pngBytes, 0, bytePos );
			crc.reset();
			crc.update( pngBytes, 0, bytePos );
			outfile.writeInt( (int)crc.getValue() ); // CRC (4 bytes)
			
			outfile.flush();
			outfile.close();
			
			//mng.closeStream();
            mng.reopenStream();
			
		} catch (IOException e) {
			e.printStackTrace();
		}

	}

	public IndexColorModel icmTrans(IndexColorModel icm) {
		IndexColorModel icm2;
		// on ajouter une couleur transparente ou on en modifie une pour qu'elle devienne transparente
		if (icm.getMapSize() < 256) {
			int count = icm.getMapSize() + 1;
			System.out.print("ajout couleur (count="+count+")");
			byte reds[] = new byte[count];
			byte greens[] = new byte[count];
			byte blues[] = new byte[count];
			icm.getReds(reds);
			icm.getGreens(greens);
			icm.getBlues(blues);
			for (int i=count-1; i>0; i--) {
				reds[i] = reds[i-1];
				greens[i] = greens[i-1];
				blues[i] = blues[i-1];
			}
			reds[0] = (byte)0xFF;
			greens[0] = (byte)0xFF;
			blues[0] = (byte)0xFF;
			icm2 = new IndexColorModel(8, count, reds, greens, blues, 0);
		} else {
			// on demande un volontaire pour devenir transparent
			int count = icm.getMapSize();
			int indtrans = -1;
			long dist = -1;
			for (int i=0; i<count; i++) {
				int rgbi = icm.getRGB(i);
				int ri = (rgbi >> 16) & 0x00FF;
				int gi = (rgbi >> 8) & 0x0000FF;
				int bi = rgbi & 0x000000FF;
				for (int j=i+1; j<count; j++) {
					int rgbj = icm.getRGB(j);
					int rj = (rgbj >> 16) & 0x00FF;
					int gj = (rgbj >> 8) & 0x0000FF;
					int bj = rgbj & 0x000000FF;
					long diff = (ri - rj)*(ri - rj) + (gi - gj)*(gi - gj) + (bi - bj)*(bi - bj);
					if (dist == -1 || diff < dist) {
						dist = diff;
						indtrans = i;
					}
				}
			}
			System.out.print("volontaire transparent: " + indtrans + " dist="+dist+" ");
			System.out.println("rgb=" + Long.toString(icm.getRGB(indtrans) & 0xFFFFFFFFL, 16).toUpperCase());
			byte reds[] = new byte[count];
			byte greens[] = new byte[count];
			byte blues[] = new byte[count];
			icm.getReds(reds);
			icm.getGreens(greens);
			icm.getBlues(blues);
			icm2 = new IndexColorModel(icm.getPixelSize(), count, reds, greens, blues, indtrans);
		}
		return(icm2);
	}
	
	public BufferedImage optimiser(BufferedImage frame, BufferedImage oldframe, int backrgb,
		IndexColorModel icm2, boolean arriere_plan, DataOutputStream outfile) throws IOException {
		int width = frame.getWidth();
		int height = frame.getHeight();
		//System.out.println("optimiser width="+width+" height="+height);
		// icm ici servirait si on voulait mettre une palette par image quand il n'y a pas de palette globale
		//IndexColorModel icm = null;
		//if (frame.getColorModel() instanceof IndexColorModel)
		//	icm =  (IndexColorModel)frame.getColorModel();
		if (oldframe != null) {
			// dtermination de la zone de diffrences
			int xmin = -1;
			int ymin = -1;
			int xmax = -1;
			int ymax = -1;
			for (int ix=0; ix<width; ix++)
				for (int iy=0; iy<height; iy++) {
					if (frame.getRGB(ix, iy) != oldframe.getRGB(ix, iy)) {
						if (xmin == -1 || xmin > ix)
							xmin = ix;
						if (ymin == -1 || ymin > iy)
							ymin = iy;
						if (xmax == -1 || xmax < ix)
							xmax = ix;
						if (ymax == -1 || ymax < iy)
							ymax = iy;
					}
				}
			if (xmin == -1) {// aucune diffrence -> on met juste un pixel
				xmin = 0;
				ymin = 0;
				xmax = 0;
				ymax = 0;
			}
			int width2 = xmax - xmin + 1;
			int height2 = ymax - ymin + 1;
			//System.out.println("width2="+width2+" height2="+height2);
			// cration petite image
			BufferedImage frame2;
			int transrgb = -1;
			int indtrans;
			if (icm2 == null) {
				/*
				if (icm != null) {
					indtrans = icm.getTransparentPixel();
					if (indtrans != -1) {
						transrgb = icm.getRGB(indtrans);
						icm2 = icm;
					} else {
						icm2 = icmTrans(icm);
						indtrans = icm2.getTransparentPixel();
						transrgb = icm2.getRGB(indtrans);
					}
				}
				*/
				frame2 = new BufferedImage(width2, height2, BufferedImage.TYPE_INT_ARGB);
			} else {
				indtrans = icm2.getTransparentPixel();
				if (indtrans != -1)
					transrgb = icm2.getRGB(indtrans);
				frame2 = new BufferedImage(width2, height2, BufferedImage.TYPE_BYTE_INDEXED, icm2);
			}
			int[] rgbs = frame.getRGB(xmin, ymin, width2, height2, null, 0, width2);
			for (int ix=0; ix<width2; ix++)
				for (int iy=0; iy<height2; iy++) {
					int rgb = rgbs[iy*width2 + ix];
					int orgb = oldframe.getRGB(ix+xmin, iy+ymin);
					//if (rgb == orgb || ((rgb & 0xFF000000) == 0 && (orgb & 0xFF000000) == 0)) {
					if (rgb == orgb) {
						if (transrgb == -1)
							rgbs[iy*width2 + ix] = rgb & 0x00FFFFFF; // le pixel doit tre transparent
						else
							rgbs[iy*width2 + ix] = transrgb;
					} else if (/*arriere_plan &&*/ (rgb & 0xFF000000) == 0) { // commentaire pour windoz bug
						rgbs[iy*width2 + ix] = rgb | 0xFF000000; // le pixel doit tre opaque
					}
				}
			frame2.setRGB(0, 0, width2, height2, rgbs, 0, width2);
			// DEFI chunk (position de l'objet)
			writeDEFI(outfile, xmin, ymin);
			return(frame2);
		} else {
			// la premire image doit tre opaque
			BufferedImage frame2;
			if (icm2 == null)
				frame2 = new BufferedImage(width, height, BufferedImage.TYPE_INT_ARGB);
			else
				frame2 = new BufferedImage(width, height, BufferedImage.TYPE_BYTE_INDEXED, icm2);
			
			Graphics2D g2 = frame2.createGraphics();
			if (System.getProperty("os.name").startsWith("Windows"))
				g2.setComposite(AlphaComposite.Src);// windoz bug workaround
			//g2.setColor(new Color(backrgb));
			//g2.fillRect(0, 0, width, height);
			g2.drawImage(frame, 0, 0, null);
			return(frame2);
		}
	}
	
	public static BufferedImage getBufferedImage(Image image, IndexColorModel cm) {
		int imageWidth = image.getWidth(null);
		int imageHeight = image.getHeight(null);
		
		BufferedImage buffImage;
		if (cm == null)
			buffImage = new BufferedImage(imageWidth, imageHeight, BufferedImage.TYPE_INT_ARGB);
		else
			buffImage = new BufferedImage(imageWidth, imageHeight, BufferedImage.TYPE_BYTE_INDEXED, cm);
		
		Graphics2D g2 = buffImage.createGraphics();
		g2.setComposite(AlphaComposite.Src);
		g2.drawImage(image, 0, 0, null);
		
		return buffImage;
	}
	
	protected void writePLTE(DataOutputStream outfile, byte[][] pallet ) throws IOException {
		byte[] allPal = new byte[pallet.length*pallet[0].length];
	
		for (int i=0; i<pallet[0].length; i++) {
			allPal[i*3] = pallet[0][i];
			allPal[i*3+1] = pallet[1][i];
			allPal[i*3+2] = pallet[2][i];
		}
		bytePos = 0;
		writeInt4( allPal.length );
		writeString( "PLTE" );
		CRC32 crc = new CRC32();
		crc.update("PLTE".getBytes());
		writeBytes( allPal );
		crc.update( allPal );
		writeInt4( (int) crc.getValue());
		outfile.write( pngBytes, 0, bytePos );
	}

	protected void writetRNS(DataOutputStream outfile, byte[] trans, int t_len) throws IOException {
		bytePos = 0;
		writeInt4( t_len );
		writeString( "tRNS" );
		CRC32 crc = new CRC32();
		crc.update("tRNS".getBytes());
		for (int i=0; i<t_len; i++) {
			writeByte( trans[i] );
			crc.update( trans[i] );
		}
		writeInt4( (int) crc.getValue());
		outfile.write( pngBytes, 0, bytePos );
	}

	protected void writeFRAMmode(DataOutputStream outfile, int mode) throws IOException {
		// FRAM chunk (pour remettre le fond - du coup ce n'est pas du MNG-VLC mais du MNG-LC)
		bytePos = 0;
		outfile.writeInt( 1 ); // FRAM chunk size
		writeString("FRAM");
		writeByte( mode ); // Framing_mode (1 byte)
		
		outfile.write( pngBytes, 0, bytePos );
	        CRC32 crc = new CRC32();
		crc.reset();
		crc.update( pngBytes, 0, bytePos );
		outfile.writeInt( (int)crc.getValue() ); // CRC (4 bytes)
	}
	
	protected void writeFRAMdelay(DataOutputStream outfile, int mode, int ticks) throws IOException {
		bytePos = 0;
		outfile.writeInt( 10 ); // FRAM chunk size
		writeString("FRAM");
		writeByte( mode ); // Framing_mode (1 byte)
		//writeByte( 0 ); // Subframe_name (1 byte)
		writeByte( 0 ); // Separator (1 byte)
		writeByte( 2 ); // Change_interframe_delay (1 byte)
		writeByte( 0 ); // Change_timeout_and_termination (1 byte)
		writeByte( 0 ); // Change_layer_clipping_boundaries (1 byte)
		writeByte( 0 ); // Change_sync_id_list (1 byte)
		writeInt4( ticks ); // Interframe_delay (4 bytes)
		
		outfile.write( pngBytes, 0, bytePos );
	        CRC32 crc = new CRC32();
		crc.reset();
		crc.update( pngBytes, 0, bytePos );
		outfile.writeInt( (int)crc.getValue() ); // CRC (4 bytes)
	}

	protected void writeDEFI(DataOutputStream outfile, int x, int y) throws IOException {
	        outfile.writeInt(12);
	    	bytePos = 0;
	        writeString( "DEFI" );
	        writeInt2( 0 ); // Object_id
	        writeByte( 0 ); // Do_not_show
	        writeByte( 0 ); // Concrete_flag
	        writeInt4( x ); // X_location
	        writeInt4( y ); // Y_location
		
	        CRC32 crc = new CRC32();
		crc.reset();
		crc.update( pngBytes, 0, bytePos );
	        writeInt4( (int) crc.getValue());
		outfile.write( pngBytes, 0, bytePos );
	}

	// utilitaires piqus dans PngEncoder:
	
    protected byte[] pngBytes;
	protected int bytePos;
    
    /**
     * Increase or decrease the length of a byte array.
     *
     * @param array The original array.
     * @param newLength The length you wish the new array to have.
     * @return Array of newly desired length. If shorter than the
     *         original, the trailing elements are truncated.
     */
    protected byte[] resizeByteArray( byte[] array, int newLength )
    {
        byte[]  newArray = new byte[newLength];
        int     oldLength = array.length;

        System.arraycopy( array, 0, newArray, 0,
            Math.min( oldLength, newLength ) );
        return newArray;
    }

    /**
     * Write an array of bytes into the pngBytes array.
     * Note: This routine has the side effect of updating
     * maxPos, the largest element written in the array.
     * The array is resized by 1000 bytes or the length
     * of the data to be written, whichever is larger.
     *
     * @param data The data to be written into pngBytes.
     * @param offset The starting point to write to.
     * @return The next place to be written to in the pngBytes array.
     */
    protected void writeBytes( byte[] data )
    {
        int offset = bytePos;
        if (data.length + offset > pngBytes.length)
        {
            pngBytes = resizeByteArray( pngBytes, pngBytes.length +
                Math.max( 1000, data.length ) );
        }
        System.arraycopy( data, 0, pngBytes, offset, data.length );
	bytePos = offset + data.length;
    }

    /**
     * Write an array of bytes into the pngBytes array, specifying number of bytes to write.
     * Note: This routine has the side effect of updating
     * maxPos, the largest element written in the array.
     * The array is resized by 1000 bytes or the length
     * of the data to be written, whichever is larger.
     *
     * @param data The data to be written into pngBytes.
     * @param nBytes The number of bytes to be written.
     * @param offset The starting point to write to.
     * @return The next place to be written to in the pngBytes array.
     */
    protected void writeBytes( byte[] data, int nBytes )
    {
        int offset = bytePos;
        if (nBytes + offset > pngBytes.length)
        {
            pngBytes = resizeByteArray( pngBytes, pngBytes.length +
                Math.max( 1000, nBytes ) );
        }
        System.arraycopy( data, 0, pngBytes, offset, nBytes );
        bytePos = offset + nBytes;
    }

    /**
     * Write a two-byte integer into the pngBytes array at a given position.
     *
     * @param n The integer to be written into pngBytes.
     * @param offset The starting point to write to.
     * @return The next place to be written to in the pngBytes array.
     */
    protected void writeInt2( int n )
    {
        byte[] temp = { (byte)((n >> 8) & 0xff),
            (byte) (n & 0xff) };
        writeBytes( temp );
    }

    /**
     * Write a four-byte integer into the pngBytes array at a given position.
     *
     * @param n The integer to be written into pngBytes.
     * @param offset The starting point to write to.
     * @return The next place to be written to in the pngBytes array.
     */
    protected void writeInt4( int n )
    {
        byte[] temp = { (byte)((n >> 24) & 0xff),
            (byte) ((n >> 16) & 0xff ),
            (byte) ((n >> 8) & 0xff ),
            (byte) ( n & 0xff ) };
        writeBytes( temp );
    }

    /**
     * Write a single byte into the pngBytes array at a given position.
     *
     * @param n The integer to be written into pngBytes.
     * @param offset The starting point to write to.
     * @return The next place to be written to in the pngBytes array.
     */
    protected void writeByte( int b )
    {
        byte[] temp = { (byte) b };
        writeBytes( temp );
    }

    /**
     * Write a string into the pngBytes array at a given position.
     * This uses the getBytes method, so the encoding used will
     * be its default.
     *
     * @param n The integer to be written into pngBytes.
     * @param offset The starting point to write to.
     * @return The next place to be written to in the pngBytes array.
     * @see java.lang.String#getBytes()
     */
    protected void writeString( String s )
    {
        writeBytes( s.getBytes() );
    }
}
