package moulinette;

import java.awt.*;
import java.awt.image.*;
import java.awt.geom.AffineTransform;
import java.io.*;
import com.sun.image.codec.jpeg.*; // pas b !

public class JPEGImage implements ImAnim {
	Image img = null;
	
	public void open(File f) throws IOException {
		img = Toolkit.getDefaultToolkit().getImage(f.getPath());
		
		try {
			// load image
			while (img.getWidth(null) == -1 || img.getHeight(null) == -1)
				Thread.currentThread().sleep(100);
		} catch (InterruptedException ex) {
			throw new IOException("InterruptedException: " + ex.getMessage());
		}
	}
	
	public int getWidth() {
		if (img == null)
			return(-1);
		else
			return(img.getWidth(null));
	}
	
	public int getHeight() {
		if (img == null)
			return(-1);
		else
			return(img.getHeight(null));
	}
	
	public int getImageCount() {
		if (img == null)
			return(0);
		else
			return(1);
	}
	
	public Image getImage(int n) {
		if (n != 0)
			return(null);
		else
			return(img);
	}
	
	public void rescale(File newf, int width, int height) throws IOException {
		System.out.println("rescale " + newf.getName() + " " + width + " " + height);
		//Image newimg = img.getScaledInstance(width, height, Image.SCALE_SMOOTH);
		
		FileOutputStream out = new FileOutputStream( newf );
		JPEGImageEncoder encoder = JPEGCodec.createJPEGEncoder(out);
		BufferedImage bimg = getScaledBufferedImage(width, height);
		/*JPEGEncodeParam jpegParams = encoder.getDefaultJPEGEncodeParam(bimg);
		jpegParams.setQuality(1.0f, false);
		encoder.setJPEGEncodeParam(jpegParams);*/
		encoder.encode(bimg);
		out.flush();
		out.close();
	}

	public BufferedImage getScaledBufferedImage(int width, int height) {
		
		/*
		int width1 = img.getWidth(null);
		int height1 = img.getHeight(null);
		BufferedImage buffImage = new BufferedImage(width1, height1, BufferedImage.TYPE_INT_RGB);
		Graphics2D g2 = buffImage.createGraphics();
		WaitingObserver wobs = new WaitingObserver();
		if (!g2.drawImage(img, 0, 0, wobs)) {
			wobs.attendre();
			g2.drawImage(img, 0, 0, wobs);
		}
		g2.drawImage(img, 0, 0, null);
		g2.dispose();
		double scalew = (1.0 * width) / width1;
		double scaleh = (1.0 * height) / height1;
		AffineTransformOp aop = new AffineTransformOp(AffineTransform.getScaleInstance(scalew, scaleh), 
			AffineTransformOp.TYPE_BILINEAR);
		BufferedImage buff2 = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
		aop.filter(buffImage, buff2);
		return buff2;
		*/
		
		Image newimg =  Toolkit.getDefaultToolkit().createImage(
			new FilteredImageSource(img.getSource(), new AreaAveragingScaleFilter(width, height)));
		BufferedImage buffImage = new BufferedImage(width, height, BufferedImage.TYPE_INT_RGB);
		Graphics2D g2 = buffImage.createGraphics();
		WaitingObserver wobs = new WaitingObserver();
		if (!g2.drawImage(newimg, 0, 0, wobs)) {
			wobs.attendre();
			g2.drawImage(newimg, 0, 0, null);
		}
		g2.dispose();

		return buffImage;
	}
	
	class WaitingObserver implements ImageObserver {
		boolean stillwaiting = true;
		public void attendre() {
			while (stillwaiting) {
				try {
					Thread.currentThread().sleep(100);
				} catch (InterruptedException ex) {
					System.err.println("InterruptedException: " + ex.getMessage());
				}
			}
		}
		public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
			if ((infoflags & ImageObserver.ALLBITS) != 0) {
				stillwaiting = false;
				return false;
			}
			if ((infoflags & ImageObserver.ABORT) != 0) {
				System.err.println("imageUpdate: ABORT");
				stillwaiting = false;
				return false;
			}
			return true;
		}
	}
}
