package moulinette;

import java.io.File;

/**
  * usine  ImAnim
  */
public class ImAnimFactory {
	public static ImAnim create(File f) {
		String fname = f.getName().toLowerCase();
		if (fname.endsWith(".mng"))
			return(new MNGAnim());
		else if (fname.endsWith(".png"))
			return(new PNGImage());
		else if (fname.endsWith(".jpeg") || fname.endsWith(".jpg"))
			return(new JPEGImage());
		else if (fname.endsWith(".gif"))
			return(new GIFAnim());
		else if (fname.endsWith(".mpeg") || fname.endsWith(".mpg"))
			return(new MPEGAnim());
		else
			return(null);
	}
}
