package moulinette;

import java.util.Vector;
import java.io.*;
import java.awt.*;
import java.awt.image.*;

import com.keypoint.*;

import xml.*;

/**
 * copie et conversion (pour localisation=page ou icne) des images
 * A lancer dans le rpertoire IUFM ou UEL ou DEA (contribXML et site doivent se trouver dans ce rpertoire)
 * N'utilise *plus* convert et identify de ImageMagick
 * compilation: javac -d classes -encoding ISO-8859-1 FaireImages.java
 */
public class FaireImages {

    static final String slash = "/";
    static final String convert = "convert";
    static final String identify = "identify";
	static final String newline = System.getProperty("line.separator");
	String cheminImages = "images.xml";
	String cheminSortie = "imagespage2.html";
	String dossier = "";
	MessageHandler messhdl = null;

    public static void main(String[] args) {
		String cheminImages = null;
		if (args != null && args.length > 0)
			cheminImages = args[0];
		FaireImages moi = new FaireImages(cheminImages);
		moi.conversion(null);
		System.exit(0);
	}
	
	public FaireImages(String cheminImages) {
		if (cheminImages != null)
			this.cheminImages = cheminImages;
		File fim = new File(this.cheminImages);
		if (fim.getParent() != null)
			dossier = fim.getParent() + File.separator;
	}
	
	public void conversion(MessageHandler messhdl) {
		if (messhdl != null)
			this.messhdl = messhdl;

		// copie des fichiers des contributions (pas seulement les images) vers le site
		message("   Copie des fichiers des contributions...");
		File fim = new File(this.cheminImages);
		String cheminSite = fim.getParent();
		(new CopieContribs()).copie(cheminSite);
		
        try {
        // lecture de images.xml
        XMLTree tree = new XMLTree(null, "", null, "");
        Parser_XML p = new Parser_XML(new FileInputStream(cheminImages), System.out, tree);
        p.parse(0);
        if (!"IMAGES".equalsIgnoreCase(tree.tag)) {
            erreur("Mauvais fichier XML !");
            return;
        }
        
        // dbut de cration de imagespage2.html
        PrintWriter out = new PrintWriter(new BufferedWriter(new OutputStreamWriter(
            new FileOutputStream(dossier + cheminSortie), "ISO-8859-1")));
        out.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        out.println("<html>");
        out.println("<head><title>Images en page ou icone</title></head>");
        out.println("<body>");
        out.println("<table border=\"1\">");
        out.println("<tr><th>nom</th><th>contribution</th><th>largeur1</th><th>hauteur1</th><th>redim.</th><th>largeur2</th><th>hauteur2</th><th>carte</th><th>nouveau nom</th><th>localisation</th></tr>");
        
        // rduction des images, cration de fichiers HTML si ncessaire
        XMLTree noeudImage;
        for (noeudImage=tree.first_child; noeudImage!=null; noeudImage=noeudImage.next_brother) {
            String contrib = noeudImage.getAttVal("contrib");
            String nomlocal = noeudImage.getAttVal("nomlocal"); // chemin du fichier dans la contrib
            String localisation = noeudImage.getAttVal("localisation");
            File fsite = new File(dossier + "site" + slash + "images" + slash + contrib + slash + nomlocal);
			
			if ("page".equals(localisation) || "icne".equals(localisation) ||
                    nomlocal.toLowerCase().endsWith(".mng") ||
                    nomlocal.toLowerCase().endsWith(".mpg") || nomlocal.toLowerCase().endsWith(".mpeg")) {
                    // on a besoin de connatre la taille des MPEG pour pouvoir les afficher
				
				int hmax;
				int wmax;
				String anciennom = nomlocal;
				File petitf;
                
				if ("icne".equals(localisation)) {
					hmax = 100;
					wmax = 100;
                    petitf = new File(dossier + "site" + slash + "images_icone" + slash + contrib + slash + nomlocal);
				} else if ("page".equals(localisation)) {
					hmax = 300;
					wmax = 300;
                    petitf = new File(dossier + "site" + slash + "images_page" + slash + contrib + slash + nomlocal);
				} else {
					hmax = 500;
					wmax = 500;
                    petitf = new File(dossier + "site" + slash + "images_texte" + slash + contrib + slash + nomlocal);
				}
	            int h=0,w=0,h2=0,w2=0;
				
				String scarte;
				String nomsansext = nomlocal;
				if (nomsansext.indexOf('.') != -1)
					nomsansext = nomsansext.substring(0, nomsansext.lastIndexOf('.'));
	            File fcarte = new File(dossier + "site" + slash + "images" + slash + contrib + slash + nomsansext + ".carte");
	            if (fcarte.exists())
	                scarte = "oui";
				else
					scarte = "non";
				
	            if (fsite.exists() && fsite.isFile()) {
					ImAnim imanim = ImAnimFactory.create(fsite);
					if (imanim == null) {
						erreur("Format inconnu: " + fsite.getName());
						continue;
					}
					imanim.open(fsite);
	                w = imanim.getWidth();
	                h = imanim.getHeight();
					//System.out.println(fsite.getName()+ " w="+w+" h="+h);
					if (w < 0 || h < 0) {
						erreur("Erreur pour trouver les dimensions de " + contrib + slash + nomlocal);
						w = 0;
						h = 0;
					}
					if ((w > wmax || h > hmax) && !(imanim instanceof MPEGAnim)) {
                        /*if (nomlocal.toLowerCase().endsWith(".gif")) {
                            // transformation GIF -> PNG/MNG quand la rduction est ncessaire
                            AMortLesGIFs amort = new AMortLesGIFs();
                            File nouveauf = amort.amort(fsite, false);
                            fsite.delete();
                            fsite = nouveauf;
                            if (nomlocal.indexOf(slash) == -1)
                                nomlocal = fsite.getName();
                            else
                                nomlocal = nomlocal.substring(0, nomlocal.lastIndexOf(slash) + 1) + fsite.getName();
                            petitf = new File(petitf.getParent(), fsite.getName());
                            imanim = ImAnimFactory.create(fsite);
                            imanim.open(fsite);
                        }*/ // GIFAnim gre maintenant les rductions d'animations
                        //File dirfsite = new File(fsite.getParent());
                        //if (!dirfsite.exists())
                        //    dirfsite.mkdirs();
                        File dirpetitf = new File(petitf.getParent());
                        if (!dirpetitf.exists())
                            dirpetitf.mkdirs();
                        if ((1.0*w)/wmax > (1.0*h)/hmax) {
                            w2 = wmax;
                            h2 = (int)Math.round(((1.0*wmax)/w) * h);
                            if (h2 > hmax)
                                h2 = hmax;
                        } else {
                            h2 = hmax;
                            w2 = (int)Math.round(((1.0*hmax)/h) * w);
                            if (w2 > wmax)
                                w2 = wmax;
                        }
                        if (!petitf.exists() || fsite.lastModified() > petitf.lastModified()) {
                            message("   " + nomlocal + " dans " + contrib + " en " + w + " x " + h,Color.gray,true,false);
                            imanim.rescale(petitf, w2, h2);
                        }
                        
                        if (fcarte.exists() && "page".equals(localisation)) {
                            File fcarte2 = new File(dossier + "site" + slash + "images_page" + slash + contrib + slash + nomsansext + ".carte");
                            copierFichier(fcarte, fcarte2);
                        }
                        
						// s'il s'agit d'un PNG, on cre un fichier HTML pour pouvoir le visualiser avec ce p*beep* de IE
						if (imanim instanceof PNGImage) {
							File grandhtml = new File(dossier + "site" + slash + "images" + slash + contrib + slash + nomsansext + ".html");
							PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(grandhtml)));
        					pw.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
							pw.println("<html>");
							pw.println("<head>");
							pw.println("<title>" + fsite.getName() + "</title>");
							pw.println("</head>");
							pw.println("<body>");
							pw.println("<img width=\"" + w + "\" height=\"" + h +
								"\" src=\"" + fsite.getName() + "\">");
							pw.println("</body>");
							pw.println("</html>");
							pw.close();
						}
						// s'il s'agit d'un MNG, on cre un fichier HTML avec une applet pour pouvoir le visualiser
						else if (imanim instanceof MNGAnim) {
							File grandhtml = new File(dossier + "site" + slash + "images" + slash + contrib + slash + nomsansext + ".html");
							PrintWriter pw = new PrintWriter(new BufferedWriter(new FileWriter(grandhtml)));
        					pw.println("<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01 Transitional//EN\">");
							pw.println("<html>");
							pw.println("<head>");
							pw.println("<title>" + fsite.getName() + "</title>");
							pw.println("</head>");
							pw.println("<body>");
							String prefixe = "../../";
							for (int i=0; i<nomsansext.length(); i++)
								if (nomsansext.charAt(i) == '/')
									prefixe += "../";
							pw.println("<applet code=\"MNG_LC_Player.class\" width=\"" + w + "\" height=\"" + h +
								"\" codebase=\"" + prefixe + "\" archive=\"applets/mngplay.jar\">");
							pw.println("<param name=\"src\" value=\"" + fsite.getName() + "\">");
							pw.println("<param name=\"bgcolor\" value=\"#FFFFFF\">");
							pw.println("<param name=\"caching\" value=\"off\">");
							pw.println("</applet>");
							pw.println("</body>");
							pw.println("</html>");
							pw.close();
						}
	                }
                    if (imanim instanceof MNGAnim) {
                        // en plus on cre une image fixe correspondante pour les impressions
                        File fimfixe = new File(dossier + "site" + slash + "images_anims" + slash +
                            contrib + slash + nomsansext + ".png");
                        if (!fimfixe.exists() || fsite.lastModified() > fimfixe.lastModified()) {
                            fimfixe.getParentFile().mkdirs();
                            creerImageFixe(imanim, fimfixe);
                        }
                        ((MNGAnim)imanim).close();
                    } else if (imanim instanceof GIFAnim && imanim.getImageCount() > 1) {
                        File fimfixe = new File(dossier + "site" + slash + "images_anims" + slash +
                            contrib + slash + nomsansext + ".gif");
                        if (!fimfixe.exists() || fsite.lastModified() > fimfixe.lastModified()) {
                            fimfixe.getParentFile().mkdirs();
                            creerImageFixe(imanim, fimfixe);
                        }
                    }
	            }
	            if (fsite.exists()) {
	                String redim;
	                if (petitf.exists())
	                    redim = "oui";
	                else
	                    redim = "non";
	                out.println("<tr>");
					if (w2 == 0 && h2 == 0) {
						w2 = w;
						h2 = h;
					}
	                out.println("<td>" + anciennom + "</td> <td>" + contrib + "</td> <td>" + w +
	                    "</td> <td>" + h + "</td> <td>" + redim + "</td> <td>" + w2 + "</td> <td>" + h2 +
						"</td> <td>" + scarte + "</td><td>" + nomlocal + "</td><td>" + localisation + "</td>");
	                out.println("</tr>");
	            }
			}
        } // for noeudImage
        out.println("</table>");
        out.println("</body>");
        out.println("</html>");
        out.close();
		
        } catch (Exception ex) {
            erreur(ex);
            return;
        }
    }
    
    public void creerImageFixe(ImAnim anim, File newf) {
        int width = anim.getWidth();
        int height = anim.getHeight();
        int n = anim.getImageCount();
        try {
            BufferedImage buffImage = new BufferedImage(width*2, height*2, BufferedImage.TYPE_INT_ARGB);
            Graphics2D g2 = buffImage.createGraphics();
            WaitingObserver wobs = new WaitingObserver();
            Image img1 = anim.getImage(n/4+1);
            if (!g2.drawImage(img1, 0, 0, wobs)) {
                wobs.attendre();
                g2.drawImage(img1, 0, 0, null);
            }
            Image img2 = anim.getImage(n/2+1);
            if (!g2.drawImage(img2, width, 0, wobs)) {
                wobs.attendre();
                g2.drawImage(img2, width, 0, null);
            }
            Image img3 = anim.getImage((n*3)/4+1);
            if (!g2.drawImage(img3, 0, height, wobs)) {
                wobs.attendre();
                g2.drawImage(img3, 0, height, null);
            }
            Image img4 = anim.getImage(n);
            if (!g2.drawImage(img4, width, height, wobs)) {
                wobs.attendre();
                g2.drawImage(img4, width, height, null);
            }
            g2.setColor(Color.black);
            g2.drawRect(0, 0, width*2-1, height*2-1);
            g2.drawLine(0, height, width*2-1, height);
            g2.drawLine(width, 0, width, height*2-1);
            g2.dispose();
            
            byte[] pngbytes;
            PngEncoder png =  new PngEncoder( buffImage, PngEncoderB.ENCODE_ALPHA, PngEncoderB.FILTER_NONE, 9 );
            FileOutputStream outfile = new FileOutputStream( newf );
            pngbytes = png.pngEncode();
            if (pngbytes == null)
                throw new IOException("PNG encoding " + newf.getPath());
            else
                outfile.write( pngbytes );
            outfile.flush();
            outfile.close();
        } catch (IOException ex) {
            erreur(ex);
        }
    }
    
	void erreur(Exception ex) {
        ex.printStackTrace();
		erreur(ex.getClass().getName() + ": " + ex.getMessage());
	}
	
	void erreur(String msg) {
		if (messhdl != null)
			messhdl.erreur(msg);
		else
			System.err.println(msg);
	}
	
	void message(String msg) {
		if (messhdl != null)
			messhdl.message(msg);
		else
			System.out.println(msg);
	}
    
    void message(String msg, Color c, boolean italic, boolean bold) {
        if (messhdl != null)
            messhdl.message(msg,c,italic,bold);
        else
            System.out.println(msg);
    }
	
    public static void copierFichier(File inputFile, File outputFile) throws IOException {
        int bufSize = 1024; 
        BufferedInputStream in  = new BufferedInputStream( 
                                      new FileInputStream(inputFile),bufSize); 
        BufferedOutputStream out = new BufferedOutputStream( 
                                      new FileOutputStream(outputFile), bufSize); 
        int length = 32;  
        byte[] ch = new byte[length]; 
        while((length = in.read(ch))!= -1) { 
            out.write(ch,0,length); 
        } 
        out.flush(); 
        in.close(); 
        out.close(); 
    }
    
	class WaitingObserver implements ImageObserver {
		boolean stillwaiting = true;
		public void attendre() {
			while (stillwaiting) {
				try {
					Thread.currentThread().sleep(100);
				} catch (InterruptedException ex) {
					System.err.println("InterruptedException: " + ex.getMessage());
				}
			}
		}
		public boolean imageUpdate(Image img, int infoflags, int x, int y, int width, int height) {
			if ((infoflags & ImageObserver.ALLBITS) != 0) {
				stillwaiting = false;
				return false;
			}
			if ((infoflags & ImageObserver.ERROR) != 0)
				System.err.println("imageUpdate: ERROR");
			if ((infoflags & ImageObserver.ABORT) != 0) {
				System.err.println("imageUpdate: ABORT");
				stillwaiting = false;
				return false;
			}
			return true;
		}
	}
}
