package moulinette;

import javax.swing.*;
import java.awt.*;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.File;
import javax.swing.filechooser.*;
import java.util.Hashtable;
import java.util.Enumeration;


public class DialogueConfig extends JDialog implements ActionListener {
	
	JTextField TextFileASM2 = new JTextField(35);
	JButton bValider, bAnnuler, bASM2, binfo;
	ChaineEdition ChaineEdit;
    static final String slash = File.separator;
    File repXSL = new File("XSL");
    Image infoImage = Toolkit.getDefaultToolkit().getImage(ChaineEdition.class.getResource("info.gif"));
    Icon infoIcon = new ImageIcon(infoImage);
	
	public DialogueConfig(ChaineEdition ChaineEdit) {
		super((JFrame)ChaineEdit, "Configuration", true);
	 	this.ChaineEdit = ChaineEdit;	
	 	JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, BoxLayout.Y_AXIS));
        JPanel PanelMainConfig = new JPanel();
        PanelMainConfig.setLayout(new BoxLayout(PanelMainConfig, BoxLayout.Y_AXIS));
        PanelMainConfig.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1,Color.white,new Color(70,70,70))," Modifier le traitement ",1,2));
        JPanel PanelConfig1 = new JPanel();
        TextFileASM2.setText(((ChaineEdit.ASM2).getAbsoluteFile()).toString());
        bASM2 = new JButton("XSL tape 4");
        bASM2.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {
            	newFile();
          	}
        });
        binfo = new JButton("", infoIcon);
        binfo.addActionListener(this);
        binfo.setActionCommand("infoASM2");
        binfo.setToolTipText("Infos concernant cette action");
        PanelConfig1.add(TextFileASM2);
        PanelConfig1.add(bASM2);
        PanelConfig1.add(binfo);
        PanelMainConfig.add(PanelConfig1);
        JPanel PanelValider = new JPanel(new FlowLayout());
        bValider = new JButton("Valider");
        bValider.setForeground(new Color(13,155,73));
        bValider.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {   
            	valider();
          	}
        }); 
        bAnnuler = new JButton("Annuler");
        bAnnuler.setForeground(new Color(13,155,73));
        bAnnuler.addActionListener(new ActionListener() {
            public void actionPerformed(ActionEvent e) {   
            	annuler();
          	}
        });  
        PanelValider.add(bValider);
        PanelValider.add(bAnnuler);
        pane.add(PanelMainConfig);
        pane.add(PanelValider);
        setContentPane(pane);
        pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
    	//centrer % chaineEdit
        //setLocation((int)(ChaineEdit.getWidth()/2-this.getWidth()/2)+ChaineEdit.getX(),(int)(ChaineEdit.getHeight()/2-this.getHeight()/2)+ChaineEdit.getY());
        setLocation((screen.width - getSize().width)/2,(screen.height - getSize().height)/2);
        setResizable(false);
        setVisible(true);
	}
	
	
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if ("infoASM2".equals(cmd)) {
            JOptionPane.showMessageDialog(this, MyResourceBundle.getAides().getString("modifConfig"),"info", JOptionPane.INFORMATION_MESSAGE);
        }     
    }     
	
	
	public void newFile() {
        String[] defaultExt = {"xsl"};
        MyFileChooser myChooser = new MyFileChooser(repXSL.getAbsolutePath());
		MyFileFilter filter = new MyFileFilter(defaultExt, "feuille de style tape 4 ");
		myChooser.addChoosableFileFilter(filter);
		int returnVal = myChooser.showOpenDialog(this);
		if ((myChooser.getSelectedFile() != null) && (returnVal == JFileChooser.APPROVE_OPTION)) {
        	TextFileASM2.setText(myChooser.getSelectedFile().toString());
        }   
	}
	 
	 
	public void valider() {
		File newFile = new File(TextFileASM2.getText());
		if (newFile.exists() &&	newFile.toString().toLowerCase().endsWith(".xsl")) {
			if ((repXSL.getAbsolutePath()).equals(newFile.getParentFile().getAbsolutePath())) {
				if (!TextFileASM2.getText().equals(((ChaineEdit.ASM2).getAbsoluteFile()).toString())) {
					ChaineEdit.ASM2 = newFile;
					ChaineEdit.message("La feuille de style utilise  l'tape 4 est dsormais : " + newFile.toString() + "\n");
				}
			 	this.dispose();			
			}
			else {
				JOptionPane.showMessageDialog(this,"Erreur : La feuille de style doit tre dans le rpertoire \"XSL\" de l'application !\n");
			}			
		}
		else {
			if (!newFile.exists()) JOptionPane.showMessageDialog(this,"Erreur : Le fichier choisi n'a pas t trouv !\n");
			else JOptionPane.showMessageDialog(this,"Erreur : Le fichier choisi n'a pas l'extension xsl !\n");
		}		
	}
	 
	 
	public void annuler(){
	 	this.dispose();
	}
	
	
	class MyFileChooser extends JFileChooser {
		
        public MyFileChooser() {
            super();
        }

        public MyFileChooser(String defaultDir) {
            super(defaultDir);
        }

        public void approveSelection() {
            if (!validation(this.getSelectedFile())) {
                return;
            }
            super.approveSelection();
        }

        private boolean validation(File file) {
            if (file.exists()) {
            	if (file.toString().toLowerCase().endsWith(".xsl")) {
            		if (!(repXSL.getAbsolutePath()).equals(file.getParentFile().getAbsolutePath())) {
        				JOptionPane.showMessageDialog(this,"Erreur : La feuille de style doit tre dans le rpertoire \"XSL\" de l'application !\n");
            			return false;
            		}
            	}
            	else {
            		JOptionPane.showMessageDialog(this,"Erreur : Le fichier choisi n'a pas l'extension xsl !\n");
            		return false;
            	}
            }
            else {
            	JOptionPane.showMessageDialog(this,"Erreur : Le fichier choisi n'a pas t trouv !\n");
            	return false;
            }
            return true;
        }
    }

	
	class MyFileFilter extends FileFilter {

	    private Hashtable filtres = null;
	    private String description = null;
	    private String descriptionWithExt = null;
	    
	    public MyFileFilter(String[] allFiltres, String description) {
	        filtres = new Hashtable(allFiltres.length);
	        for (int i=0 ; i < allFiltres.length ; i++) {
	      	    if (filtres == null)
	      	        filtres = new Hashtable(5);
	      	    filtres.put(allFiltres[i].toLowerCase(), this);
	        }
	        descriptionWithExt = null;
	        this.description = description;
	    }

	    public boolean accept(File file) {
	        boolean result = false;
	        if (file != null) {
	            if (file.isDirectory())
	                result = true;
	            if ((getExtension(file) != null) && (filtres.get(getExtension(file)) != null))
	          	    result = true;
	        }
	        return (result);
        }

	    public String getExtension(File file) {
	        if (file != null) {
	            String filename = file.getName();
	            int i = filename.lastIndexOf('.');
	            if (i>0 && i<filename.length()-1)
	            	return filename.substring(i+1).toLowerCase();
	        }
	        return null;
	    }

	    public String getDescription() {
	        if (descriptionWithExt == null) {
			    if (description != null)
			        descriptionWithExt = description;
			    Enumeration extensions = filtres.keys();
			    if (extensions != null) {
				    descriptionWithExt += " (";
			        descriptionWithExt += "." + (String) extensions.nextElement();
			        while (extensions.hasMoreElements()) {
			            descriptionWithExt += ", ." + (String) extensions.nextElement();
			        }
				    descriptionWithExt += ")";
			    }
	        }
	        return (descriptionWithExt);
	    }

	}
	
	
	 
}