package moulinette;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import java.util.*;
import org.w3c.dom.*;
import java.io.*;

 
public class DialogueArbre extends JDialog implements ActionListener, ItemListener {

    private static DOMTree MyTree;
    private static String activeType;
    static int selectNoeud = 0;
    static String noeudActif = new String("");
    JComboBox valNoeud;
    DialogueArbre dialogue;
    String[][][] pere_fils, attrib_balise; 
    static int nbAtt = 0;
    static final String slash = File.separator;
    static boolean actif = true;
    int index; 
    JComponent[] champs;
    JPanel dlgpane, pane;
    ChaineEdition CE;

    
    public DialogueArbre(DOMTree Mtree, String type, ChaineEdition ChaineEdit) {
        super((JFrame)ChaineEdit, "Modification Arbre", true);
        MyTree = Mtree;
        activeType = type;
        String Root = MyTree.nameRoot();
        CE = ChaineEdit;
        
        /* Schma du doc. coursvirtuels */
        // (un pere => les fils possibles)*
        String[][][] pereFils = { { {""} , {"null"} } ,
                                  { {Root} , {"CHAPITRE","TP"} } ,
                                  { {"CHAPITRE"} , {"AUTEUR","DATE","INTRODUCTION","SOUSCHAPITRE"} } ,
                                  { {"INTRODUCTION"} , {"texte"} } ,
                                  { {"SOUSCHAPITRE"} , {"AUTEUR","DATE","SECTION"} } ,
                                  { {"SECTION"} , {""} } ,
                                  { {"TP"} , {"INTRODUCTION"} } ,
                                  { {"AUTEUR"} , {"texte"} } ,
                                  { {"DATE"} , {"texte"} }
                                };
         // (la balise => les attributs)*  /  attributs en majuscule = obligatoires
         String[][][] attribBalise = { { {""} , {""} } ,
                                       { {Root} , {} } ,
                                       { {"INTRODUCTION"} , {} } ,
                                       { {"CHAPITRE"} , {"contrib","LABEL","liencontenu","TITRE"} } ,
                                       { {"SOUSCHAPITRE"} , {"contrib","LABEL","liencontenu","TITRE"} } ,
                                       { {"TP"} , {"contrib","LABEL","liencontenu","TITRE"} } ,
                                       { {"AUTEUR"} , {} } ,
                                       { {"DATE"} , {} } ,
                                       { {"texte"} , {"texte"} } ,
                                       { {"SECTION"} , {"CONTRIB","LABEL","LIENCONTENU","TITRE"} }
                                    };
        
        pere_fils = pereFils;
        attrib_balise = attribBalise;
        
        this.addKeyListener( new KeyAdapter() { 
            public void keyPressed(KeyEvent kEvt) { 
                if (kEvt.getKeyCode() == KeyEvent.VK_ESCAPE) {
                    fermeture();            
                } 
            } 
        });
        
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                fermeture();
            }
            public void windowActivated(WindowEvent e) {             
                requestFocus(); 
            }
        });

        if ((MyTree.nameElement(MyTree.nameSelectNode()).equals(Root))&&(activeType.equals("frere"))) {
            JOptionPane.showMessageDialog(this,"Impossible d'ajouter un lement frre  la racine !!","Info.", JOptionPane.INFORMATION_MESSAGE);
            fermeture();
        }
        else if ((!MyTree.isElement())&&(activeType.equals("fils"))) {
            JOptionPane.showMessageDialog(this,"Impossible d'ajouter un lement fils  du texte !!","Info.", JOptionPane.INFORMATION_MESSAGE);
            fermeture();
        }
        else {
            pane = new JPanel();
            dlgpane = new JPanel();
            if (activeType.equals("modifier")) {
                dlgpane.add(modifyComponent());
            }
            else {
                dlgpane.add(AddComponent());
            }    
            pane.add(dlgpane);
            setContentPane(pane);
            pack();
            Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
            setLocation((screen.width - getSize().width)/2,(screen.height - getSize().height)/2);
            setResizable(false);
            setVisible(true);
        }
    }

    
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        fermeture();            
    }
    
    
    public void valider(String[] valAtt){
        boolean appliquer = true;
        for (int i=0;i<nbAtt;i++)
            if (listAttributs(noeudActif)[i].equals(listAttributs(noeudActif)[i].toUpperCase())){
                if (champs[i] instanceof JTextArea) {
                    if ("".equals(((JTextArea)champs[i]).getText())) appliquer = false;
                }
                else if (champs[i] instanceof JTextField) {
                    if ("".equals(((JTextField)champs[i]).getText())) appliquer = false;
                }
            }
        if (appliquer) appliquer();
    }


    public void itemStateChanged(ItemEvent e) {
        Object source = e.getSource();
        if ((source == valNoeud)&&(e.getStateChange()==1)) {
            selectNoeud = valNoeud.getSelectedIndex();
            noeudActif = (String)valNoeud.getSelectedItem();
            dlgpane.removeAll();
            dlgpane.add(AddComponent());
            pane.updateUI();
            pack();
        }
    }


    public void fermeture() {
        noeudActif = "";
        selectNoeud = 0;
        actif = true;
        CE.enableButtons(true);
        dispose();     
    }
        
    
    public void appliquer() {
        StringBuffer valueNode = new StringBuffer("");
        if (!(noeudActif).equals("texte")) valueNode.append("<" + noeudActif);
        if (!actif) valueNode.append(" activer=\"faux\"");
        for(int i=0;i<nbAtt;i++) {
            String valAtt = new String("");
            if (champs[i] instanceof JTextField) {
                String val = new String (((JTextField)champs[i]).getText());
                val = replace(val,"\"","",true);
                if (!val.equals("")) valueNode.append(" " + listAttributs(noeudActif)[i].toLowerCase() + "=\"" + val + "\"");
            } else if (champs[i] instanceof JTextArea) {
                valueNode.append(formTxt(((JTextArea)champs[i]).getText()));
            }    
        }
        if ((!(noeudActif).equals("texte")) && (valueNode.charAt(valueNode.length()-1)!='>')) valueNode.append(">");
        if (activeType.equals("fils")) MyTree.ajouterFils(valueNode.toString());
        else if (activeType.equals("frere")) MyTree.ajouterFrere(valueNode.toString());
             else if (activeType.equals("modifier")) MyTree.modifierNoeud(valueNode.toString());
        fermeture();         
    }
    
    
    public JPanel modifyComponent(){
        JPanel attrCompo = new JPanel();
        JPanel enonce = new JPanel();        
        JPanel chxAttr = new JPanel();
        JPanel chxType = new JPanel();
        JPanel validation = new JPanel();
        setTitle("Editer un noeud");
        attrCompo.setLayout(new BoxLayout(attrCompo, BoxLayout.Y_AXIS));
        if (existBalises() || (!MyTree.isElement())) {
            JLabel text = new JLabel("Modifier le noeud slectionn :");
            if (MyTree.isElement()) noeudActif = MyTree.nameElement(MyTree.nameSelectNode());
            else noeudActif = "texte";
            JLabel valElt = new JLabel(noeudActif);
            valElt.setForeground(new Color(184,96,96));
            enonce.add(text);
            enonce.add(valElt);
            nbAtt = listAttributs(noeudActif).length;
            champs = new JComponent[nbAtt];
            StringBuffer buf1 = new StringBuffer(MyTree.nameSelectNode());
            if (MyTree.isElement()) {
                buf1.delete(0,noeudActif.length()+1);
                buf1.deleteCharAt(buf1.length()-1);
                if (subIndice(buf1,"activer=\"faux\"")!=-1) actif = false;
            }
            final String[] valAtt = new String[nbAtt];
            for (int i=0;i<nbAtt;i++){
                 if ((listAttributs(noeudActif)[i]).equals("texte")) {
                     valAtt[i] = MyTree.nameSelectNode();
                 } 
                 else {
                     Character guill = new Character('"');
                     int loc1 = subIndice(buf1,listAttributs(noeudActif)[i].toLowerCase()+"=\"");
                     int loc2 = subIndice(buf1,guill.toString(),loc1+listAttributs(noeudActif)[i].length()+2);
                     if ((loc1!=-1)&&(loc2!=-1)) valAtt[i] = buf1.substring(loc1+listAttributs(noeudActif)[i].length()+2,loc2);
                     else valAtt[i] = "";
                 }
            }
            chxAttr.setLayout(new GridBagLayout());
            chxAttr.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1,Color.white,new Color(70,70,70))," Attributs ",1,2));
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = GridBagConstraints.EAST;
            for (int i=0;i<nbAtt;i++){
                JLabel libelAtt = new JLabel((listAttributs(noeudActif)[i] + " : ").toLowerCase());
                if (listAttributs(noeudActif)[i].equals(listAttributs(noeudActif)[i].toUpperCase())) libelAtt.setForeground(Color.red);
                c.gridx = 0;
                c.gridy = i;
                chxAttr.add(libelAtt,c);
                if ((listAttributs(noeudActif)[i]).equals("texte")) {
                    champs[i] = new JTextArea(valAtt[i],5,30);
                    JScrollPane scrolledit = new JScrollPane(champs[i]);
                    scrolledit.setPreferredSize(new Dimension(300,100));
                    c.gridx = 1;
                    c.gridy = i;
                    chxAttr.add(scrolledit,c);
                } else {
                     champs[i] = new JTextField(valAtt[i], 35);
                     c.gridx = 1;
                     c.gridy = i;
                     c.ipady = 6;
                     chxAttr.add(champs[i],c);
                     if (listAttributs(noeudActif)[i].toLowerCase().equals("liencontenu")) {
                    	index = i;
                    	JButton bChoix = new JButton("Slection");
                    	bChoix.addActionListener(new ActionListener() { public void actionPerformed(ActionEvent e) {
                           	selectLienContrib();
                        }});
                    	c.gridx = 2;
		                c.gridy = i;
	                    c.ipady = 0;
		                chxAttr.add(bChoix,c);
                    }
                }
                champs[i].addKeyListener(new KeyAdapter() { public void keyPressed(KeyEvent evt) {
                    if (evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
                        fermeture();
                    }
                }});
            }
            if (nbAtt==0){
                JLabel libelAtt = new JLabel("-- Pas d'attributs  modifier pour ce type d'lement --");
                libelAtt.setOpaque(true);
                libelAtt.setForeground(Color.gray);
                chxAttr.add(libelAtt); 
            } else {
                validation.setLayout(new BoxLayout(validation, BoxLayout.X_AXIS));
                JButton bajouter = new JButton("OK");
                bajouter.addActionListener( new ActionListener() { public void actionPerformed(ActionEvent e) {
                    valider(valAtt);
                }});
                getRootPane().setDefaultButton(bajouter);
                validation.add(bajouter);
                validation.add(Box.createHorizontalStrut(5));
            }
        } 
        else {
            JLabel libelType = new JLabel("-- Cette balise n'est pas repertorie --");
            libelType.setOpaque(true);
            libelType.setForeground(Color.red);
            enonce.add(libelType);
        }             
        JButton bannuler = new JButton("ANNULER");
        bannuler.addActionListener(this);
        bannuler.setActionCommand("Annuler");
        validation.add(bannuler);
        attrCompo.add(enonce);
        attrCompo.add(Box.createVerticalStrut(3));
        attrCompo.add(chxAttr);
        attrCompo.add(Box.createVerticalStrut(10));
        attrCompo.add(validation);
        return attrCompo;
    }
    
    
    public JPanel AddComponent(){
        JPanel attrCompo = new JPanel();
        JPanel chxType = new JPanel();
        JPanel chxAttr = new JPanel();
        JPanel validation = new JPanel();
        setTitle("Ajouter un noeud");
        attrCompo.setLayout(new BoxLayout(attrCompo, BoxLayout.Y_AXIS));
        chxType.setLayout(new BoxLayout(chxType, BoxLayout.X_AXIS));
        valNoeud = new JComboBox(listBalises());
        if ((noeudActif.equals("")) && (!valNoeud.getItemAt(0).equals(""))) noeudActif = (String)valNoeud.getItemAt(0);
        if ((existBalises() && !noeudActif.equals("")) || (!MyTree.isElement() && !noeudActif.equals("null"))) { 
            JLabel chxLab = new JLabel("Choisissez le type de l'lement " +activeType+ "  insrer : ");
            valNoeud.setSelectedIndex(selectNoeud);                 
            valNoeud.addItemListener(this);
            chxType.add(chxLab);
            chxType.add(valNoeud);
            chxAttr.setLayout(new GridBagLayout());
            chxAttr.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1,Color.white,new Color(70,70,70))," Attributs ",1,2));
            GridBagConstraints c = new GridBagConstraints();
            c.anchor = GridBagConstraints.EAST;
            nbAtt = listAttributs(noeudActif).length;
            champs = new JComponent[nbAtt];
            if (nbAtt==0){
                JLabel libelAtt1 = new JLabel("-- Pas d'attributs pour ce type d'lement --");
                libelAtt1.setOpaque(true);
                libelAtt1.setForeground(Color.gray);
                c.gridy = 0;
                chxAttr.add(libelAtt1,c);
                c.gridy = 1;
                chxAttr.add(Box.createVerticalStrut(8),c); 
            }
            for (int i=0;i<nbAtt;i++){
                JLabel libelAtt = new JLabel((listAttributs(noeudActif)[i] + " : ").toLowerCase());
                if (listAttributs(noeudActif)[i].equals(listAttributs(noeudActif)[i].toUpperCase())) libelAtt.setForeground(Color.red);
                c.gridx = 0;
                c.gridy = i;
                chxAttr.add(libelAtt,c);
                if ((listAttributs(noeudActif)[i]).equals("texte")) {
                    champs[i] = new JTextArea(4,30);
                    JScrollPane scrolledit = new JScrollPane(champs[i]);
                    scrolledit.setPreferredSize(new Dimension(300,70));
                    c.gridx = 1;
                    c.gridy = i;
                    chxAttr.add(scrolledit,c);
                } else {
                    champs[i] = new JTextField("", 35);
                    c.gridx = 1;
                    c.gridy = i;
                    c.ipady = 6;
                    chxAttr.add(champs[i],c);
                    if (listAttributs(noeudActif)[i].toLowerCase().equals("liencontenu")) {
                        index = i;
                    	JButton bChoix = new JButton("Slection");
                    	bChoix.addActionListener(new ActionListener() { public void actionPerformed(ActionEvent e) {
                            selectLienContrib();    
                        }});
                   	    c.gridx = 2;
		                c.gridy = i;
	                    c.ipady = 0;
		                chxAttr.add(bChoix,c);
                    }
                }
                champs[i].addKeyListener(new KeyAdapter() { public void keyPressed(KeyEvent evt) {
                    if (evt.getKeyCode() == KeyEvent.VK_ESCAPE) {
                        fermeture();
                    }
                }});
            }
            validation.setLayout(new BoxLayout(validation, BoxLayout.X_AXIS));
            JButton bajouter = new JButton("OK");
            bajouter.addActionListener( new ActionListener() { public void actionPerformed(ActionEvent e) {
                valider(listAttributs(noeudActif));
            }});
            getRootPane().setDefaultButton(bajouter);
            validation.add(bajouter);
            validation.add(Box.createHorizontalStrut(5));
        } else {
            JPanel noWay = new JPanel();
            noWay.setLayout(new BoxLayout(noWay, BoxLayout.Y_AXIS));
        	JLabel libelType = new JLabel();
            if (noeudActif.equals("")) libelType.setText("-- Aucun ajout possible  ce niveau pour cette balise --");
            else libelType.setText("-- La balise de rference n'est pas repertorie --");
            libelType.setOpaque(true);
            libelType.setForeground(Color.red);
            noWay.add(Box.createVerticalStrut(15));
            noWay.add(libelType);
            chxType.add(noWay);            
        } 
           JButton bannuler = new JButton("ANNULER");
           bannuler.addActionListener(this);
           bannuler.setActionCommand("Annuler");
           validation.add(bannuler);
           attrCompo.add(chxType);
           attrCompo.add(Box.createVerticalStrut(7));
           attrCompo.add(chxAttr);
           attrCompo.add(Box.createVerticalStrut(10));
           attrCompo.add(validation);
       return attrCompo;
    }
    
    
    public String[] listAttributs(String balise) {
        int i=0, j=0;
        for (i=0;i<=((attrib_balise.length)-1);i++){
            if ((balise).equals(attrib_balise[i][0][0])) {
                j=i;
            } 
        }
        return attrib_balise[j][1];
    }
   
    
    public String[] listBalises() {
        int i=0, j=0;
        String recherche = new String(); 
        if (activeType.equals("frere")) recherche = MyTree.nameElement(MyTree.ParentNameNode());
        else recherche = MyTree.nameElement(MyTree.nameSelectNode());
        for (i=0;i<=((pere_fils.length)-1);i++){
            if (recherche.equals(pere_fils[i][0][0])) {
                j=i;
            } 
        }
        return pere_fils[j][1];
    } 
    
    
    public boolean existBalises() {
        int i=0, j=0;
        String recherche = new String(MyTree.nameElement(MyTree.nameSelectNode())); 
        for (i=0;i<=((pere_fils.length)-1);i++){
            if (recherche.equals(pere_fils[i][0][0])) {
                j=i;
            } 
        }
        if (j==0) return false;
        else return true;
    }
    
    
    public StringBuffer formTxt(String txt) {
        StringBuffer val = new StringBuffer(txt);
        int i=0;
        while (val.charAt(0)=='<') {
            val.deleteCharAt(0);
            if (val.length()==0) break;
        }
        while (val.charAt(val.length()-1)=='>') {
            val.deleteCharAt(val.length()-1);
            if (val.length()==0) break;
        }
        return val;
    }  
    
    
    public int subIndice(StringBuffer chaine, String ssChaine) {
        return subIndice(chaine,ssChaine,0);
    }


    public int subIndice(StringBuffer chaine, String ssChaine, int begin) {
        int indice = -1;
        if (chaine.length() >= ssChaine.length()){
            for (int i=(0+begin);i<=(chaine.length()-ssChaine.length());i++){
                if (((chaine.toString().substring(i,i+ssChaine.length())).equals(ssChaine)) && (indice==-1)) {
                    indice = i ;
                } 
            }
        }  
        return indice;      
    }
    

    public static String replace(String orig, String strReplace, String strWith, boolean all) {
        if (orig == null || strReplace == null || strReplace.length() == 0 || strWith == null)
            throw new IllegalArgumentException("pas d'arguments.");
        StringBuffer buffOrig = new StringBuffer(orig);
        int i = 0;
        while (i + strReplace.length() <= buffOrig.length()) {
            if (buffOrig.substring(i, i + strReplace.length()).equals(strReplace)) {
                buffOrig.replace(i, i + strReplace.length(), strWith);
                if (!all)
                    break;
                else
                    i += strWith.length();
                }
            else
                i++;
        }
        return buffOrig.toString();
    }
    
    
    public void selectLienContrib() {
    	String contribXML = "contribXML";
     	File repContrib = new File(CE.cheminSite + slash + contribXML);
    	FileDialog fd = new FileDialog(CE, "Slection du document XML");
    	FilenameFilter filter = new FilenameFilter() {
            public boolean accept(File dir, String name) {
            	if (name.endsWith(".xml") || dir.isDirectory()) return true;
            	else return false;
        }};
        fd.setFilenameFilter(filter);
    	if (repContrib.exists())
    		fd.setDirectory(repContrib.toString());
		fd.show();
		if (fd.getFile() != null) {
    		File fChoix = new File(fd.getDirectory() + fd.getFile());  
    		if (fChoix.getAbsolutePath().startsWith(repContrib.getAbsolutePath())) {
    			String linkContrib = (contribXML + fChoix.toString().substring(repContrib.getAbsolutePath().length())).replace('\\','/');
    			((JTextField)champs[index]).setText(linkContrib);
    			String valContrib = new String(linkContrib);
    			if (linkContrib.startsWith(contribXML)) 
    				valContrib = valContrib.substring(contribXML.length()+1);
    			if (valContrib.endsWith(fd.getFile())) 
    				valContrib=valContrib.substring(0,(valContrib.length()-fd.getFile().length()));
    			if (valContrib.endsWith("/")) 
    				valContrib=valContrib.substring(0,(valContrib.length()-1));
    			if (valContrib.startsWith("/")) 
    				valContrib=valContrib.substring(1,(valContrib.length()));
    			if (valContrib != null) {
    	   		    for (int j=0;j<nbAtt;j++){
    				    if (listAttributs(noeudActif)[j].toLowerCase().equals("contrib")) {
    					    ((JTextField)champs[j]).setText(valContrib);
    			        }
       	        	}
    			}
    		}
    		else {
    			JOptionPane.showMessageDialog(CE,"Erreur : les contributions XML doivent tre sous le rpertoire \"contribXML\" du projet en cours !\n");
    		}
		}
    }
    
}
