/*
 * The Apache Software License, Version 1.1
 *
 *
 * Copyright (c) 1999 The Apache Software Foundation.  All rights 
 * reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 *
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer. 
 *
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in
 *    the documentation and/or other materials provided with the
 *    distribution.
 *
 * 3. The end-user documentation included with the redistribution,
 *    if any, must include the following acknowledgment:  
 *       "This product includes software developed by the
 *        Apache Software Foundation (http://www.apache.org/)."
 *    Alternately, this acknowledgment may appear in the software itself,
 *    if and wherever such third-party acknowledgments normally appear.
 *
 * 4. The names "Xerces" and "Apache Software Foundation" must
 *    not be used to endorse or promote products derived from this
 *    software without prior written permission. For written 
 *    permission, please contact apache@apache.org.
 *
 * 5. Products derived from this software may not be called "Apache",
 *    nor may "Apache" appear in their name, without prior written
 *    permission of the Apache Software Foundation.
 *
 * THIS SOFTWARE IS PROVIDED ``AS IS'' AND ANY EXPRESSED OR IMPLIED
 * WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES
 * OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED.  IN NO EVENT SHALL THE APACHE SOFTWARE FOUNDATION OR
 * ITS CONTRIBUTORS BE LIABLE FOR ANY DIRECT, INDIRECT, INCIDENTAL,
 * SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT
 * LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES; LOSS OF
 * USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY,
 * OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT
 * OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 * ====================================================================
 *
 * This software consists of voluntary contributions made by many
 * individuals on behalf of the Apache Software Foundation and was
 * originally based on software copyright (c) 1999, International
 * Business Machines, Inc., http://www.apache.org.  For more
 * information on the Apache Software Foundation, please see
 * <http://www.apache.org/>.
 */
 
package moulinette ;

import javax.swing.JTree;
import javax.swing.event.* ;
import javax.swing.tree.*;
import java.util.*;
import java.io.*;
import org.w3c.dom.*;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import java.awt.*;


/**
 * Displays a DOM document in a tree control.
 *
 * @author  Andy Clark, IBM
 * @version
 */
public class DOMTree extends JTree {
    
    static TreeNode activeNode = null;
    static Object activeNodes = null;
    static TreePath activePath = null;
    static TreeNode activeParentNode = null;
    
    //
    // Constructors
    //

    /** Default constructor. */
    public DOMTree() {
        this(null);
    }

    /** Constructs a tree with the specified document. */
    public DOMTree(Document document) {
        super(new Model());
        
        setInvokesStopCellEditing(true);
        
        this.addTreeSelectionListener(
            new TreeSelectionListener() {
                public void valueChanged(TreeSelectionEvent e) {
                    activePath = e.getPath();
                    activeNode = (TreeNode)(e.getPath().getLastPathComponent());
                    activeParentNode = (TreeNode)(e.getPath().getParentPath().getLastPathComponent());
                }
            }
        );

        this.setCellRenderer(new DefaultTreeCellRenderer()
        {
             public Component getTreeCellRendererComponent(JTree pTree,
                 Object pValue, boolean pIsSelected, boolean pIsExpanded,
                 boolean pIsLeaf, int pRow, boolean pHasFocus)
             {
                DefaultMutableTreeNode node = (DefaultMutableTreeNode)pValue;
                //setFont(new Font("sansSerif", Font.BOLD, 12));
                super.getTreeCellRendererComponent(pTree, pValue, pIsSelected,
                     pIsExpanded, pIsLeaf, pRow, pHasFocus);
                if ((pValue.toString()!=null) && (pValue.toString().length()>0)) { 
                    if ((isElement(pValue.toString())) && (pValue.toString().indexOf("activer=\"faux\"")!=-1)) 
                        setForeground(new Color(155,155,155));
                    else if (!isElement(pValue.toString())) 
                        setForeground(new Color(175,138,113));
                    if (haveDesacParent(node)) setForeground(new Color(155,155,155));   
                    if (!isElement(pValue.toString())) setBackgroundSelectionColor(new Color(215,243,220));
                    else setBackgroundSelectionColor(new Color(215,227,243));
                }
                return (this);
            }
        });

        // set tree properties
        setRootVisible(false);

        // set properties
        setDocument(document);

    } // <init>()

    //
    // Public methods
    //

    public boolean isSelectNode(){
        if (activeNode != null) return true;
        else return false;
    }
    
    public String nameSelectNode(){
        return activeNode.toString();
    }
    
    public String ParentNameNode(){
        return activeParentNode.toString();
    }
    
    public String nameRoot(){
        return nameElement(((Model)getModel()).nameRoot());
    }
    
    public void supprimerNoeud(){
        ((Model)getModel()).supprimerNoeud(activeNode);
        activeNode = null;
    }
    
    public void ajouterFils(String value){
        ((Model)getModel()).ajouterFils(activeNode,value);
        expandPath(activePath);
    }
    
    public void ajouterFrere(String value){
        ((Model)getModel()).ajouterFrere(activeNode,value);
    }
    
    public void modifierNoeud(String value){
        ((Model)getModel()).modifierNoeud(activeNode,value);
    }
    
    public boolean haveDesacParent(DefaultMutableTreeNode node){
        boolean desact = false;
        TreeNode nodeTempo = node.getParent();
        for (int i=0;i<node.getLevel();i++){
            if (nodeTempo.toString()!=null)
              if (nodeTempo.toString().indexOf("activer=\"faux\"")!=-1) 
                desact = true;
            nodeTempo = nodeTempo.getParent();
        }
        return desact;     
    }
    
    public boolean isElement(String val){
            StringBuffer buf1 = new StringBuffer();
            buf1.append(val.toString());
            if ((buf1.charAt(0)=='<')&&(buf1.charAt(buf1.length()-1)=='>')) return true;
            else return false;
    }
    
    public boolean isElement(){
        StringBuffer buf1 = new StringBuffer();
        buf1.append(activeNode.toString());
        if ((buf1.charAt(0)=='<')&&(buf1.charAt(buf1.length()-1)=='>')) return true;
        else return false;
    }
    
    public String nameElement(String valElement){
        StringBuffer buf1 = new StringBuffer();
        buf1.append(valElement);
        if (buf1.charAt(0)=='<') buf1.deleteCharAt(0);
        if (buf1.charAt(buf1.length()-1)=='>') buf1.deleteCharAt(buf1.length()-1); 
        String val = buf1.toString();
        StringTokenizer st = new StringTokenizer(val," ");
        return st.nextToken();
    }

    /** Sets the document. */
    public void setDocument(Document document) {
        ((Model)getModel()).setDocument(document);
        expandRow(0);
    }
    
    /** Returns the document. */
    public Document getDocument() {
        return ((Model)getModel()).getDocument();
    }

    /** get the org.w3c.Node for a MutableTreeNode. */
    public Node getNode(Object treeNode) {
        return ((Model)getModel()).getNode(treeNode);
    }
    
    /** get the MutableTreeNode for a org.w3c.Node. */
     public DefaultMutableTreeNode getMutNode(Node node) {
        return ((Model)getModel()).getMutNode(node);
    }

    //
    // Classes
    //

    /**
     * DOM tree model.
     *
     * @author  Andy Clark, IBM
     * @version
     */
    static class Model extends DefaultTreeModel implements Serializable {

        //
        // Data
        //

        /** Document. */
        private Document document;
        Document docu;

        /** Node Map. */
        private Hashtable nodeMap = new Hashtable();
        private Hashtable nodeMapInv = new Hashtable();

        //
        // Constructors
        //

        /** Default constructor. */
        public Model() {
            this(null);
        }

        /** Constructs a model from the specified document. */
        public Model(Document document) {
            super(new DefaultMutableTreeNode());
            setDocument(document);
        }

        //
        // Public methods
        //
        
        /** Returns the document. */
        public Document getDocument() {
             return domGenerate();
        }
        
        /** Sets the document. */
        public synchronized void setDocument(Document document) {

            // save document
            this.document = document;

            // clear tree and re-populate
            ((DefaultMutableTreeNode)getRoot()).removeAllChildren();
            nodeMap.clear();
            nodeMapInv.clear();
            buildTree();
            fireTreeStructureChanged(this, new Object[] {getRoot()}, new int[0], new Object[0]);

        } // setDocument(Document)
        
        /** get the org.w3c.Node for a MutableTreeNode. */
        public Node getNode(Object treeNode) {
            return (Node)nodeMap.get(treeNode);
        }
        
        /** get the MutableTreeNode for a org.w3c.Node. */
        public DefaultMutableTreeNode getMutNode(Node node) {
            return (DefaultMutableTreeNode)nodeMapInv.get(node);
        }
        
        public String nameRoot(){
             return (String)((DefaultMutableTreeNode)getRoot()).getFirstChild().toString();
        }
        
        public Document domGenerate() {
           try {
               DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
               docu = factory.newDocumentBuilder().newDocument();
           }
           catch (ParserConfigurationException ex) {
               System.err.println(ex);
           }
           TreeNode m_root= (TreeNode)((DefaultMutableTreeNode)getRoot()).getFirstChild();
           StringBuffer buf1 = new StringBuffer();
           buf1.append(m_root.toString());
           if ((buf1.charAt(0)=='<')&&(buf1.charAt(buf1.length()-1)=='>')) {
               buf1.deleteCharAt(0);
               buf1.deleteCharAt(buf1.length()-1);
           }    
           buf1 = formate(buf1);
           String val_root = buf1.toString();
           StringTokenizer st = new StringTokenizer(val_root," ");
           Element root = docu.createElement(st.nextToken()); 
           while (st.hasMoreTokens()){
               StringTokenizer st2 = new StringTokenizer(st.nextToken(),"=");
               String name_attr = st2.nextToken();
               String val_attr = strReplace(st2.nextToken(),"&nbsp;"," ");
               root.setAttribute(name_attr,strReplace(val_attr,"\"",""));
           }
           docu.appendChild(root);
           insertFils(docu,m_root,root);
           return docu;       
        }

        public void insertFils(Document docu,TreeNode t1,Element t2){
            int nb_fils=0;
            while (nb_fils<getChildCount((Object)t1))
            {
                TreeNode fils = t1.getChildAt(nb_fils);
                StringBuffer buf1 = new StringBuffer();
                buf1.append(fils.toString());
                if (((buf1.charAt(0)=='<')&&(buf1.charAt(buf1.length()-1)=='>'))||(fils.getChildCount()>0)) {
                    if (buf1.charAt(0)=='<') buf1.deleteCharAt(0);
                    if (buf1.charAt(buf1.length()-1)=='>') buf1.deleteCharAt(buf1.length()-1);                    
                    buf1 = formate(buf1);
                    String val_fils = buf1.toString();
                    StringTokenizer st = new StringTokenizer(val_fils," ");
                    Element elt_fils = docu.createElement(st.nextToken());
                    while (st.hasMoreTokens()) {
                        StringTokenizer st2 = new StringTokenizer(st.nextToken(),"=");
                        String name_attr = st2.nextToken();
                        String val_attr = strReplace(st2.nextToken(),"&nbsp;"," ");
                        elt_fils.setAttribute(name_attr,strReplace(val_attr,"\"",""));
                    }
                    t2.appendChild(elt_fils);
                    insertFils(docu,fils,elt_fils);
                }
                else {
                    Text txtLeaf  = docu.createTextNode(buf1.toString());
                    t2.appendChild(txtLeaf);     
                }
                nb_fils++;
            }
            return;
        }
        
        public void supprimerNoeud(TreeNode activeNode){
            removeNodeFromParent((MutableTreeNode)activeNode);
        }
        
        public void ajouterFils(TreeNode activeNode, String value){
            DefaultMutableTreeNode child = new DefaultMutableTreeNode(value);
            insertNodeInto(child,(MutableTreeNode)activeNode,0);
        }
        
        public void ajouterFrere(TreeNode activeNode, String value){
            DefaultMutableTreeNode brother = new DefaultMutableTreeNode(value);
            insertNodeInto(brother,(MutableTreeNode)activeNode.getParent(),getIndexOfChild(activeNode.getParent(),activeNode)+1);
        }
        
        public void modifierNoeud(TreeNode activeNode, String value){
            DefaultMutableTreeNode newValue = new DefaultMutableTreeNode(value);
            int nb_fils = activeNode.getChildCount();
            for (int i=0;i<nb_fils;i++) {
                newValue.add((MutableTreeNode)activeNode.getChildAt(0));
            }
            insertNodeInto(newValue,(MutableTreeNode)activeNode.getParent(),getIndexOfChild(activeNode.getParent(),activeNode));
            removeNodeFromParent((MutableTreeNode)activeNode);
        }
        
        
        //
        // Private methods
        //

        public int subIndice(StringBuffer chaine, String ssChaine) {
            return subIndice(chaine,ssChaine,0);
        }

        public int subIndice(StringBuffer chaine, String ssChaine, int begin) {
            int indice = -1;
            if (chaine.length() >= ssChaine.length()){
                for (int i=(0+begin);i<=(chaine.length()-ssChaine.length());i++){
                    if (((chaine.toString().substring(i,i+ssChaine.length())).equals(ssChaine)) && (indice==-1)) {
                        indice = i ;
                    } 
                }
            }  
            return indice;      
        }
        
        private String strReplace(String str, String oldSub, String newSub){
             final StringBuffer result = new StringBuffer();
             final StringBuffer strBuff = new StringBuffer(str);
             int startIdx = 0;
             int idxOld = 0;
             while ((idxOld = subIndice(strBuff , oldSub , startIdx)) >= 0) {
               result.append( str.substring(startIdx, idxOld) );
               result.append( newSub );
               startIdx = idxOld + oldSub.length();
             }
             result.append( str.substring(startIdx) );
             return result.toString();
          }

        private StringBuffer formate(StringBuffer str) {
            for (int i=0;i<str.length()-2;i++) {
                if (str.substring(i,i+2).equals("=\"")) {
                    str.replace(i,subIndice(str,"\"",i+2),strReplace(str.substring(i,subIndice(str,"\"",i+2))," ","&nbsp;")); 
                    i=subIndice(str,"\"",i+2); 
                }
            }
            return str;
        }

        /** Builds the tree. */
        private void buildTree() {
            
            // is there anything to do?
            if (document == null) { return; }

            // iterate over children of this node
            NodeList nodes = document.getChildNodes();
            int len = (nodes != null) ? nodes.getLength() : 0;
            MutableTreeNode root = (MutableTreeNode)getRoot();
            for (int i = 0; i < len; i++) {
                Node node = nodes.item(i);
                switch (node.getNodeType()) {
                    case Node.DOCUMENT_NODE: {
                        root = setDocumentNode(node);
                        break;
                    }

                    case Node.ELEMENT_NODE: {
                        insertElementNode(node, root);
                        break;
                    }

                    default: // ignore

                } // switch

            } // for 

        } // buildTree()

        /** Inserts a node and returns a reference to the new node. */
        private MutableTreeNode insertNode(String what, MutableTreeNode where) {
            MutableTreeNode node = new DefaultMutableTreeNode(what);
            insertNodeInto(node, where, where.getChildCount());
            return node;
        } // insertNode(Node,MutableTreeNode):MutableTreeNode
            
        /** Inserts the document node. */
        private MutableTreeNode setDocumentNode(Node what) {
            MutableTreeNode treeNode = new DefaultMutableTreeNode("<"+what.getNodeName()+'>');
            setRoot(treeNode) ;
            //MutableTreeNode treeNode = setRoot("<"+what.getNodeName()+'>');
            nodeMap.put(treeNode, what);
            nodeMapInv.put(what,treeNode);
            return treeNode;
        }

        /** Inserts an element node. */
        private MutableTreeNode insertElementNode(Node what, MutableTreeNode where) {
            // build up name
            StringBuffer name = new StringBuffer();
            name.append('<');
            String nomNoeud = what.getNodeName() ;
            if (nomNoeud.equals("html")) {
                name.append(' ');
            }
            name.append(nomNoeud);
            NamedNodeMap attrs = what.getAttributes();
            int attrCount = (attrs != null) ? attrs.getLength() : 0;
            for (int i = 0; i < attrCount; i++) {
                Node attr = attrs.item(i);
                name.append(' ');
                name.append(attr.getNodeName());
                name.append("=\"");
                name.append(attr.getNodeValue());
                name.append('"');
            }
            name.append('>');

            // insert element node
            
            MutableTreeNode element = insertNode(name.toString(), where);
            nodeMap.put(element, what);
            nodeMapInv.put(what,element);
            
            // gather up attributes and children nodes
            NodeList children = what.getChildNodes();
            int len = (children != null) ? children.getLength() : 0;
            for (int i = 0; i < len; i++) {
                Node node = children.item(i);
                switch (node.getNodeType()) {
                    case Node.CDATA_SECTION_NODE: { 
                       insertCDataSectionNode(node, element ); //Add a Section Node
                       break;
                      }
                    case Node.TEXT_NODE: {
                        insertTextNode(node, element);
                        break;
                    }
                    case Node.ELEMENT_NODE: {
                        insertElementNode(node, element);
                        break;
                    }
                }
            }
            return element;
        } // insertElementNode(Node,MutableTreeNode):MutableTreeNode

        /** Inserts a text node. */
        private MutableTreeNode insertTextNode(Node what, MutableTreeNode where) {
            String value = what.getNodeValue().trim();
            if (value.length() > 0) {
                MutableTreeNode treeNode = insertNode(what.getNodeValue(), where);
                nodeMap.put(treeNode, what);
                nodeMapInv.put(what,treeNode);           
                return treeNode;
                }
            return null;
       }

        
      /** Inserts a CData Section Node. */
      private MutableTreeNode insertCDataSectionNode(Node what, MutableTreeNode where) {
         StringBuffer CSectionBfr = new StringBuffer();         
         //--- optional --- CSectionBfr.append( "<![CDATA[" );
         CSectionBfr.append( what.getNodeValue() );
         //--- optional --- CSectionBfr.append( "]]>" );
         if (CSectionBfr.length() > 0) {
            MutableTreeNode treeNode = insertNode(CSectionBfr.toString(), where);
            nodeMap.put(treeNode, what); 
            nodeMapInv.put(what,treeNode);           
            return treeNode;
        }
         return null;
        }
    } // class Model
} // class DOMTree
