package moulinette;

import java.io.*;
import java.util.Vector;

import xml.*;

/**
 * Copie des fichiers des contributions (images, tables xml, animations, annexes, ...) depuis le dossier
 * contribXML vers le dossier images du site web.
 * compilation: javac -d classes -encoding ISO-8859-1 CopieContribs.java
 */
 
public class CopieContribs {
	String cheminSite;
	static final String cheminContrib = "contribXML";
	static final String cheminCoursVirtuel = "coursvirtuel.xml";
	static final String slash = File.separator;
	File[] contribs;
	File[] fichiersXML;

	public static void main(String[] args) {
		if (args.length != 1) {
			System.err.println("usage: java CopieContribs cheminSite");
			System.exit(1);
		}
		CopieContribs moi = new CopieContribs();
		moi.copie(args[0]);
		System.exit(0);
	}
	
	public void copie(String cheminSite) {
		this.cheminSite = cheminSite;
		getContribs();
		File dossierImages = new File(cheminSite + slash + "site" + slash + "images");
        dossierImages.mkdir();
		for (int i=0; i<contribs.length; i++) {
			File nouveauDossier = new File(dossierImages, contribs[i].getName());
			if (nouveauDossier.exists()) 
                 System.out.println("dossier effac et remplac : " + nouveauDossier.getPath());
            else System.out.println("dossier trait : " + nouveauDossier.getPath());    
			try {
				if (nouveauDossier.exists())
					effacerDossier(nouveauDossier);
				copierDossier(contribs[i], nouveauDossier);
			} catch (IOException ex) {
				erreur(ex);
			}
		}
		for (int i=0; i<fichiersXML.length; i++) {
			String dossier = fichiersXML[i].getParentFile().getName();
			File nouveauFichier = new File(dossierImages + slash + dossier + slash + fichiersXML[i].getName());
			System.out.println("fichier effac : " + nouveauFichier.getPath());
			if (nouveauFichier.exists() && !nouveauFichier.delete()) {
                erreur("Impossible d'effacer le fichier : " + nouveauFichier.getPath());
            }            
		}
	}
	
	void erreur(Exception ex) {
		erreur(ex.getClass().getName() + ": " + ex.getMessage());
	}
	
	void erreur(String msg) {
		System.err.println(msg);
	}
	
	void getContribs() {
		File coursvirtuel = new File(cheminSite + slash + cheminCoursVirtuel);
        XMLTree tree = new XMLTree(null, "", null, "");
		try {
	        Parser_XML p = new Parser_XML(new FileInputStream(coursvirtuel), System.out, tree);
	        p.parse(0);
		} catch (FileNotFoundException ex) {
			erreur(ex);
			return;
		}
        
		Vector vcontribs = new Vector();
		Vector vfichiers = new Vector();
		contribsArbre(tree, vcontribs, vfichiers);
		contribs = new File[vcontribs.size()];
		for (int i=0; i<vcontribs.size(); i++)
			contribs[i] = new File(cheminSite + slash + cheminContrib + slash + (String)vcontribs.get(i));
		fichiersXML = new File[vfichiers.size()];
		for (int i=0; i<vfichiers.size(); i++)
			fichiersXML[i] = new File((String)vfichiers.get(i));
	}
	
	void contribsArbre(XMLTree tree, Vector vcontribs, Vector vfichiers) {
        for (XMLTree noeud=tree.first_child; noeud!=null; noeud=noeud.next_brother) {
            String contrib = noeud.getAttVal("contrib");
            String activer = noeud.getAttVal("activer");
			if (contrib != null && !"".equals(contrib) && (activer == null || !"faux".equals(activer)) )
				vcontribs.add(contrib);
			if ((noeud.first_child != null) && (activer == null || !"faux".equals(activer)) )
				contribsArbre(noeud, vcontribs, vfichiers);
            String liencontenu = noeud.getAttVal("liencontenu");
			if (liencontenu != null && !"".equals(liencontenu) && (activer == null || !"faux".equals(activer)) )
				vfichiers.add(liencontenu);
		}
	}
	
	/**
	  * Copie un dossier d1 et son contenu rcursivement (la destination d2 ne doit pas exister)
	  */
	public void copierDossier(File d1, File d2) throws IOException {
		if (!d2.mkdir())
			throw new IOException("Impossible de crer le rpertoire: " + d2.getPath());
		File[] liste = d1.listFiles();
		if (liste == null)
			erreur("pas un dossier? " + d1.getPath());
		for (int i=0; i<liste.length; i++)
			if (liste[i].isDirectory())
				copierDossier(liste[i], new File(d2, liste[i].getName()));
		for (int i=0; i<liste.length; i++)
			if (!liste[i].isDirectory())
				copierFichier(liste[i], new File(d2, liste[i].getName()));
	 }
	 
	/**
	  * Efface un dossier d et son contenu rcursivement
	  */
	public static void effacerDossier(File d) throws IOException {
	 	File[] liste = d.listFiles();
		for (int i=0; i<liste.length; i++)
			if (liste[i].isDirectory()) {
				effacerDossier(liste[i]);
				liste[i] = null;
			}
		for (int i=0; i<liste.length; i++)
			if (liste[i] != null)
				if (!liste[i].delete())
					throw new IOException("Impossible d'effacer le fichier: " + liste[i].getPath());
		if (!d.delete())
			throw new IOException("Impossible d'effacer le dossier: " + d.getPath());
	}
	
    public static void copierFichier(File inputFile, File outputFile) throws IOException {
        int bufSize = 1024; 
        BufferedInputStream in  = new BufferedInputStream( 
                                      new FileInputStream(inputFile),bufSize); 
        BufferedOutputStream out = new BufferedOutputStream( 
                                      new FileOutputStream(outputFile), bufSize); 
        int length = 32;  
        byte[] ch = new byte[length]; 
        while((length = in.read(ch))!= -1) { 
            out.write(ch,0,length); 
        } 
        out.flush(); 
        in.close(); 
        out.close(); 
        outputFile.setLastModified(inputFile.lastModified());
    }
 }
 