package moulinette;

import java.awt.*;
import java.awt.event.*;
import java.io.*;
import java.io.File.*;
import java.net.URL;
import java.util.*;
import javax.accessibility.*;
import javax.swing.*;
import javax.swing.text.*;
import javax.swing.tree.* ;
import javax.swing.event.* ;
import org.apache.xerces.parsers.DOMParser;
import org.xml.sax.SAXException;
import javax.xml.transform.*;
import javax.xml.transform.stream.*;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.dom.DOMSource;


/**
 * Interface pour la gestion de la chane d'dition du site web
 * compilation: javac13 -d classes -encoding ISO-8859-1 ChaineEdition.java
 */
public class ChaineEdition extends JFrame implements ActionListener, ItemListener, MouseListener {

    ThreadXSLT th = null;
    ThreadImages thImag = null;
    JTextPane log = null;
    JEditorPane jeditVirtuel;
    File fVirtuel;
    JLabel labNav = null;
    String[] ssites = {""};
    String cheminSite;
    boolean modifiable = false;
    static final String SiteInitial = "DOCUMENTATION";
    static final String cheminContribs = "contribXML";
    static final String cheminCoursVirtuel = "coursvirtuel.xml";
    static final String cheminToutlecours = "toutlecours.xml";
    static final String cheminInter = "inter.xml";
    static final String cheminFImages = "images.xml";
    static final String slash = File.separator; 
    String[] filestodel = { cheminToutlecours , cheminInter , cheminFImages , "imagespage2.html" };
    File fnavigateur = null;
    String typedesite; // "public", "production" ou "priv"
    File coursvirtuel, toutlecours, inter, fimages; // fichiers intermdiaires
    static final String cheminASM0= "XSL/ASM_0.xsl";
    static final String cheminASMTP= "XSL/ASM_TP.xsl";
    static final String cheminASM1= "XSL/ASM_1.xsl";
    static final String cheminASM2= "XSL/ASM_2.xsl";
    static final String cheminMAITRISE0= "XSL/MAITRISE_0.xsl";
    static final String cheminMAITRISE1= "XSL/MAITRISE_1.xsl";
    File ASM0, ASMTP, ASM1, ASM2, MAITRISE0, MAITRISE1; // feuilles de style
    JButton bsuiv2, bsuiv3, bsuiv4, bsuiv5, bvisu, braz, babout1, babout2, babout3, babout4, babout5, bexecMult;
    JButton bsavedit, bmodifedit, brectree, breloadtree, bactivernoeud, bediternoeud, bajouterfrere, bajouterfils, bsuppnoeud;
    JMenuBar jmenubar;
    JMenu jmenu1, jmenu2, jmenu3, jmenu4, jsubmenu1, jsubmenu2, jsubmenu4, jsubmenu5;
    JCheckBoxMenuItem CheckArbre, CheckEdit, CheckSite, CheckWeb, CheckPrint, CheckPublic, CheckProduction, CheckPrive;
    JMenuItem jmenuItem;
    JTabbedPane ong;
    JPanel zoneArbre, zoneEdition;
    ButtonGroup groupeFormes = new ButtonGroup();
    static long pos_msg=0;
    DOMParser parser = new DOMParser(); 
    DOMTree m_tree = new DOMTree();
    static int num_doc = 0;
    static boolean modifie = false, modifiedit = false;
    static String typeSortie = "web";
    JLabel labSortie1 = new JLabel("");
    JLabel labSortie2 = new JLabel("");
    JLabel labSortie3 = new JLabel("");
    JLabel labSortie4 = new JLabel("");
    JLabel labSortie5 = new JLabel("");
    JLabel lab1Popup, lab2Popup, lab3Popup, lab4Popup, labVisuPopup;
    static boolean AffArbre = true;
    static boolean AffEditeur = false;
    Image infoImage = Toolkit.getDefaultToolkit().getImage(ChaineEdition.class.getResource("info.gif"));
    Image recImage = Toolkit.getDefaultToolkit().getImage(ChaineEdition.class.getResource("rec.gif"));
    Image filsImage = Toolkit.getDefaultToolkit().getImage(ChaineEdition.class.getResource("fils.gif"));
    Image frereImage = Toolkit.getDefaultToolkit().getImage(ChaineEdition.class.getResource("frere.gif"));
    Image delImage = Toolkit.getDefaultToolkit().getImage(ChaineEdition.class.getResource("del.gif"));
    Image modifImage = Toolkit.getDefaultToolkit().getImage(ChaineEdition.class.getResource("modif.gif"));
    Image actifImage = Toolkit.getDefaultToolkit().getImage(ChaineEdition.class.getResource("actif.gif"));
    Image annulImage = Toolkit.getDefaultToolkit().getImage(ChaineEdition.class.getResource("annuler.gif"));
    Icon infoIcon = new ImageIcon(infoImage);
    Icon recIcon = new ImageIcon(recImage);
    Icon filsIcon = new ImageIcon(filsImage);
    Icon frereIcon = new ImageIcon(frereImage);
    Icon delIcon = new ImageIcon(delImage);
    Icon modifIcon = new ImageIcon(modifImage);
    Icon actifIcon = new ImageIcon(actifImage);
    Icon annulIcon = new ImageIcon(annulImage);
    String[] desactivable = { "CHAPITRE" , "SOUSCHAPITRE" , "SECTION" , "TP" }; // les balises qui peuvent tre actives/dsactives
    static int etapeActive = 0;
    static String derniereEtapeWeb = "0";
    static String derniereEtapePrint = "0";
    static String typeUtilisateur = MyResourceBundle.getConfig().getString("Utilisateur");
    JFrame fpopup = new JFrame();
    JPopupMenu popup = new JPopupMenu();
    JCheckBox box1, box2, box3, box4, boxVisu;
    static int etapeSuccessive;

    
    public static void main(String[] args) {
        ChaineEdition CE = new ChaineEdition();
    }

    
    public ChaineEdition() {
        super("Chane d'Edition du Site");
        super.setDefaultCloseOperation(JFrame.DO_NOTHING_ON_CLOSE);
        
        addWindowListener(new WindowAdapter() {
            public void windowClosing(WindowEvent e) {
                fermer();
            }
        });

        chargerPreferences();
        
        jmenubar = new JMenuBar();
        jmenubar.addMouseListener(this);
        jmenu1 = new JMenu("Slection du site");
        jmenuItem = new JMenuItem ("Ajouter un site");
        jmenuItem.addActionListener(this);
        jmenuItem.setActionCommand("AjouterSite");   
        jmenu1.add(jmenuItem);
        jmenuItem = new JMenuItem ("Supprimer le lien vers ce site");
        jmenuItem.addActionListener(this);
        jmenuItem.setActionCommand("SupprimerSite");   
        jmenu1.add(jmenuItem);
        jsubmenu1 = new JMenu ("Slectionner un autre site");
        for (int i=0; i<ssites.length; i++) {  
            CheckSite = new JCheckBoxMenuItem(ssites[i].toString());
            CheckSite.addActionListener(new ActionListener() {
                public void actionPerformed(ActionEvent e) {   
                        String site = ((JMenuItem)(e.getSource())).getText();
                        if (!cheminSite.equals(((JMenuItem)(e.getSource())).getText())) 
                            choixSite(site); 
                        }
                }
            );
            groupeFormes.add(CheckSite);
            jsubmenu1.add(CheckSite);
        }   
        jmenu1.add(jsubmenu1);
        jmenubar.add(jmenu1);
        
        jmenu2 = new JMenu("Traitement");
        jmenuItem = new JMenuItem ("Traitement Multiple");
        jmenuItem.addActionListener(this);
        jmenuItem.setActionCommand("RunMultiple");   
        jmenu2.add(jmenuItem);
        jmenubar.add(jmenu2);
        
        jmenu3 = new JMenu("Options");
        jsubmenu2 = new JMenu ("Premire tape");
        CheckArbre = new JCheckBoxMenuItem("Afficher Arbre",AffArbre);
        CheckArbre.addItemListener(this);
        CheckEdit = new JCheckBoxMenuItem("Afficher Editeur",AffEditeur);
        CheckEdit.addItemListener(this);
        jsubmenu2.add(CheckArbre);
        jsubmenu2.add(CheckEdit);
        if (typeUtilisateur.equals("PUBLIC"))
            typedesite = "public";
        else
            typedesite = "production";
        jsubmenu5 = new JMenu ("Type de site");
        CheckPublic = new JCheckBoxMenuItem("Site public", typedesite.equals("public"));
        CheckPublic.addActionListener(this);
        jsubmenu5.add(CheckPublic);
        CheckProduction = new JCheckBoxMenuItem("Site de production", typedesite.equals("production"));
        CheckProduction.addActionListener(this);
        jsubmenu5.add(CheckProduction);
        if (!typeUtilisateur.equals("PUBLIC")) {
            CheckPrive = new JCheckBoxMenuItem("Site priv", typedesite.equals("priv"));
            CheckPrive.addActionListener(this);
            jsubmenu5.add(CheckPrive);
        } else
            CheckPrive = null;
        jsubmenu4 = new JMenu ("Type de sortie");
        CheckWeb = new JCheckBoxMenuItem("mode web",typeSortie.equals("web"));
        CheckWeb.addActionListener(this);
        CheckPrint = new JCheckBoxMenuItem("mode impression",typeSortie.equals("impression"));
        CheckPrint.addActionListener(this);
        jsubmenu4.add(CheckWeb);
        jsubmenu4.add(CheckPrint);
        jmenu3.add(jsubmenu2);
        jmenu3.add(jsubmenu5);
        jmenu3.add(jsubmenu4);
        jmenu3.addSeparator();  
        jmenuItem = new JMenuItem ("Choisir le navigateur");
        jmenuItem.addActionListener(this);
        jmenuItem.setActionCommand("Navigateur");   
        jmenu3.add(jmenuItem);
        //if (!typeUtilisateur.equals("PUBLIC")){
            jmenu3.addSeparator();  
            jmenuItem = new JMenuItem ("Configuration");
            jmenuItem.addActionListener(this);
            jmenuItem.setActionCommand("Configurer");   
            jmenu3.add(jmenuItem);
        //}
        jmenubar.add(jmenu3);

        jmenu4 = new JMenu("?");
        jmenuItem = new JMenuItem ("A propos de PICCEL");
        jmenuItem.addActionListener(this);
        jmenuItem.setActionCommand("AProposDe");   
        jmenu4.add(jmenuItem);
        jmenubar.add(jmenu4);   
        
        setJMenuBar(jmenubar);
        
        JPanel mainp = new JPanel(new BorderLayout());
        mainp.addMouseListener(this);

        JPanel haut = new JPanel();
        mainp.add(haut, BorderLayout.NORTH);

        JPanel etapes = new JPanel();
        etapes.setLayout(new BoxLayout(etapes, BoxLayout.X_AXIS));
        
        ASM0 = new File(cheminASM0);
        ASMTP = new File(cheminASMTP);
        ASM1 = new File(cheminASM1);
        ASM2 = new File(cheminASM2);
        MAITRISE0 = new File(cheminMAITRISE0);
        MAITRISE1 = new File(cheminMAITRISE1);
        
        JPanel p2 = new JPanel(new BorderLayout());
        p2.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1,Color.white,new Color(70,70,70))," 1) Etape 1 : Etablir le plan ",1,2));

        JPanel p2menu = new JPanel();
        p2menu.setLayout(new BoxLayout(p2menu, BoxLayout.X_AXIS));
        p2menu.add(Box.createHorizontalStrut(200));
        bsuiv2 = new JButton("ETAPE  1");
        bsuiv2.addMouseListener(this);
        bsuiv2.addActionListener(this);
        bsuiv2.setActionCommand("Etape2");
        bsuiv2.setToolTipText("Etape 1 (executable si le document XML est enregistr)   ");
        bsuiv2.setMnemonic(KeyEvent.VK_1);       
        p2menu.add(bsuiv2);
        babout1 = new JButton("", infoIcon);
        babout1.addMouseListener(this);
        babout1.addActionListener(this);
        babout1.setActionCommand("about1");
        babout1.setToolTipText("Informations concernant l'tape 1");
        p2menu.add(babout1);
        p2.add(p2menu, BorderLayout.NORTH);
        
        ong = new JTabbedPane();
        ong.addMouseListener(this);

        zoneEdition = new JPanel();
        zoneEdition.setLayout(new BoxLayout(zoneEdition, BoxLayout.Y_AXIS));
        JPanel zoneEditionact = new JPanel();
        zoneEditionact.setLayout(new BoxLayout(zoneEditionact, BoxLayout.X_AXIS));
        bsavedit = new JButton("Enregistrer", recIcon);
        bsavedit.addMouseListener(this);
        bsavedit.addActionListener(this);
        bsavedit.setActionCommand("EnregistrerCoursVirtuel");
        bsavedit.setToolTipText("Enregistrer le document XML   ");
        bsavedit.setMnemonic(KeyEvent.VK_E);
        zoneEditionact.add(bsavedit);
        zoneEditionact.add(Box.createHorizontalStrut(5));
        bmodifedit = new JButton("Modifier", modifIcon);
        bmodifedit.addMouseListener(this);
        bmodifedit.addActionListener(this);
        bmodifedit.setActionCommand("ModifierCoursVirtuel");
        bmodifedit.setToolTipText("Rendre le document modifiable   ");    
        bmodifedit.setMnemonic(KeyEvent.VK_M);    
        zoneEditionact.add(bmodifedit);
        zoneEdition.add(zoneEditionact);
        jeditVirtuel = new JEditorPane();
        jeditVirtuel.addMouseListener(this);
        jeditVirtuel.setContentType("text/plain; charset=ISO-8859-1");
        jeditVirtuel.setFont(new Font("Monospaced", Font.PLAIN, 10));
        jeditVirtuel.setEditable(false);
        JScrollPane scrolledit = new JScrollPane(jeditVirtuel);
        scrolledit.setPreferredSize(new Dimension(480,260));
        zoneEdition.add(scrolledit);
        
        zoneArbre = new JPanel();
        zoneArbre.setLayout(new BoxLayout(zoneArbre, BoxLayout.Y_AXIS));
        JPanel zoneArbreact = new JPanel();
        zoneArbreact.setLayout(new BoxLayout(zoneArbreact, BoxLayout.X_AXIS));
        brectree = new JButton("", recIcon);
        brectree.addMouseListener(this);
        brectree.addActionListener(this);
        brectree.setActionCommand("EnregistrerArbre");
        brectree.setToolTipText("Enregistrer le document XML   ");
        brectree.setMnemonic(KeyEvent.VK_E);
        zoneArbreact.add(brectree);
        breloadtree = new JButton("", annulIcon);
        breloadtree.addMouseListener(this);
        breloadtree.addActionListener(this);
        breloadtree.setActionCommand("ReloadArbre");
        breloadtree.setToolTipText("Annuler toutes les modifications effectues depuis le dernier enregistrement   ");
        breloadtree.setMnemonic(KeyEvent.VK_Z);
        zoneArbreact.add(breloadtree);
        zoneArbreact.add(Box.createHorizontalStrut(110));
        bactivernoeud = new JButton("", actifIcon);
        bactivernoeud.addMouseListener(this);
        bactivernoeud.addActionListener(this);
        bactivernoeud.setActionCommand("actifNoeud");
        bactivernoeud.setToolTipText("Tenir en compte (ou non : activer=faux) de ce noeud pour la genration du site   ");
        bactivernoeud.setMnemonic(KeyEvent.VK_A);  
        zoneArbreact.add(bactivernoeud);
        bediternoeud = new JButton("", modifIcon);
        bediternoeud.addMouseListener(this);
        bediternoeud.addActionListener(this);
        bediternoeud.setActionCommand("EditerNoeud");
        bediternoeud.setToolTipText("Modifier les valeurs lies  ce noeud   ");
        bediternoeud.setMnemonic(KeyEvent.VK_M);  
        zoneArbreact.add(bediternoeud);
        bajouterfrere = new JButton("", frereIcon);
        bajouterfrere.addMouseListener(this);
        bajouterfrere.addActionListener(this);
        bajouterfrere.setActionCommand("AjouterFrere");
        bajouterfrere.setToolTipText("Ajouter  la suite un noeud au mme niveau (frre)   ");
        bajouterfrere.setMnemonic(KeyEvent.VK_B);       
        zoneArbreact.add(bajouterfrere);
        bajouterfils = new JButton("", filsIcon);
        bajouterfils.addMouseListener(this);
        bajouterfils.addActionListener(this);
        bajouterfils.setActionCommand("AjouterFils");
        bajouterfils.setToolTipText("Ajouter  la suite un noeud au niveau infrieur (fils)   ");
        bajouterfils.setMnemonic(KeyEvent.VK_S);           
        zoneArbreact.add(bajouterfils);
        bsuppnoeud = new JButton("", delIcon);
        bsuppnoeud.addMouseListener(this);
        bsuppnoeud.addActionListener(this);
        bsuppnoeud.setActionCommand("SupprimerNoeud");
        bsuppnoeud.setToolTipText("Supprimer le noeud slectionn   ");
        bsuppnoeud.setMnemonic(KeyEvent.VK_DELETE);
        zoneArbreact.add(bsuppnoeud);
        zoneArbre.add(zoneArbreact);
        m_tree.getSelectionModel().setSelectionMode(TreeSelectionModel.SINGLE_TREE_SELECTION);
        JScrollPane scrollarbre = new JScrollPane(m_tree);
        scrollarbre.getVerticalScrollBar().addMouseListener(this);
        scrollarbre.getHorizontalScrollBar().addMouseListener(this);
        m_tree.addMouseListener(this);
        scrollarbre.setPreferredSize(new Dimension(480,260));
        zoneArbre.add(scrollarbre);
        if (AffArbre) ong.addTab("Arbre",zoneArbre);
        if (AffEditeur) ong.addTab("Editeur",zoneEdition);
        p2.add(ong, BorderLayout.CENTER);
        etapes.add(p2);
        p2.setAlignmentY(Component.TOP_ALIGNMENT);
        etapes.add(Box.createHorizontalStrut(5));
        
        JPanel opt1 = new JPanel();
        GridLayout layout = new GridLayout(4,1);
        opt1.setLayout(layout);
        layout.setVgap(5);
        layout.setHgap(5);
        
        JPanel p3 = new JPanel();
        p3.setLayout(new BoxLayout(p3, BoxLayout.Y_AXIS));
        p3.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1,Color.white,new Color(70,70,70))," 2) Etape 2 : Mise en Page ",1,2));
        JPanel p3gen = new JPanel();
        p3gen.setLayout(new BoxLayout(p3gen, BoxLayout.X_AXIS));
        bsuiv3 = new JButton("ETAPE  2");
        bsuiv3.addMouseListener(this);
        bsuiv3.addActionListener(this);
        bsuiv3.setActionCommand("Etape3");
        bsuiv3.setToolTipText("Etape 2   ");
        bsuiv3.setMnemonic(KeyEvent.VK_2);   
        bsuiv3.setAlignmentX(Component.CENTER_ALIGNMENT);
        babout2 = new JButton("", infoIcon);
        babout2.addMouseListener(this);
        babout2.addActionListener(this);
        babout2.setActionCommand("about2");
        babout2.setToolTipText("Informations concernant l'tape 2");
        p3gen.add(bsuiv3);
        p3gen.add(babout2);
        p3gen.add(Box.createHorizontalStrut(5));
        JPanel p3info = new JPanel();
        p3info.setLayout(new BoxLayout(p3info, BoxLayout.X_AXIS));
        if (!typeUtilisateur.equals("PUBLIC")) {
        	labSortie1.setText(" sortie " + typeSortie);
            labSortie1.setForeground(new Color(184,96,96));
            p3info.add(labSortie1);
            p3info.add(Box.createHorizontalStrut(4));
        	if (!typedesite.equals("production") || typeSortie.equals("impression"))
            	labSortie5.setText("/ documentation : non");
        	else
        		labSortie5.setText("/ documentation : oui");
            labSortie5.setForeground(new Color(184,96,96));
            p3info.add(labSortie5);
        }
        else {
        	labSortie1.setText("Type de sortie : " + typeSortie);
            labSortie1.setForeground(new Color(184,96,96));
            p3info.add(labSortie1);   
        }
        p3.add(Box.createVerticalStrut(4));
        p3.add(p3gen);
        p3.add(Box.createVerticalStrut(6));
        p3.add(p3info);
        p3.add(Box.createVerticalStrut(3));
        p3.setAlignmentY(Component.CENTER_ALIGNMENT);
        
        JPanel p4 = new JPanel();
        p4.setLayout(new BoxLayout(p4, BoxLayout.Y_AXIS));
        p4.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1,Color.white,new Color(70,70,70))," 3) Etape 3 : Gestion des Images ",1,2));
        JPanel p4gen = new JPanel();
        p4gen.setLayout(new BoxLayout(p4gen, BoxLayout.X_AXIS));       
        p4gen.add(Box.createHorizontalStrut(1));
        bsuiv4 = new JButton("ETAPE  3");
        bsuiv4.addMouseListener(this);
        bsuiv4.addActionListener(this);
        bsuiv4.setActionCommand("Etape4");
        bsuiv4.setToolTipText("Etape 3   ");
        bsuiv4.setMnemonic(KeyEvent.VK_3);        
        bsuiv4.setAlignmentX(Component.CENTER_ALIGNMENT);
        babout3 = new JButton("", infoIcon);
        babout3.addMouseListener(this);
        babout3.addActionListener(this);
        babout3.setActionCommand("about3");
        babout3.setToolTipText("Informations concernant l'tape 3");
        p4gen.add(bsuiv4);
        p4gen.add(babout3);
        p4.add(p4gen);
        p4.setAlignmentY(Component.CENTER_ALIGNMENT);
        
        JPanel p5 = new JPanel();
        p5.setLayout(new BoxLayout(p5, BoxLayout.Y_AXIS));
        p5.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1,Color.white,new Color(70,70,70))," 4) Etape 4 : Gnration du site ",1,2));
        JPanel p5gen = new JPanel();
        p5gen.setLayout(new BoxLayout(p5gen, BoxLayout.X_AXIS));
        bsuiv5 = new JButton("ETAPE  4");
        bsuiv5.addMouseListener(this);
        bsuiv5.addActionListener(this);
        bsuiv5.setActionCommand("Etape5");
        bsuiv5.setToolTipText("Etape 4   ");
        bsuiv5.setMnemonic(KeyEvent.VK_4);
        bsuiv5.setAlignmentX(Component.CENTER_ALIGNMENT);
        babout4 = new JButton("", infoIcon);
        babout4.addMouseListener(this);
        babout4.addActionListener(this);
        babout4.setActionCommand("about4");
        babout4.setToolTipText("Informations concernant l'tape 4");
        p5gen.add(bsuiv5);
        p5gen.add(babout4);
        p5.add(Box.createVerticalStrut(6));
        p5.add(p5gen);
        p5.add(Box.createVerticalStrut(8));
        
        JPanel infoSortie = new JPanel();
        infoSortie.setLayout(new BoxLayout(infoSortie, BoxLayout.X_AXIS));
        infoSortie.add(Box.createHorizontalStrut(2));
        labSortie2.setText(" sortie " + typeSortie);
        labSortie2.setForeground(new Color(184,96,96));
        infoSortie.add(labSortie2);
        infoSortie.add(Box.createHorizontalStrut(4));
        labSortie3.setText("/ avec commentaire ");
        labSortie3.setForeground(new Color(184,96,96));
        infoSortie.add(labSortie3);
        String sitepublic;
        if (typedesite.equals("public"))
            sitepublic = "oui";
        else
            sitepublic = "non";
        labSortie4.setText("/ public : " + sitepublic + " ");
        labSortie4.setForeground(new Color(184,96,96));
        infoSortie.add(labSortie4);
        infoSortie.add(Box.createHorizontalStrut(2));
        infoSortie.setAlignmentX(Component.CENTER_ALIGNMENT);
        infoSortie.setMaximumSize(infoSortie.getPreferredSize());
        p5.add(infoSortie);
        
        JPanel p6 = new JPanel();
        p6.setLayout(new BoxLayout(p6, BoxLayout.Y_AXIS));
        p6.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1,Color.white,new Color(70,70,70))," 5) Le site ",1,2));
        JPanel actsite = new JPanel();
        actsite.setLayout(new BoxLayout(actsite, BoxLayout.X_AXIS));
        bvisu = new JButton("Visualiser");
        bvisu.addMouseListener(this);
        bvisu.addActionListener(this);
        bvisu.setToolTipText("Visualiser le site   ");
        bvisu.setMnemonic(KeyEvent.VK_V);
        bvisu.setAlignmentX(Component.CENTER_ALIGNMENT);
        braz = new JButton("Rinitialiser");
        braz.addMouseListener(this);
        braz.addActionListener(this);
        braz.setToolTipText("Rinitialiser la chane d'dition   ");
        braz.setMnemonic(KeyEvent.VK_R);
        braz.setAlignmentX(Component.CENTER_ALIGNMENT);
        babout5 = new JButton("", infoIcon);
        babout5.addMouseListener(this);
        babout5.addActionListener(this);
        babout5.setActionCommand("about5");
        actsite.add(Box.createHorizontalStrut(5));
        actsite.add(bvisu);
        actsite.add(Box.createHorizontalStrut(13));
        actsite.add(braz);
        actsite.add(babout5);
        actsite.add(Box.createHorizontalStrut(5));
        p6.add(actsite);

        JPanel navp = new JPanel();
        navp.setLayout(new BoxLayout(navp, BoxLayout.X_AXIS));
        String nomNav;
        if (fnavigateur != null) {
            nomNav = fnavigateur.getName();
        }
        else {
            nomNav="non spcifi !";
        }
        labNav = new JLabel("navigateur : " + nomNav);
        labNav.setForeground(new Color(184,96,96));
        labNav.setAlignmentX(Component.CENTER_ALIGNMENT);
        navp.add(labNav);
        navp.add(Box.createHorizontalStrut(8));
        p6.add(navp);
        p6.setAlignmentY(Component.TOP_ALIGNMENT);
        
        opt1.add(p3);
        opt1.add(p4);
        opt1.add(p5);
        opt1.add(p6);
        etapes.add(opt1);
        opt1.setAlignmentY(Component.TOP_ALIGNMENT);
        mainp.add(etapes, BorderLayout.CENTER);
        
        JPanel bas = new JPanel();
        bas.setLayout(new BoxLayout(bas, BoxLayout.Y_AXIS));
        bas.add(Box.createVerticalStrut(10));
        JPanel historique = new JPanel();
        historique.setLayout(new BoxLayout(historique, BoxLayout.Y_AXIS));
        historique.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(1,Color.white,new Color(70,70,70))," Historique des oprations ",2,2));
        log = new JTextPane();
        log.addMouseListener(this);
        log.setEditable(false);
        JScrollPane scrollLog = new JScrollPane(log, ScrollPaneConstants.VERTICAL_SCROLLBAR_ALWAYS,
            ScrollPaneConstants.HORIZONTAL_SCROLLBAR_NEVER);
        scrollLog.setPreferredSize(new Dimension(700, 120));
        scrollLog.getVerticalScrollBar().addMouseListener(this);
        historique.add(scrollLog);
        bas.add(historique);
        mainp.add(bas, BorderLayout.SOUTH);
        setContentPane(mainp);

        if (ssites != null && ssites.length > 0)
            choixSite(0);
        
        pack();
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        setLocation((screen.width - getSize().width)/2,(screen.height - getSize().height)/2);
        setResizable(false);
        setVisible(true);
    }

    
    public void fermer() {
        if (modifie || modifiedit){
            int rep = JOptionPane.showConfirmDialog(null, "Voulez-vous que les modifications apportes au document XML (plan du cours) soient sauvegardes ?","Quitter le programme", JOptionPane.YES_NO_CANCEL_OPTION);
            if (rep == JOptionPane.YES_OPTION) {
                if (modifie) 
                    enregistrerArbre();
                else if (modifiedit) 
                    enregistrerCoursVirtuel();
                System.exit(0); 
            } 
            else if (rep == JOptionPane.NO_OPTION) {
               System.exit(0); 
            }
        }
        else {
            System.exit(0);         
        }
    }
    
    
    public void mouseReleased(MouseEvent evt) {
    	if (evt.isPopupTrigger() && etapeSuccessive==0)
    		menuContextuel(evt);
	}    
    public void mousePressed(MouseEvent evt) {
    	if (evt.isPopupTrigger() && etapeSuccessive==0)
    		menuContextuel(evt);
    }
    public void mouseEntered(MouseEvent evt) {}
    public void mouseExited(MouseEvent evt) {}
    public void mouseClicked(MouseEvent evt){}
   
    
    public GridBagConstraints addBagConstraints(int x, int y) {
	    GridBagConstraints contraintes = new GridBagConstraints();
    	contraintes.gridx = x;
    	contraintes.gridx = y;
    	return contraintes;
    }
    
    
    public JPanel panelEtapesMult() {
    	JPanel mainPopup = new JPanel();
		mainPopup.setLayout(new BoxLayout(mainPopup, BoxLayout.Y_AXIS));
		JLabel titrePopup = new JLabel(" Etapes successives : ");
		titrePopup.setForeground(new Color(163,138,125));
		titrePopup.setAlignmentX(Component.CENTER_ALIGNMENT);
		mainPopup.add(titrePopup);
	    JPanel etapesPopup = new JPanel();
	    etapesPopup.setLayout(new GridBagLayout());
	    GridBagConstraints contraintes = new GridBagConstraints();
	    etapesPopup.setAlignmentX(Component.CENTER_ALIGNMENT);
	    box1 = new JCheckBox("",true);
        box1.addItemListener(new ItemListener() {
            public void itemStateChanged(ItemEvent e) {   
            	if (!box1.isSelected()) {
            		box2.setSelected(false);	
            		box3.setSelected(false);	
            		box4.setSelected(false);
            		boxVisu.setSelected(false);
            	} 
          	}
        });  
        lab1Popup = new JLabel();
        lab1Popup.setText("1) Etape n1");
        etapesPopup.add(box1,addBagConstraints(0,0));
        etapesPopup.add(lab1Popup,addBagConstraints(0,1));
	    box2 = new JCheckBox("",true);
        box2.addItemListener(new ItemListener() {
            public void itemStateChanged(ItemEvent e) {   
            	if (!box2.isSelected()) {
            		box3.setSelected(false);	
            		box4.setSelected(false);
            		boxVisu.setSelected(false);
            	} 
            	else {
            		box1.setSelected(true);
            	}
          	}
        });  
        lab2Popup = new JLabel();
        lab2Popup.setText("2) Etape n2");
        etapesPopup.add(box2,addBagConstraints(1,0));
        etapesPopup.add(lab2Popup,addBagConstraints(1,1));
        box3 = new JCheckBox("",true);
        box3.addItemListener(new ItemListener() {
            public void itemStateChanged(ItemEvent e) {   
            	if (!box3.isSelected()) {
            		box4.setSelected(false);	
            		boxVisu.setSelected(false);
            	} 
            	else {
            		box1.setSelected(true);
            		box2.setSelected(true);
            	}
          	}
        });  
        lab3Popup = new JLabel();
        lab3Popup.setText("3) Etape n3");
        etapesPopup.add(box3,addBagConstraints(2,0));
        etapesPopup.add(lab3Popup,addBagConstraints(2,1));
        box4 = new JCheckBox("",true);
        box4.addItemListener(new ItemListener() {
            public void itemStateChanged(ItemEvent e) {   
            	if (!box4.isSelected()) {
            		boxVisu.setSelected(false);
            	}
            	else {
            		box1.setSelected(true);
            		box2.setSelected(true);
            		box3.setSelected(true);
            	}
            }
        });  
        lab4Popup = new JLabel();
        lab4Popup.setText("4) Etape n4");
        etapesPopup.add(box4,addBagConstraints(3,0));
        etapesPopup.add(lab4Popup,addBagConstraints(3,1));
	    boxVisu = new JCheckBox("",false);
        boxVisu.addItemListener(new ItemListener() {
            public void itemStateChanged(ItemEvent e) {   
            	if (boxVisu.isSelected()) {
            		box1.setSelected(true);
            		box2.setSelected(true);
            		box3.setSelected(true);
            		box4.setSelected(true);
            	}
            }
        });  
        labVisuPopup = new JLabel();
        labVisuPopup.setText("5) Visualiser");
        etapesPopup.add(boxVisu,addBagConstraints(4,0));
        etapesPopup.add(labVisuPopup,addBagConstraints(4,1));
	    bexecMult = new JButton("LANCEMENT");
	    bexecMult.setForeground(new Color(13,155,73));
		bexecMult.addActionListener(this);
		bexecMult.setActionCommand("ExecMult");
		bexecMult.setAlignmentX(Component.CENTER_ALIGNMENT);
        mainPopup.add(Box.createVerticalStrut(2));
		mainPopup.add(etapesPopup);	    
		mainPopup.add(Box.createVerticalStrut(5));
		mainPopup.add(bexecMult);
		mainPopup.add(Box.createVerticalStrut(2));
		return mainPopup;
    }
    
    
    public void menuContextuel(MouseEvent evt) {
    	if (fpopup.isShowing()) fpopup.dispose();
    	popup.removeAll();
    	popup.add(panelEtapesMult());
		popup.show(this,
			(int)(evt.getPoint().getX() + evt.getComponent().getLocationOnScreen().getX() - this.getX()),
			(int)(evt.getPoint().getY() + evt.getComponent().getLocationOnScreen().getY() - this.getY()));
    }
    
    
    public void frameContextuel() {
    	if (fpopup.isShowing()) fpopup.dispose();
    	fpopup = new JFrame();    	
    	fpopup.setTitle("MultiRun");
    	Container fcontentPane = fpopup.getContentPane();
    	fpopup.setResizable(false);
    	fcontentPane.add(panelEtapesMult());
    	fpopup.pack();
    	fpopup.setLocation((int)(this.getWidth()/2-fpopup.getWidth()/2)+this.getX(),(int)(this.getHeight()/2-fpopup.getHeight()/2)+this.getY());
		fpopup.show();
    }

    
    public void enableButtons(boolean b) {
        brectree.setEnabled(b && modifie);
        breloadtree.setEnabled(b && modifie);
        bactivernoeud.setEnabled(b);
        bediternoeud.setEnabled(b);
        bajouterfrere.setEnabled(b); 
        bajouterfils.setEnabled(b);
        bsuppnoeud.setEnabled(b);
        bsavedit.setEnabled(modifiedit);
        bmodifedit.setEnabled(b);
        jmenu1.setEnabled(b);
        jmenu2.setEnabled(b);
        jmenu3.setEnabled(b);

        chargerDataProjet();     
        
        if (etapeActive!=1){
            if (!b || modifie || modifiedit) bsuiv2.setForeground(Color.gray);
                else if (b && derniereEtapeWeb.equals("0") && typeSortie.equals("web")) bsuiv2.setForeground(new Color(13,155,73));
                     else if (b && derniereEtapePrint.equals("0") && typeSortie.equals("impression")) bsuiv2.setForeground(new Color(13,155,73));
                     else bsuiv2.setForeground(Color.black);
            bsuiv2.setEnabled(b && !modifie && !modifiedit);
        	if (fpopup.isShowing()) lab1Popup.setForeground(Color.black);
        } else {
        	bsuiv2.setEnabled(true);
        	bsuiv2.setForeground(Color.red);
        	if (fpopup.isShowing()) lab1Popup.setForeground(Color.red);
        }

        if (etapeActive!=2){
            if (typeSortie.equals("web")) {
                if (!b || derniereEtapeWeb.equals("0")) bsuiv3.setForeground(Color.gray);
                else if (b && derniereEtapeWeb.equals("1")) bsuiv3.setForeground(new Color(13,155,73));
                     else bsuiv3.setForeground(Color.black);
                bsuiv3.setEnabled(b && ((Integer.parseInt(derniereEtapeWeb))>=1));
            }
            if (typeSortie.equals("impression")) {
                if (!b || derniereEtapePrint.equals("0")) bsuiv3.setForeground(Color.gray);
                else if (b && derniereEtapePrint.equals("1")) bsuiv3.setForeground(new Color(13,155,73));
                     else bsuiv3.setForeground(Color.black);
                bsuiv3.setEnabled(b && (Integer.parseInt(derniereEtapePrint)>=1));                   
            }      
        	if (fpopup.isShowing()) lab2Popup.setForeground(Color.black);
        } else {
        	bsuiv3.setEnabled(true);
        	bsuiv3.setForeground(Color.red);
        	if (fpopup.isShowing()) lab2Popup.setForeground(Color.red);
        }

        if (etapeActive!=3){
            if (typeSortie.equals("web")) {
                if (!b || (Integer.parseInt(derniereEtapeWeb)<=1)) bsuiv4.setForeground(Color.gray);
                else if (b && derniereEtapeWeb.equals("2")) bsuiv4.setForeground(new Color(13,155,73));
                     else bsuiv4.setForeground(Color.black);
                bsuiv4.setEnabled(b && (Integer.parseInt(derniereEtapeWeb)>=2));
            }
            if (typeSortie.equals("impression")) {
                if (!b || (Integer.parseInt(derniereEtapePrint)<=1)) bsuiv4.setForeground(Color.gray);
                else if (b && derniereEtapePrint.equals("2")) bsuiv4.setForeground(new Color(13,155,73));
                     else bsuiv4.setForeground(Color.black);
                bsuiv4.setEnabled(b && (Integer.parseInt(derniereEtapePrint)>=2));                   
            }      
        	if (fpopup.isShowing()) lab3Popup.setForeground(Color.black);            
        } else {
        	bsuiv4.setEnabled(true);
        	bsuiv4.setForeground(Color.red);
        	if (fpopup.isShowing()) lab3Popup.setForeground(Color.red);        	
        }
        
        if (etapeActive!=4){
            if (typeSortie.equals("web")) {
                if (!b || (Integer.parseInt(derniereEtapeWeb)<=2)) bsuiv5.setForeground(Color.gray);
                else if (b && derniereEtapeWeb.equals("3")) bsuiv5.setForeground(new Color(13,155,73));
                     else bsuiv5.setForeground(Color.black);
                bsuiv5.setEnabled(b && (Integer.parseInt(derniereEtapeWeb)>=3));
            }
            if (typeSortie.equals("impression")) {
                if (!b || (Integer.parseInt(derniereEtapePrint)<=2)) bsuiv5.setForeground(Color.gray);
                else if (b && derniereEtapePrint.equals("3")) bsuiv5.setForeground(new Color(13,155,73));
                     else bsuiv5.setForeground(Color.black);
                bsuiv5.setEnabled(b && (Integer.parseInt(derniereEtapePrint)>=3));                   
            }    
        	if (fpopup.isShowing()) lab4Popup.setForeground(Color.black); 
        } else {
        	bsuiv5.setEnabled(true);
        	bsuiv5.setForeground(Color.red);
        	if (fpopup.isShowing()) lab4Popup.setForeground(Color.red);         	
        }
        
        if (fpopup.isShowing()) {
        	if (etapeActive>0) bexecMult.setForeground(Color.red);
        	else bexecMult.setForeground(new Color(13,155,73));
        }	
        
        if (typeSortie.equals("impression")) {
             if (!b || !(new File(cheminSite + slash + "site" + slash + "impression.html")).exists()) bvisu.setForeground(Color.gray);
             else if (b && (new File(cheminSite + slash + "site" + slash + "impression.html")).exists()) bvisu.setForeground(new Color(13,155,73));
                  else bvisu.setForeground(Color.black);
             bvisu.setEnabled(b &&((new File(cheminSite + slash + "site" + slash + "impression.html")).exists()));
         } 
         else {
             if (!b || !(new File(cheminSite + slash + "site/index.html")).exists()) bvisu.setForeground(Color.gray);
             else if (b && (new File(cheminSite + slash + "site/index.html")).exists()) bvisu.setForeground(new Color(13,155,73));
                  else bvisu.setForeground(Color.black);
             bvisu.setEnabled(b &&((new File(cheminSite + slash + "site/index.html")).exists()));
         }
        
        if (!b) braz.setForeground(Color.gray);
        else if (b) braz.setForeground(new Color(13,155,73));
             else braz.setForeground(Color.black);
        braz.setEnabled(b);
    }
 
    
    public void enableSiteItems(boolean b) {
        for (int i=0; i<ssites.length; i++)
            jsubmenu1.getItem(i).setEnabled(b);
    }
    
    
    class ThreadImages extends Thread {
        ChaineEdition chaine;
        File fimages;
        public ThreadImages(ChaineEdition chaine, File fimages) {
            this.chaine = chaine;
            this.fimages = fimages;
        }
        synchronized void stopper() {
            thImag = null;
            stop();
            chaine.enableButtons(true);
        }
        public void run() {
            chaine.enableButtons(false);
            chaine.message("Opration en cours : Transformation des images...");
            FaireImages faire = new FaireImages(fimages.getPath());
            faire.conversion(new MyMessageHandler(chaine));
            chaine.message("Transformation tape 3 termine\n");
            if (etapeSuccessive>3)
            	etapeASM2();
            else {
                chaine.etapeEnCours(0);
                chaine.enableButtons(true); 
            	etapeSuccessive=0;
            }
        }
    }
    
    
    class ThreadXSLT extends Thread {
        ChaineEdition chaine;
        File inf;
        File outf;
        File xslf;
        Hashtable parametres;
        String msgfin;
        String etapeSuiv;
        public ThreadXSLT(ChaineEdition chaine, File inf, File outf, File xslf, Hashtable parametres,
            String msgfin, String etapeSuiv) {
            this.chaine = chaine;
            this.inf = inf;
            this.outf = outf;
            this.xslf = xslf;
            this.parametres = parametres;
            this.msgfin = msgfin;
            this.etapeSuiv = etapeSuiv;
        }
        synchronized void stopper() {
            th = null;
            suspend();
            stop();
            if (isAlive() && etapeActive==4){
                suspend();
            }
            notify();
        }
        public void run() {
            Thread thisThread = Thread.currentThread();
            while (th == thisThread) {
                try {
                    chaine.transfoXSLT(inf, outf, xslf, parametres);
                    th=null;
                }
                catch(IOException e) {
                    System.err.println(e);
                }
            }    
            chaine.message(msgfin);
            if (etapeSuiv != null) {
            	chaine.etapeSuivante(etapeSuiv);
            }
            else {
            	// == fin de l'tape 4
            	if (xslf.equals(ASM2)) { 
                	addIndexPerso();
                	if (etapeSuccessive==5) etapeVisu();
                }	
            	chaine.enableButtons(true);
                etapeSuccessive = 0;
                etapeEnCours(0);
            }
        }
    }

    
    void transfoThreadXSLT(File inf, File outf, File xslf, Hashtable parametres, String msgfin) {
        transfoThreadXSLT(inf, outf, xslf, parametres, msgfin, null);
    }
 
    
    void transfoThreadXSLT(File inf, File outf, File xslf, Hashtable parametres, String msgfin, String etapeSuiv) {
        th = new ThreadXSLT(this, inf, outf, xslf, parametres, msgfin, etapeSuiv);
        th.start();
    }
 
    
    void etapeSuivante(String nomEtape) {
        if ("ASM_TP".equals(nomEtape))
            etapeASM_TP();
        if ("MAITRISE_1".equals(nomEtape))
            etapeMAITRISE_1();
        if ("Documentation".equals(nomEtape))
            etapeDoc(++num_doc);   
        if ("ASM_1".equals(nomEtape))
            etapeASM1(); 
        if ("images".equals(nomEtape))
            etapeImages(); 
    }
    
    
    public void interrompre() {        
    	if (typeSortie.equals("web"))
            derniereEtapeWeb = Integer.toString(etapeActive-1);
        if (typeSortie.equals("impression"))
            derniereEtapePrint = Integer.toString(etapeActive-1);
        enregistrerDataProjet();
    	if (etapeActive!=3) th.stopper();
        else thImag.stopper();
        try {
            Thread.sleep(500);
        } catch (InterruptedException e) {}
        message("\nVous venez d'interrompre l'tape "+ etapeActive + " en cours de traitement !!\n");
        etapeSuccessive=0;
        etapeEnCours(0);
    }
    
    
    class MyErrorListener implements ErrorListener{

        public void error(TransformerException e) {
            message ("\nErreur au niveau de la transformation XSLT ! Stoppez le traitement et relancez toutes les tapes prcdentes !",Color.blue,false,true);
            SourceLocator locator = e.getLocator();
            int col = locator.getColumnNumber();
            int line = locator.getLineNumber();
            String publicId = locator.getPublicId();
            String systemId = locator.getSystemId();
            erreur(" Error : " + e + " (ligne:" + line + ",col:" + col + ") systemid:" + systemId);
        }

        public void fatalError(TransformerException e) {
            message ("\nErreur fatale au niveau de la transformation XSLT ! Stoppez le traitement et relancez toutes les tapes prcdentes !",Color.blue,false,true);
            SourceLocator locator = e.getLocator();
            int col = locator.getColumnNumber();
            int line = locator.getLineNumber();
            String publicId = locator.getPublicId();
            String systemId = locator.getSystemId();
            erreur(" FatalError : " + e + " (ligne:" + line + ",col:" + col + ") systemid:" + systemId);
       }

        public void warning(TransformerException e) {
            String msg;
            msg = "   En cours : " + e.getMessage(); 
            message(msg,Color.gray,true,false);
        }
    }

    
    public void transfoXSLT(File inf, File outf, File xslf, Hashtable parametres) throws IOException {
        MyErrorListener MyError = new MyErrorListener();
        FileOutputStream resultat = new FileOutputStream(outf);
        try {
               TransformerFactory tFactory = TransformerFactory.newInstance() ;
               Transformer transformer = tFactory.newTransformer(new StreamSource(xslf)) ;
               if (parametres != null)
                   for (Enumeration e = parametres.keys(); e.hasMoreElements() ;) {
                       String key = (String)e.nextElement();
                       transformer.setParameter(key, parametres.get(key));
                   }
               transformer.setErrorListener(MyError);
               StreamSource source = new StreamSource(inf);
               StreamResult result = new StreamResult(resultat); 
               transformer.transform(source,result);
             }
        catch (TransformerException ex) {
             erreur(ex);
        }
        finally { 
            resultat.close();
        } 
    }

    
    public void erreur(Exception ex) {
        erreur(ex.getClass().getName() + " : " + ex.getMessage());
    }
  
    
    public void erreur(String msg) {
        message("Erreur : " + msg);
    }


    public void message(String msg) {
        message(msg,Color.black,false,true);
    }


    public void message(String msg, Color c, boolean italic, boolean bold) {
        if (log == null)
            return;
        msg = msg + "\n";
        SimpleAttributeSet attrs = new SimpleAttributeSet();
        try {
            StyleConstants.setForeground(attrs, c);
            StyleConstants.setItalic(attrs, italic);
            StyleConstants.setBold(attrs, bold);
            log.getDocument().insertString((int)pos_msg,msg,attrs);
            pos_msg += (msg).length();
            if (log.isShowing()){  
                SwingUtilities.invokeLater( 
                    new Runnable() {
                        public void run() {
                            try {
                                log.scrollRectToVisible(log.modelToView((int)pos_msg));
                            } 
                            catch (BadLocationException ex) {
                                System.err.println(ex.getClass().getName() + ": " + ex.getMessage());
                            }    
                        }
                    }
                );    
            }
        }
        catch (BadLocationException ex) {
            System.err.println(ex.getClass().getName() + ": " + ex.getMessage());
        }
    }
    
    
    public void etapeEnCours(int num){
    	switch (num) {
            case 1 :
                bsuiv2.setLabel("STOPPER");
		        bsuiv3.setLabel("ETAPE 2");
		        bsuiv4.setLabel("ETAPE 3");
		        bsuiv5.setLabel("ETAPE 4");
                if (fpopup.isShowing()) bexecMult.setLabel("STOPPER");
                break;
            case 2 :
    	    	bsuiv2.setLabel("ETAPE 1");
    	    	bsuiv3.setLabel("STOPPER");
		        bsuiv4.setLabel("ETAPE 3");
		        bsuiv5.setLabel("ETAPE 4");
                if (fpopup.isShowing()) bexecMult.setLabel("STOPPER");
                break;
            case 3 :
    	    	bsuiv2.setLabel("ETAPE 1");
		        bsuiv3.setLabel("ETAPE 2");
                bsuiv4.setLabel("STOPPER");
		        bsuiv5.setLabel("ETAPE 4");               
                if (fpopup.isShowing()) bexecMult.setLabel("STOPPER");
                break;
            case 4 :
    	    	bsuiv2.setLabel("ETAPE 1");
		        bsuiv3.setLabel("ETAPE 2");
		        bsuiv4.setLabel("ETAPE 3");            	
                bsuiv5.setLabel("STOPPER");
                if (fpopup.isShowing()) bexecMult.setLabel("STOPPER");
                break;                  
            default :
    	    	bsuiv2.setLabel("ETAPE 1");
		        bsuiv3.setLabel("ETAPE 2");
		        bsuiv4.setLabel("ETAPE 3");
		        bsuiv5.setLabel("ETAPE 4");
		        if (fpopup.isShowing()) bexecMult.setLabel("LANCEMENT");
                etapeActive=0;
                enableButtons(true);                
                break;    
        }
    }
    
    
    public void addIndexPerso() {
        File indexSource = new File(cheminSite + slash + "permanent" + slash + "index.html");
        File indexCible = new File(cheminSite + slash + "site" + slash + "index.html");
        if (indexSource.exists() && typeSortie.equals("web")) {
            copierFichier(indexSource, indexCible);
            message("Le fichier \"index.html\" a t copi du rpertoire \"permanent\" dans le rpertoire \"site\"\n");
        }
    }
    
    
    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        
        if ("Etape1".equals(cmd)) {
            message("Etape1 non implmente !");
            
        } else if ("Etape2".equals(cmd) && etapeActive!=1) {
        	etapeSuccessive = 0;
        	etapeASM0();
         
        } else if ("Etape2".equals(cmd) && etapeActive==1) {
            interrompre();
        	
        } else if ("Etape3".equals(cmd) && etapeActive!=2) {
        	etapeSuccessive = 0;
        	etapeASM1();
            
        } else if ("Etape3".equals(cmd) && etapeActive==2) {
            interrompre();
            
        } else if ("Etape4".equals(cmd) && etapeActive!=3) {
        	etapeSuccessive = 0;
        	etapeImages();
        
        } else if ("Etape4".equals(cmd) && etapeActive==3) {
            interrompre();
            
        } else if ("Etape5".equals(cmd) && etapeActive!=4) {
        	etapeSuccessive = 0; 
        	etapeASM2();
            
        } else if ("Etape5".equals(cmd) && etapeActive==4) {
            interrompre();
            
        } else if ("RunMultiple".equals(cmd)) {
        	if (etapeSuccessive==0) 
        		frameContextuel();
        
        } else if ("ExecMult".equals(cmd) && etapeActive==0) {
        	int rep = 0;
        	popup.setVisible(false);
        	if (modifie || modifiedit) {
                rep = JOptionPane.showConfirmDialog(null, "Le document coursvirtuel.xml (plan du cours) a t modifi !\n Il sera enregistr si vous souhaitez continuer le traitement !","Confirmation", JOptionPane.OK_CANCEL_OPTION);
                if (rep == JOptionPane.OK_OPTION)
                	enregistrerArbre();   
        	}
        	if (rep != JOptionPane.CANCEL_OPTION) {
            	if (boxVisu.isSelected()) etapeSuccessive = 5;
            	else if (box4.isSelected()) etapeSuccessive = 4;
            	else if (box3.isSelected()) etapeSuccessive = 3;
            	else if (box2.isSelected()) etapeSuccessive = 2;
            	else if (box1.isSelected()) etapeSuccessive = 1;
            	else etapeSuccessive = 0;
            	if (etapeSuccessive != 0) 
            		etapeASM0();        		
        	}

        } else if ("ExecMult".equals(cmd) && etapeActive>0) {        
            interrompre();        	
        	
        } else if ("EnregistrerCoursVirtuel".equals(cmd)) {
            enregistrerCoursVirtuel();
            
        } else if ("EnregistrerArbre".equals(cmd)) {
            enregistrerArbre();    
            
        } else if ("ReloadArbre".equals(cmd)) {
        	reloadArbre();	            
            
        } else if ("ModifierCoursVirtuel".equals(cmd)) {
            modifierCoursVirtuel();   

        } else if ("Visualiser".equals(cmd)) {
            etapeVisu();
            
        } else if ("Navigateur".equals(cmd)) {
            choixNavigateur();
            
        } else if ("Configurer".equals(cmd)) {
        	DialogueConfig dlg = new DialogueConfig(this);    
        
        } else if ("AjouterSite".equals(cmd)) {
            ajouterSite();
            
        } else if ("SupprimerSite".equals(cmd)) {
            supprimerSite();
        
        } else if ("Rinitialiser".equals(cmd)) {
            enableButtons(false);
            razSite(new File(cheminSite), false);

        } else if ("AProposDe".equals(cmd)) {
            JOptionPane.showMessageDialog(this, MyResourceBundle.getAides().getString("AProposDe"),"A Propos de", JOptionPane.INFORMATION_MESSAGE);
        
        } else if ("about1".equals(cmd)) {
            JOptionPane.showMessageDialog(this, MyResourceBundle.getAides().getString("aide1"),"Info. tape 1", JOptionPane.INFORMATION_MESSAGE);    

        } else if ("about2".equals(cmd)) {
            JOptionPane.showMessageDialog(this, MyResourceBundle.getAides().getString("aide2"),"Info. tape 2", JOptionPane.INFORMATION_MESSAGE);

        } else if ("about3".equals(cmd)) {
            JOptionPane.showMessageDialog(this, MyResourceBundle.getAides().getString("aide3"),"Info. tape 3", JOptionPane.INFORMATION_MESSAGE);    
            
        } else if ("about4".equals(cmd)) {
            JOptionPane.showMessageDialog(this, MyResourceBundle.getAides().getString("aide4"),"Info. tape 4", JOptionPane.INFORMATION_MESSAGE);
        
        } else if ("about5".equals(cmd)) {
            JOptionPane.showMessageDialog(this, MyResourceBundle.getAides().getString("aide5"),"Info. rinitialisation", JOptionPane.INFORMATION_MESSAGE);
        	
        } else if ("SupprimerNoeud".equals(cmd)) {
             supprimerNoeud();   
             
        } else if ("EditerNoeud".equals(cmd)) {
             modifierNoeud();        
             
        } else if ("AjouterFils".equals(cmd)) {
             ajouterFils();   
             
        } else if ("AjouterFrere".equals(cmd)) {
             ajouterFrere();          
        
        } else if ("actifNoeud".equals(cmd)) {
             activerNoeud(); 
        
        } else if (e.getSource() == CheckWeb) {
              if (typeSortie.equals("impression") && CheckPrint.isSelected()) {
                  typeSortie = "web";
                  CheckWeb.setSelected(true);
                  CheckPrint.setSelected(false);
                  majLabels();
                  message("Vous tes pass en mode WEB\n");
              }
              else {
                  CheckWeb.setSelected(true); 
              }
              enableButtons(true);

        } else if (e.getSource() == CheckPrint) {
              if (typeSortie.equals("web") && CheckWeb.isSelected()) {
                  typeSortie = "impression";
                  CheckWeb.setSelected(false);
                  CheckPrint.setSelected(true);
                  majLabels();
                  message("Vous tes pass en mode IMPRESSION\n");
              }
              else {
                 CheckPrint.setSelected(true); 
              }
              enableButtons(true);
        }
        
       else if (e.getSource() == CheckPublic) {
           if (CheckPublic.isSelected()) {
               typedesite = "public";
               CheckProduction.setSelected(false);
               if (CheckPrive != null)
                   CheckPrive.setSelected(false);
           } else {
               typedesite = "production";
               CheckProduction.setSelected(true);
               if (CheckPrive != null)
                   CheckPrive.setSelected(false);
           }
           majLabels();
       }
        
        else if (e.getSource() == CheckProduction) {
            if (CheckProduction.isSelected()) {
                typedesite = "production";
               CheckPublic.setSelected(false);
               if (CheckPrive != null)
                   CheckPrive.setSelected(false);
            } else {
                typedesite = "public";
               CheckPublic.setSelected(true);
               if (CheckPrive != null)
                   CheckPrive.setSelected(false);
            }
           majLabels();
       }
       
        else if (e.getSource() == CheckPrive) {
            if (CheckProduction.isSelected()) {
                typedesite = "priv";
               CheckPublic.setSelected(false);
               CheckProduction.setSelected(false);
            } else {
                typedesite = "public";
               CheckPublic.setSelected(true);
               CheckProduction.setSelected(false);
            }
           majLabels();
       }
       
    }
    
    protected void majLabels() {
        labSortie1.setText("sortie " + typeSortie);
        if (typedesite.equals("production"))
            labSortie3.setText("/ avec commentaire ");
        else
            labSortie3.setText("/ sans commentaire ");
        String sitepublic;
        if (typedesite.equals("public"))
            sitepublic = "oui";
        else
            sitepublic = "non";
        labSortie4.setText("/ public : " + sitepublic);
        if (typedesite.equals("production") && typeSortie.equals("web"))
            labSortie5.setText("/ documentation : oui");
        else
            labSortie5.setText("/ documentation : non");
        labSortie2.setText("sortie " + typeSortie);
    }
    
    public void itemStateChanged(ItemEvent e) {
        
        if (e.getSource() == CheckArbre) {
            if (!AffArbre) {
                if (AffEditeur) ong.remove(zoneEdition);
                ong.addTab("Arbre",zoneArbre);
                if (AffEditeur) ong.addTab("Editeur",zoneEdition);
            } else {
                ong.remove(zoneArbre);
            }
            AffArbre = (!AffArbre);
            ong.repaint();
        }
        
        else if (e.getSource() == CheckEdit) {
             if (!AffEditeur) {
                 ong.addTab("Editeur",zoneEdition);
             } else {
                 ong.remove(zoneEdition);
             }
             AffEditeur = (!AffEditeur);
             ong.repaint();
        }  
    }
    

    public void choixSite(int index_site) {
        choixSite((String)ssites[index_site]);
        jsubmenu1.getItem(index_site).setSelected(true);
    }


    public boolean choixSite(String site) {
    	etapeSuccessive=0;
    	int rep = -1;
        if (modifie || modifiedit){
             rep = JOptionPane.showConfirmDialog(null, "Voulez-vous que les modifications apportes au document XML soient sauvegardes ?","Changement site", JOptionPane.YES_NO_CANCEL_OPTION);
             if (rep == JOptionPane.YES_OPTION) {
                 if (modifie) enregistrerArbre();
                 else if (modifiedit) enregistrerCoursVirtuel();
             } 
         }
        if (rep != JOptionPane.CANCEL_OPTION) {
            cheminSite = site;
            chargerDataProjet();
            setTitle("Chaine d'dition du site \" " + cheminSite + " \"");
            coursvirtuel = new File(cheminSite + slash + cheminCoursVirtuel);
            toutlecours = new File(cheminSite + slash + cheminToutlecours);
            inter = new File(cheminSite + slash + cheminInter);
            message("Site slectionn : " + cheminSite + "\n");
            coursvirtuel = new File(cheminSite + slash + cheminCoursVirtuel);
            toutlecours = new File(cheminSite + slash + cheminToutlecours);
            inter = new File(cheminSite + slash + cheminInter);
            fimages = new File(cheminSite + slash + cheminFImages);
            reinitOnglet();
            brectree.setEnabled(false);
            modifiedit = false;
            modifie = false;
            m_tree.activeNode = null;
            enableButtons(true);
            enableSiteItems(true);
            File source = new File(cheminSite + slash + "permanent");
            File cible = new File(cheminSite + slash + "site");
            if (!cible.exists() && source.exists()) {
            	cible.mkdir();
                copierDossier(source,cible);
            }
            return true;
       }
       else return false;
   }
    
    
    public void reinitOnglet() {
        reinitOnglet(true);
    }    

    
    public void reinitOnglet(boolean ReloadTree) {
        try {
            if (ReloadTree){
                String doctoparse = new String(cheminSite + slash + "coursvirtuel.xml");
                parser.parse(doctoparse);
                org.w3c.dom.Document doc = parser.getDocument();
                m_tree.setDocument(doc);
            }
            fVirtuel = new File("");
            jeditVirtuel.setPage(fVirtuel.toURL());
            fVirtuel = new File(cheminSite + "/" + cheminCoursVirtuel);
            jeditVirtuel.setPage(fVirtuel.toURL());
        } 
        catch (IOException ex) {
            erreur(ex);
        }
        catch (SAXException e) {
            erreur(e);
        } 
    }


    public void ajouterSite() {
        boolean creation = initAjouterSite(null);
        if (creation){
            jsubmenu1.removeAll();
            for (int i=0; i<ssites.length; i++) { 
                CheckSite = new JCheckBoxMenuItem(ssites[i].toString());
                CheckSite.addActionListener(new ActionListener() {
                    public void actionPerformed(ActionEvent e) {   
                        String siteSelect = ((JMenuItem)(e.getSource())).getText();
                        if (!cheminSite.equals(((JMenuItem)(e.getSource())).getText())) 
                            choixSite(siteSelect); 
                        }
                    }
                );
                groupeFormes.add(CheckSite);
                jsubmenu1.add(CheckSite);
            } 
            choixSite(ssites.length-1);
        }
    }

    
    public boolean initAjouterSite(String site) {
        boolean creation = false;
        boolean alreadyExist = false;
        if (site == null) {
            site = JOptionPane.showInputDialog(" Nom du site (rpertoire) :");
        }
        if (site != null){    
            String[] suppChar = {" ","\\","/","@","."};
            for (int i=0;i<suppChar.length;i++) {
                site = replace(site,suppChar[i],"",true);  
            }
            File racine = new File(".");
            File[] liste = racine.listFiles();
            for (int i=0; i<ssites.length; i++) {
                if (site.toUpperCase().equals(ssites[i].toUpperCase())) 
                    alreadyExist = true;
            }             
            if ((!site.equals("")) && (!alreadyExist)) {
                File rep = new File(site.toUpperCase());
                File fich = new File(rep + slash + "coursvirtuel.xml");
                File repPermanent = new File("permanent");
                File repSite = new File(rep + slash + "site");
                File newRepPermanent = new File(rep + slash + "permanent");
                File newContrib = new File(rep + slash + "contribXML");
                if (!rep.isDirectory()) {
                    rep.mkdir();
                    message("Cration du rpertoire " + rep.toString() + " (racine de ce site)");
                }
                if (!fich.exists()) {
                    try { 
                        FileWriter fw = new FileWriter(fich); 
                        BufferedWriter output = new BufferedWriter(fw); 
                        output.write("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>" + "\r\n");
                        output.write("<COURS/>" + "\r\n"); 
                        output.flush(); 
                        output.close();
                        message("Cration du fichier " + fich + " (plan du cours a construire)");
                    } 
                    catch(IOException ioe){ 
                        message("Un problme empche la cration du document " + rep.toString() + "/coursvirtuel.xml");
                    } 
                } 
                if (!newRepPermanent.isDirectory()) {
                    if (repPermanent.isDirectory()) {
                        copierDossier(repPermanent,newRepPermanent);
                        message("Copie du rpertoire " + repPermanent + " dans " + newRepPermanent);
                        if (!repSite.isDirectory()) {
                            File raz_File = new File(rep.toString());
                            razSite(raz_File, true);
                        }    
                    }
                    else{
                        message("Le rpertoire " + repPermanent + " n\'a pas t trouv, vous devrez le crer manuellement !");                        
                    }
                }
                if (!newContrib.isDirectory()) {
                    newContrib.mkdir();
                }
                if (rep.isDirectory() && fich.exists()) {
                    if (ssites[0].equals("")) {
                        ssites[0] = site.toUpperCase(); 
                    } 
                    else {
                        String[] ssites2 = new String[ssites.length + 1];
                        for (int i=0; i<ssites.length; i++) {
                            ssites2[i] = ssites[i];
                        } 
                        ssites2[ssites.length] = site.toUpperCase(); 
                        ssites = ssites2;
                    }
                    enregistrerPreferences();
                    creation = true;
                }
            } 
            else {
                if (alreadyExist){
                    JOptionPane.showMessageDialog(null, site.toUpperCase() + " : Opration annule car un site de ce nom existe dja !!","Problme",JOptionPane.OK_OPTION);
                    ajouterSite();                    
                }
            }
        }
        return creation;    
    }     

    
    public void supprimerSite() {
        int rep = JOptionPane.showConfirmDialog(null, "Retirer le lien vers le site " +cheminSite+ " ?","confirmation",
            JOptionPane.YES_NO_OPTION);
        if (rep == JOptionPane.YES_OPTION) {
            if (ssites.length - 1 != 0) {
                jsubmenu1.removeAll();
                String[] ssites2 = new String[ssites.length - 1];
                int i2 = 0;
                for (int i=0; i<ssites.length; i++)
                    if (cheminSite != ssites[i])
                    {
                        ssites2[i2++] = ssites[i];
                        CheckSite = new JCheckBoxMenuItem(ssites[i].toString());
                        CheckSite.addActionListener(new ActionListener() {
                            public void actionPerformed(ActionEvent e) {   
                                String site = ((JMenuItem)(e.getSource())).getText();
                                if (!cheminSite.equals(((JMenuItem)(e.getSource())).getText())) 
                                    choixSite(site); 
                                }
                            }
                        );
                        groupeFormes.add(CheckSite);
                        jsubmenu1.add(CheckSite);
                    }
                ssites = ssites2;
                message("Le lien vers le site " + cheminSite + " a t supprim !\n");
                choixSite(0);
                enregistrerPreferences();
            }
            else JOptionPane.showMessageDialog(this,"Le lien n'a pas t supprim afin de laisser au moins un site dans la slection !","Message", JOptionPane.INFORMATION_MESSAGE);    
        }
    }

 
    public void modifierCoursVirtuel() {
        jeditVirtuel.setEditable(true);
        modifiedit = true;
        modifie = false;
        enableButtons(true);
        message("Effectuez les modifications...\n");     
    }


    public void enregistrerCoursVirtuel() {
        try {
            Writer out = new BufferedWriter(new OutputStreamWriter(new FileOutputStream(fVirtuel), "ISO-8859-1"));
            jeditVirtuel.write(out);
            out.close();
            jeditVirtuel.setEditable(false);
            message("Document " + fVirtuel.getPath() + " enregistr !\n");
            modifie = false;
            modifiedit = false;
            enableButtons(true);
        } catch (IOException ex) {
            erreur(ex);
        }
        reinitOnglet();
    }
    
    
    public void enregistrerArbre() {
       DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
       if (fVirtuel.exists()) {
       try {
           org.w3c.dom.Document doc = m_tree.getDocument();
           File f = new File(fVirtuel.getPath());
           StreamResult result = new StreamResult(f);
           DOMSource source = new DOMSource(doc);
           TransformerFactory transformerFactory = TransformerFactory.newInstance();
           Transformer transformer = transformerFactory.newTransformer();
           transformer.setOutputProperty(OutputKeys.ENCODING,"ISO-8859-1");
           transformer.setOutputProperty(OutputKeys.METHOD, "xml");
           transformer.setOutputProperty(OutputKeys.INDENT, "yes");
           transformer.setOutputProperty(OutputKeys.OMIT_XML_DECLARATION, "no");
           transformer.transform(source,result);
           message("Document " + fVirtuel.getPath() + " enregistr !\n");
           modifie = false;
           modifiedit = false;
           enableButtons(true);
        }
        catch (Exception e){
            System.err.println(e.getClass().getName() + ": " + e.getMessage());
        }
       }
       else {
           message ("Le fichier \"coursvirtuel\" est introuvable !!", Color.blue, false, true);
       }
        reinitOnglet(false);
    }
    
    
    public void reloadArbre() {
        int rep = JOptionPane.showConfirmDialog(null, "Voulez-vous annuler toutes les modifications effectues depuis la dernire sauvegarde ?","", JOptionPane.YES_NO_OPTION);
        if (rep == JOptionPane.YES_OPTION) {
            try {
                String doctoparse = new String(cheminSite + slash + "coursvirtuel.xml");
                parser.parse(doctoparse);
                org.w3c.dom.Document doc = parser.getDocument();
                m_tree.setDocument(doc);
                message("Les dernires modifications ont t annules !\n");
                modifie = false;
                modifiedit = false;
                m_tree.activeNode = null;
                m_tree.activeParentNode = null;
                enableButtons(true);
            }
            catch (IOException ex) {
                erreur(ex);
            }
            catch (SAXException saxex) {
                erreur(saxex);
            } 
        }
    }
    
    
    public void supprimerNoeud(){
        if (m_tree.isSelectNode()){
            int rep = JOptionPane.showConfirmDialog(null, "Supprimer le noeud slectionn ?","confirmation",JOptionPane.YES_NO_OPTION);
            if (rep == JOptionPane.YES_OPTION) {
                m_tree.supprimerNoeud();
                modifie = true;
                modifiedit = false;
                enableButtons(true);
            }
        }
        else JOptionPane.showMessageDialog(this,"Veuillez d'abord slectionner un noeud","Message", JOptionPane.INFORMATION_MESSAGE);    
    }
    
    
    public void modifierNoeud(){
        if (m_tree.isSelectNode()) {
            modifie=true;
            modifiedit = false;
            enableButtons(false);
            DialogueArbre dlg = new DialogueArbre(m_tree,"modifier",this);
        }
        else JOptionPane.showMessageDialog(this,"Veuillez d'abord slectionner un noeud","Message", JOptionPane.INFORMATION_MESSAGE);    
    }
    

    public void ajouterFils(){
        if (m_tree.isSelectNode()) {
            modifie = true;
            modifiedit = false;
            enableButtons(false);
            DialogueArbre dlg = new DialogueArbre(m_tree,"fils",this);
        }
        else JOptionPane.showMessageDialog(this,"Veuillez d'abord slectionner un noeud","Message", JOptionPane.INFORMATION_MESSAGE);    
    }


    public void ajouterFrere(){
       if (m_tree.isSelectNode()){ 
           modifie = true;
           modifiedit = false;
           enableButtons(false);
           DialogueArbre dlg = new DialogueArbre(m_tree,"frere",this);
       }
       else JOptionPane.showMessageDialog(this,"Veuillez d'abord slectionner un noeud","Message", JOptionPane.INFORMATION_MESSAGE);    
    }
    
    
    public void activerNoeud(){
        boolean modifiable = false;
        if (m_tree.isSelectNode()) { 
            if (m_tree.isElement()) {
                for (int i=0;i<(desactivable.length);i++) {
                    if (m_tree.nameElement(m_tree.nameSelectNode()).equals(desactivable[i])) modifiable = true;
                }    
                if (modifiable) {
                    String value;
                    StringBuffer buf1 = new StringBuffer(m_tree.nameSelectNode());
                    if (subIndice(buf1,"activer=\"faux\"")!=-1) {
                        value = replace(m_tree.nameSelectNode()," activer=\"faux\"","",true);
                    }
                    else value = (buf1.insert(buf1.length()-1," activer=\"faux\"")).toString(); 
                    m_tree.modifierNoeud(value);
                    m_tree.activeNode = null;
                    m_tree.activeParentNode = null;
                    modifie = true;
                    modifiedit = false;
                    brectree.setEnabled(true);
                    breloadtree.setEnabled(true);
                    bsuiv2.setEnabled(false);
                }
                else JOptionPane.showMessageDialog(this,"Ce type de balise ne peut tre activer/dsactiver","Message", JOptionPane.INFORMATION_MESSAGE);
            } 
        }
        else JOptionPane.showMessageDialog(this,"Veuillez d'abord slectionner un noeud","Message", JOptionPane.INFORMATION_MESSAGE);
    }
  
    
   public void etapeASM0() {
   	   razLancementEtape(1);
       if (typeSortie.equals("web"))
           derniereEtapeWeb = "1";
       if (typeSortie.equals("impression"))
           derniereEtapePrint = "1";
       enregistrerDataProjet(); 
       etapeActive=1;
       etapeEnCours(1);
       enableButtons(false);
       message("Etape 1 en cours (" + ASM0.toString() + ") ...");
       String etapeSuiv = null;
       if (etapeSuccessive>1)
           etapeSuiv = "ASM_1";
       if ("IUFM".equals(cheminSite))
           etapeSuiv = "ASM_TP";
       if ("MAITRISE".equals(cheminSite)) {
           etapeSuiv = "MAITRISE_1";
           transfoThreadXSLT(coursvirtuel, toutlecours, MAITRISE0, null, "Transformation MAITRISE_0 termine\n", etapeSuiv);
       } else
           transfoThreadXSLT(coursvirtuel, toutlecours, ASM0, null, "Transformation Etape 1 termine\n", etapeSuiv);
    }
   
    
    public void etapeASM_TP() {
        message("Opration en cours : TP (" + cheminASMTP + ") ...");
        File tmpf;
        try {
            tmpf = java.io.File.createTempFile("tmp",".xml") ;
        } catch (IOException ex) {
            erreur(ex);
            return;
        }
        tmpf.deleteOnExit() ;
        try {
            transfoXSLT(toutlecours, tmpf, ASMTP, null);
        }
        catch(IOException e) {
            System.err.println(e);
        }
        copierFichier(tmpf, toutlecours);
        etapeEnCours(0);
        enableButtons(true);
        message("Transformation TP termine\n");
        if (etapeSuccessive>1)
        	etapeASM1();
        else etapeSuccessive=0;
    }

    
    public void etapeMAITRISE_1() {
        message("Opration en cours : MAITRISE_1 (" + cheminMAITRISE1 + ") ...");
        File tmpf;
        try {
            tmpf = java.io.File.createTempFile("tmp",".xml") ;
        } catch (IOException ex) {
            erreur(ex);
            return;
        }
        tmpf.deleteOnExit() ;
        try {
            transfoXSLT(toutlecours, tmpf, MAITRISE1, null);
        }
        catch(IOException e) {
            System.err.println(e);
        }
        copierFichier(tmpf, toutlecours);
        etapeEnCours(0);
        enableButtons(true);
        message("Transformation MAITRISE_1 termine\n");
        if (etapeSuccessive>1)
        	etapeASM1();
        else etapeSuccessive=0;
    }    
    

    public void etapeDoc(int numeroDoc) {
        Hashtable newParametres = new Hashtable();
        switch (numeroDoc) {
            case 1 : {
                message("Opration en cours : Documentation du site...");
                File credits = new File("XSL/liste_credits.xsl");
                File htmlCredits = new File(cheminSite + slash + "site/credits.html"); 
                transfoThreadXSLT(toutlecours, htmlCredits, credits, newParametres, "   1/5) credits.html termine", "Documentation");
                break;
            }
            case 2 : {
                File creditsTri = new File("XSL/credits_tri.xsl");
                File htmlCreditsTri = new File(cheminSite + slash + "site/credits_tri.html"); 
                transfoThreadXSLT(toutlecours, htmlCreditsTri, creditsTri, newParametres, "   2/5) credits_tri.html termine", "Documentation");
                break;
            }
            case 3 : {
                File badLink = new File("XSL/mauvais_liens.xsl");
                File htmlBadLink = new File(cheminSite + slash + "site/mauvais_liens.html"); 
                transfoThreadXSLT(toutlecours, htmlBadLink, badLink, newParametres, "   3/5) mauvais_liens.html termine", "Documentation");
                break;
            }
            case 4 : {
                File labels = new File("XSL/labels.xsl");
                File htmlLabel = new File(cheminSite + slash + "site/labels.html"); 
                transfoThreadXSLT(toutlecours, htmlLabel, labels, newParametres, "   4/5) labels.html termine", "Documentation");
                break;
            }
            case 5 : {
            	File labelsfigures = new File("XSL/labelsfigures.xsl");
                File htmlLabelsFigures = new File(cheminSite + slash + "site/labelsfigures.html"); 
                num_doc=0;
                if (etapeSuccessive>2)
                	transfoThreadXSLT(toutlecours, htmlLabelsFigures, labelsfigures, newParametres, "   5/5) labelsfigures.html termine \nDocumentation Termine !\n", "images");
                else 
                	transfoThreadXSLT(toutlecours, htmlLabelsFigures, labelsfigures, newParametres, "   5/5) labelsfigures.html termine \nDocumentation Termine !\n");
                break;
            }    
        }
    }
    
    
    public void etapeASM1() {
    	razLancementEtape(2);
        if (typeSortie.equals("web")) {
            derniereEtapeWeb = "2";
            if (Integer.parseInt(derniereEtapePrint)>=2) derniereEtapePrint = "1";
        }
        if (typeSortie.equals("impression")) {
            derniereEtapePrint = "2";        	
            if (Integer.parseInt(derniereEtapeWeb)>=2) derniereEtapeWeb = "1";
        }
        enregistrerDataProjet();
        etapeActive=2;
        etapeEnCours(2);
        enableButtons(false);
        message("Etape 2 en cours (" + ASM1.toString() + ") ...");
        Hashtable parametres = new Hashtable();
        parametres.put("affichage", typeSortie) ;
        message("   Affichage = " + typeSortie);
        if ("web".equals(typeSortie) && typedesite.equals("production")) 
            transfoThreadXSLT(toutlecours, inter, ASM1, parametres, "Transformation tape 2 termine\n", "Documentation");
        else {
            if (etapeSuccessive > 2)
            	transfoThreadXSLT(toutlecours, inter, ASM1, parametres, "Transformation tape 2 termine\n", "images");
            else 
            	transfoThreadXSLT(toutlecours, inter, ASM1, parametres, "Transformation tape 2 termine\n");
        }
    }
    
    
    public void etapeImages() {
        //razLancementEtape(3);
        if (typeSortie.equals("web"))
            derniereEtapeWeb = "3";
        if (typeSortie.equals("impression"))
            derniereEtapePrint = "3";
        enregistrerDataProjet(); 
        etapeActive=3;
        etapeEnCours(3);
        enableButtons(false);
    	message("Etape 3 en cours : Traitement des images ...");
        thImag = new ThreadImages(this, fimages);
        thImag.start();
    }    
    
    
    public void etapeASM2() {
        razLancementEtape(4);
        if (typeSortie.equals("web"))
            derniereEtapeWeb = "4";
        if (typeSortie.equals("impression"))
            derniereEtapePrint = "4";
        enregistrerDataProjet(); 
        etapeActive=4;
        etapeEnCours(4);
        enableButtons(false);
        message("Etape 4 en cours (" + ASM2.toString() + ") ...");
        File fsortie;
        if ("impression".equals(typeSortie))
            fsortie = new File(cheminSite + slash + "site" + slash + "impression.html");
        else {
            try {
                fsortie = java.io.File.createTempFile("tmp",".xml") ;
            } catch (IOException ex) {
                erreur(ex);
                return;
            }
            fsortie.deleteOnExit() ;
        }
        Hashtable parametres = new Hashtable();
        parametres.put("affichage", typeSortie);
        message("   Affichage = " + typeSortie);
        parametres.put("imagespage2", ".." + slash + cheminSite + slash + "imagespage2.html") ;
        String commenter;
        if (typedesite.equals("production"))
            commenter = "oui";
        else
            commenter = "non";
        parametres.put("commentaires", commenter) ;
        message("   Commentaires = " + commenter);
        String sitepublic;
        if (typedesite.equals("public"))
            sitepublic = "oui";
        else
            sitepublic = "non";
        parametres.put("public", sitepublic) ;
        message("   Public = " + sitepublic);
        transfoThreadXSLT(inter, fsortie, ASM2, parametres, "Transformation tape 4 termine\n");
    }

    
    public void etapeVisu() {
        // lancer navigateur web
        if (fnavigateur == null) {
            message ("Vous devez choisir le navigateur que vous souhaitez utiliser (ex : mozilla.exe)\n",Color.red,false,true);
            choixNavigateur();
        }
        try {
            // il existe peut-tre des plate-formes o il faut mettre un \ devant les espaces
            /*for (int i=0; i<cheminNav.length(); i++) {
                if (cheminNav.charAt(i) == ' ') {
                    cheminNav = cheminNav.substring(0,i) + "\\ " + cheminNav.substring(i+1);
                    i++;
                }
            }*/
            String cheminNav = "\"" + fnavigateur.getPath() + "\"";
            File findex;
            if (typeSortie.equals("impression")) {
                findex = new File(cheminSite + slash + "site" + slash + "impression.html");                  
            }
            else {
                findex = new File(cheminSite + slash + "site" + slash + "index.html");                
            }
            if (System.getProperty("os.name").startsWith("Mac")) {
                blindexec("/usr/bin/open -a " + cheminNav + " \"" + findex.getAbsolutePath() +"\"");
            } else
                blindexec(cheminNav + " \"" + findex.getAbsolutePath() +"\"");
        } catch (Exception ex) {
            erreur(ex);
        }
    }

    
    public void choixNavigateur() {
        FileDialog fdlg = new FileDialog(this, "Slection du navigateur", FileDialog.LOAD);
        fdlg.show();
        String chemin = null;
        String dir = fdlg.getDirectory();
        String nom = fdlg.getFile();
        if (dir == null)
            chemin = nom;
        else if (nom != null)
            chemin = dir + slash + nom;
        if (chemin != null) {
            fnavigateur = new File(chemin);
            labNav.setText("navigateur : " + nom);
            enregistrerPreferences();
        }
    }

 
    // Supprime fichiers si dj existant
    public void razLancementEtape(int num_etape){
        File site_File = new File(cheminSite + slash + "site");
        File source = new File(cheminSite + slash + "permanent");
        File cible = new File(cheminSite + slash + "site");
        switch (num_etape) {
            case 1 :
                File del0 = new File(cheminSite + slash + cheminToutlecours);
                if (del0.exists()) del0.delete();
                break;
            case 2 :
                if (!site_File.exists()) site_File.mkdir(); 
                File del1 = new File(cheminSite + slash + cheminInter);
                File del2 = new File(cheminSite + slash + cheminFImages);
                if (del1.exists()) del1.delete();
                if (del2.exists()) del2.delete();
                break;
            case 3 :
                if (site_File.exists()) {
                    File[] files = site_File.listFiles();
                    for(int i=0; i<files.length; i++) {
                        if (files[i].isDirectory() && (files[i].getName().startsWith("images"))) {
                            effacerDossier(files[i]);
                        } 
                    }
                }    
                break;        
            case 4 :
                if ("web".equals(typeSortie)) {
                    if (site_File.exists()) {
                        File[] files = site_File.listFiles();
                        for(int i=0; i<files.length; i++) {
                            if (files[i].isDirectory() && (files[i].getName().startsWith("chapitre"))) {
                                effacerDossier(files[i]);
                            } 
                        }
                    }
                }
                break;        
        } 
    }
    
    
    public boolean razSite(File path, boolean auto) {
        boolean resultat = true;
        boolean delete;
        int rep1=0, rep2=0;
        File site_File = new File(path + slash + "site");
        if (!auto) {
            message("Rinitialisation du site " + path.toString() + "...");
            rep1 = JOptionPane.showConfirmDialog(null, "Rinitialiser les fichiers du site " + path.toString() + "?","confirmation",JOptionPane.YES_NO_OPTION);
        }
        if ((rep1 == JOptionPane.YES_OPTION) || auto) {    
            if (!auto)
                rep2 = JOptionPane.showConfirmDialog(null, "Pour viter tout problme, vrifier qu'aucun\nrpertoire ni fichier relatif  ce site n'est ouvert !\n\nVous souhaitez confirmer la rinitialisation de ce site ?","confirmation",JOptionPane.YES_NO_OPTION);
            if ((rep2 == JOptionPane.YES_OPTION) || auto) {
                if (!site_File.isDirectory()) 
                    site_File.mkdir(); 
                File[] files = path.listFiles();
                for(int i=0; i<files.length; i++) {
                    delete = false;
                    if (!files[i].isDirectory()) {
                        for(int j=0; j<filestodel.length; j++) {
                           if (files[i].getName().equals(filestodel[j])) delete = true;
                        }
                        if (delete) {
                            resultat &= files[i].delete();
                        }
                    }
                }
                effacerDossier(site_File);
                resultat &= !site_File.exists();
                File source = new File(path.toString() + slash + "permanent");
                File cible = new File(path.toString() + slash + "site");
                cible.mkdir();
                if (source.exists())
                	copierDossier(source,cible);
                // supp. ventuel de index.html dans le site (rajout auto aprs tape 4) 
                File index = new File(path.toString() + slash + "site" + slash + "index.html");
                if (index.exists())
                    index.delete();
                if (resultat) {
                    derniereEtapeWeb = "0";
                    derniereEtapePrint = "0";
                    enregistrerDataProjet();
                    if (auto)
                        message("Cration du rpertoire " + path.toString() + slash + "site \n");
                    else     
                        message("La rinitialisation du site " + path.toString() + " a russi\n");
                }
                else {
                    message("Certains fichiers du site " + path.toString() + " n'ont pu tre effacer ! Vous pouvez relancer cette application pour rsoudre ce problme !!\n");
                }
            }
            else {
            message("Opration annule !!\n");
            }   
        }
        else {
            message("Opration annule !!\n");
        }
        enableButtons(true);    
        return(resultat);
    }


    public void chargerDataProjet() {
        File fdata = new File(cheminSite + slash + "infoProjet");
        Properties data = new Properties();
        if (!fdata.exists()){
            enregistrerDataProjet();
        }
        try {
           data.load(new FileInputStream(fdata));
        } catch (IOException ex) {
            erreur(ex);
            return;
        }
        if (!data.containsKey("DerniereEtapeWeb")) {
            data.setProperty("DerniereEtapeWeb", "0");
        }
        if (!data.containsKey("DerniereEtapePrint")) {
            data.setProperty("DerniereEtapePrint", "0");
        }
        derniereEtapeWeb = (data.getProperty("DerniereEtapeWeb")).toString();
        derniereEtapePrint = (data.getProperty("DerniereEtapePrint")).toString();
    }
    
    
    public void enregistrerDataProjet() {
        File fdata = new File(cheminSite + slash + "infoProjet");
        Properties data = new Properties();
        if (!fdata.exists()) {
            data.setProperty("DerniereEtapeWeb", "0");
            data.setProperty("DerniereEtapePrint", "0");
        }  
        else {
            data.setProperty("DerniereEtapeWeb", derniereEtapeWeb);
            data.setProperty("DerniereEtapePrint", derniereEtapePrint);
        }  
        try {
            data.store(new FileOutputStream(fdata), "Donnes du projet");
        } catch (IOException ex) {
            erreur(ex);
        }
    }
    
    
    public void chargerPreferences() {
        File fpref = new File("prfrences");
        if (!fpref.exists()){
            initAjouterSite(SiteInitial);
        }
        Properties prefs = new Properties();
        try {
            prefs.load(new FileInputStream(fpref));
        } catch (IOException ex) {
            erreur(ex);
            return;
        }
        if (!prefs.containsKey("sites"))
            prefs.setProperty("sites","");
        if (prefs.getProperty("sites").equals("")) {
            prefs.setProperty("sites",SiteInitial);
            initAjouterSite(SiteInitial);
        }
        if (prefs.getProperty("navigateur") != null) {
            fnavigateur = new File(prefs.getProperty("navigateur"));
            if (labNav != null)
                labNav.setText("Navigateur: " + fnavigateur.getName());
        }
        if (prefs.getProperty("sites") != null) {
            ssites = split(prefs.getProperty("sites"));
        }
    }
 
    
    public void enregistrerPreferences() {
        Properties prefs = new Properties();
        if (fnavigateur != null)
            prefs.setProperty("navigateur", fnavigateur.getPath());
        if (ssites != null)
            prefs.setProperty("sites", join(ssites));
        try {
            prefs.store(new FileOutputStream("prfrences"), "Prfrences pour la chane d'dition");
        } catch (IOException ex) {
            erreur(ex);
        }
    }

    
    static class MyMessageHandler implements MessageHandler {
        ChaineEdition chaine;
        public MyMessageHandler(ChaineEdition chaine) {
            this.chaine = chaine;
        }
        public void message(String msg) {
            chaine.message(msg);
        }
        public void message(String msg, Color c, boolean italic, boolean bold){
            chaine.message(msg,c,italic,bold);
        }
        public void erreur(String msg) {
            chaine.erreur(msg);
        }
    }
   
    
    /**
     * exec simplifi (renvoit uniquement stdout, renvoit stderr sur stderr)
     */
    /*public static String execout(String cmd) throws Exception {
        Vector v = exec(cmd);
        String serr = (String)v.elementAt(2);
        if (!"".equals(serr.trim()))
            System.err.println(serr.trim());
        if ((((Integer)v.elementAt(0)).intValue() >> 8) != 0) {
            throw new Exception("la commande suivante a renvoy un code d'erreur: " + cmd);
        }
        return((String)v.elementAt(1));
    }*/

    
    /**
     * this executes the command and returns a Vector with: <ul>
     *  <li> [0] - the exit code as an Integer
     *  <li> [1] - the standard output as a String
     *  <li> [2] - the standard error as a String
     * </ul>
     * can recognize the " characters to separate arguments
     */
    /*public static Vector exec(String cmd) throws Exception {
        int r;
        int BUFFSIZE = 100;
        int n;
        byte[] ac = new byte[BUFFSIZE];
        
        Process process = blindexec(cmd);
        try {
            process.waitFor();
        } catch (Exception ex) {
            throw new Exception("exec " + cmd + ": " +
                ex.getClass().getName() + ": " + ex.getMessage());
        }
        r = process.exitValue();
        
        InputStream out = process.getInputStream();
        String outs = "";
        try {
            while ((n=out.read(ac)) != -1) {
                outs += new String(ac, 0, n);
            }
        } catch (IOException ex) {
            throw new Exception("exec " + cmd + ": " +
                ex.getClass().getName() + ": " + ex.getMessage());
        }
        out.close();
        
        InputStream err = process.getErrorStream();
        String errs = "";
        try {
            while ((n=err.read(ac)) != -1) {
                errs += new String(ac, 0, n);
            }
        } catch (IOException ex) {
            throw new Exception("exec " + cmd + ": " +
                ex.getClass().getName() + ": " + ex.getMessage());
        }
        err.close();
        
        Vector v = new Vector();
        v.addElement(new Integer(r));
        v.addElement(outs);
        v.addElement(errs);
        return(v);
    }*/


    /**
     * Excution de la commande en ignorant le rsultat.
     * Renvoit le process pour permettre un traitement du rsultat.
     * Reconnait les " pour sparer les arguments.
     */
    public static Process blindexec(String cmd) throws Exception {
        Process process;
        try {
            if (cmd.indexOf('"') != -1) {
                Vector vcmd = new Vector();
                int inds = cmd.indexOf(' ');
                int indq = cmd.indexOf('"');
                while (inds != -1 || indq != -1) {
                    if (inds != -1 && (indq == -1 || inds < indq)) {
                        if (inds != 0)
                            vcmd.addElement(cmd.substring(0,inds));
                        cmd = cmd.substring(inds + 1);
                    } else {
                        if (indq != 0)
                            vcmd.addElement(cmd.substring(0,indq));
                        cmd = cmd.substring(indq + 1);
                        indq = cmd.indexOf('"');
                        if (indq == -1)
                            indq = cmd.length() - 1;
                        vcmd.addElement(cmd.substring(0,indq));
                        cmd = cmd.substring(indq + 1);
                    }
                    inds = cmd.indexOf(' ');
                    indq = cmd.indexOf('"');
                }
                if (cmd.length() != 0)
                    vcmd.addElement(cmd);
                String[] acmd = new String[vcmd.size()];
                for (int i=0; i<vcmd.size(); i++)
                    acmd[i] = (String)vcmd.elementAt(i);
                process = Runtime.getRuntime().exec(acmd);
            } else
                process = Runtime.getRuntime().exec(cmd);
            return(process);
        } catch (Exception ex) {
            throw new Exception("exec " + cmd + ": " +
                ex.getClass().getName() + ": " + ex.getMessage());
        }
    }


    public static String replace(String orig, String strReplace, String strWith, boolean all) {
        if (orig == null || strReplace == null || strReplace.length() == 0 || strWith == null)
            throw new IllegalArgumentException("pas d'arguments.");
        StringBuffer buffOrig = new StringBuffer(orig);
        int i = 0;
        while (i + strReplace.length() <= buffOrig.length()) {
            if (buffOrig.substring(i, i + strReplace.length()).equals(strReplace)) {
                buffOrig.replace(i, i + strReplace.length(), strWith);
                if (!all)
                    break;
                else
                    i += strWith.length();
                }
            else
                i++;
        }
        return buffOrig.toString();
    }
    
   
    public int subIndice(StringBuffer chaine, String ssChaine) {
        return subIndice(chaine,ssChaine,0);
    }


    public int subIndice(StringBuffer chaine, String ssChaine, int begin) {
        int indice = -1;
        if (chaine.length() >= ssChaine.length()){
            for (int i=(0+begin);i<=(chaine.length()-ssChaine.length());i++){
                if (((chaine.toString().substring(i,i+ssChaine.length())).equals(ssChaine)) && (indice==-1)) {
                    indice = i ;
                } 
            }
        }  
        return indice;      
    }
    
    
    public String join(String[] tab) {
        String res = "";
        for (int i=0; i<tab.length; i++) {
            res += tab[i];
            if (i < tab.length - 1)
                res += "|";
        }
        return(res);
    }

    
    public String[] split(String s) {
        int n=1;
        if (s.length()==0) return (null);
        for (int i=0; i<s.length(); i++)
            if (s.charAt(i) == '|')
                n++;
        String[] tab = new String[n];
        int it = 0;
        for (int ind = s.indexOf('|'); ind != -1; s = s.substring(ind+1), ind = s.indexOf('|'))
            tab[it++] = s.substring(0, ind);
        tab[it] = s;
        return(tab);
    }

    
    public void copierFichier(File inputFile, File outputFile) {
        try {
            int bufSize = 1024; 
            BufferedInputStream in  = new BufferedInputStream(new FileInputStream(inputFile),bufSize); 
            BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(outputFile), bufSize); 
            int length = 32;  
            byte[] ch = new byte[length]; 
            while((length = in.read(ch))!= -1) { 
                out.write(ch,0,length); 
            } 
            out.flush(); 
            in.close(); 
            out.close(); 
        } catch (IOException ex) {
            JOptionPane.showMessageDialog(this, ex.getMessage(),"IOException", JOptionPane.ERROR_MESSAGE);
        }
    }

    
    public void copierDossier(File d1, File d2){
        if (!d2.isDirectory())
            d2.mkdir();
        File[] liste = d1.listFiles();
        if (liste == null)
            erreur("manque un dossier ? : " + d1.getPath());
        for (int i=0; i<liste.length; i++)
            if (liste[i].isDirectory())
                copierDossier(liste[i], new File(d2, liste[i].getName()));
        for (int i=0; i<liste.length; i++)
            if (!liste[i].isDirectory())
                copierFichier(liste[i], new File(d2, liste[i].getName()));
    }

     
    public void effacerDossier(File d) {
        File[] liste = d.listFiles();
        for (int i=0; i<liste.length; i++)
            if (liste[i].isDirectory()) {
                effacerDossier(liste[i]);
                liste[i] = null;
            }
        for (int i=0; i<liste.length; i++)
            if (liste[i] != null)
                if (!liste[i].delete())
                    System.err.println("Impossible d'effacer le fichier : " + liste[i].getPath());
        if (!d.delete())
            System.err.println("Impossible d'effacer le dossier: " + d.getPath());
    }
    
}