#!/bin/csh

# nettoyage d'un rpertoire d'images (par exemple images-collees) utilis avec Jaxe
# les fichiers du dossier qui ne sont pas rfrencs dans le fichier XML sont automatiquement effacs

# paramtres:
#  -  le fichier XML
#  -  le dossier d'images
#  -  "confirmation" pour vraiment effacer les fichiers (sinon une liste est juste affiche)

set refxsl = "../XSL/references.xsl"

set fichierxml = "$1"
set dossier = "$2"
set confirmation = "$3"

if (!(-f $fichierxml) || !(-d $dossier)) then
	echo "Il manque un paramtre"
	exit 1
endif

set references = `java org.apache.xalan.xslt.Process -in $fichierxml -xsl $refxsl`

set fichiers = `ls $dossier`

foreach f ($fichiers)
	set nomf = "$dossier/$f"
	set trouve = false
	foreach fref ($references)
		if ($nomf == $fref) then
			set trouve = true
		endif
	end
	if ($trouve == true) then
		echo "$f trouv"
	else
		if ($confirmation == "confirmation") then
			echo "$f pas trouv -> EFFACE"
        	rm $nomf
		else
			echo "$f pas trouv -> sera effac si confirmation"
		endif
	endif
end
