<?xml version="1.0" encoding='ISO-8859-1' ?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" encoding="ISO-8859-1"/>

<!-- feuille de style  utiliser sur toutlecours.xml -->
<!-- sortie possible: site/credits.html -->

<xsl:template match="IUFMDOC|UELDOC|DEADOC|MAITRISE|COURS">
	<html>
	<head>
		<title>Liste des figures et des crdits, trie par crdit</title>
	</head>
	
	<body>
		<h1>Liste des figures et des crdits</h1>
		<p><a href="credits.html">Liste trie par page</a></p>
		<p><i><b>Attention: les figures sans crdit seront caches automatiquement</b></i></p>
		<p>Les quations ne doivent normalement pas tre dans des balises FIGURE.</p>
		<p>
		<xsl:for-each select=".//FIGURE/CREDIT[not(preceding::FIGURE/CREDIT = .)]">
			<xsl:sort select="."/>
			<a href="#{.}"><xsl:value-of select="."/></a><xsl:text> - </xsl:text>
		</xsl:for-each>
		</p>
		<table border="1">
			<tr><th>Crdit</th><th>Image</th><th>Titre</th><th>Nom fichier</th><th>Lgende</th><th>page</th></tr>
			<xsl:apply-templates select=".//FIGURE">
				<xsl:sort select="CREDIT"/>
			</xsl:apply-templates>
		</table>
	</body>
	</html>
</xsl:template>

<xsl:template match="FIGURE">
	<tr>
	<xsl:variable name="nomf"><xsl:choose>
		<!--<xsl:when test="@localisation='page' and contains(.//FICHIER[1]/@nom, '.gif')"><xsl:value-of select="concat(substring-before(.//FICHIER[1]/@nom, '.gif'), '.png')"/></xsl:when>-->
		<xsl:when test="contains(.//FICHIER[1]/@nom, '.mng') or .//FICHIER[1]/@type='mpeg'">animation</xsl:when>
		<xsl:otherwise><xsl:value-of select=".//FICHIER[1]/@nom"/></xsl:otherwise>
	</xsl:choose></xsl:variable>
	<xsl:variable name="url"><xsl:call-template name="numerotation"/></xsl:variable>
	<td><a name="{CREDIT}"/><xsl:choose>
		<xsl:when test="CREDIT!=''"><xsl:value-of select="CREDIT"/></xsl:when>
		<xsl:otherwise><font color="#FF0000">Aucun crdit !!!</font></xsl:otherwise>
	</xsl:choose></td>
	<td><a href="{$url}"><xsl:choose>
		<xsl:when test="$nomf = 'animation'">animation</xsl:when>
		<xsl:otherwise><img src="{concat('images/', ancestor::*[@contrib][1]/@contrib, '/', $nomf)}" width="200"/></xsl:otherwise>
	</xsl:choose></a></td>
	<td><xsl:value-of select="@titre"/></td>
	<td><xsl:value-of select=".//FICHIER[1]/@nom"/></td>
	<td><xsl:value-of select="LEGENDE"/></td>
	<td><a href="{$url}"><xsl:number level="multiple" count="CHAPITRE|SOUSCHAPITRE|SECTION|PAGE" format="1_1_1_1"/></a></td>
	</tr>
</xsl:template>

<!--...........................................................................................................................................-->
<!-- numerotation d'un fichier (nom du fichier HTML par rapport  un lment XML,  partir de la base du site) -->
<!-- utilis dans urlLIEN -->
<xsl:template name="numerotation">
	<xsl:choose>
		<xsl:when test="ancestor-or-self::CHAPITRE and not(ancestor-or-self::SOUSCHAPITRE)"><xsl:value-of select="ancestor-or-self::CHAPITRE/@label"/>/index.html</xsl:when>
        
		<xsl:when test="ancestor-or-self::SOUSCHAPITRE and not(ancestor-or-self::SECTION)"><xsl:value-of select="ancestor-or-self::CHAPITRE/@label"/>/<xsl:value-of select="ancestor-or-self::SOUSCHAPITRE/@label"/>/index.html</xsl:when>
        
		<xsl:when test="ancestor-or-self::SECTION and not(ancestor-or-self::PAGE)"><xsl:choose>
            <xsl:when test="ancestor-or-self::INTRODUCTION"><xsl:value-of select="ancestor::CHAPITRE/@label"/>/<xsl:value-of select="ancestor::SOUSCHAPITRE/@label"/>/<xsl:value-of select="ancestor-or-self::SECTION/@label"/>/INTRODUCTION/index.html</xsl:when>
            <xsl:otherwise><xsl:choose>
				<xsl:when test="/UELDOC">
					<xsl:for-each select="PAGE[1]/*[self::OBSERVER or self::APPRENDRE or self::SIMULER or self::SEXERCER or self::SEVALUER]">
					   <xsl:if test="position()=1"><xsl:value-of select="ancestor::CHAPITRE/@label"/>/<xsl:value-of select="ancestor::SOUSCHAPITRE/@label"/>/<xsl:value-of select="ancestor::SECTION/@label"/>/<xsl:value-of select="ancestor::PAGE/@label"/>/<xsl:value-of select="name()"/>.html</xsl:if>
					</xsl:for-each>
				</xsl:when>
				<xsl:otherwise><xsl:value-of select="ancestor::CHAPITRE/@label"/>/<xsl:value-of select="ancestor::SOUSCHAPITRE/@label"/>/<xsl:value-of select="ancestor-or-self::SECTION/@label"/>/<xsl:value-of select="PAGE[1]/@label"/>/index.html</xsl:otherwise>
			</xsl:choose></xsl:otherwise>
        </xsl:choose></xsl:when>
		<xsl:otherwise><xsl:value-of select="ancestor::CHAPITRE/@label"/>/<xsl:value-of select="ancestor::SOUSCHAPITRE/@label"/>/<xsl:value-of select="ancestor::SECTION/@label"/>/<xsl:value-of select="ancestor-or-self::PAGE/@label"/>/<xsl:if test="not((self::FIGURE or self::TABLEAU) and (@localisation='icne')) and not(/UELDOC)">index</xsl:if><xsl:choose>
			<xsl:when test="(self::FIGURE or self::TABLEAU) and (@localisation='page')">
				<xsl:variable name="ntype" select="name()"/>
				
				<xsl:variable name="numfig"><xsl:choose><xsl:when test="/UELDOC"><xsl:number level="any" from="OBSERVER|APPRENDRE|SIMULER|SEXERCER|SEVALUER" count="FIGURE[@localisation='page'] | TABLEAU[@localisation='page']"/></xsl:when><xsl:otherwise><xsl:number level="any" from="PAGE" count="FIGURE[@localisation='page'] | TABLEAU[@localisation='page']"/></xsl:otherwise></xsl:choose></xsl:variable>
				
				<xsl:variable name="countfig"><xsl:choose>
				<xsl:when test="/UELDOC"><xsl:value-of select="count(ancestor::*[contains('|OBSERVER|APPRENDRE|SIMULER|SEXERCER|SEVALUER|',concat('|',name(),'|'))]//*[(self::FIGURE or self::TABLEAU) and @localisation='page'])"/></xsl:when>
				<xsl:otherwise><xsl:value-of select="count(ancestor::PAGE//*[(self::FIGURE or self::TABLEAU) and @localisation='page'])"/></xsl:otherwise>
				</xsl:choose></xsl:variable>
				
				<xsl:if test="/UELDOC"><xsl:value-of select="name(ancestor::OBSERVER | ancestor::APPRENDRE | ancestor::SIMULER | ancestor::SEXERCER | ancestor::SEVALUER)"/></xsl:if>
				<xsl:if test="$countfig>1 and $numfig>1">_<xsl:value-of select="$numfig"/></xsl:if>
			</xsl:when>
            <xsl:when test="self::FIGURE and @localisation='icne'">figure_<xsl:choose>
                    <xsl:when test="@label!=''"><xsl:value-of select="@label"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="translate(substring-before(FICHIER[1]/@nom,'.'),'/','_')"/></xsl:otherwise>
            </xsl:choose><xsl:if test="/UELDOC">_<xsl:value-of select="name(ancestor::OBSERVER | ancestor::APPRENDRE | ancestor::SIMULER | ancestor::SEXERCER | ancestor::SEVALUER)"/></xsl:if></xsl:when>
            <xsl:when test="self::TABLEAU and @localisation='icne'">tableau_<xsl:choose>
                    <xsl:when test="@label!=''"><xsl:value-of select="@label"/></xsl:when>
                    <xsl:otherwise>sanslabel</xsl:otherwise>
            </xsl:choose><xsl:if test="/UELDOC">_<xsl:value-of select="name(ancestor::OBSERVER | ancestor::APPRENDRE | ancestor::SIMULER | ancestor::SEXERCER | ancestor::SEVALUER)"/></xsl:if></xsl:when>
			<xsl:when test="not(self::FIGURE or self::TABLEAU) and parent::PAGE"><xsl:value-of select="name()"/></xsl:when>
			<xsl:otherwise>
				<xsl:if test="/UELDOC"><xsl:value-of select="name(ancestor::OBSERVER | ancestor::APPRENDRE | ancestor::SIMULER | ancestor::SEXERCER | ancestor::SEVALUER)"/></xsl:if>
			</xsl:otherwise>
		</xsl:choose>.html</xsl:otherwise>
	</xsl:choose>
</xsl:template>

</xsl:stylesheet>

