/*
 * Decompiled with CFR 0.152.
 */
package xml;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.UnsupportedEncodingException;
import java.util.Vector;
import xml.Attribute;

public class XMLTree {
    public String tag;
    public Vector attr;
    public String val;
    public XMLTree first_child;
    public XMLTree next_brother;
    public XMLTree father;
    static final String[][] const_ent = new String[][]{{"amp", "&", "&#38;"}, {"lt", "<", "&#60;"}, {"gt", ">", "&#62;"}, {"quot", "\"", "&#34;"}, {"apos", "'", "&#39;"}, {"agrave", "\u00e0", "&#224;"}, {"acirc", "\u00e2", "&#226;"}, {"ccedil", "\u00e7", "&#231;"}, {"egrave", "\u00e8", "&#232;"}, {"eacute", "\u00e9", "&#233;"}, {"ecirc", "\u00ea", "&#234;"}, {"icirc", "\u00ee", "&#238;"}};

    public XMLTree(XMLTree xMLTree, String string, Vector vector, String string2) {
        this.tag = string;
        this.attr = vector;
        this.val = string2;
        this.first_child = null;
        this.next_brother = null;
        this.father = xMLTree;
    }

    public void addChild(XMLTree xMLTree) {
        if (this.first_child == null) {
            this.first_child = xMLTree;
        } else {
            XMLTree xMLTree2 = this.first_child;
            while (xMLTree2.next_brother != null) {
                xMLTree2 = xMLTree2.next_brother;
            }
            xMLTree2.next_brother = xMLTree;
        }
        xMLTree.father = this;
    }

    public XMLTree addChild(String string, Vector vector, String string2) {
        XMLTree xMLTree = new XMLTree(this, string, vector, string2);
        this.addChild(xMLTree);
        return xMLTree;
    }

    public void addBrother(XMLTree xMLTree) {
        if (this.next_brother == null) {
            this.next_brother = xMLTree;
        } else {
            xMLTree.next_brother = this.next_brother;
            this.next_brother = xMLTree;
        }
        xMLTree.father = this.father;
    }

    public XMLTree addBrother(String string, Vector vector, String string2) {
        XMLTree xMLTree = new XMLTree(this.father, string, vector, string2);
        this.addBrother(xMLTree);
        return xMLTree;
    }

    public XMLTree getNode(String string) {
        XMLTree xMLTree = this.first_child;
        while (xMLTree != null) {
            if (xMLTree.tag.equals(string)) {
                return xMLTree;
            }
            xMLTree = xMLTree.next_brother;
        }
        return null;
    }

    public XMLTree getChildAt(int n) {
        XMLTree xMLTree = this.first_child;
        for (int i = 0; xMLTree != null && i < n; ++i) {
            xMLTree = xMLTree.next_brother;
        }
        return xMLTree;
    }

    public void removeChildAt(int n) {
        if (n == 0) {
            XMLTree xMLTree = this.getChildAt(n);
            xMLTree.father.first_child = xMLTree.next_brother;
        } else {
            XMLTree xMLTree = this.getChildAt(n - 1);
            xMLTree.next_brother = this.getChildAt((int)n).next_brother;
        }
    }

    public int getChildrenCount() {
        int n = 0;
        XMLTree xMLTree = this.first_child;
        while (xMLTree != null) {
            ++n;
            xMLTree = xMLTree.next_brother;
        }
        return n;
    }

    public int getLeavesCount() {
        int n = 0;
        XMLTree xMLTree = this.first_child;
        while (xMLTree != null) {
            n = xMLTree.first_child != null ? (n += xMLTree.getLeavesCount()) : ++n;
            xMLTree = xMLTree.next_brother;
        }
        return n;
    }

    public String getAttVal(String string) {
        if (this.attr != null) {
            for (int i = 0; i < this.attr.size(); ++i) {
                if (!((Attribute)this.attr.elementAt((int)i)).name.equals(string)) continue;
                return ((Attribute)this.attr.elementAt((int)i)).val;
            }
        }
        return null;
    }

    public void setAttVal(String string, String string2) {
        if (this.attr != null) {
            boolean bl = false;
            for (int i = 0; i < this.attr.size(); ++i) {
                if (!((Attribute)this.attr.elementAt((int)i)).name.equals(string)) continue;
                ((Attribute)this.attr.elementAt((int)i)).val = string2;
                bl = true;
                break;
            }
            if (!bl) {
                this.attr.addElement(new Attribute(string, string2));
            }
        } else {
            this.attr = new Vector();
            this.attr.addElement(new Attribute(string, string2));
        }
    }

    public void writeTree(OutputStream outputStream, String string) {
        PrintWriter printWriter;
        try {
            printWriter = new PrintWriter(new OutputStreamWriter(outputStream, "ISO-8859-1"));
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            System.err.println(unsupportedEncodingException.getClass().getName() + " : " + unsupportedEncodingException.getMessage());
            return;
        }
        printWriter.println("<?xml version=\"1.0\" encoding=\"ISO-8859-1\"?>");
        if (string != null) {
            printWriter.println("<!DOCTYPE " + string + " system \"" + string + ".dtd\" [");
            for (int i = 0; i < const_ent.length; ++i) {
                printWriter.println("        <!ENTITY " + const_ent[i][0] + "    \"" + const_ent[i][2] + "\">");
            }
            printWriter.println("] >");
        }
        this.writeTree(printWriter);
        printWriter.flush();
    }

    private void writeTree(PrintWriter printWriter) {
        printWriter.print("<" + this.tag);
        if (this.attr != null) {
            for (int i = 0; i < this.attr.size(); ++i) {
                Attribute attribute = (Attribute)this.attr.elementAt(i);
                printWriter.print(" " + attribute.name + "=\"" + this.substEntities(attribute.val) + "\"");
            }
        }
        if (!this.val.equals("") && this.first_child == null) {
            printWriter.print("> " + this.substEntities(this.val));
        } else if (this.val.equals("") && this.first_child == null) {
            printWriter.println("/>");
        } else {
            printWriter.println(">");
        }
        if (!this.val.equals("") || this.first_child != null) {
            XMLTree xMLTree = this.first_child;
            while (xMLTree != null) {
                xMLTree.writeTree(printWriter);
                xMLTree = xMLTree.next_brother;
            }
            if (!this.val.equals("") && this.first_child == null) {
                printWriter.println(" </" + this.tag + ">");
            } else {
                printWriter.println("</" + this.tag + ">");
            }
        }
    }

    private String substEntities(String string) {
        String string2 = new String("");
        for (int i = 0; i < string.length(); ++i) {
            int n;
            char c = string.charAt(i);
            boolean bl = false;
            for (n = 0; n < const_ent.length && !bl; ++n) {
                if (const_ent[n][1].charAt(0) != c) continue;
                bl = true;
            }
            string2 = bl ? string2 + "&" + const_ent[n - 1][0] + ";" : string2 + c;
        }
        return string2;
    }
}

