<?xml version="1.0" encoding='ISO-8859-1' ?>

<!-- feuille de style pour afficher les labels utiliss -->

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xalanredirect="org.apache.xalan.xslt.extensions.Redirect" version="1.0" extension-element-prefixes="xalanredirect">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" encoding="ISO-8859-1"/>

<xsl:template match = "IUFMDOC|UELDOC|DEADOC|COURS">
	<html>
		<head>
			<title>Figures et Tableaux</title>
		</head>
		<body>
			<h1>Figures et Tableaux</h1>
			<xsl:for-each select="//FIGURE | //TABLEAU">
				<xsl:sort select="@label"/>
				<xsl:variable name="type" select="translate(name(),'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz')"/>
				&#xA0;&#xA0;&#xA0;&#xA0;
				<xsl:choose>
					<xsl:when test="@label!=''"><tt><xsl:value-of select="@label"/></tt></xsl:when>
					<xsl:otherwise><i>sans label</i></xsl:otherwise>
				</xsl:choose>
				&#xA0;&#xA0;&#xA0;&#xA0;
				<xsl:value-of select="$type"/>&#xA0;
				<xsl:choose>
					<xsl:when test="@titre!=''">"<xsl:value-of select="@titre"/>"</xsl:when>
					<xsl:otherwise><i>sans titre</i></xsl:otherwise>
				</xsl:choose>
				<xsl:for-each select="ancestor::PAGE">
					dans la page
					<xsl:choose>
						<xsl:when test="@label!=''"><a href="labels.html#page{@label}"><tt><xsl:value-of select="@label"/></tt></a></xsl:when>
						<xsl:otherwise><i>sans label</i></xsl:otherwise>
					</xsl:choose>
					"<xsl:value-of select="@titre"/>"
				</xsl:for-each>
				<br/>
			</xsl:for-each>
		</body>
	</html>
</xsl:template>


</xsl:stylesheet>

