<?xml version="1.0" encoding='ISO-8859-1' ?>

<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xalanredirect="http://xml.apache.org/xalan/redirect" version="1.0" extension-element-prefixes="xalanredirect">
<xsl:output method="xml" indent="yes" encoding="ISO-8859-1"/>
<!--Premire feuille de style XSLT pour le site IUFM Observatoire de Meudon-Paris-->
<xsl:param name="affichage">web</xsl:param> <!-- web ou impression ou jaxe -->
<!--<xsl:param name="systeme">WINDOWS</xsl:param>--> <!-- UNIX ou WINDOWS -->

<xsl:variable name="projet"><xsl:choose>
    <xsl:when test="/IUFMDOC">IUFM</xsl:when>
    <xsl:when test="/UELDOC">UEL</xsl:when>
    <xsl:when test="/DEADOC">DEA</xsl:when>
    <xsl:when test="/MAITRISE">MAITRISE</xsl:when>
    <xsl:when test="/COURS">COURS</xsl:when>
    <xsl:otherwise></xsl:otherwise>
</xsl:choose></xsl:variable>


<xsl:template match = "IUFMDOC|UELDOC|DEADOC|MAITRISE|COURS">
    
    <!--le fichier .bat gener en mode web qui copie les images dans les repertoire images respectif-->
    <xsl:if test="$affichage='web' or $affichage='impression'">
        <!--<xalanredirect:write file="imagespage.xml">-->
        <xalanredirect:write file="images.xml">
            <IMAGES>
            <!--<xsl:for-each select="//FIGURE[@localisation='page' or @localisation='icne']/FICHIER">-->
            <!-- maintenant on met toutes les images -->
            <xsl:for-each select="//FICHIER[@nom!='' and not(starts-with(@nom,'symboles/'))]">
                <xsl:choose>
                <xsl:when test="parent::FIGURE and ../@localisation">
                    <IMAGE nomlocal="{@nom}" contrib="{ancestor::*[@contrib][1]/@contrib}" localisation="{../@localisation}"/>
                </xsl:when>
                <xsl:otherwise>
                    <IMAGE nomlocal="{@nom}" contrib="{ancestor::*[@contrib][1]/@contrib}" localisation="texte"/>
                </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
            </IMAGES>
        </xalanredirect:write>
        <!--<xsl:call-template name="scriptfichiers"/>-->
    </xsl:if>
    
    <!-- la page index -->
    <SITEASM>
    <PROJET><xsl:value-of select="$projet"/></PROJET>
    <xsl:if test="count(APPLETDOC)!=1">
        <PAGEWEB nom="site/index.html">
        <TITREFICHIER>Sommaire ASM/<xsl:value-of select="$projet"/></TITREFICHIER>
        <NIVEAUPAGE>index</NIVEAUPAGE>
        <TYPEPAGE>index</TYPEPAGE>
        <SOMMAIRE>
        <!--<ENTREESOM>
        <TITRE>Le cours</TITRE>
        <LISTESOM>-->
        <xsl:apply-templates select="CHAPITRE">
            <xsl:with-param name="mode">sommaire</xsl:with-param>
            <xsl:with-param name="chapitre">999</xsl:with-param> <!-- aucun chapitre slectionn -->
        </xsl:apply-templates>
        <!--</LISTESOM>
        </ENTREESOM>-->
        <xsl:if test="TP">
            <ENTREESOM>
            <TITRE>Les travaux pratiques</TITRE>
            <URLCLICK>tp1/tp_1.html</URLCLICK>
            <URLFLECHE>tp1/tp_1.html</URLFLECHE>
            <!--
            <LISTESOM>
            <xsl:apply-templates select="TP">
                <xsl:with-param name="mode">sommaire</xsl:with-param>
                <xsl:with-param name="TP">999</xsl:with-param>
            </xsl:apply-templates>
            </LISTESOM>-->
            </ENTREESOM>
        </xsl:if>
        <xsl:if test="APPLETDOC">
            <ENTREESOM>
            <TITRE>Les applets</TITRE>
            <LISTESOM>
                <xsl:apply-templates select="APPLETDOC">
                    <xsl:with-param name="mode">sommaire</xsl:with-param>
                </xsl:apply-templates>
            </LISTESOM>
            </ENTREESOM>
        </xsl:if>
        </SOMMAIRE>
        </PAGEWEB>
    </xsl:if>
    
<!-- ici on commende la cration l'ensemble des pages web du site-->
    <xsl:apply-templates select="CHAPITRE">
        <xsl:with-param name="mode">fichiers</xsl:with-param>
    </xsl:apply-templates>

    <xsl:apply-templates select="TP">
        <xsl:with-param name="mode">fichiers</xsl:with-param>
    </xsl:apply-templates>
    
    <xsl:apply-templates select="APPLETDOC">
        <xsl:with-param name="mode">fichiers</xsl:with-param>
    </xsl:apply-templates>
    
    </SITEASM>
</xsl:template>

<!--...........................................................................................................................................-->
<!-- numerotation d'un fichier (nom du fichier HTML par rapport  un lment XML,  partir de la base du site) -->
<!-- utilis dans urlLIEN -->
<xsl:template name="numerotation">
    <xsl:choose>
        <xsl:when test="self::CHAPITRE"><xsl:value-of select="@label"/>/index.html</xsl:when>
        
        <xsl:when test="self::SOUSCHAPITRE"><xsl:value-of select="../@label"/>/<xsl:value-of select="@label"/>/index.html</xsl:when>
        
        <xsl:when test="self::SECTION"><xsl:choose>
                <xsl:when test="/UELDOC">
                    <xsl:choose>
                    <xsl:when test="INTRODUCTION"><xsl:value-of select="../../@label"/>/<xsl:value-of select="../@label"/>/<xsl:value-of select="@label"/>/INTRODUCTION/index.html</xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="PAGE[1]/*[self::OBSERVER or self::APPRENDRE or self::SIMULER or self::SEXERCER or self::SEVALUER]">
                           <xsl:if test="position()=1"><xsl:value-of select="ancestor::CHAPITRE/@label"/>/<xsl:value-of select="ancestor::SOUSCHAPITRE/@label"/>/<xsl:value-of select="ancestor::SECTION/@label"/>/<xsl:value-of select="ancestor::PAGE/@label"/>/<xsl:value-of select="name()"/>.html</xsl:if>
                        </xsl:for-each>
                    </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise><xsl:value-of select="../../@label"/>/<xsl:value-of select="../@label"/>/<xsl:value-of select="@label"/>/<xsl:value-of select="PAGE[1]/@label"/>/index.html</xsl:otherwise>
            </xsl:choose></xsl:when>
        
        <xsl:otherwise><xsl:value-of select="ancestor::CHAPITRE/@label"/>/<xsl:value-of select="ancestor::SOUSCHAPITRE/@label"/>/<xsl:value-of select="ancestor::SECTION/@label"/>/<xsl:value-of select="ancestor-or-self::PAGE/@label"/>/<xsl:if test="not((self::FIGURE or self::TABLEAU) and (@localisation='icne')) and not(/UELDOC)">index</xsl:if><xsl:choose>
            <xsl:when test="(self::FIGURE or self::TABLEAU) and (@localisation='page')">
                <xsl:variable name="ntype" select="name()"/>
                
                <xsl:variable name="numfig"><xsl:choose><xsl:when test="/UELDOC"><xsl:number level="any" from="OBSERVER|APPRENDRE|SIMULER|SEXERCER|SEVALUER" count="FIGURE[@localisation='page'] | TABLEAU[@localisation='page']"/></xsl:when><xsl:otherwise><xsl:number level="any" from="PAGE" count="FIGURE[@localisation='page'] | TABLEAU[@localisation='page']"/></xsl:otherwise></xsl:choose></xsl:variable>
                
                <xsl:variable name="countfig"><xsl:choose>
                <xsl:when test="/UELDOC"><xsl:value-of select="count(ancestor::*[contains('|OBSERVER|APPRENDRE|SIMULER|SEXERCER|SEVALUER|',concat('|',name(),'|'))]//*[(self::FIGURE or self::TABLEAU) and @localisation='page'])"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="count(ancestor::PAGE//*[(self::FIGURE or self::TABLEAU) and @localisation='page'])"/></xsl:otherwise>
                </xsl:choose></xsl:variable>
                
                <xsl:if test="/UELDOC"><xsl:value-of select="name(ancestor::OBSERVER | ancestor::APPRENDRE | ancestor::SIMULER | ancestor::SEXERCER | ancestor::SEVALUER)"/></xsl:if>
                <xsl:if test="$countfig>1 and $numfig>1">_<xsl:value-of select="$numfig"/></xsl:if>
            </xsl:when>
            <xsl:when test="self::FIGURE and @localisation='icne'">figure_<xsl:choose>
                    <xsl:when test="@label!=''"><xsl:value-of select="@label"/></xsl:when>
                    <xsl:otherwise><xsl:value-of select="translate(substring-before(FICHIER[1]/@nom,'.'),'/','_')"/></xsl:otherwise>
            </xsl:choose><xsl:if test="/UELDOC">_<xsl:value-of select="name(ancestor::OBSERVER | ancestor::APPRENDRE | ancestor::SIMULER | ancestor::SEXERCER | ancestor::SEVALUER)"/></xsl:if></xsl:when>
            <xsl:when test="self::TABLEAU and @localisation='icne'">tableau_<xsl:choose>
                    <xsl:when test="@label!=''"><xsl:value-of select="@label"/></xsl:when>
                    <xsl:otherwise>sanslabel</xsl:otherwise>
            </xsl:choose><xsl:if test="/UELDOC">_<xsl:value-of select="name(ancestor::OBSERVER | ancestor::APPRENDRE | ancestor::SIMULER | ancestor::SEXERCER | ancestor::SEVALUER)"/></xsl:if></xsl:when>
            <xsl:when test="not(self::FIGURE or self::TABLEAU) and parent::PAGE"><xsl:value-of select="name()"/></xsl:when>
            <xsl:otherwise>
                <xsl:if test="/UELDOC"><xsl:value-of select="name(ancestor::OBSERVER | ancestor::APPRENDRE | ancestor::SIMULER | ancestor::SEXERCER | ancestor::SEVALUER)"/></xsl:if>
            </xsl:otherwise>
        </xsl:choose>.html</xsl:otherwise>
    </xsl:choose>
</xsl:template>

<!--...........................................................................................................................................-->
<!-- creation d'un script pour copier les images dans les sous-repertoires -->

<!--
<xsl:template name="scriptfichiers">
    <xsl:variable name="nomfichier">
        <xsl:choose>
            <xsl:when test="$systeme='WINDOWS'">images.bat</xsl:when>
            <xsl:when test="$systeme='UNIX'">images.sh</xsl:when>
        </xsl:choose>
    </xsl:variable>
    <xalanredirect:write file="{$nomfichier}">
        <xsl:if test="$systeme='UNIX'">
#!/bin/sh
        </xsl:if>
        <xsl:for-each select="/*/CHAPITRE//FICHIER[@nom!='' and not(starts-with(@nom,'symboles/'))] | /*/TP//FICHIER[@nom!='' and not(starts-with(@nom,'symboles/'))]">
            <xsl:variable name="contrib" select="ancestor::*[@contrib][1]/@contrib"/>
            <xsl:choose>
            <xsl:when test="$systeme='WINDOWS'">
                <xsl:variable name="nom">
                    <xsl:value-of select="translate(@nom,'/','\')"/>
                </xsl:variable>
                xcopy contribXML\<xsl:value-of select="$contrib"/>\<xsl:value-of select="$nom"/> site\images\<xsl:value-of select="$contrib"/>\<xsl:value-of select="$nom"/>
            </xsl:when>
            <xsl:when test="$systeme='UNIX'">
                <xsl:variable name="nouveaunom">site/images/<xsl:value-of select="$contrib"/>/<xsl:value-of select="@nom"/></xsl:variable>
mkdir -p `dirname "<xsl:value-of select="$nouveaunom"/>"`
cp "contribXML/<xsl:value-of select="$contrib"/>/<xsl:value-of select="@nom"/>" "<xsl:value-of select="$nouveaunom"/>"
            </xsl:when>
            </xsl:choose>
        </xsl:for-each>
    </xalanredirect:write>
</xsl:template>
-->
<!--...........................................................................................................................................-->

<!--creation des pages chapitre-->
<!-- le noeud courant doit etre le CHAPITRE -->
<xsl:template name="PAGECHAPITRE">
<xsl:param name="mode"></xsl:param>
<xsl:param name="chapitre"></xsl:param>
<xsl:variable name="prefixe">../</xsl:variable>

<PREFIXE><xsl:value-of select="$prefixe"/></PREFIXE>
<NIVEAUPAGE>chapitre</NIVEAUPAGE>
<TYPEPAGE>PAGE</TYPEPAGE>
<LABELCHAPITRE><xsl:value-of select="$chapitre"/></LABELCHAPITRE>

<xsl:choose>
<xsl:when test="INTRODUCTION">
    <xsl:call-template name="NAVIGATION">
        <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
        <xsl:with-param name="increment">-1</xsl:with-param>
    </xsl:call-template>
    <xsl:for-each select="INTRODUCTION">
        <xsl:call-template name="NAVIGATION">
            <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
            <xsl:with-param name="increment">1</xsl:with-param>
        </xsl:call-template>
    </xsl:for-each>
</xsl:when>
<xsl:otherwise>
    <xsl:call-template name="NAVIGATION">
        <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
    </xsl:call-template>
</xsl:otherwise>
</xsl:choose>

<!--Sommaire des pages chapitre-->
<SOMMAIRE>
<xsl:apply-templates select="//CHAPITRE">
    <xsl:with-param name="mode">sommaire</xsl:with-param>
    <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
    <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
</xsl:apply-templates>
</SOMMAIRE>

<xsl:if test="@titre">
    <TITREPAGE><xsl:value-of select="@titre"/></TITREPAGE>
</xsl:if>

<!--contenu de la page prerequis+resume+introduction-->
<ZONETEXTE>
<xsl:apply-templates select="PREREQUIS"/>
<xsl:apply-templates select="RESUME"/>
<xsl:apply-templates select="INTRODUCTION">
    <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
    <xsl:with-param name="illustration"><xsl:value-of select="position()"/></xsl:with-param>
    <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
    <xsl:with-param name="mode">base</xsl:with-param>
</xsl:apply-templates>
</ZONETEXTE>
</xsl:template>


<!--...........................................................................................................................................-->

<!-- Cration des pages sous chapitre -->
<!-- le noeud courant doit etre le SOUSCHAPITRE -->
<xsl:template name="PAGESOUSCHAPITRE">
<xsl:param name="mode"></xsl:param>
<xsl:param name="chapitre"></xsl:param>
<xsl:param name="souschapitre"></xsl:param>
<xsl:variable name="prefixe">../../</xsl:variable>

<PREFIXE><xsl:value-of select="$prefixe"/></PREFIXE>
<NIVEAUPAGE>souschapitre</NIVEAUPAGE>
<TYPEPAGE>PAGE</TYPEPAGE>
<LABELSOUSCHAPITRE><xsl:value-of select="$souschapitre"/></LABELSOUSCHAPITRE>
<LABELCHAPITRE><xsl:value-of select="$chapitre"/></LABELCHAPITRE>

<!-- l'intro fait maintenant page  part -->
<xsl:choose>
<xsl:when test="INTRODUCTION and not(PREREQUIS or RESUME or OBJECTIFS or INTRODUCTION//FIGURE[@localisation='page'])">
    <xsl:call-template name="NAVIGATION">
        <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
        <xsl:with-param name="increment">-1</xsl:with-param>
    </xsl:call-template>
    <xsl:for-each select="INTRODUCTION">
        <xsl:call-template name="NAVIGATION">
            <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
            <xsl:with-param name="increment">1</xsl:with-param>
        </xsl:call-template>
    </xsl:for-each>
</xsl:when>
<xsl:otherwise>
    <xsl:call-template name="NAVIGATION">
        <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
    </xsl:call-template>
</xsl:otherwise>
</xsl:choose>

    <!--Sommaire des pages sous chapitre-->
<SOMMAIRE>
<xsl:apply-templates select="//CHAPITRE">
    <xsl:with-param name="mode">sommaire</xsl:with-param>
    <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
    <xsl:with-param name="souschapitre"><xsl:value-of select="$souschapitre"/></xsl:with-param>
    <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
</xsl:apply-templates>
</SOMMAIRE>

<!--le contenu de la page -->
<xsl:apply-templates select="AUTEUR"/>
<xsl:apply-templates select="DATECRE"/>
<xsl:apply-templates select="DATEMAJ"/>

<!-- pour les TPs -->
<xsl:apply-templates select="TEMPS"/>
<xsl:apply-templates select="NIVEAU"/>
<xsl:apply-templates select="CHAMP"/>

<xsl:if test="@titre">
    <TITREPAGE><xsl:value-of select="@titre"/></TITREPAGE>
</xsl:if>

<ZONETEXTE>
<xsl:apply-templates select="OBJECTIFS"/>
<xsl:apply-templates select="PREREQUIS"/>
<xsl:apply-templates select="RESUME"/>
<xsl:if test="INTRODUCTION and not(PREREQUIS or RESUME or OBJECTIFS or INTRODUCTION//FIGURE[@localisation='page'])">
    <xsl:apply-templates select="INTRODUCTION">
        <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
        <xsl:with-param name="souschapitre"><xsl:value-of select="$souschapitre"/></xsl:with-param>
        <xsl:with-param name="illustration"><xsl:value-of select="position()"/></xsl:with-param>
        <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
        <xsl:with-param name="mode">base</xsl:with-param>
    </xsl:apply-templates>
</xsl:if>
</ZONETEXTE>
</xsl:template>

<!--...........................................................................................................................................-->

<!--creation des pages section (pour la coquille UEL)-->
<!-- les introductions de sections sont dans des pages spares -->
<xsl:template name="PAGESECTION">

<xsl:param name="mode"></xsl:param>
<xsl:param name="chapitre"></xsl:param>
<xsl:param name="souschapitre"></xsl:param>
<xsl:param name="section"></xsl:param>
<xsl:variable name="prefixe">../../../</xsl:variable>

<PREFIXE><xsl:value-of select="$prefixe"/></PREFIXE>
<NIVEAUPAGE>section</NIVEAUPAGE>
<TYPEPAGE>PAGE</TYPEPAGE>
<LABELSECTION><xsl:value-of select="$section"/></LABELSECTION>
<LABELSOUSCHAPITRE><xsl:value-of select="$souschapitre"/></LABELSOUSCHAPITRE>
<LABELCHAPITRE><xsl:value-of select="$chapitre"/></LABELCHAPITRE>

<xsl:call-template name="NAVIGATION">
    <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
</xsl:call-template>

<SOMMAIRE>
<xsl:apply-templates select="//CHAPITRE">
    <xsl:with-param name="mode">sommaire</xsl:with-param>
    <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
    <xsl:with-param name="souschapitre"><xsl:value-of select="$souschapitre"/></xsl:with-param>
    <xsl:with-param name="section"><xsl:value-of select="$section"/></xsl:with-param>
    <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
</xsl:apply-templates>
</SOMMAIRE>

<xsl:apply-templates select="AUTEUR"/>
<xsl:apply-templates select="DATECRE"/>
<xsl:apply-templates select="DATEMAJ"/>

<xsl:if test="@titre">
    <TITREPAGE><xsl:value-of select="@titre"/></TITREPAGE>
</xsl:if>

</xsl:template>

<!--...........................................................................................................................................-->
<!-- type de la page -->
<xsl:template name="typepage"><xsl:choose>
        <xsl:when test="(substring-before(@label,'-')='hst') or (@type='historique')">historique</xsl:when>
        <xsl:when test="(substring-before(@label,'-')='ens') or (@type='ensavoirplus')">ensavoirplus</xsl:when>
        <xsl:when test="self::PAGE and (EXERCICE or QCM)">exercice</xsl:when>
        <xsl:otherwise>normal</xsl:otherwise>
</xsl:choose></xsl:template>

<!--...........................................................................................................................................-->

<!--fleches page suivante/precedente et icne historique a partir d'une page donne-->
<xsl:template name="NAVIGATION">
<xsl:param name="prefixe">../../../../</xsl:param>
<xsl:param name="increment"></xsl:param> <!-- 1 pour la page suivante, -1 pour la page prcdente, rien pour avoir les deux -->
<!-- attention, pour xalan, +1 != 1 (mme convertis en nombres) -->
<xsl:param name="cherchepage">non</xsl:param> <!-- 'oui' si on cherche la premire page non historique -->

<xsl:variable name="typage"><xsl:call-template name="typepage"/></xsl:variable>

<xsl:variable name="balisespage"><xsl:choose>
    <xsl:when test="/UELDOC">|CHAPITRE|SOUSCHAPITRE|OBSERVER|APPRENDRE|SIMULER|SEXERCER|SEVALUER|INTRODUCTION|CONCLUSION|</xsl:when>
    <xsl:otherwise>|CHAPITRE|SOUSCHAPITRE|PAGE|INTRODUCTION|CONCLUSION|DOCUMENTS|BIBLIOGRAPHIE|CONSEILS|</xsl:otherwise>
</xsl:choose></xsl:variable>

<xsl:variable name="num">
    <xsl:number level="any" count="*[contains($balisespage,concat('|',name(),'|')) and (not(ancestor::PAGE) or self::OBSERVER or self::APPRENDRE or self::SIMULER or self::SEXERCER or self::SEVALUER)]"/>
</xsl:variable>

<!--
<xsl:message>
dpart:<xsl:value-of select="@label"/>: <xsl:number level="multiple" count="CHAPITRE|SOUSCHAPITRE|SECTION|PAGE" format="1/1/1/1"/>
</xsl:message>
-->
<xsl:for-each select="//*[contains($balisespage,concat('|',name(),'|')) and (not(ancestor::PAGE) or self::OBSERVER or self::APPRENDRE or self::SIMULER or self::SEXERCER or self::SEVALUER)]">
    <xsl:variable name="num2"><xsl:number level="any" count="*[contains($balisespage,concat('|',name(),'|')) and (not(ancestor::PAGE) or self::OBSERVER or self::APPRENDRE or self::SIMULER or self::SEXERCER or self::SEVALUER)]"/></xsl:variable>
    <xsl:if test="number($num2)=number($num)-1 and ($increment='' or number($increment)=-1)">
        <xsl:call-template name="NAVIGATIONSUITE">
            <xsl:with-param name="increment">-1</xsl:with-param>
            <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
            <xsl:with-param name="typage"><xsl:value-of select="$typage"/></xsl:with-param>
            <xsl:with-param name="cherchepage"><xsl:value-of select="$cherchepage"/></xsl:with-param>
        </xsl:call-template>
    </xsl:if>
    <xsl:if test="number($num2)=number($num)+1 and ($increment='' or number($increment)=1)">
        <xsl:call-template name="NAVIGATIONSUITE">
            <xsl:with-param name="increment">1</xsl:with-param>
            <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
            <xsl:with-param name="typage"><xsl:value-of select="$typage"/></xsl:with-param>
            <xsl:with-param name="cherchepage"><xsl:value-of select="$cherchepage"/></xsl:with-param>
        </xsl:call-template>
    </xsl:if>
</xsl:for-each>
</xsl:template>

<!-- le noeud courant est maintenant la page suivante ou prcdente (sans tenir compte des exercices) -->
<xsl:template name="NAVIGATIONSUITE">
<xsl:param name="prefixe"/>
<xsl:param name="increment"/> <!-- 1 pour la page suivante, -1 pour la page prcdente -->
<xsl:param name="typage">normal</xsl:param>
<xsl:param name="cherchepage">non</xsl:param>


    <xsl:variable name="nchapitre" select="string(ancestor-or-self::CHAPITRE/@label)"/>
    <xsl:variable name="nsouschapitre" select="string(ancestor-or-self::SOUSCHAPITRE/@label)"/>
    <xsl:variable name="nsection" select="string(ancestor-or-self::SECTION/@label)"/>
    <xsl:variable name="npage" select="string(ancestor-or-self::PAGE/@label)"/>
    <xsl:variable name="nbalise" select="name()"/>

<!--
<xsl:message>
NAVIGATIONSUITE-> page <xsl:value-of select="concat($increment, ': ', $nbalise,'  ',$nchapitre,'/',$nsouschapitre,'/',$nsection,'/',$npage)"/>
</xsl:message>
-->

    <xsl:variable name="href"><xsl:choose>
        <!--si la page est une introduction/conclusion/autre de section -->
        <xsl:when test="$npage='' and $nsection!='' and $nbalise!='PAGE'">
            <xsl:value-of select="concat($prefixe,$nchapitre,'/',$nsouschapitre,'/',$nsection,'/',$nbalise,'/index.html')"/>
        </xsl:when>
        <!--si la page est un truc dans une page (comme OBSERVER)-->
        <xsl:when test="$npage!='' and $nsection!='' and $nbalise!='PAGE'">
            <xsl:value-of select="concat($prefixe,$nchapitre,'/',$nsouschapitre,'/',$nsection,'/',$npage,'/',$nbalise,'.html')"/>
        </xsl:when>
        <!--si la page est une intro/conclu/autre de souschapitre-->
        <xsl:when test="$npage='' and $nsection='' and $nsouschapitre!='' and ($nbalise='INTRODUCTION' or $nbalise='CONCLUSION' or $nbalise='DOCUMENTS' or $nbalise='BIBLIOGRAPHIE' or $nbalise='CONSEILS')">
            <xsl:choose>
                <!-- introduction de sous-chapitre -> page du sous-chapitre dans certains cas -->
                <xsl:when test="$nbalise='INTRODUCTION' and not(../PREREQUIS or ../RESUME or ../OBJECTIFS or .//FIGURE[@localisation='page'])">
                    <xsl:value-of select="concat($prefixe,$nchapitre,'/',$nsouschapitre,'/index.html')"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat($prefixe,$nchapitre,'/',$nsouschapitre,'/',$nbalise,'/index.html')"/>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:when>
        <!--si la page est un souschapitre -->
        <xsl:when test="$npage='' and $nsection='' and $nsouschapitre!='' and $nbalise='SOUSCHAPITRE'">
            <xsl:value-of select="concat($prefixe,$nchapitre,'/',$nsouschapitre,'/index.html')"/>
        </xsl:when>
        <!--si la page est un chapitre ou une introduction de chapitre-->
        <xsl:when test="$npage='' and $nsection='' and $nsouschapitre='' and $nchapitre!='' and ($nbalise='CHAPITRE' or $nbalise='INTRODUCTION')">
            <xsl:value-of select="concat($prefixe,$nchapitre,'/index.html')"/>
        </xsl:when>
        <!--dans le cas ordinaire-->
        <xsl:when test="$npage!='' and $nsection!='' and $nsouschapitre!='' and $nchapitre!=''">
            <xsl:value-of select="concat($prefixe,$nchapitre,'/',$nsouschapitre,'/',$nsection,'/',$npage,'/index.html')"/>
        </xsl:when>
    </xsl:choose></xsl:variable>
    
    <xsl:variable name="typage2"><xsl:call-template name="typepage"/></xsl:variable>
    <xsl:choose>
        <!-- lien vers la page si elle est normale ou si elle est de mme type que la page actuelle mais qu'on ne
            cherche pas une page normale -->
        <xsl:when test="$npage='' or $typage2='normal' or ($cherchepage='non' and $typage2=$typage)">
            <xsl:if test="$href!=''">
                <xsl:if test="number($increment)=1">
                    <PAGESUIVANTE>
                        <URL><xsl:value-of select="$href"/></URL>
                    </PAGESUIVANTE>
                </xsl:if>
                <xsl:if test="number($increment)=-1">
                    <PAGEPRECEDENTE>
                        <URL><xsl:value-of select="$href"/></URL>
                    </PAGEPRECEDENTE>
                </xsl:if>
            </xsl:if>

        </xsl:when>
        <!-- lien vers la page spciale + lien vers la prochaine page normale -->
        <xsl:otherwise>
            <!-- Un lien apparait avec un icone historique vers la premiere page de la serie de pages historique-->
            <xsl:if test="number($increment)=1 and $cherchepage='non' and $typage2!='normal'">
                <xsl:if test="$href!=''">
                    <AUTRELIEN vers="{$typage2}">
                        <URL><xsl:value-of select="$href"/></URL>
                    </AUTRELIEN>
                </xsl:if>
            </xsl:if>
        
            <xsl:call-template name="NAVIGATION">
                <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
                <xsl:with-param name="increment"><xsl:value-of select="$increment"/></xsl:with-param>
                <xsl:with-param name="cherchepage">oui</xsl:with-param>
            </xsl:call-template>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<!--...........................................................................................................................................-->

<!--cration des pages PAGE, INTRODUCTION, ...-->
<!-- le noeud courant doit etre la page ou un descendant de PAGE -->
<xsl:template name="PAGEPAGE">
<xsl:param name="chapitre"></xsl:param>
<xsl:param name="souschapitre"></xsl:param>
<xsl:param name="section"></xsl:param>
<xsl:param name="page"></xsl:param>
<xsl:param name="illustration">0</xsl:param>
<xsl:param name="prefixe">../../../../</xsl:param>
<xsl:param name="balise">PAGE</xsl:param>


<PREFIXE><xsl:value-of select="$prefixe"/></PREFIXE>
<NIVEAUPAGE>page</NIVEAUPAGE>
<TYPEPAGE><xsl:value-of select="$balise"/></TYPEPAGE>

<xsl:if test="parent::PAGE and /UELDOC">
    <THEMEUEL><xsl:value-of select="name()"/></THEMEUEL>
</xsl:if>
<xsl:if test="$page!=''">
    <NUMEROPAGE><xsl:number count="PAGE"/></NUMEROPAGE>
    <LABELPAGE><xsl:value-of select="$page"/></LABELPAGE>
</xsl:if>
<LABELSECTION><xsl:value-of select="$section"/></LABELSECTION>
<LABELSOUSCHAPITRE><xsl:value-of select="$souschapitre"/></LABELSOUSCHAPITRE>
<LABELCHAPITRE><xsl:value-of select="$chapitre"/></LABELCHAPITRE>
<ILLUSTRATION><xsl:value-of select="$illustration"/></ILLUSTRATION>

<xsl:if test="self::PAGE">
    <TOTALPAGES><xsl:value-of select="count(../PAGE)"/></TOTALPAGES>
</xsl:if>

<!--Il y a un menu de navigation(fleche droite-gauche) au dessus du sommaire du site-->
<xsl:call-template name="NAVIGATION">
    <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
</xsl:call-template>

<xsl:if test="$affichage='web'">
<SOMMAIRE>
    <xsl:apply-templates select="//CHAPITRE">
        <xsl:with-param name="mode">sommaire</xsl:with-param>
        <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
        <xsl:with-param name="souschapitre"><xsl:value-of select="$souschapitre"/></xsl:with-param>
        <xsl:with-param name="section"><xsl:value-of select="$section"/></xsl:with-param>
        <xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
        <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
        <!--<xsl:if test="$balise!='PAGE'">-->
            <xsl:with-param name="selection"><xsl:value-of select="$balise"/>_<xsl:value-of select="$chapitre"/>_<xsl:value-of select="$souschapitre"/>_<xsl:value-of select="$section"/></xsl:with-param>
        <!--</xsl:if>-->
    </xsl:apply-templates>
</SOMMAIRE>
</xsl:if>

<xsl:call-template name="imagettes">
    <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
    <xsl:with-param name="souschapitre"><xsl:value-of select="$souschapitre"/></xsl:with-param>
    <xsl:with-param name="section"><xsl:value-of select="$section"/></xsl:with-param>
    <xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
    <xsl:with-param name="illustration"><xsl:value-of select="$illustration"/></xsl:with-param>
</xsl:call-template>

<!-- AUTEUR et DATE importants pour les introductions de SECTION -->
<xsl:if test="$balise='INTRODUCTION'">
    <xsl:apply-templates select="../AUTEUR"/>
    <xsl:apply-templates select="../DATE"/>
    <xsl:apply-templates select="../NIVEAULMD"/>
</xsl:if>

<xsl:if test="parent::PAGE and /UELDOC">
    <xsl:apply-templates select="../NIVEAULMD"/>
</xsl:if>

<xsl:if test="$affichage='web' and (.//FIGURE[@localisation='page'] | .//TABLEAU[@localisation='page'])">
    <ZONEFIGURES>
        <!--l'image centrale avec son commentaire--> 
        <xsl:call-template name="imagecentre">
            <xsl:with-param name="illustration"><xsl:value-of select="$illustration"/></xsl:with-param>
        </xsl:call-template>
    </ZONEFIGURES>
</xsl:if>

<xsl:if test="ancestor-or-self::PAGE">
    <TITREPAGE><xsl:value-of select="ancestor-or-self::PAGE/@titre"/></TITREPAGE>
    <TITRESECTION><xsl:value-of select="ancestor-or-self::SECTION/@titre"/></TITRESECTION>
</xsl:if>

<xsl:if test="not(ancestor-or-self::PAGE) and ../@titre!=''">
    <TITRESECTION><xsl:value-of select="../@titre"/></TITRESECTION>
</xsl:if>

<!--contenu texte de la page-->
<xsl:if test="$affichage='web' or $illustration=1 ">
    <ZONETEXTE>
        <xsl:apply-templates select="."><xsl:with-param name="mode">base</xsl:with-param><xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param></xsl:apply-templates>
    </ZONETEXTE>
</xsl:if>

<xsl:if test="parent::PAGE and /UELDOC">
    <PAGESUEL>
        <xsl:variable name="courant" select="name()"/>
        <xsl:for-each select="../OBSERVER | ../APPRENDRE | ../SIMULER | ../SEXERCER | ../SEVALUER">
            <PARTIEUEL selection="{$courant=name()}">
                <TITRE><xsl:choose>
                <xsl:when test="self::OBSERVER">Observer</xsl:when>
                <xsl:when test="self::APPRENDRE">Apprendre</xsl:when>
                <xsl:when test="self::SIMULER">Simuler</xsl:when>
                <xsl:when test="self::SEXERCER">S'exercer</xsl:when>
                <xsl:when test="self::SEVALUER">S'valuer</xsl:when>
                </xsl:choose></TITRE>
                <URL><xsl:value-of select="name()"/>.html</URL>
            </PARTIEUEL>
        </xsl:for-each>
    </PAGESUEL>
</xsl:if>
</xsl:template>

<!--...........................................................................................................................................-->

<!--GESTION DES CHAPITRE-->
<xsl:template match="CHAPITRE">
<xsl:param name="prefixe"></xsl:param>
<xsl:param name="mode"></xsl:param>
<xsl:param name="chapitre"><xsl:value-of select="@label"/></xsl:param>
<xsl:param name="souschapitre"></xsl:param>
<xsl:param name="section"></xsl:param>
<xsl:param name="page"></xsl:param>
<xsl:param name="selection"></xsl:param>

<xsl:choose>
    <!--crer les fichiers chapitresxx.html, appeler la cration des fichier souschapitrexxx.html, intro et conclu-->
    <xsl:when test="$mode='fichiers' ">
        <xsl:variable name="fichier">site/<xsl:value-of select="$chapitre"/>/index.html</xsl:variable>
<xsl:text disable-output-escaping="yes">
</xsl:text>
        <PAGEWEB nom="{$fichier}">
            <xsl:if test="@contrib">
                <CONTRIB><xsl:value-of select="@contrib"/></CONTRIB>
            </xsl:if>
            <TITREFICHIER>Chapitre '<xsl:value-of select="@titre"/>'</TITREFICHIER>
            <xsl:call-template name="PAGECHAPITRE">
                <xsl:with-param name="mode"><xsl:value-of select="$mode"/></xsl:with-param>
                <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
                <xsl:with-param name="souschapitre"><xsl:value-of select="$souschapitre"/></xsl:with-param>
                <xsl:with-param name="section"><xsl:value-of select="$section"/></xsl:with-param>
                <xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
            </xsl:call-template>
        </PAGEWEB>
        <xsl:apply-templates select="SOUSCHAPITRE">
            <xsl:with-param name="mode"><xsl:value-of select="$mode"/></xsl:with-param>
            <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
        </xsl:apply-templates>
<!-- l'introduction est dj dans la page du chapitre
        <xsl:apply-templates select="./INTRODUCTION">
            <xsl:with-param name="mode"><xsl:value-of select="$mode"/></xsl:with-param>
            <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
            <xsl:with-param name="prefixe">../../</xsl:with-param>
        </xsl:apply-templates>
-->
        <xsl:apply-templates select="./CONCLUSION">
            <xsl:with-param name="mode"><xsl:value-of select="$mode"/></xsl:with-param>
            <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
            <xsl:with-param name="prefixe">../../</xsl:with-param>
        </xsl:apply-templates>
    </xsl:when>
    
    <!--cration du sommaire des chapitre-->
    <xsl:when test="$mode='sommaire'">
        <!-- @label=$chapitre signifie que l'entre du sommaire est dplie -->
        <!-- $prefixe='../' signifie que le chapitre est slectionn (parce-qu'une page section de ce chapitre est affiche) -->
        <xsl:variable name="lien"><xsl:value-of select="$prefixe"/><xsl:value-of select="@label"/>/index.html</xsl:variable>
        <xsl:choose>
            <xsl:when test="@label=$chapitre or $affichage!='web'">
                <ENTREESOM selection="{$prefixe='../'}">
                    <TITRE><xsl:value-of select="@titre"/></TITRE>
                    <URLFLECHE><xsl:value-of select="concat($prefixe,'index.html')"/></URLFLECHE>
                    <URLCLICK><xsl:value-of select="$lien"/></URLCLICK>
                    <xsl:if test="SOUSCHAPITRE">
                        <LISTESOM>
                            <xsl:apply-templates select="SOUSCHAPITRE">
                                <xsl:with-param name="mode"><xsl:value-of select="$mode"/></xsl:with-param>
                                <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
                                <xsl:with-param name="souschapitre"><xsl:value-of select="$souschapitre"/></xsl:with-param>
                                <xsl:with-param name="section"><xsl:value-of select="$section"/></xsl:with-param>
                                <xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
                                <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
                                <xsl:with-param name="selection"><xsl:value-of select="$selection"/></xsl:with-param>
                            </xsl:apply-templates>
                        </LISTESOM>
                    </xsl:if>
                </ENTREESOM>
            </xsl:when>
            <xsl:otherwise>
                <xsl:if test="$prefixe=''">
                    <ENTREESOM selection="false">
                        <TITRE><xsl:value-of select="@titre"/></TITRE>
                        <URLFLECHE><xsl:value-of select="$lien"/></URLFLECHE>
                        <URLCLICK><xsl:value-of select="$lien"/></URLCLICK>
                    </ENTREESOM>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:when>
</xsl:choose>
</xsl:template>

<!--...........................................................................................................................................-->

<!--GESTION DES SOUSCHAPITRE-->
<xsl:template match="SOUSCHAPITRE">
<xsl:param name="prefixe"></xsl:param>
<xsl:param name="mode"></xsl:param>
<xsl:param name="chapitre"></xsl:param>
<xsl:param name="souschapitre"><xsl:value-of select="@label"/></xsl:param>
<xsl:param name="section"></xsl:param>
<xsl:param name="page"></xsl:param>
<xsl:param name="selection"></xsl:param>

<xsl:choose>
    <!--cration des pages souschapitre, appal a la creation des pages section conclusion et intro des souschap-->
    <xsl:when test="$mode='fichiers' and @label != 'glossaire'">
        <xsl:variable name="fichier">site/<xsl:value-of select="$chapitre"/>/<xsl:value-of select="@label"/>/index.html</xsl:variable>
<xsl:text disable-output-escaping="yes">
</xsl:text>
        <PAGEWEB nom="{$fichier}">
            <CONTRIB><xsl:value-of select="ancestor-or-self::*[@contrib][1]/@contrib"/></CONTRIB>
            <TITREFICHIER>Sous-chapitre '<xsl:value-of select="@titre"/>'</TITREFICHIER>
            <xsl:call-template name="PAGESOUSCHAPITRE">
                <xsl:with-param name="mode"><xsl:value-of select="$mode"/></xsl:with-param>
                <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
                <xsl:with-param name="souschapitre"><xsl:value-of select="$souschapitre"/></xsl:with-param>
                <xsl:with-param name="section"><xsl:value-of select="$section"/></xsl:with-param>
                <xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
            </xsl:call-template>
        </PAGEWEB>
        <xsl:for-each select="INTRODUCTION[../PREREQUIS or ../RESUME or ../OBJECTIFS or .//FIGURE[@localisation='page']] | DOCUMENTS | SECTION | CONSEILS | CONCLUSION | BIBLIOGRAPHIE">
            <xsl:variable name="pref2">../../../<xsl:if test="self::SECTION">../</xsl:if></xsl:variable>
            <xsl:apply-templates select=".">
                <xsl:with-param name="mode"><xsl:value-of select="$mode"/></xsl:with-param>
                <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
                <xsl:with-param name="souschapitre"><xsl:value-of select="$souschapitre"/></xsl:with-param>
                <xsl:with-param name="prefixe"><xsl:value-of select="$pref2"/></xsl:with-param>
            </xsl:apply-templates>
        </xsl:for-each>
    </xsl:when>
    <!--sommaire-->
    <xsl:when test="$mode='sommaire' and @label != 'glossaire'">
        <xsl:variable name="lien" select="concat($prefixe,$chapitre,'/',@label,'/index.html')"/>
        <xsl:choose>
            <xsl:when test="@label=$souschapitre or $affichage!='web'">
                <ENTREESOM selection="{$prefixe='../../'}">
                    <TITRE><xsl:value-of select="@titre"/></TITRE>
                    <URLFLECHE><xsl:value-of select="concat($prefixe,$chapitre,'/index.html')"/></URLFLECHE>
                    <URLCLICK><xsl:value-of select="$lien"/></URLCLICK>
                    <xsl:if test="INTRODUCTION | DOCUMENTS | SECTION | CONSEILS | CONCLUSION | BIBLIOGRAPHIE">
                        <LISTESOM>
                            <xsl:apply-templates select="INTRODUCTION[../PREREQUIS or ../RESUME or ../OBJECTIFS or .//FIGURE[@localisation='page']] | DOCUMENTS | SECTION | CONSEILS | CONCLUSION | BIBLIOGRAPHIE">
                                <xsl:with-param name="mode"><xsl:value-of select="$mode"/></xsl:with-param>
                                <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
                                <xsl:with-param name="souschapitre"><xsl:value-of select="$souschapitre"/></xsl:with-param>
                                <xsl:with-param name="section"><xsl:value-of select="$section"/></xsl:with-param>
                                <xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
                                <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
                                <xsl:with-param name="selection"><xsl:value-of select="$selection"/></xsl:with-param>
                            </xsl:apply-templates>
                        </LISTESOM>
                    </xsl:if>
                </ENTREESOM>
            </xsl:when>
            <xsl:otherwise>
                <xsl:if test="$prefixe='' or $prefixe='../'">
                    <!-- l'introduction est dj dans la page du sous-chapitre
                    <xsl:if test="position()=1">
                    <xsl:apply-templates select="../INTRODUCTION">
                        <xsl:with-param name="mode">sommaire</xsl:with-param>
                        <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
                        <xsl:with-param name="souschapitre"><xsl:value-of select="$souschapitre"/></xsl:with-param>
                        <xsl:with-param name="section"><xsl:value-of select="$section"/></xsl:with-param>
                        <xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
                        <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
                        <xsl:with-param name="selection"><xsl:value-of select="$selection"/></xsl:with-param>
                    </xsl:apply-templates>
                    </xsl:if>
                    -->
                    <ENTREESOM selection="false">
                        <TITRE><xsl:value-of select="@titre"/></TITRE>
                        <URLFLECHE><xsl:value-of select="$lien"/></URLFLECHE>
                        <URLCLICK><xsl:value-of select="$lien"/></URLCLICK>
                    </ENTREESOM>
                    <xsl:if test="position()=last()">
                        <xsl:apply-templates select="../CONCLUSION">
                            <xsl:with-param name="mode">sommaire</xsl:with-param>
                            <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
                            <xsl:with-param name="souschapitre"><xsl:value-of select="$souschapitre"/></xsl:with-param>
                            <xsl:with-param name="section"><xsl:value-of select="$section"/></xsl:with-param>
                            <xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
                            <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
                            <xsl:with-param name="selection"><xsl:value-of select="$selection"/></xsl:with-param>
                        </xsl:apply-templates>
                    </xsl:if>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:when>
</xsl:choose>
</xsl:template>

<!--...........................................................................................................................................-->

<!--GESTION DES SECTION-->
<xsl:template match="SECTION">
<xsl:param name="prefixe"></xsl:param>
<xsl:param name="mode"></xsl:param>
<xsl:param name="chapitre"></xsl:param>
<xsl:param name="souschapitre"></xsl:param>
<xsl:param name="section"><xsl:value-of select="@label"/></xsl:param>
<xsl:param name="page"></xsl:param>
<xsl:param name="selection"></xsl:param>

<xsl:choose>
    <!--(creation du fichier section et) appel a la creation de la page page-->
    <xsl:when test="$mode='fichiers'">
        <!-- on cre les pages section pour le projet UEL -->
        <xsl:if test="/UELDOC and $affichage='web'">
            <xsl:variable name="fichier">site/<xsl:value-of select="$chapitre"/>/<xsl:value-of select="$souschapitre"/>/<xsl:value-of select="$section"/>/index.html</xsl:variable>
<xsl:text disable-output-escaping="yes">
</xsl:text>
            <PAGEWEB nom="{$fichier}">
                <CONTRIB><xsl:value-of select="ancestor-or-self::*[@contrib][1]/@contrib"/></CONTRIB>
                <TITREFICHIER>Section '<xsl:value-of select="@titre"/>'</TITREFICHIER>
                <xsl:call-template name="PAGESECTION">
                    <xsl:with-param name="mode"><xsl:value-of select="$mode"/></xsl:with-param>
                    <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
                    <xsl:with-param name="souschapitre"><xsl:value-of select="$souschapitre"/></xsl:with-param>
                    <xsl:with-param name="section"><xsl:value-of select="$section"/></xsl:with-param>
                </xsl:call-template>
            </PAGEWEB>
        </xsl:if>
        <xsl:apply-templates select="INTRODUCTION | PAGE | CONCLUSION | BIBLIOGRAPHIE">
            <xsl:with-param name="mode"><xsl:value-of select="$mode"/></xsl:with-param>
            <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
            <xsl:with-param name="souschapitre"><xsl:value-of select="$souschapitre"/></xsl:with-param>
            <xsl:with-param name="section"><xsl:value-of select="$section"/></xsl:with-param>
        </xsl:apply-templates>
    </xsl:when>
    
    <!--sommaire de la page section-->
    <xsl:when test="$mode='sommaire' and @label != 'glossaire'">
        <!--<xsl:variable name="secpos" select="position()"/> a priori c'est un bug -->
        <xsl:variable name="seclabel"><xsl:value-of select="@label"/></xsl:variable>
        <xsl:variable name="lien"><xsl:choose>
            <xsl:when test="INTRODUCTION">
                <xsl:value-of select="concat($prefixe,$chapitre,'/',$souschapitre,'/',$seclabel,'/INTRODUCTION/index.html')"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:choose>
                <xsl:when test="/UELDOC">
                    <xsl:for-each select="PAGE[1]/*[self::OBSERVER or self::APPRENDRE or self::SIMULER or self::SEXERCER or self::SEVALUER]">
                    <xsl:if test="position()=1">
                        <xsl:value-of select="concat($prefixe,$chapitre,'/',$souschapitre,'/',$seclabel,'/', ../@label, '/',name(),'.html')"/>
                    </xsl:if>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:value-of select="concat($prefixe,$chapitre,'/',$souschapitre,'/',$seclabel,'/', PAGE[1]/@label, '/index.html')"/>
                </xsl:otherwise>
                </xsl:choose>
            </xsl:otherwise>
        </xsl:choose></xsl:variable>
        <xsl:choose>
            <xsl:when test="$seclabel=$section or $affichage!='web'">
                <ENTREESOM selection="{$prefixe='../../../' or $prefixe='../../../../'}">
                    <TITRE><xsl:value-of select="@titre"/></TITRE>
                    <URLFLECHE><xsl:value-of select="concat($prefixe,$chapitre,'/',$souschapitre,'/index.html')"/></URLFLECHE>
                    <URLCLICK><xsl:value-of select="$lien"/></URLCLICK>
                    <xsl:if test="INTRODUCTION | PAGE | CONCLUSION | BIBLIOGRAPHIE">
                        <LISTESOM>
                            <xsl:apply-templates select="INTRODUCTION | PAGE | CONCLUSION | BIBLIOGRAPHIE">
                                <xsl:with-param name="mode"><xsl:value-of select="$mode"/></xsl:with-param>
                                <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
                                <xsl:with-param name="souschapitre"><xsl:value-of select="$souschapitre"/></xsl:with-param>
                                <xsl:with-param name="section"><xsl:value-of select="$section"/></xsl:with-param>
                                <xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
                                <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
                                <xsl:with-param name="selection"><xsl:value-of select="$selection"/></xsl:with-param>
                            </xsl:apply-templates>
                        </LISTESOM>
                    </xsl:if>
                </ENTREESOM>
            </xsl:when>
            <xsl:otherwise>
                <!--<xsl:if test="position()=1">
                <xsl:apply-templates select="../INTRODUCTION">
                    <xsl:with-param name="mode">sommaire</xsl:with-param>
                    <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
                    <xsl:with-param name="souschapitre"><xsl:value-of select="$souschapitre"/></xsl:with-param>
                    <xsl:with-param name="section"><xsl:value-of select="$section"/></xsl:with-param>
                    <xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
                    <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
                    <xsl:with-param name="selection"><xsl:value-of select="$selection"/></xsl:with-param>
                </xsl:apply-templates>
                </xsl:if>-->
                <ENTREESOM selection="false">
                    <TITRE><xsl:value-of select="@titre"/></TITRE>
                    <URLFLECHE><xsl:value-of select="$lien"/></URLFLECHE>
                    <URLCLICK><xsl:value-of select="$lien"/></URLCLICK>
                </ENTREESOM>
                <!--
                <xsl:if test="position()=last()">
                    <xsl:apply-templates select="../CONCLUSION">
                        <xsl:with-param name="mode">sommaire</xsl:with-param>
                        <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
                        <xsl:with-param name="souschapitre"><xsl:value-of select="$souschapitre"/></xsl:with-param>
                        <xsl:with-param name="section"><xsl:value-of select="$section"/></xsl:with-param>
                        <xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
                        <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
                        <xsl:with-param name="selection"><xsl:value-of select="$selection"/></xsl:with-param>
                    </xsl:apply-templates>
                </xsl:if>
                -->
            </xsl:otherwise>
        </xsl:choose>
    </xsl:when>
</xsl:choose>

</xsl:template>

<!--...........................................................................................................................................-->

<!--GESTION DES PAGES-->
<xsl:template match="PAGE">
<xsl:param name="prefixe"></xsl:param>
<xsl:param name="mode"></xsl:param>
<xsl:param name="chapitre"></xsl:param>
<xsl:param name="souschapitre"></xsl:param>
<xsl:param name="section"></xsl:param>
<xsl:param name="page"><xsl:value-of select="@label"/></xsl:param>
<xsl:param name="illustration">1</xsl:param>

<xsl:choose>
    <!--creation des pages page, appel a la creation des conclusion et introduction-->
    <xsl:when test="$mode='fichiers'">
<xsl:message>PAGE <xsl:value-of select="concat($chapitre,'_',$souschapitre,'_',$section,'_',$page,'_',$illustration)"/></xsl:message>
        <xsl:choose>
        <xsl:when test="/UELDOC">
        <xsl:for-each select="OBSERVER|APPRENDRE|SIMULER|SEXERCER|SEVALUER">
            <xsl:variable name="fichier">site/<xsl:value-of select="concat($chapitre,'/',$souschapitre,'/',$section,'/',$page, '/',name(),'.html')"/></xsl:variable>
    <xsl:text disable-output-escaping="yes">
    </xsl:text>
            <PAGEWEB nom="{$fichier}">
                <CONTRIB><xsl:value-of select="ancestor::*[@contrib][1]/@contrib"/></CONTRIB>
                <TITREFICHIER><xsl:value-of select="../@titre"/></TITREFICHIER>
                <xsl:call-template name="PAGEPAGE">
                    <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
                    <xsl:with-param name="souschapitre"><xsl:value-of select="$souschapitre"/></xsl:with-param>
                    <xsl:with-param name="section"><xsl:value-of select="$section"/></xsl:with-param>
                    <xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
                    <xsl:with-param name="illustration"><xsl:value-of select="$illustration"/></xsl:with-param>
                </xsl:call-template>
            </PAGEWEB>
            <xsl:if test="$affichage='web'">
                <xsl:apply-templates select=".//FIGURE[@localisation='page'] | .//TABLEAU[@localisation='page']">
                    <xsl:with-param name="mode"><xsl:value-of select="$mode"/></xsl:with-param>
                    <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
                    <xsl:with-param name="souschapitre"><xsl:value-of select="$souschapitre"/></xsl:with-param>
                    <xsl:with-param name="section"><xsl:value-of select="$section"/></xsl:with-param>
                    <xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
                </xsl:apply-templates>
            </xsl:if>
        </xsl:for-each>
        </xsl:when>
        <xsl:otherwise>
            <xsl:variable name="fichier">site/<xsl:value-of select="$chapitre"/>/<xsl:value-of select="$souschapitre"/>/<xsl:value-of select="$section"/>/<xsl:value-of select="$page"/>/index.html</xsl:variable>
    <xsl:text disable-output-escaping="yes">
    </xsl:text>
            <PAGEWEB nom="{$fichier}">
                <CONTRIB><xsl:value-of select="ancestor::*[@contrib][1]/@contrib"/></CONTRIB>
                <TITREFICHIER><xsl:value-of select="@titre"/></TITREFICHIER>
                <xsl:call-template name="PAGEPAGE">
                    <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
                    <xsl:with-param name="souschapitre"><xsl:value-of select="$souschapitre"/></xsl:with-param>
                    <xsl:with-param name="section"><xsl:value-of select="$section"/></xsl:with-param>
                    <xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
                    <xsl:with-param name="illustration"><xsl:value-of select="$illustration"/></xsl:with-param>
                </xsl:call-template>
            </PAGEWEB>
            <xsl:if test="$affichage='web'">
                <xsl:apply-templates select=".//FIGURE[@localisation='page'] | .//TABLEAU[@localisation='page']">
                    <xsl:with-param name="mode"><xsl:value-of select="$mode"/></xsl:with-param>
                    <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
                    <xsl:with-param name="souschapitre"><xsl:value-of select="$souschapitre"/></xsl:with-param>
                    <xsl:with-param name="section"><xsl:value-of select="$section"/></xsl:with-param>
                    <xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
                </xsl:apply-templates>
            </xsl:if>
        </xsl:otherwise>
        </xsl:choose>
    </xsl:when>
    <!--sommaire des pages-->
    <xsl:when test="$mode='sommaire'">
        <xsl:variable name="cettepage"><xsl:value-of select="ancestor-or-self::PAGE/@label"/></xsl:variable>
        <ENTREESOM selection="{$cettepage=$page}" noeud="true">
        <TITRE><xsl:value-of select="@titre"/></TITRE>
        <xsl:choose>
            <xsl:when test="$cettepage!=$page">
                <xsl:choose>
                    <xsl:when test="/UELDOC">
                    <xsl:for-each select="OBSERVER|APPRENDRE|SIMULER|SEXERCER|SEVALUER">
                    <xsl:if test="position()=1">
                        <URLCLICK><xsl:value-of select="concat($prefixe,$chapitre,'/',$souschapitre,'/',$section,'/',$cettepage, '/',name(),'.html')"/></URLCLICK>
                    </xsl:if>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                    <URLCLICK><xsl:value-of select="concat($prefixe,$chapitre,'/',$souschapitre,'/',$section,'/',$cettepage, '/index.html')"/></URLCLICK>
                </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
        </xsl:choose>
        </ENTREESOM>
    </xsl:when>

    <!--retourne le contenu de la page-->
    <xsl:when test="$mode='base'">
        <xsl:copy>
            <xsl:apply-templates select="@*|node()"/>
        </xsl:copy>
    </xsl:when>
</xsl:choose>

</xsl:template>


<!--...........................................................................................................................................-->

<!--gestion de l'image localise dans la page affiche a l'ecran-->

<xsl:template name="imagecentre">
<xsl:param name="illustration">1</xsl:param>

    <xsl:variable name="balise" select="name()"/>

    <xsl:for-each select=".//FIGURE[@localisation='page'] | .//TABLEAU[@localisation='page']">
        <xsl:variable name="numero">
            <xsl:number level="any" from="*[name()=$balise]" count="FIGURE[@localisation='page'] | TABLEAU[@localisation='page']"/>
        </xsl:variable>
        <xsl:if test="$numero=$illustration">
            <xsl:apply-templates select="."><xsl:with-param name="loc">page</xsl:with-param></xsl:apply-templates>
        </xsl:if>
    </xsl:for-each>
</xsl:template>

<!--...........................................................................................................................................-->

    <!--gestion des icones representant les images localisees dans la page-->

<xsl:template name="imagettes">

<xsl:param name="chapitre"></xsl:param>
<xsl:param name="souschapitre"></xsl:param>
<xsl:param name="section"></xsl:param>
<xsl:param name="page"></xsl:param>
<xsl:param name="illustration"></xsl:param>

    <xsl:if test="count(.//FIGURE[@localisation='page'] | .//TABLEAU[@localisation='page']) > 1">
        <xsl:variable name="balise" select="name()"/>
        <xsl:variable name="nomfpage"><xsl:choose>
            <xsl:when test="/UELDOC"><xsl:value-of select="$balise"/></xsl:when>
            <xsl:otherwise>index</xsl:otherwise>
        </xsl:choose></xsl:variable>
        <IMAGETTES>
            <xsl:for-each select=".//FIGURE[@localisation='page'] | .//TABLEAU[@localisation='page']">
                <xsl:variable name="illustration2"><xsl:number level="any" from="*[name()=$balise]" count="FIGURE[@localisation='page'] | TABLEAU[@localisation='page']"/></xsl:variable>
                <URL>
                <xsl:if test="@titre!=''">
                    <xsl:attribute name="titre"><xsl:value-of select="@titre"/></xsl:attribute>
                </xsl:if>
                <xsl:if test="$illustration2=$illustration">
                    <xsl:attribute name="selection">true</xsl:attribute>
                </xsl:if>
                <xsl:choose>
                    <xsl:when test="contains('|INTRODUCTION|CONCLUSION|BIBLIOGRAPHIE|DOCUMENTS|CONSEILS|', concat('|',$balise,'|')) and $illustration2=1">index.html</xsl:when>
                    <xsl:when test="contains('|INTRODUCTION|CONCLUSION|BIBLIOGRAPHIE|DOCUMENTS|CONSEILS|', concat('|',$balise,'|')) and $illustration2!=1">
                        <xsl:value-of select="concat('index_',$illustration2,'.html')"/>
                    </xsl:when>
                    <xsl:when test="$illustration2=1">
                        <xsl:value-of select="concat($nomfpage,'.html')"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="concat($nomfpage,'_',$illustration2,'.html')"/>
                    </xsl:otherwise>
                </xsl:choose>
                </URL>
            </xsl:for-each>
        </IMAGETTES>
    </xsl:if>
</xsl:template>

<!--...........................................................................................................................................-->

<!--GESTION DES TP-->
<!-- les TPs sont maintenant transforms en CHAPITREs avant cette feuille de style, donc cette partie est inutilise -->

<xsl:template name="flechesTP">
    <xsl:param name="prefixe"/>
    
    <!-- NAVIGATIONSUIVANT et NAVIGATIONPRECEDENT-->
    <xsl:variable name="balisespage">
        |TP|INTRODUCTION|CONCLUSION|DOCUMENTS|DEROULEMENT|CONSEILS|BIBLIOGRAPHIE|
    </xsl:variable>
    
    <xsl:variable name="num">
        <xsl:number level="any" count="*[contains($balisespage,concat('|',name(),'|')) and (self::TP or parent::TP)]"/>
    </xsl:variable>
    
    <xsl:for-each select="/IUFMDOC/TP | /IUFMDOC/TP/*[contains($balisespage,concat('|',name(),'|'))]">
        <xsl:variable name="num2"><xsl:number level="any" count="*[contains($balisespage,concat('|',name(),'|')) and (self::TP or parent::TP)]"/></xsl:variable>
        <xsl:if test="($num2 = $num + 1) or ($num2 = $num - 1)">
            <xsl:variable name="pos1"><xsl:number count="TP"/></xsl:variable>
            <xsl:if test="$pos1!=''">
                <xsl:variable name="href"><xsl:choose>
                    <xsl:when test="name()='TP'">
                        <xsl:value-of select="concat($prefixe,'tp',$pos1,'/tp_',$pos1,'.html')"/>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:value-of select="concat($prefixe,'tp',$pos1,'/tp_',$pos1,'_',name(),'.html')"/>
                    </xsl:otherwise>
                </xsl:choose></xsl:variable>
                <xsl:if test="$num2 = $num + 1">
                    <PAGESUIVANTE>
                        <URL><xsl:value-of select="$href"/></URL>
                    </PAGESUIVANTE>
                </xsl:if>
                <xsl:if test="$num2 = $num - 1">
                    <PAGEPRECEDENTE>
                        <URL><xsl:value-of select="$href"/></URL>
                    </PAGEPRECEDENTE>
                </xsl:if>
            </xsl:if>
        </xsl:if>
    </xsl:for-each>
</xsl:template>


<xsl:template match="TP">
<xsl:param name="prefixe">../</xsl:param>
<xsl:param name="mode"></xsl:param>
<xsl:param name="page"></xsl:param>
<xsl:param name="illustration">1</xsl:param>
<xsl:param name="TP"><xsl:number count="TP"/></xsl:param>
<xsl:param name="balise"/>
 
<xsl:choose>
    <xsl:when test="$mode='sommaire'">
        <xsl:variable name="pos1"><xsl:number count="TP"/></xsl:variable>
        <ENTREESOM selection="{$TP=$pos1}" noeud="{name()!='TP'}">
        <TITRE><xsl:value-of select="@titre"/></TITRE>
        
        <xsl:choose>
        <xsl:when test="$pos1=$TP">
            <!--<URLFLECHE>../index.html</URLFLECHE>-->
            <URLCLICK><xsl:value-of select="concat($prefixe,'tp',$pos1,'/tp_',$pos1,'.html')"/></URLCLICK>
            <LISTESOM>
            <xsl:for-each select="INTRODUCTION | DOCUMENTS | DEROULEMENT | CONCLUSION | CONSEILS | BIBLIOGRAPHIE">
                <ENTREESOM selection="{$balise=name()}" noeud="true">
                    <TITRE><xsl:value-of select="name()"/></TITRE>
                    <URLCLICK><xsl:value-of select="concat($prefixe,'tp',$pos1,'/tp_',$pos1,'_',name(),'.html')"/></URLCLICK>
                </ENTREESOM>
            </xsl:for-each>
            </LISTESOM>
        </xsl:when>
        <xsl:otherwise>
            <URLCLICK><xsl:value-of select="concat($prefixe,'tp',$pos1,'/tp_',$pos1,'.html')"/></URLCLICK>
        </xsl:otherwise>
        </xsl:choose>
        </ENTREESOM>
    </xsl:when>
    
    <xsl:when test="$mode='fichiers'">
        <xsl:message>TP <xsl:value-of select="$TP"/></xsl:message>
        <xsl:variable name="fichier">site/tp<xsl:value-of select="$TP"/>/tp_<xsl:value-of select="$TP"/></xsl:variable>
<xsl:text disable-output-escaping="yes">
</xsl:text>
        <PAGEWEB nom="{$fichier}.html">
            <xsl:if test="@contrib">
                <CONTRIB><xsl:value-of select="@contrib"/></CONTRIB>
            </xsl:if>
            <TITREFICHIER>TP '<xsl:value-of select="@titre"/>'</TITREFICHIER>

            <PREFIXE><xsl:value-of select="$prefixe"/></PREFIXE>
            <NIVEAUPAGE>chapitre</NIVEAUPAGE>
            <TYPEPAGE>TP</TYPEPAGE>
            
            <!-- NAVIGATIONSUIVANT et NAVIGATIONPRECEDENT-->
            <xsl:call-template name="flechesTP">
                <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
            </xsl:call-template>
            
            <SOMMAIRE>
                <ENTREESOM>
                    <TITRE>Travaux Pratiques</TITRE>
                    <URLFLECHE><xsl:value-of select="concat($prefixe,'index.html')"/></URLFLECHE>
                    <URLCLICK><xsl:value-of select="$prefixe"/>tp1/tp_1.html</URLCLICK>
                    <LISTESOM>
                        <xsl:apply-templates select="//TP">
                            <xsl:with-param name="mode">sommaire</xsl:with-param>
                            <xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
                            <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
                            <xsl:with-param name="TP"><xsl:value-of select="$TP"/></xsl:with-param>
                        </xsl:apply-templates>
                    </LISTESOM>
                </ENTREESOM>
            </SOMMAIRE>
            
            <TITREPAGE><xsl:value-of select="@titre"/></TITREPAGE>
            
            <!--contenu texte de la page-->
            <ZONETEXTE>
                <xsl:apply-templates select="AUTEUR | DATECRE | DATEMAJ | CHAMP | NIVEAU | TEMPS | OBJECTIFS | PREREQUIS"/>
            </ZONETEXTE>
        </PAGEWEB>
        <xsl:for-each select="INTRODUCTION | DOCUMENTS | DEROULEMENT | CONCLUSION | CONSEILS | BIBLIOGRAPHIE">
            <PAGEWEB nom="{$fichier}_{name()}.html">
                <xsl:if test="ancestor::TP/@contrib">
                    <CONTRIB><xsl:value-of select="ancestor::TP/@contrib"/></CONTRIB>
                </xsl:if>
                <TITREFICHIER>TP '<xsl:value-of select="ancestor::TP/@titre"/>'</TITREFICHIER>
    
                <PREFIXE><xsl:value-of select="$prefixe"/></PREFIXE>
                <NIVEAUPAGE>page</NIVEAUPAGE>
                <TYPEPAGE>TP</TYPEPAGE>
                
                <!-- NAVIGATIONSUIVANT et NAVIGATIONPRECEDENT-->
                <xsl:call-template name="flechesTP">
                    <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
                </xsl:call-template>
                
                <SOMMAIRE>
                    <ENTREESOM>
                        <TITRE>Travaux Pratiques</TITRE>
                        <URLFLECHE><xsl:value-of select="concat($prefixe,'index.html')"/></URLFLECHE>
                        <URLCLICK><xsl:value-of select="$prefixe"/>tp_1.html</URLCLICK>
                        <LISTESOM>
                            <xsl:apply-templates select="//TP">
                                <xsl:with-param name="mode">sommaire</xsl:with-param>
                                <xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
                                <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
                                <xsl:with-param name="TP"><xsl:value-of select="$TP"/></xsl:with-param>
                                <xsl:with-param name="balise"><xsl:value-of select="name()"/></xsl:with-param>
                            </xsl:apply-templates>
                        </LISTESOM>
                    </ENTREESOM>
                </SOMMAIRE>
                
                <TITRESECTION><xsl:value-of select="ancestor::TP/@titre"/></TITRESECTION>
                
                <!--contenu texte de la page-->
                <ZONETEXTE>
                    <xsl:copy>
                        <xsl:apply-templates select="@*|node()"/>
                    </xsl:copy>
                </ZONETEXTE>
            </PAGEWEB>
        </xsl:for-each>

    </xsl:when>
    
    </xsl:choose>
</xsl:template>


<!--...........................................................................................................................................-->

<!--GESTION DES LIENS-->

<xsl:template name="urlLIEN">
    <xsl:param name="cible"></xsl:param>
    <xsl:variable name="ntype" select="normalize-space(@type)"/>
    <xsl:variable name="label" select="normalize-space(@label)"/>
    <xsl:variable name="prefixe"><xsl:if test="$affichage='web'">../<xsl:if test="ancestor::SOUSCHAPITRE">../</xsl:if><xsl:if test="ancestor::SECTION or (ancestor::SOUSCHAPITRE and ancestor::INTRODUCTION and (ancestor::SOUSCHAPITRE/PREREQUIS or ancestor::SOUSCHAPITRE/RESUME or ancestor::SOUSCHAPITRE/OBJECTIFS or ancestor::INTRODUCTION//FIGURE[@localisation='page']))">../</xsl:if><xsl:if test="ancestor::SOUSCHAPITRE and (ancestor::CONSEILS or ancestor::DOCUMENTS or ancestor::BIBLIOGRAPHIE or ancestor::CONCLUSION) and not(ancestor::SECTION)">../</xsl:if><xsl:if test="ancestor::SECTION">../</xsl:if></xsl:if></xsl:variable>
    <xsl:choose>
        <xsl:when test="$ntype='http'">
            <xsl:choose>
            <xsl:when test="@type='http' and not(starts-with($label,'http://'))">
                <xsl:variable name="contrib" select="ancestor::*[@contrib][1]/@contrib"/>
                <xsl:value-of select="concat($prefixe,'images/',$contrib,'/',$label)"/>
            </xsl:when>
            <xsl:otherwise>
                <xsl:value-of select="$label"/>
            </xsl:otherwise>
            </xsl:choose>
        </xsl:when>
        <xsl:when test="$ntype='chapitre'">
            <xsl:for-each select="/*/CHAPITRE[@label=$cible]"><xsl:value-of select="$prefixe"/><xsl:call-template name="numerotation"/></xsl:for-each>
        </xsl:when>
        <xsl:when test="$ntype='souschapitre' or $ntype='tp'">
            <xsl:for-each select="/*/CHAPITRE/SOUSCHAPITRE[@label=$cible]">
                <xsl:value-of select="$prefixe"/><xsl:call-template name="numerotation"/>
            </xsl:for-each>
        </xsl:when>
        <xsl:when test="$ntype='section'">
            <xsl:for-each select="/*/CHAPITRE/SOUSCHAPITRE/SECTION[@label=$cible]">
                <xsl:value-of select="$prefixe"/><xsl:call-template name="numerotation"/>
            </xsl:for-each>
        </xsl:when>
        <xsl:when test="$ntype='page'">
            <xsl:choose>
            <xsl:when test="/UELDOC">
                <xsl:choose>
                <xsl:when test="contains($cible,'.')">
                    <xsl:variable name="nomuel"><xsl:value-of select="translate(substring-after($cible,'.'),'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/></xsl:variable>
                    <xsl:for-each select="/*/CHAPITRE/SOUSCHAPITRE/SECTION/PAGE[@label=substring-before($cible,'.')]/*[name()=$nomuel]">
                        <xsl:value-of select="$prefixe"/><xsl:call-template name="numerotation"/>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:for-each select="/*/CHAPITRE/SOUSCHAPITRE/SECTION/PAGE[@label=$cible]">
                        <xsl:for-each select="INTRODUCTION|OBSERVER|APPRENDRE|SIMULER|SEXERCER|SEVALUER">
                        <xsl:if test="position()=1">
                            <xsl:value-of select="$prefixe"/><xsl:call-template name="numerotation"/>
                        </xsl:if>
                        </xsl:for-each>
                    </xsl:for-each>
                </xsl:otherwise>
                </xsl:choose>
            </xsl:when>
            <xsl:otherwise>
                <xsl:for-each select="/*/CHAPITRE/SOUSCHAPITRE/SECTION/PAGE[@label=$cible][1]">
                    <xsl:value-of select="$prefixe"/><xsl:call-template name="numerotation"/>
                </xsl:for-each>
            </xsl:otherwise>
            </xsl:choose>
        </xsl:when>
        <xsl:when test="$ntype='figure' or $ntype='tableau'">
            <xsl:variable name="ntypemaj" select="translate($ntype,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
            <xsl:for-each select="//*[name()=$ntypemaj and @label=$cible]">
                <xsl:choose>
                <xsl:when test="ancestor::PAGE">
                    <xsl:value-of select="$prefixe"/><xsl:call-template name="numerotation"/>#<xsl:value-of select="$label"/>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="parent" select="name(ancestor::*[contains('|INTRODUCTION|CONCLUSION|BIBLIOGRAPHIE|DOCUMENTS|CONSEILS|', concat('|',name(),'|'))])"/>
                    <xsl:variable name="illustration"><xsl:number level="any" from="*[name()=$parent]" count="FIGURE[@localisation='page'] | TABLEAU[@localisation='page']"/></xsl:variable>
                    <xsl:variable name="debut"><xsl:value-of select="$prefixe"/><xsl:value-of select="ancestor-or-self::CHAPITRE/@label"/>/<xsl:if test="ancestor::SOUSCHAPITRE"><xsl:value-of select="ancestor-or-self::SOUSCHAPITRE/@label"/>/</xsl:if><xsl:if test="ancestor::SECTION"><xsl:value-of select="ancestor-or-self::SECTION/@label"/>/</xsl:if></xsl:variable>
                    <xsl:choose>
                        <xsl:when test="$illustration &lt;= 1">
                            <xsl:value-of select="concat($debut,$parent,'/index.html#',$label)"/>
                        </xsl:when>
                        <xsl:when test="$illustration!=1">
                            <xsl:value-of select="concat($debut,$parent,'/index_',$illustration,'.html#',$label)"/>
                        </xsl:when>
                    </xsl:choose>
                </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </xsl:when>
        <xsl:when test="$ntype='paragraphe' or $ntype='exercice' or $ntype='definition'">
            <xsl:variable name="ntypemaj" select="translate($ntype,'abcdefghijklmnopqrstuvwxyz','ABCDEFGHIJKLMNOPQRSTUVWXYZ')"/>
            <xsl:for-each select="(//*[name()=$ntypemaj and @label=$cible])[1]">
                <xsl:choose>
                <xsl:when test="ancestor::PAGE">
                    <xsl:choose>
                    <xsl:when test="/UELDOC">
                        <xsl:for-each select="ancestor::OBSERVER | ancestor::APPRENDRE | ancestor::SIMULER | ancestor::SEXERCER | ancestor::SEVALUER">
                            <xsl:value-of select="$prefixe"/><xsl:call-template name="numerotation"/>#<xsl:value-of select="$label"/>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="ancestor::PAGE">
                            <xsl:value-of select="$prefixe"/><xsl:call-template name="numerotation"/>#<xsl:value-of select="$label"/>
                        </xsl:for-each>
                    </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="parent" select="name(ancestor::*[contains('|INTRODUCTION|CONCLUSION|BIBLIOGRAPHIE|DOCUMENTS|CONSEILS|', concat('|',name(),'|'))])"/>
                    <xsl:variable name="debut"><xsl:value-of select="$prefixe"/><xsl:value-of select="ancestor-or-self::CHAPITRE/@label"/>/<xsl:if test="ancestor::SOUSCHAPITRE"><xsl:value-of select="ancestor-or-self::SOUSCHAPITRE/@label"/>/</xsl:if><xsl:if test="ancestor::SECTION"><xsl:value-of select="ancestor-or-self::SECTION/@label"/>/</xsl:if></xsl:variable>
                    <xsl:value-of select="concat($debut,$parent,'/index.html#',$label)"/>
                </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </xsl:when>
        <xsl:when test="$ntype='equation'">
            <xsl:for-each select="(//*[(name()='EQUATION' or name()='EQUATEX') and @label=$cible])[1]">
                <xsl:choose>
                <xsl:when test="ancestor::PAGE">
                    <xsl:choose>
                    <xsl:when test="/UELDOC">
                        <xsl:for-each select="ancestor::OBSERVER | ancestor::APPRENDRE | ancestor::SIMULER | ancestor::SEXERCER | ancestor::SEVALUER">
                            <xsl:value-of select="$prefixe"/><xsl:call-template name="numerotation"/>#<xsl:value-of select="$label"/>
                        </xsl:for-each>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:for-each select="ancestor::PAGE">
                            <xsl:value-of select="$prefixe"/><xsl:call-template name="numerotation"/>#<xsl:value-of select="$label"/>
                        </xsl:for-each>
                    </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:variable name="parent" select="name(ancestor::*[contains('|INTRODUCTION|CONCLUSION|BIBLIOGRAPHIE|DOCUMENTS|CONSEILS|', concat('|',name(),'|'))])"/>
                    <xsl:variable name="debut"><xsl:value-of select="$prefixe"/><xsl:value-of select="ancestor-or-self::CHAPITRE/@label"/>/<xsl:if test="ancestor::SOUSCHAPITRE"><xsl:value-of select="ancestor-or-self::SOUSCHAPITRE/@label"/>/</xsl:if><xsl:if test="ancestor::SECTION"><xsl:value-of select="ancestor-or-self::SECTION/@label"/>/</xsl:if></xsl:variable>
                    <xsl:value-of select="concat($debut,$parent,'/index.html#',$label)"/>
                </xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </xsl:when>
        <xsl:when test="$ntype='applet'">
            <xsl:for-each select="(//APPLET[@label=$cible])[1]">
                <xsl:variable name="chemin"><xsl:value-of select="$prefixe"/><xsl:choose>
                <xsl:when test="/UELDOC"><xsl:for-each select="ancestor::OBSERVER | ancestor::APPRENDRE | ancestor::SIMULER | ancestor::SEXERCER | ancestor::SEVALUER"><xsl:call-template name="numerotation"/></xsl:for-each></xsl:when>
                <xsl:otherwise><xsl:for-each select="ancestor::PAGE"><xsl:call-template name="numerotation"/></xsl:for-each></xsl:otherwise>
                </xsl:choose>#<xsl:value-of select="$label"/></xsl:variable>
                <xsl:choose>
                    <xsl:when test="@localisation='icne'">
                        <xsl:variable name="numero"><xsl:number level="any" from="PAGE|OBSERVER|APPRENDRE|SIMULER|SEXERCER|SEVALUER" count="APPLET"/></xsl:variable>
                        <xsl:call-template name="repfichier">
                            <xsl:with-param name="chemin" select="$chemin"/>
                        </xsl:call-template>/applet<xsl:value-of select="$numero"/><xsl:if test="/UELDOC">_<xsl:value-of select="name(ancestor::OBSERVER | ancestor::APPRENDRE | ancestor::SIMULER | ancestor::SEXERCER | ancestor::SEVALUER)"/></xsl:if>.html</xsl:when>
                    <xsl:otherwise><xsl:value-of select="$chemin"/></xsl:otherwise>
                </xsl:choose>
            </xsl:for-each>
        </xsl:when>
    </xsl:choose>
</xsl:template>

<xsl:template name="repfichier">
<!-- renvoit le chemin du rpertoire d'un fichier  partir du chemin complet-->
<xsl:param name="chemin"/>
<xsl:choose>
    <xsl:when test="contains($chemin,'/') and contains(substring-after($chemin,'/'),'/')">
        <xsl:value-of select="substring-before($chemin,'/')"/>/<xsl:call-template name="repfichier"><xsl:with-param name="chemin" select="substring-after($chemin,'/')"/></xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
        <xsl:value-of select="substring-before($chemin,'/')"/>
    </xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template match="LIEN|SUITE">
    <xsl:param name="cible"><xsl:value-of select="normalize-space(./@label)"/></xsl:param> 
    <xsl:variable name="url"><xsl:choose>
        <xsl:when test="$affichage='web'"><xsl:call-template name="urlLIEN"><xsl:with-param name="cible" select="$cible"/></xsl:call-template></xsl:when>
        <xsl:when test="starts-with($cible,'http:/')"><xsl:value-of select="$cible"/></xsl:when>
        <xsl:otherwise>#<xsl:value-of select="$cible"/></xsl:otherwise>
    </xsl:choose></xsl:variable>
    
    <xsl:choose>
        <xsl:when test="normalize-space(@type)='figure' or normalize-space(@type)='tableau'">
            <A href="{$url}" class="lienfigure"><xsl:apply-templates/></A>
        </xsl:when>
        <xsl:otherwise>
            <A href="{$url}"><xsl:apply-templates/></A>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<!--...........................................................................................................................................-->

<!--GESTION DES LIENS: rsolution pour les liens issus de TeX4ht-->
<xsl:template match="A">
    <xsl:choose>
        <xsl:when test="@href">
            <xsl:variable name="cible"><xsl:value-of select="normalize-space(@href)"/></xsl:variable> 
            <xsl:variable name="url">
                <xsl:for-each select="/*/CHAPITRE"><xsl:variable name="chap"><xsl:value-of select="@label"/></xsl:variable>
                    <xsl:for-each select="SOUSCHAPITRE"><xsl:variable name="souschap"><xsl:value-of select="@label"/></xsl:variable>
                        <xsl:for-each select="SECTION"><xsl:variable name="section"><xsl:value-of select="@label"/></xsl:variable>
                            <xsl:for-each select="PAGE"><xsl:variable name="page"><xsl:value-of select="@label"/></xsl:variable>
                                <xsl:for-each select=".//A">
                                    <xsl:if test="normalize-space(@name)=substring-after($cible,'#')">../../../../<xsl:value-of select="$chap"/>/<xsl:value-of select="$souschap"/>/<xsl:value-of select="$section"/>/<xsl:value-of select="$page"/>/index.html#<xsl:value-of select="@name"/></xsl:if>
                                </xsl:for-each>
                            </xsl:for-each>
                        </xsl:for-each>
                    </xsl:for-each>
                </xsl:for-each>
            </xsl:variable>
            <xsl:variable name="url1"><xsl:value-of select="substring-before($url,'#')"/><xsl:value-of select="$cible"/></xsl:variable>
               <A href="{$url1}"><xsl:apply-templates/></A>
        </xsl:when>
        <xsl:otherwise>
            <xsl:if test="@name and (not(preceding-sibling::A) or preceding-sibling::A[1]/@name != @name)">
                <A name="{@name}"><xsl:apply-templates/></A>
            </xsl:if>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<!--...........................................................................................................................................-->

<!--GESTION DES FIGURES et TABLEAUX-->
<xsl:template match="FIGURE|TABLEAU">
<xsl:param name="prefixe"></xsl:param>
<xsl:param name="mode"></xsl:param>
<xsl:param name="chapitre"></xsl:param>
<xsl:param name="souschapitre"></xsl:param>
<xsl:param name="section"></xsl:param>
<xsl:param name="page"></xsl:param>
<xsl:param name="illustration"><xsl:choose><xsl:when test="/UELDOC"><xsl:number level="any" from="OBSERVER|APPRENDRE|SIMULER|SEXERCER|SEVALUER" count="FIGURE[@localisation='page'] | TABLEAU[@localisation='page']"/></xsl:when><xsl:otherwise><xsl:number level="any" from="PAGE" count="FIGURE[@localisation='page'] | TABLEAU[@localisation='page']"/></xsl:otherwise></xsl:choose></xsl:param>
<xsl:param name="loc"></xsl:param>

<xsl:if test="$mode='fichiers' and $illustration != '1'">
    <xsl:choose>
    <xsl:when test="/UELDOC">
        <xsl:for-each select="ancestor::OBSERVER | ancestor::APPRENDRE | ancestor::SIMULER | ancestor::SEXERCER | ancestor::SEVALUER">
            <xsl:variable name="fichier">site/<xsl:value-of select="concat($chapitre,'/',$souschapitre,'/',$section,'/',$page, '/',name(),'_',$illustration,'.html')"/></xsl:variable>
            <!--cration des pages pages pour chaque illustration de la page localise dans la page-->
<xsl:text disable-output-escaping="yes">
</xsl:text>
            <PAGEWEB nom="{$fichier}">
                <CONTRIB><xsl:value-of select="ancestor::*[@contrib][1]/@contrib"/></CONTRIB>
                <TITREFICHIER>Page '<xsl:value-of select="/*/CHAPITRE[@label=$chapitre]/SOUSCHAPITRE[@label=$souschapitre]/SECTION[@label=$section]/PAGE[@label=$page]/@titre"/>'</TITREFICHIER>
                <xsl:call-template name="PAGEPAGE">
                    <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
                    <xsl:with-param name="souschapitre"><xsl:value-of select="$souschapitre"/></xsl:with-param>
                    <xsl:with-param name="section"><xsl:value-of select="$section"/></xsl:with-param>
                    <xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
                    <xsl:with-param name="illustration"><xsl:value-of select="$illustration"/></xsl:with-param>
                </xsl:call-template>
            </PAGEWEB>
        </xsl:for-each>
    </xsl:when>
    <xsl:otherwise>
        <xsl:variable name="fichier">site/<xsl:value-of select="concat($chapitre,'/',$souschapitre,'/',$section,'/',$page, '/index','_',$illustration,'.html')"/></xsl:variable>
        <xsl:for-each select="ancestor::PAGE">
            <!--cration des pages pages pour chaque illustration de la page localise dans la page-->
<xsl:text disable-output-escaping="yes">
</xsl:text>
            <PAGEWEB nom="{$fichier}">
                <CONTRIB><xsl:value-of select="ancestor::*[@contrib][1]/@contrib"/></CONTRIB>
                <TITREFICHIER>Page '<xsl:value-of select="/*/CHAPITRE[@label=$chapitre]/SOUSCHAPITRE[@label=$souschapitre]/SECTION[@label=$section]/PAGE[@label=$page]/@titre"/>'</TITREFICHIER>
                <xsl:call-template name="PAGEPAGE">
                    <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
                    <xsl:with-param name="souschapitre"><xsl:value-of select="$souschapitre"/></xsl:with-param>
                    <xsl:with-param name="section"><xsl:value-of select="$section"/></xsl:with-param>
                    <xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
                    <xsl:with-param name="illustration"><xsl:value-of select="$illustration"/></xsl:with-param>
                </xsl:call-template>
            </PAGEWEB>
        </xsl:for-each>
    </xsl:otherwise>
    </xsl:choose>
</xsl:if>
<xsl:if test="$loc=@localisation or not(@localisation='page') or $affichage!='web'">
    <xsl:copy>
        <xsl:apply-templates select="@*|node()"/>
    </xsl:copy>
</xsl:if>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="INTRODUCTION|CONCLUSION|BIBLIOGRAPHIE|DOCUMENTS|CONSEILS">
    <xsl:param name="selection"></xsl:param>
    <xsl:param name="prefixe">../../../../</xsl:param>
    <xsl:param name="mode">base</xsl:param>
    <xsl:param name="chapitre"></xsl:param>
    <xsl:param name="souschapitre"></xsl:param>
    <xsl:param name="section"></xsl:param>
    <xsl:param name="page"></xsl:param>
    <xsl:param name="illustration"></xsl:param>
    <xsl:variable name="balise" select="name()"/>
    <xsl:variable name="titrebalise" select="concat(substring(name(),1,1),substring(translate(name(),'ABCDEFGHIJKLMNOPQRSTUVWXYZ','abcdefghijklmnopqrstuvwxyz'),2,string-length(name())))"/>
    <xsl:choose>
        <xsl:when test="$mode='fichiers'">
            <xsl:variable name="titredivision"><xsl:if test="parent::CHAPITRE or parent::SOUSCHAPITRE or parent::SECTION or parent::PAGE or parent::TP"><xsl:value-of select="../@titre"/></xsl:if></xsl:variable>
            <xsl:if test=".//FIGURE[@localisation='page'] | .//TABLEAU[@localisation='page']">
              <xsl:for-each select=".//FIGURE[@localisation='page'] | .//TABLEAU[@localisation='page']">
                  <xsl:variable name="illus" select="position()"/>
                <xsl:for-each select="ancestor::*[name()=$balise]">
                    <xsl:variable name="fichier">
                    <xsl:if test="$illus = 1">
                        <xsl:if test="parent::CHAPITRE">site/<xsl:value-of select="$chapitre"/>/<xsl:value-of select="$balise"/>/index.html</xsl:if><xsl:if test="parent::SOUSCHAPITRE">site/<xsl:value-of select="$chapitre"/>/<xsl:value-of select="$souschapitre"/>/<xsl:value-of select="$balise"/>/index.html</xsl:if><xsl:if test="parent::SECTION">site/<xsl:value-of select="$chapitre"/>/<xsl:value-of select="$souschapitre"/>/<xsl:value-of select="$section"/>/<xsl:value-of select="$balise"/>/index.html</xsl:if>
                    </xsl:if>
                    <xsl:if test="$illus != 1">
                        <xsl:if test="parent::CHAPITRE">site/<xsl:value-of select="$chapitre"/>/<xsl:value-of select="$balise"/>/index_<xsl:value-of select="$illus"/>.html</xsl:if><xsl:if test="parent::SOUSCHAPITRE">site/<xsl:value-of select="$chapitre"/>/<xsl:value-of select="$souschapitre"/>/<xsl:value-of select="$balise"/>/index_<xsl:value-of select="$illus"/>.html</xsl:if><xsl:if test="parent::SECTION">site/<xsl:value-of select="$chapitre"/>/<xsl:value-of select="$souschapitre"/>/<xsl:value-of select="$section"/>/<xsl:value-of select="$balise"/>/index_<xsl:value-of select="$illus"/>.html</xsl:if>
                    </xsl:if>
                    </xsl:variable>
<xsl:text disable-output-escaping="yes">
</xsl:text>
                    <PAGEWEB nom="{$fichier}">
                        <CONTRIB><xsl:value-of select="ancestor::*[@contrib][1]/@contrib"/></CONTRIB>
                        <TITREFICHIER><xsl:value-of select="$titrebalise"/><xsl:if test="$titredivision!=''"> de '<xsl:value-of select="$titredivision"/>'</xsl:if></TITREFICHIER>
                        <xsl:call-template name="PAGEPAGE">
                            <xsl:with-param name="balise"><xsl:value-of select="$balise"/></xsl:with-param>
                            <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
                            <xsl:with-param name="souschapitre"><xsl:value-of select="$souschapitre"/></xsl:with-param>
                            <xsl:with-param name="section"><xsl:value-of select="$section"/></xsl:with-param>
                            <xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
                            <xsl:with-param name="illustration"><xsl:value-of select="$illus"/></xsl:with-param>
                            <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
                        </xsl:call-template>
                    </PAGEWEB>
                </xsl:for-each>
              </xsl:for-each>
            </xsl:if>
            <xsl:if test="not(.//FIGURE[@localisation='page']) and not (.//TABLEAU[@localisation='page'])">
                <xsl:variable name="fichier"><xsl:if test="parent::CHAPITRE">site/<xsl:value-of select="$chapitre"/>/<xsl:value-of select="$balise"/>/index.html</xsl:if><xsl:if test="parent::SOUSCHAPITRE">site/<xsl:value-of select="$chapitre"/>/<xsl:value-of select="$souschapitre"/>/<xsl:value-of select="$balise"/>/index.html</xsl:if><xsl:if test="parent::SECTION">site/<xsl:value-of select="$chapitre"/>/<xsl:value-of select="$souschapitre"/>/<xsl:value-of select="$section"/>/<xsl:value-of select="$balise"/>/index.html</xsl:if></xsl:variable>
<xsl:text disable-output-escaping="yes">
</xsl:text>
                <PAGEWEB nom="{$fichier}">
                    <CONTRIB><xsl:value-of select="ancestor::*[@contrib][1]/@contrib"/></CONTRIB>
                    <TITREFICHIER><xsl:value-of select="$titrebalise"/><xsl:if test="$titredivision!=''"> de '<xsl:value-of select="$titredivision"/>'</xsl:if></TITREFICHIER>
                    <xsl:call-template name="PAGEPAGE">
                        <xsl:with-param name="balise"><xsl:value-of select="$balise"/></xsl:with-param>
                        <xsl:with-param name="chapitre"><xsl:value-of select="$chapitre"/></xsl:with-param>
                        <xsl:with-param name="souschapitre"><xsl:value-of select="$souschapitre"/></xsl:with-param>
                        <xsl:with-param name="section"><xsl:value-of select="$section"/></xsl:with-param>
                        <xsl:with-param name="page"><xsl:value-of select="$page"/></xsl:with-param>
                        <xsl:with-param name="illustration">1</xsl:with-param>
                        <xsl:with-param name="prefixe"><xsl:value-of select="$prefixe"/></xsl:with-param>
                    </xsl:call-template>
                </PAGEWEB>
            </xsl:if>
        </xsl:when>
        
        <xsl:when test="$mode='sommaire'">
            <xsl:variable name="nomintro"><xsl:choose>
                <xsl:when test="../../CHAPITRE"><xsl:value-of select="$balise"/>_<xsl:value-of select="$chapitre"/>__</xsl:when>
                <xsl:when test="../../SOUSCHAPITRE"><xsl:value-of select="$balise"/>_<xsl:value-of select="$chapitre"/>_<xsl:value-of select="$souschapitre"/>_</xsl:when>
                <xsl:when test="../../SECTION"><xsl:value-of select="$balise"/>_<xsl:value-of select="$chapitre"/>_<xsl:value-of select="$souschapitre"/>_<xsl:value-of select="$section"/></xsl:when>
                </xsl:choose>
            </xsl:variable>
            <ENTREESOM selection="{$selection=$nomintro}" noeud="true">
            <xsl:choose>
                <xsl:when test="$selection=$nomintro">
                    <xsl:if test="../../CHAPITRE">
                        <TITRE><xsl:value-of select="$titrebalise"/> du chapitre</TITRE>
                        <URLFLECHE><xsl:value-of select="concat($prefixe,$chapitre,'/index.html')"/></URLFLECHE>
                    </xsl:if>
                    <xsl:if test="../../SOUSCHAPITRE">
                        <TITRE><xsl:value-of select="$titrebalise"/><!-- du sous-chapitre--></TITRE>
                        <URLFLECHE><xsl:value-of select="concat($prefixe,$chapitre,'/',$souschapitre,'/index.html')"/></URLFLECHE>
                    </xsl:if>
                    <xsl:if test="../../SECTION">
                        <TITRE><xsl:value-of select="$titrebalise"/><!-- de la section--></TITRE>
                    </xsl:if>
                </xsl:when>
                <xsl:otherwise>
                    <xsl:if test="../../CHAPITRE">
                        <TITRE><xsl:value-of select="$titrebalise"/> du chapitre</TITRE>
                        <URLCLICK><xsl:value-of select="concat($prefixe,$chapitre,'/',$balise,'/index.html')"/></URLCLICK>
                    </xsl:if>
                    <xsl:if test="../../SOUSCHAPITRE">
                        <TITRE><xsl:value-of select="$titrebalise"/><!-- du sous-chapitre--></TITRE>
                        <URLCLICK><xsl:value-of select="concat($prefixe,$chapitre,'/',$souschapitre,'/',$balise,'/index.html')"/></URLCLICK>
                    </xsl:if>
                    <xsl:if test="../../SECTION">
                        <TITRE><xsl:value-of select="$titrebalise"/><!-- de la section--></TITRE>
                        <URLCLICK><xsl:value-of select="concat($prefixe,$chapitre,'/',$souschapitre,'/',$section,'/',$balise,'/index.html')"/></URLCLICK>
                    </xsl:if>
                </xsl:otherwise>
            </xsl:choose>
            </ENTREESOM>
        </xsl:when>
        
        <xsl:otherwise> <!-- when mode='base' -->
            <xsl:copy> 
                <xsl:apply-templates select="@*|node()"/>
            </xsl:copy> 
        </xsl:otherwise>
        
    </xsl:choose>
</xsl:template>

<!--...........................................................................................................................................-->

<!--APPLETDOC-->
<xsl:template match="APPLETDOC">
<xsl:param name="prefixe"></xsl:param>
<xsl:param name="mode"></xsl:param>
<xsl:param name="page"></xsl:param>
<xsl:param name="selection"></xsl:param>
<xsl:param name="appletdoc"><xsl:number count="APPLETDOC"/></xsl:param>

<xsl:choose>
    <xsl:when test="$mode='fichiers' ">
        <xsl:variable name="fichier">site/appliquettes/<xsl:value-of select="@label"/>/<xsl:value-of select="@label"/></xsl:variable>
<xsl:text disable-output-escaping="yes">
</xsl:text>
        <PAGEWEB nom="{$fichier}.html">
            <TITREFICHIER>Simulation '<xsl:value-of select="@titre"/>'</TITREFICHIER>
            <TITREPAGE><xsl:value-of select="@titre"/></TITREPAGE>
            <ZONETEXTE>
                <xsl:choose>
                    <xsl:when test="EXPLICATIONS/PAGE">
                        <xsl:apply-templates select="*[name() != 'EXPLICATIONS']"/>
                        <xsl:if test="$affichage != 'web'">
                            <EXPLICATIONS>
                                <xsl:for-each select="EXPLICATIONS/PAGE">
                                    <xsl:apply-templates/>
                                    <BR/>
                                </xsl:for-each>
                            </EXPLICATIONS>
                        </xsl:if>
                    </xsl:when>
                    <xsl:otherwise>
                        <xsl:apply-templates/>
                    </xsl:otherwise>
                </xsl:choose>
            </ZONETEXTE>
        </PAGEWEB>
        <xsl:if test="EXPLICATIONS/PAGE and $affichage='web'">
            <xsl:for-each select="EXPLICATIONS/PAGE">
                <PAGEWEB nom="{$fichier}_{position()}.html">
                    <TITREFICHIER>Explications - page <xsl:value-of select="@label"/></TITREFICHIER>
                    <xsl:call-template name="PAGEPAGE">
                        <xsl:with-param name="page"><xsl:value-of select="@label"/></xsl:with-param>
                        <xsl:with-param name="prefixe">../../</xsl:with-param>
                    </xsl:call-template>
                </PAGEWEB>
                <xsl:apply-templates select=".//FIGURE[@localisation='page'] | .//TABLEAU[@localisation='page']">
                    <xsl:with-param name="mode"><xsl:value-of select="$mode"/></xsl:with-param>
                    <xsl:with-param name="page"><xsl:value-of select="@label"/></xsl:with-param>
                    <xsl:with-param name="prefixe">../../</xsl:with-param>
                </xsl:apply-templates>
            </xsl:for-each>
        </xsl:if>
    </xsl:when>
    
    <!--cration du sommaire-->
    <xsl:when test="$mode='sommaire'">
        <xsl:variable name="lien"><xsl:value-of select="$prefixe"/>appliquettes/<xsl:value-of select="@label"/>/<xsl:value-of select="@label"/>.html</xsl:variable>
        <xsl:choose>
            <xsl:when test="position()=$appletdoc">
                <ENTREESOM selection="{$prefixe='../'}">
                    <TITRE><xsl:value-of select="@titre"/></TITRE>
                    <URLFLECHE><xsl:value-of select="concat($prefixe,'index.html')"/></URLFLECHE>
                    <URLCLICK><xsl:value-of select="$lien"/></URLCLICK>
                </ENTREESOM>
            </xsl:when>
            <xsl:otherwise>
                <xsl:if test="$prefixe=''">
                    <ENTREESOM selection="false">
                        <TITRE><xsl:value-of select="@titre"/></TITRE>
                        <URLFLECHE><xsl:value-of select="$lien"/></URLFLECHE>
                        <URLCLICK><xsl:value-of select="$lien"/></URLCLICK>
                    </ENTREESOM>
                </xsl:if>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:when>
</xsl:choose>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="APPLET">
<!-- normalement on ne devrait utiliser que le nom, mais temporairement on utilise aussi la classe -->
<!-- il ne devrait pas non plus etre ncessaire d'utiliser [name()!='archive'] -->
    <xsl:choose>
        <xsl:when test="@nom='AstroImage' or @classe='AstroImage'">
            <APPLET classe="AstroImage" archive="applets/AstroImage.jar">
                <xsl:apply-templates select="@*[name()!='archive']|node()"/>
            </APPLET>
        </xsl:when>
        <xsl:when test="@nom='VisImage' or @classe='VisImage'">
            <APPLET classe="VisImage" archive="applets/VisImage.jar">
                <xsl:apply-templates select="@*[name()!='archive']|node()"/>
            </APPLET>
        </xsl:when>
        <xsl:when test="@nom='ImageCarte' or @classe='ImageCarte'">
            <APPLET classe="ImageCarte" archive="applets/ImageCarte.jar">
                <xsl:apply-templates select="@*[name()!='archive']|node()"/>
            </APPLET>
        </xsl:when>
        <xsl:when test="@nom='TabloGraphe' or @classe='TabloGraphe'">
            <xsl:choose>
                <xsl:when test="$affichage='impression'">
                    <!-- le '../' est parce-que le fichier XSL est dans un dossier XSL -->
                    <!-- on suppose que les contributions sont dans $project/contribXML -->
                    <xsl:for-each select="document(concat('../', $projet, '/contribXML/', ancestor::*[@contrib][1]/@contrib, '/', PARAM[@nom='fichierXML']/@valeur))/TABLE">
                        <xsl:copy>
                            <xsl:apply-templates select="@*|node()"/>
                        </xsl:copy>
                    </xsl:for-each>
                </xsl:when>
                <xsl:otherwise>
                    <APPLET classe="tablographe.TabloGraphe" archive="applets/TabloGraphe.jar">
                        <xsl:apply-templates select="@*[name()!='archive' and name()!='classe']|node()"/>
                    </APPLET>
                </xsl:otherwise>
            </xsl:choose>
        </xsl:when>
        <xsl:when test="@nom='CoordImage' or @classe='CoordImage'">
            <APPLET classe="CoordImage" archive="applets/CoordImage.jar">
                <xsl:apply-templates select="@*[name()!='archive']|node()"/>
            </APPLET>
        </xsl:when>
        <xsl:when test="@nom='Fit' or @classe='Fit'">
            <APPLET classe="Fit" archive="applets/Fit.jar">
                <xsl:apply-templates select="@*[name()!='archive']|node()"/>
            </APPLET>
        </xsl:when>
        <xsl:when test="@nom='Coupes' or @classe='Coupes'">
            <APPLET classe="Coupes" archive="applets/Coupes.jar">
                <xsl:apply-templates select="@*[name()!='archive']|node()"/>
            </APPLET>
        </xsl:when>
        <xsl:when test="@nom='Calcotron' or @classe='Calcotron'">
            <APPLET classe="CalcoApplet" archive="applets/Calcotron.jar">
                <xsl:apply-templates select="@*[name()!='archive']|node()"/>
            </APPLET>
        </xsl:when>
        <xsl:when test="@nom='FTS' or @classe='FTS'">
            <APPLET classe="FTS" archive="applets/SimuLab.jar,applets/FTS.jar">
                <xsl:apply-templates select="@*[name()!='archive']|node()"/>
            </APPLET>
        </xsl:when>
        <xsl:when test="@nom='PoissonSample' or @classe='PoissonSample'">
            <APPLET classe="PoissonSample" archive="applets/SimuLab.jar,applets/Probas.jar">
                <xsl:apply-templates select="@*[name()!='archive']|node()"/>
            </APPLET>
        </xsl:when>
        <xsl:when test="@nom='Speckle' or @classe='Speckle'">
            <APPLET classe="Speckle" archive="applets/SimuLab.jar,applets/Speckle.jar">
                <xsl:apply-templates select="@*[name()!='archive']|node()"/>
            </APPLET>
        </xsl:when>
        <xsl:when test="@nom='CorpsNoir' or @classe='CorpsNoir'">
            <APPLET classe="corpsnoir.CorpsNoir" archive="applets/CorpsNoir.jar">
                <xsl:apply-templates select="@*[name()!='archive' and name()!='classe']|node()"/>
            </APPLET>
        </xsl:when>
        <xsl:when test="@nom='Atmosphere' or @classe='Atmosphere'">
            <APPLET classe="atmosphere.Atmosphere" archive="applets/Atmosphere.jar">
                <xsl:apply-templates select="@*[name()!='archive' and name()!='classe']|node()"/>
            </APPLET>
        </xsl:when>
        <xsl:when test="@nom='Binaires' or @classe='Binaires'">
            <APPLET classe="Binaires" archive="applets/SimuLab.jar,applets/Binaires.jar">
                <xsl:apply-templates select="@*[name()!='archive']|node()"/>
            </APPLET>
        </xsl:when>
        <xsl:when test="@nom='TF' or @classe='TF'">
            <APPLET classe="TF" archive="applets/SimuLab.jar,applets/TF.jar">
                <xsl:apply-templates select="@*[name()!='archive']|node()"/>
            </APPLET>
        </xsl:when>
        <xsl:when test="@nom='Pupilles' or @classe='Pupilles'">
            <APPLET classe="Pupilles" archive="applets/SimuLab.jar,applets/Pupilles.jar">
                <xsl:apply-templates select="@*[name()!='archive']|node()"/>
            </APPLET>
        </xsl:when>
        <xsl:when test="@nom='Composition' or @classe='composition.Composition'">
            <APPLET classe="composition.Composition" archive="applets/Composition.jar">
                <xsl:apply-templates select="@*[name()!='archive']|node()"/>
            </APPLET>
        </xsl:when>
        <xsl:when test="@nom='Traitement'">
            <APPLET classe="traitement.Traitement" archive="applets/Traitement.jar">
                <xsl:apply-templates select="@*[name()!='archive']|node()"/>
            </APPLET>
        </xsl:when>
        <xsl:when test="@nom='DarkEnergy' or @classe='DarkEnergy'">
            <APPLET classe="DarkEnergy" archive="applets/SimuLab.jar,applets/DarkEnergy.jar">
                <xsl:apply-templates select="@*[name()!='archive']|node()"/>
            </APPLET>
        </xsl:when>
        <xsl:when test="@nom='AgeUnivers' or @classe='AgeUnivers'">
            <APPLET classe="AgeUnivers" archive="applets/SimuLab.jar,applets/AgeUnivers.jar">
                <xsl:apply-templates select="@*[name()!='archive']|node()"/>
            </APPLET>
        </xsl:when>
        <xsl:when test="@nom='Diaporama' or @classe='Diaporama'">
            <APPLET classe="diaporama.Diaporama" archive="applets/Diaporama.jar">
                <xsl:apply-templates select="@*[name()!='archive']|node()"/>
            </APPLET>
        </xsl:when>
        <xsl:otherwise>
            <xsl:copy><xsl:apply-templates select="@*|node()"/></xsl:copy>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="@*|node()"> 
  <xsl:copy> 
    <xsl:apply-templates select="@*|node()"/> 
  </xsl:copy> 
</xsl:template>

</xsl:stylesheet>