<?xml version="1.0" encoding='ISO-8859-1' ?>

<!--<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:xalanredirect="org.apache.xalan.xslt.extensions.Redirect" version="1.0" extension-element-prefixes="xalanredirect">-->
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" version="1.0" xmlns:xalanredirect="http://xml.apache.org/xalan/redirect" extension-element-prefixes="xalanredirect">
<xsl:output method="html" indent="yes" doctype-public="-//W3C//DTD HTML 4.01 Transitional//EN" doctype-system="http://www.w3.org/TR/html4/loose.dtd" encoding="ISO-8859-1"/>

<!--Deuxime feuille de style XSLT pour le site ASM - *le* Observatoire -->
<xsl:param name="affichage"></xsl:param> <!-- web / impression / jaxe -->
<xsl:param name="commentaires">non</xsl:param> <!-- affichage des commentaires dans les pages web: oui ou non -->
<xsl:param name="public">non</xsl:param> <!-- site public: "oui" ou "non" (les formulaires ne sont pas affichs si public="oui") -->
<xsl:param name="imagespage2">imagespage2.html</xsl:param>

<xsl:template match="SITEASM">
    <xsl:choose>
    <xsl:when test="$affichage='impression' or $affichage='jaxe'">
        <html><head><title>document <xsl:value-of select="PROJET"/></title>
        <link type="text/css" rel="stylesheet" href="feuillesdestyle/style.css"/>
        </head>
        <body bgcolor="#ffffff">
        <xsl:if test="$affichage='impression'">
            <img src="interface/intro.png" alt="astronomie pour {PROJET}" width="500" height="36"/><br/>
        </xsl:if>
        <!-- ajouter le sommaire ici -->
        <xsl:apply-templates select="PAGEWEB" mode="depart"/>
        <xsl:if test="$affichage='impression'">
            <xsl:call-template name="reponses-exercices"/>
        </xsl:if>
        </body></html>
    </xsl:when>
    <xsl:otherwise>
        <!-- le glossaire -->
        <xalanredirect:write file="site/glossaire/glossaire.html">
            <html>
            <head>
                <title>glossaire</title>
                <link href="../feuillesdestyle/style.css" rel="stylesheet" type="text/css"/>
<script type="text/javascript">
    window.onload = fixStupidSafariBug;
    function fixStupidSafariBug() {
        if ((navigator.userAgent.toLowerCase().indexOf("safari") != -1) &amp;&amp;
                (window.location.href.match(/#(\w.+)/)))
            window.location.replace(window.location.hash);
    }
</script>
            </head>
            <body class="cours">
                <xsl:call-template name="zone_logo">
                    <xsl:with-param name="prefixe" select="'../'"/>
                </xsl:call-template>
                <xsl:call-template name="zone_bandeau">
                    <xsl:with-param name="prefixe" select="'../'"/>
                </xsl:call-template>
                <div class="zone_titre"><h1>Glossaire</h1></div>
                <div class="zone_contenu">
                <!--<dl>
                <xsl:apply-templates select="/SITEASM/PAGEWEB[not(ILLUSTRATION) or ILLUSTRATION=1]/ZONETEXTE//GLOSSAIRE | /SITEASM/PAGEWEB/ZONEFIGURES//GLOSSAIRE">
                    <xsl:sort select="concat(@ref,@mot)"/>
                    <xsl:with-param name="mode">fichier</xsl:with-param>
                </xsl:apply-templates>
                </dl>-->
                <!-- mieux, avec les lettres affiches :  -->
                <xsl:call-template name="lettres-glossaire">
                    <xsl:with-param name="lettres">ABCDEFGHIJKLMNOPQRSTUVWXYZ</xsl:with-param>
                </xsl:call-template>
                <br/><br/><br/><br/><br/><br/> <!-- pour que les liens pointent vers le haut de la page -->
                </div>
            </body>
            </html>
        </xalanredirect:write>
        
        <!-- le sommaire -->
        <xalanredirect:write file="site/sommaire.html">
            <html>
            <head>
                <title>Sommaire</title>
                <link href="feuillesdestyle/style.css" rel="stylesheet" type="text/css"/>
                <style type="text/css">
                    div.retrait { margin: 0 0 0 4em }
                </style>
            </head>
            <body class="cours">
                <xsl:call-template name="zone_logo"/>
                
                <xsl:call-template name="zone_bandeau"/>
                
                <div class="zone_titre">
                <h1>Sommaire</h1>
                </div>
                
                <div class="zone_contenu">
                <xsl:for-each select="/SITEASM/PAGEWEB[NIVEAUPAGE='chapitre']">
                    <div class="retrait">
                    <!--<xsl:value-of select="LABELCHAPITRE"/> - --><a class="sommaire2" href="{substring-after(@nom,'site/')}"><xsl:value-of select="TITREPAGE"/></a><br/>
                    <xsl:variable name="numchap" select="LABELCHAPITRE"/>
                    <xsl:for-each select="/SITEASM/PAGEWEB[NIVEAUPAGE='souschapitre' and LABELCHAPITRE=$numchap]">
                        <div class="retrait"><!--<xsl:value-of select="LABELSOUSCHAPITRE"/> - --><a class="sommaire3" href="{substring-after(@nom,'site/')}"><xsl:value-of select="TITREPAGE"/></a><br/>
                        <xsl:variable name="numsouschap" select="LABELSOUSCHAPITRE"/>
                        <!--<xsl:for-each select="/SITEASM/PAGEWEB[NIVEAUPAGE='section' and LABELCHAPITRE=$numchap and LABELSOUSCHAPITRE=$numsouschap]">
                            <h3><a href="{substring-after(@nom,'site/')}"><xsl:value-of select="TITREPAGE"/></a></h3><br/>
                        </xsl:for-each>-->
                        <!-- il n'y a pas de page section pour IUFM -> autre mthode pour les sections -->
                        <xsl:for-each select="SOMMAIRE//ENTREESOM[@selection='true']/LISTESOM/ENTREESOM">
                            <div class="retrait"><a class="sommairepage" href="{substring-after(URLCLICK,'../../')}"><xsl:value-of select="TITRE"/></a></div>
                        </xsl:for-each>
                        <br/></div>
                    </xsl:for-each>
                    <br/></div>
                </xsl:for-each>
                </div>
                </body>
            </html>
        </xalanredirect:write>
        
    <!-- la page web contenant la liste des commentaires des auteurs-->
        <xsl:if test="$commentaires='oui'">
            <xalanredirect:write file="site/commentaires.html">
                <html>
                <head>
                    <title>Commentaires des auteurs</title>
                    <link type="text/css" rel="stylesheet" href="feuillesdestyle/style.css"/>
                </head>
                <body bgcolor="#FFFFFF">
                <h1>Commentaires des auteurs</h1>
                <ul>
                    <xsl:apply-templates select="//COMMENTAIRE">
                        <xsl:with-param name="liste">oui</xsl:with-param>
                    </xsl:apply-templates>
                    </ul>
                </body>
                </html>
            </xalanredirect:write>
        </xsl:if>
        
    <!-- la page web contenant le message de reponse aux exos, c'est une page temporaire-->
    <!--
        <xalanredirect:write file="site/reponse.html">
            <html><head><title>rponse</title>
            <link type="text/css" rel="stylesheet" href="feuillesdestyle/style.css"/>
            </head><body bgcolor="#ffffff">
            <img src="interface/intro.png"  alt="astronomie pour {PROJET}" width="500" height="36"/><br/>
            <table width="100%"><tr><td width="200">
            <a href="index.html">Retour au sommaire</a>
            </td><td width="85%">
            <div class="sommairechapitre">Votre rponse s'est perdue dans l'ocan numrique, peut-tre qu'un jour quelqu'un trouvera cette bouteille virtuelle, et alors vous saurez...</div>
            </td></tr></table>
            </body></html>
        </xalanredirect:write>
    -->

        <xsl:apply-templates select="PAGEWEB" mode="depart"/>
    </xsl:otherwise>
    </xsl:choose>
</xsl:template>


<xsl:template name="lettres-glossaire">
    <xsl:param name="lettres"/>
    
    <xsl:variable name="lettre" select="substring($lettres,1,1)"/>
    
        <h2>- <xsl:value-of select="$lettre"/> -</h2>
        <dl>
            <xsl:apply-templates select="/SITEASM/PAGEWEB[not(ILLUSTRATION) or ILLUSTRATION=1]/ZONETEXTE//GLOSSAIRE[translate(substring(@ref,1,1),'abcdefghijklmnopqrstuvwxyz','AABCCDEEEEFGHIIIJKLMNOOPQRSTUUVWXYZ')=$lettre or (not(@ref) and translate(substring(@mot,1,1),'abcdefghijklmnopqrstuvwxyz','AABCCDEEEEFGHIIIJKLMNOOPQRSTUUVWXYZ')=$lettre)] | /SITEASM/PAGEWEB/ZONEFIGURES//GLOSSAIRE[translate(substring(@ref,1,1),'abcdefghijklmnopqrstuvwxyz','AABCCDEEEEFGHIIIJKLMNOOPQRSTUUVWXYZ')=$lettre or (not(@ref) and translate(substring(@mot,1,1),'abcdefghijklmnopqrstuvwxyz','AABCCDEEEEFGHIIIJKLMNOOPQRSTUUVWXYZ')=$lettre)]">
                <xsl:sort select="concat(@ref,@mot)"/>
                <xsl:with-param name="mode">fichier</xsl:with-param>
            </xsl:apply-templates>
    </dl>
    <xsl:if test="string-length($lettres)&gt;1">
        <xsl:call-template name="lettres-glossaire">
            <xsl:with-param name="lettres"><xsl:value-of select="substring($lettres,2)"/></xsl:with-param>
        </xsl:call-template>
    </xsl:if>
</xsl:template>


<xsl:template name="zone_logo">
    <xsl:param name="prefixe"/>
    <div class="zone_logo">
        <xsl:variable name="urlprojet"><xsl:choose>
            <xsl:when test="/SITEASM/PROJET='UEL'">http://foad.obspm.fr/rubrique89.html</xsl:when>
            <xsl:when test="/SITEASM/PROJET='IUFM'">http://foad.obspm.fr/</xsl:when>
            <xsl:when test="/SITEASM/PROJET='DEA'">http://master-recherche.obspm.fr/rubrique28.html</xsl:when>
            <xsl:otherwise>http://foad.obspm.fr/</xsl:otherwise>
        </xsl:choose></xsl:variable>
        <a href="{$urlprojet}"><img src="{$prefixe}interface/logo.png" width="190" height="64" alt="Observatoire de Paris - UFE" border="0"/></a>
    </div>
</xsl:template>


<xsl:template name="zone_bandeau">
    <xsl:param name="prefixe"/>
    <div class="zone_bandeau">
        <xsl:choose>
        <xsl:when test="/SITEASM/PROJET='IUFM'"><img src="{$prefixe}interface/intro.png" width="442" height="36" alt="Astronomie et Mcanique cleste"/></xsl:when>
        <xsl:when test="/SITEASM/PROJET='UEL'"><a href="http://foad.obspm.fr/rubrique89.html"><img src="{$prefixe}interface/intro.png" width="500" height="36" alt="Fentres sur l'Univers" border="0"/></a></xsl:when>
        <xsl:when test="/SITEASM/PROJET='DEA'"><img src="{$prefixe}interface/intro.png" width="500" height="36" alt="Les cours en ligne de l'Ecole Doctorale"/></xsl:when>
        </xsl:choose>
    </div>
</xsl:template>


<xsl:template match="PAGEWEB" mode="depart">
    <xsl:choose>
    <xsl:when test="$affichage='impression' or $affichage='jaxe'">
        <!--<xsl:if test="ZONETEXTE!='' or ZONEFIGURES!=''">-->
            <xsl:apply-templates select="." mode="contenuimpr"/>
        <!--</xsl:if>-->
    </xsl:when>
    <xsl:otherwise>
        <!--<xsl:message><xsl:value-of select="@nom"/></xsl:message>-->
        <xsl:if test="NIVEAUPAGE != 'section'"> <!-- les pages section sont pour la coquille UEL -->
            <xalanredirect:write file="{@nom}">
                <html>
                <head>
                    <title><xsl:value-of select="TITREFICHIER"/></title>
                    <link type="text/css" rel="stylesheet" href="{PREFIXE}feuillesdestyle/style.css"/>
                    <link rel="Start" href="{PREFIXE}index.html"/>
                    <link rel="Contents" href="{PREFIXE}sommaire.html"/>
                    <link rel="Glossary" href="{PREFIXE}glossaire/glossaire.html"/>
                    <xsl:if test="PAGEPRECEDENTE/URL!=''">
                        <link rel="Prev" href="{PAGEPRECEDENTE/URL}"/>
                    </xsl:if>
                    <xsl:if test="SOMMAIRE//ENTREESOM[@selection='true'][1]/../../URLCLICK!=''">
                        <link rel="Up" href="{SOMMAIRE//ENTREESOM[@selection='true'][1]/../../URLCLICK}"/>
                    </xsl:if>
                    <xsl:if test="PAGESUIVANTE/URL!=''">
                        <link rel="Next" href="{PAGESUIVANTE/URL}"/>
                    </xsl:if>
                    <xsl:if test="ZONETEXTE//QCM">
                        <xsl:call-template name="script-qcm"/>
                    </xsl:if>
                </head>
                
                <xsl:for-each select="ZONETEXTE[.//EXERCICE or .//QCM]">
                    <xsl:call-template name="fichiers-aide"/>
                </xsl:for-each>
                
                <body class="cours">
                
                    <xsl:apply-templates select="." mode="contenuweb"/>
                
                </body>
                </html>
            </xalanredirect:write>
        </xsl:if>
    </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<!-- affichage d'une page pour le web -->
<xsl:template match="PAGEWEB" mode="contenuweb">

<xsl:variable name="prefixe" select="PREFIXE"/>

<!--
Organisation des divs:

     ______________________
    |      intro      | lo |
    |_________________| go |
    |outils |  titre  |    |
    |       |_________|____|
    |       |              |
    |  som  |  corps du    |
    | maire |  texte       |
    |       |              |
    |       |              |
    |       |              |
    |_______|______________|

-->

<xsl:call-template name="zone_logo">
    <xsl:with-param name="prefixe" select="$prefixe"/>
</xsl:call-template>

<xsl:call-template name="zone_bandeau">
    <xsl:with-param name="prefixe" select="$prefixe"/>
</xsl:call-template>

<div class="zone_sommaire">
    <xsl:if test="/SITEASM/PROJET != 'DEA'">
        <div class="zone_outils">
            <a href="{$prefixe}sommaire.html" title="sommaire"><img src="{$prefixe}interface/sommaire_petit.gif" width="25" height="25" border="0" alt="sommaire"/></a>
            &#xA0;&#xA0;
            <a href="{$prefixe}glossaire/glossaire.html" title="glossaire" target="_blank"><img src="{$prefixe}interface/glossaire_petit.gif" width="25" height="25" border="0" alt="glossaire"/></a>
            <xsl:if test="$public!='oui' and $commentaires!='oui'">
                &#xA0;&#xA0;
                <a href="{$prefixe}../recherche/" title="recherche" target="_blank"><img src="{$prefixe}interface/loupe_petit.gif" width="25" height="25" border="0" alt="recherche"/></a>
            </xsl:if>
        </div>
    </xsl:if>
    
    <div class="zone_mininav">
        <table width="100%"><tr>
            <td>
            <xsl:if test="PAGEPRECEDENTE">
                <a href="{PAGEPRECEDENTE/URL}"><img src="{$prefixe}interface/petiteflechegauche.gif" width="25" height="16" border="0" alt="&lt;-" title="page prcdente"/></a>
            </xsl:if>
            </td>
        
            <td align="right">
            <xsl:if test="PAGESUIVANTE">
                <a href="{PAGESUIVANTE/URL}"><img src="{$prefixe}interface/petiteflechedroite.gif" width="25" height="16" border="0" alt="-&gt;" title="page suivante"/></a>
            </xsl:if>
            </td>
        </tr></table>
    </div>
    
    <div class="sommaire">
        <xsl:apply-templates select="SOMMAIRE"/>
    </div>
</div>

<div class="zone_titre">
    <xsl:choose>
    <xsl:when test="/SITEASM/PROJET = 'UEL'">
        <xsl:choose>
            <xsl:when test="TITREPAGE != ''">
                <h1><xsl:value-of select="TITREPAGE"/></h1>
            </xsl:when>
            <xsl:when test="TITRESECTION != ''">
                <h1><xsl:value-of select="TITRESECTION"/></h1>
            </xsl:when>
        </xsl:choose>
    </xsl:when>
    <xsl:otherwise>
        <xsl:choose>
            <xsl:when test="TITRESECTION != ''">
                <h1><xsl:value-of select="TITRESECTION"/>
                <xsl:if test="NUMEROPAGE and TOTALPAGES">
                    &#160;
                    (<i><xsl:value-of select="NUMEROPAGE"/>/<xsl:value-of select="TOTALPAGES"/></i>)
                </xsl:if>
                </h1>
            </xsl:when>
            <xsl:otherwise>
                <h1><xsl:value-of select="TITREPAGE"/></h1>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:otherwise>
    </xsl:choose>
</div>

<div class="zone_contenu">
    <div class="zone_infos">
        
        <xsl:if test="NIVEAUPAGE='page' and NIVEAULMD!=''">
            <div class="auteurs">
                <xsl:apply-templates select="NIVEAULMD"/>
            </div>
        </xsl:if>
        
        <xsl:if test="PAGESUEL">
            <div class="pages_uel">
                <table bgcolor="#FF9400" border="0">
                <tr>
                <xsl:for-each select="PAGESUEL/PARTIEUEL">
                    <xsl:choose>
                        <xsl:when test="@selection='true'">
                            <td bgcolor="#F6F4B9"><b><xsl:value-of select="TITRE"/></b></td>
                        </xsl:when>
                        <xsl:otherwise>
                            <td bgcolor="#FEEBB8"><b><a class="theme" href="{URL}"><xsl:value-of select="TITRE"/></a></b></td>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:for-each>
                </tr>
                </table>
            </div>
        </xsl:if>
        
        <xsl:if test="NIVEAUPAGE='souschapitre' or NIVEAUPAGE='section' or (TYPEPAGE='INTRODUCTION' and AUTEUR!='')">
            <div class="auteurs">
                <xsl:call-template name="auteurs"/>
                <xsl:apply-templates select="DATEMAJ"/>
                <xsl:apply-templates select="NIVEAULMD"/>
            </div>
        </xsl:if>
    </div>
    
    <xsl:if test="ZONEFIGURES">
        <xsl:variable name="typezone"><xsl:choose>
            <xsl:when test="ZONEFIGURES/TABLEAU">zone_tableau</xsl:when>
            <xsl:otherwise>zone_figure</xsl:otherwise>
        </xsl:choose></xsl:variable>
        <div class="{$typezone}">
            <xsl:if test="IMAGETTES/URL">
                <div class="imagettes">
                    <xsl:for-each select="IMAGETTES/URL">
                        <xsl:choose>
                            <xsl:when test="@selection='true'">
                                <img src="{$prefixe}interface/imagesel.gif" alt="figure" border="0" width="59" height="52"><xsl:if test="@titre!=''">
                                    <xsl:attribute name="title"><xsl:value-of select="@titre"/></xsl:attribute>
                                </xsl:if></img>
                            </xsl:when>
                            <xsl:otherwise>
                                <a href="{.}">
                                <img src="{$prefixe}interface/images.gif" alt="figure" border="0" width="59" height="52"><xsl:if test="@titre!=''">
                                    <xsl:attribute name="title"><xsl:value-of select="@titre"/></xsl:attribute>
                                </xsl:if></img></a>
                            </xsl:otherwise>
                        </xsl:choose>
                    </xsl:for-each>
                </div>
            </xsl:if>
            <div class="cadre_figure">
                <xsl:apply-templates select="ZONEFIGURES/*"/>
            </div>
        </div>
    </xsl:if>
    
    <div class="zone_texte">
        <xsl:if test="ZONETEXTE or TITREPAGE">
            <xsl:if test="/SITEASM/PROJET != 'UEL' and TITRESECTION!='' and TITREPAGE!=''">
                <h2><xsl:value-of select="TITREPAGE"/></h2>
            </xsl:if>
            <xsl:apply-templates select="ZONETEXTE"/>
        </xsl:if>
    </div>
    
    <div class="spacer"></div>
    
    <div class="zone_liens">
    <table width="100%"><tr>
        <td>
        <xsl:if test="PAGEPRECEDENTE">
            <a href="{PAGEPRECEDENTE/URL}"><img src="{$prefixe}interface/flechegauche.gif" width="48" height="31" border="0" alt="page prcdente" title="page prcdente"/></a>
        </xsl:if>
        </td>
        <xsl:for-each select="AUTRELIEN">
            <xsl:variable name="txtvers"><xsl:choose>
                <xsl:when test="@vers='ensavoirplus'">en savoir plus</xsl:when>
                <xsl:otherwise><xsl:value-of select="@vers"/></xsl:otherwise>
            </xsl:choose></xsl:variable>
            <td align="center">
                <a href="{URL}" class="sommairepage"><img src="{$prefixe}interface/{@vers}.gif" border="0" alt="page {$txtvers}"/><br/><xsl:value-of select="$txtvers"/></a>
            </td>
        </xsl:for-each>
        <td align="right">
        <xsl:if test="PAGESUIVANTE">
            <a href="{PAGESUIVANTE/URL}"><img src="{$prefixe}interface/flechedroite.gif" width="48" height="31" border="0" alt="page suivante" title="page suivante"/></a>
        </xsl:if>
        </td>
    </tr></table>
    </div>
</div>
</xsl:template>

<!-- affichage d'une page pour Jaxe ou pour l'impression -->
<xsl:template match="PAGEWEB" mode="contenuimpr">
    
    <xsl:if test="LABELCHAPITRE!=''">
        <tt><xsl:value-of select="concat('chapitre ', LABELCHAPITRE)"/>
        <xsl:if test="LABELSOUSCHAPITRE!=''">
            <xsl:value-of select="concat(', souschapitre ', LABELSOUSCHAPITRE)"/>
        </xsl:if>
        <xsl:if test="LABELSECTION!=''">
            <xsl:value-of select="concat(', section ', LABELSECTION)"/>
        </xsl:if>
        <xsl:if test="LABELPAGE!=''">
            <xsl:value-of select="concat(', page ', LABELPAGE)"/>
        </xsl:if>
        <xsl:if test="../PROJET='UEL' and LABELPAGE!=''">
            <xsl:value-of select="concat(', partie ', PAGESUEL/PARTIEUEL[@selection='true']/TITRE)"/>
        </xsl:if>
        </tt>
        <!-- ajouter ici info page UEL -->
        <br/>
    </xsl:if>

    <xsl:choose>
        <xsl:when test="/SITEASM/PROJET = 'UEL'">
            <xsl:choose>
                <xsl:when test="TITREPAGE != ''">
                    <h1><xsl:value-of select="TITREPAGE"/></h1>
                </xsl:when>
                <xsl:when test="TITRESECTION != ''">
                    <h1><xsl:value-of select="TITRESECTION"/></h1>
                </xsl:when>
            </xsl:choose>
        </xsl:when>
        <xsl:otherwise>
                <h1><xsl:value-of select="TITRESECTION"/>
                <xsl:if test="NUMEROPAGE and TOTALPAGES">
                    &#160;
                    (<i><xsl:value-of select="NUMEROPAGE"/>/<xsl:value-of select="TOTALPAGES"/></i>)
                </xsl:if>
                </h1>
        </xsl:otherwise>
    </xsl:choose>
    
    <!-- on affiche le sommaire si c'est la premire page, avec l'index -->
    <xsl:if test="NIVEAUPAGE='index'">  <!--or NIVEAUPAGE='chapitre'-->
        <xsl:apply-templates select="SOMMAIRE"/>
    </xsl:if>
    
    <xsl:if test="ZONETEXTE">
        <xsl:if test="/SITEASM/PROJET != 'UEL'">
            <h2><xsl:value-of select="TITREPAGE"/></h2>
        </xsl:if>
        <xsl:apply-templates select="ZONETEXTE"/>
    </xsl:if>
    
    <xsl:if test="$affichage='impression'">
        <xsl:comment>PAGE BREAK</xsl:comment> <!-- pour htmldoc -->
        <div style="page-break-after: always"/> <!-- pour les navigateurs comprenant CSS 2 -->
    </xsl:if>
</xsl:template>


<!--...........................................................................................................................................-->

<xsl:template match="SOMMAIRE">
    <xsl:choose>
    <xsl:when test="$affichage='web'">
        <a href="{ancestor::PAGEWEB/PREFIXE}index.html" class="sommaire1">Liste des chapitres</a>
    </xsl:when>
    <xsl:otherwise>
        <a class="sommaire1">Sommaire</a>
    </xsl:otherwise>
    </xsl:choose>
    
    <xsl:apply-templates/>
</xsl:template>

<xsl:template match="ENTREESOM">
    <xsl:variable name="classe">
        <xsl:choose>
            <xsl:when test="@selection='true'"><xsl:choose>
                <xsl:when test="LISTESOM">fondsel1sommaire</xsl:when>
                <xsl:otherwise>fondsel2sommaire</xsl:otherwise>
            </xsl:choose></xsl:when>
            <xsl:otherwise><xsl:choose>
                <xsl:when test="../../@selection='true'">fondsel1sommaire</xsl:when>
                <xsl:otherwise>fondsommaire</xsl:otherwise>
            </xsl:choose></xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:variable name="niveau">
        <xsl:choose>
            <xsl:when test="@noeud='true'">page</xsl:when>
            <xsl:otherwise><xsl:value-of select="count(ancestor::ENTREESOM)+1"/></xsl:otherwise>
        </xsl:choose>
    </xsl:variable>
    <xsl:choose>
    <xsl:when test="$affichage='web'">
        <xsl:choose>
            <xsl:when test="@noeud='true'">
                <div class="{$classe}">
                <a class="sommaire{$niveau}"><xsl:if test="URLCLICK"><xsl:attribute name="href"><xsl:value-of select="URLCLICK"/></xsl:attribute></xsl:if><img src="{ancestor::PAGEWEB/PREFIXE}interface/page.gif"  border="0" alt="o" width="8" height="5"/><xsl:value-of select="TITRE"/><xsl:text> </xsl:text></a>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div class="{$classe}">
                <a href="{URLFLECHE}"><xsl:choose>
                    <xsl:when test="@selection='true' or descendant::*[@selection='true']"><img src="{ancestor::PAGEWEB/PREFIXE}interface/listeactive.gif" border="0" alt="-" width="11" height="11"/></xsl:when>
                    <xsl:otherwise><img src="{ancestor::PAGEWEB/PREFIXE}interface/listeinactive.gif" border="0" alt="+" width="11" height="11"/></xsl:otherwise>
                </xsl:choose></a><xsl:choose>
                    <xsl:when test="@selection='true' and not(descendant::*[@selection='true'])"><a href="{URLCLICK}" class="sommaire{$niveau}select"><xsl:value-of select="TITRE"/><xsl:text> </xsl:text></a></xsl:when>
<!-- l'espace aprs le titre est pour rattraper un bug de netscape 7.0 sur windows -->
                    <xsl:otherwise><a href="{URLCLICK}" class="sommaire{$niveau}"><xsl:value-of select="TITRE"/><xsl:text> </xsl:text></a></xsl:otherwise>
                </xsl:choose>
                <xsl:apply-templates select="LISTESOM"/>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:when>
    <xsl:otherwise>
        <xsl:choose>
            <xsl:when test="LISTESOM">
                <div class="{$classe}">
                <xsl:value-of select="count(preceding-sibling::ENTREESOM)+1"/>. <xsl:value-of select="TITRE"/>
                <xsl:apply-templates select="LISTESOM"/>
                </div>
            </xsl:when>
            <xsl:otherwise>
                <div class="{$classe}">
                <xsl:value-of select="count(preceding-sibling::ENTREESOM)+1"/>. <xsl:value-of select="TITRE"/>
                </div>
            </xsl:otherwise>
        </xsl:choose>
    </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="LISTESOM">
    <div class="divsommaire">
        <xsl:apply-templates/>
    </div>
</xsl:template>


<!--...........................................................................................................................................-->

<!--GESTION DES MINISECTIONS-->
<xsl:template match="MINISECTION">

    <div class="minisection">
    <xsl:if test="@label!=''">
        <a name="{@label}"/>
    </xsl:if>
    <xsl:if test="@titre">
        <h3><xsl:value-of select="@titre"/></h3>
    </xsl:if>
    <xsl:apply-templates/>
    <br/>
    </div>
</xsl:template>

<!--...........................................................................................................................................-->

<!--GESTION DES PARAGRAPHES-->
<xsl:template match="PARAGRAPHE">

    <xsl:if test="@label!=''">
        <a name="{@label}"/>
    </xsl:if>
    <xsl:choose>
        <xsl:when test="@titre!=''">
            <h3><xsl:value-of select="@titre"/></h3>
        </xsl:when>
        <xsl:otherwise>
            <!--<br/>-->
        </xsl:otherwise>
    </xsl:choose>
    <xsl:choose>
        <xsl:when test='position()=2'>
            <div class="premierparagraphe">
            <xsl:apply-templates/>
            <br/>
            </div>
        </xsl:when>
        <xsl:otherwise>
            <div class="paragraphe">
            <xsl:apply-templates/>
            <br/>
            </div>
        </xsl:otherwise>
    </xsl:choose>
    <!-- on utilise des br au lieu de CSS pour que a marche sans CSS -->
    <!-- maj : on laisse tomber la gestion sans CSS
         attention en cas de changement, les questions utilisent la classe css paragraphe
    <xsl:if test="not(following-sibling::*[1][name()='LISTEPOINTS' or name()='LISTENUM' or name()='LISTEDEF'])">
        <br/>
    </xsl:if>
    -->
</xsl:template>

<!--...........................................................................................................................................-->

<!--GESTION DES TP-->
<!-- inutilis: les TPs sont transforms en sous-chapitres par ASM_TP -->
<xsl:template match="TP">
    <div align="center"><h1>TP: <xsl:value-of select="@titre"/></h1></div>
    <!--Tableau en en-tete-->
    <table border="1" cellpadding="2" align="center">
    <xsl:if test="NIVEAU">
        <tr>
        <td><b>Champs</b></td>
        <td><b><xsl:value-of select="CHAMP"/></b></td>
        </tr>
    </xsl:if>
    <xsl:if test="NIVEAU">
        <tr>
        <td><b>Niveau scolaire</b></td>
        <td><b><xsl:value-of select="NIVEAU"/></b></td>
        </tr>
    </xsl:if>
    <xsl:if test="TEMPS">
        <tr>
        <td><b>Temps ncessaire</b></td>
        <td><b><xsl:value-of select="TEMPS"/></b></td>
        </tr>
    </xsl:if>
    <tr>
    <td colspan="2">
    <ul>
    <xsl:if test="OBJECTIFS">
        <li><b><a href="#objectifs">Objectifs</a></b></li>
    </xsl:if>
    <xsl:if test="PREREQUIS">
        <li><b><a href="#prerequis">Prrequis</a></b></li>
    </xsl:if>
    <xsl:if test="DOCUMENTS">
        <li><b><a href="#documents">Documents et/ou matriel</a></b></li>
    </xsl:if>

    <xsl:if test="DEROULEMENT">
        <li><b><a href="#deroulement">Droulement</a></b></li>
    </xsl:if>

    <xsl:if test="CONCLUSION">
        <li><b><a href="#conclusion">Conclusion</a></b></li>
    </xsl:if>
    <xsl:if test="BIBLIOGRAPHIE">
        <li><b><a href="#bibliographie">Bibliographie</a></b></li>
    </xsl:if>
    </ul>
    </td>
    </tr>
    </table>
    <!--Fin tableau en en-tete-->
    <xsl:apply-templates/>
    <br/>
</xsl:template>

<!--...........................................................................................................................................-->

<!--GESTION DES AUTEURS-->
<xsl:template name="auteurs">
    <xsl:choose>
        <xsl:when test="count(AUTEUR)=1">
            <b>Auteur: <i><xsl:value-of select="AUTEUR"/></i></b><br/>
        </xsl:when>
        <xsl:when test="count(AUTEUR)&gt;1">
            <b>Auteurs: 
            <i><xsl:for-each select="AUTEUR"><xsl:value-of select="."/><xsl:if test="position()!=last()">, </xsl:if></xsl:for-each></i></b><br/>
        </xsl:when>
    </xsl:choose>
</xsl:template>

<!--
<xsl:template match="AUTEUR">      
</xsl:template>
-->

<!--...........................................................................................................................................-->

<!--GESTION DE LA DATE DE CREATION -->
<xsl:template match="DATECRE">
    
<br/><div align="right">Date de cration&#xA0;: <i><xsl:apply-templates/></i></div><br/>
</xsl:template>

<!--...........................................................................................................................................-->

<!--GESTION DE LA DATE DE MISE A JOUR-->
<xsl:template match="DATEMAJ">
    
<br/><div align="right">Date de mise  jour&#xA0;: <i><xsl:apply-templates/></i></div><br/>
</xsl:template>

<!--...........................................................................................................................................-->

<!--GESTION DES LIENS-->
<!-- remplac par A dans ASM_1 -->

<!--GESTION DES LIENS A-->
<xsl:template match="A">
    <xsl:element name="a">
        <xsl:if test="@class">
            <xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute>
        </xsl:if>
        <xsl:if test="@href">
            <xsl:attribute name="href"><xsl:value-of select="@href"/></xsl:attribute>
            <xsl:if test="starts-with(@href,'http://') or ancestor::AIDE or ancestor::SOLUTION">
                <xsl:attribute name="target">_blank</xsl:attribute>
            </xsl:if>
        </xsl:if>
        <xsl:if test="@name">
            <xsl:attribute name="name"><xsl:value-of select="@name"/></xsl:attribute>
        </xsl:if>
        <xsl:apply-templates/>
    </xsl:element>
</xsl:template>

<!--...........................................................................................................................................-->

<!--GESTION DES FIGURES-->
<xsl:template match="FIGURE">
    <xsl:choose>
        <xsl:when test="@localisation='icne' and $affichage='web'">
            <xsl:variable name="rep"><xsl:call-template name="repfichier"><xsl:with-param name="chemin" select="ancestor::PAGEWEB/@nom"/></xsl:call-template></xsl:variable>
            <xsl:variable name="nomfichier">figure_<xsl:choose>
                <xsl:when test="@label!=''"><xsl:value-of select="@label"/></xsl:when>
                <xsl:otherwise><xsl:value-of select="translate(substring-before(FICHIER[1]/@nom,'.'),'/','_')"/></xsl:otherwise>
            </xsl:choose><xsl:if test="/SITEASM/PROJET='UEL'">_<xsl:value-of select="ancestor::PAGEWEB/THEMEUEL"/></xsl:if>.html</xsl:variable>
            <xsl:variable name="prefixe"><xsl:if test="$affichage='web'"><xsl:value-of select="ancestor::PAGEWEB/PREFIXE"/></xsl:if></xsl:variable>
            <xalanredirect:write file="{concat($rep, '/', $nomfichier)}">
                <html>
                <head>
                    <title><xsl:value-of select="@titre"/></title>
                    <link type="text/css" rel="stylesheet" href="{$prefixe}feuillesdestyle/style.css"/>
                    <script language="JavaScript" type="text/javascript">
                        window.onblur = fermeture;
                        function fermeture() { window.close(); }
                    </script>
                </head>
                <body>
                    <xsl:if test="@label!=''"><a name="{@label}"/></xsl:if>
                    <div align="center">
                        <xsl:if test="@titre!=''">
                            <b class="titretable"><xsl:value-of select="@titre"/></b><br/>
                        </xsl:if>
                        <xsl:apply-templates/>
                    </div>
                </body>
                </html>
            </xalanredirect:write>
            <xsl:apply-templates select="FICHIER[1]">
                <xsl:with-param name="icone" select="'petite'"/>
                <xsl:with-param name="lienicone" select="$nomfichier"/>
            </xsl:apply-templates>
        </xsl:when>
        <xsl:otherwise>
            <xsl:if test="not(@localisation) or @localisation='texte' or $affichage='impression'">
                <br/>
            </xsl:if>
            <xsl:if test="@label!=''"><a name="{@label}"/></xsl:if>
            <div align="center">
                <xsl:if test="@titre!=''">
                    <b class="titretable"><xsl:value-of select="@titre"/></b><br/>
                </xsl:if>
                <xsl:apply-templates/>
            </div>
            <br/>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<!--...........................................................................................................................................-->

<!--GESTION DES FICHIERS-->
<xsl:template match="FICHIER">
<xsl:param name="icone">non</xsl:param>
<xsl:param name="lienicone"/>

<xsl:variable name="temp">
<xsl:value-of select="substring-before(@nom,'/')"/>
</xsl:variable>

<xsl:variable name="prefixe"><xsl:if test="$affichage='web'"><xsl:value-of select="ancestor::PAGEWEB/PREFIXE"/></xsl:if></xsl:variable>
<!--
<xsl:variable name="prefixeimages"><xsl:choose>
<xsl:when test="ancestor::TP"></xsl:when>
<xsl:otherwise><xsl:value-of select="concat($prefixe,'chapitre',ancestor::PAGEWEB/LABELCHAPITRE,'/souschapitre',ancestor::PAGEWEB/LABELSOUSCHAPITRE,'/')"/></xsl:otherwise>
</xsl:choose></xsl:variable>

et plus loin:
                    <a href="{$prefixeimages}grandesimages/{@nom}" name="{@label}" target="_blank">
-->
<xsl:variable name="contrib" select="ancestor::*[CONTRIB!='']/CONTRIB"/>

<xsl:choose>
    <xsl:when test="$affichage='web' and (parent::ZONEFIGURES or ../@localisation='page' or ../@localisation='icne' or @type='mng')">
        <xsl:if test="@label!=''"><a name="{@label}"/></xsl:if>
        
        <xsl:if test= "@type='png' or @type='jpeg' or @type='gif' or @type='mng' or @type='mpeg'">
            <xsl:variable name="nom" select="@nom"/>
            <xsl:variable name="type" select="@type"/>
            <xsl:variable name="localisation" select="../@localisation"/>
            
            <xsl:for-each select="document($imagespage2)/html/body/table/tr[td[1]=$nom and td[2]=$contrib and td[10]=$localisation][position()=1]">
                <xsl:variable name="carte"><xsl:choose>
                    <xsl:when test="td[8]='oui'">oui</xsl:when>
                    <xsl:otherwise>non</xsl:otherwise>
                </xsl:choose></xsl:variable>
                <xsl:variable name="redim" select="td[5]='oui'"/>
                <xsl:variable name="nouveaunom" select="td[9]"/>
                <xsl:variable name="largeur1" select="number(td[3])"/> <!-- autrefois appel "largeur2" -->
                <xsl:variable name="hauteur1" select="number(td[4])"/>
                <xsl:variable name="largeur2" select="number(td[6])"/> <!-- autrefois appel "largeur" -->
                <xsl:variable name="hauteur2" select="number(td[7])"/>
                <xsl:variable name="grandeimage" select="concat($prefixe,'images/',$contrib,'/',$nouveaunom)"/>
                <xsl:variable name="dossierpetiteimage"><xsl:choose><xsl:when test="$localisation='page'">images_page</xsl:when><xsl:when test="$localisation='icne'">images_icone</xsl:when><xsl:otherwise>images_texte</xsl:otherwise></xsl:choose></xsl:variable>
                <xsl:variable name="petiteimage" select="concat($prefixe,$dossierpetiteimage,'/',$contrib,'/',$nouveaunom)"/>
                <!-- en esprant qu'il n'y ait pas de . dans le nom: -->
                <xsl:variable name="nouveautype" select="substring-after(td[9], '.')"/>
                <xsl:if test="$carte!='oui'">
                    <xsl:choose>
                        <xsl:when test="$nouveautype!='mng' and $type!='mpeg' and $icone='petite'">
                            <a href="{$lienicone}" target="_blank" onclick="window.open('{$lienicone}', '', 'scrollbars=yes,scrolling=auto,toolbar=no,directories=no,menubar=no,status=no, width={$largeur1+25},height={$hauteur1+200}'); return 
    false"><xsl:choose>
                            <xsl:when test="$redim"><img src="{$petiteimage}" width="{$largeur2}" height="{$hauteur2}" border="2" alt="{$nouveaunom}" align="right" class="iconeimage"/></xsl:when>
                            <xsl:otherwise><img src="{$grandeimage}" width="{$largeur1}" height="{$hauteur1}" border="2" alt="{$nouveaunom}" align="right"/></xsl:otherwise>
                            </xsl:choose></a>
                        </xsl:when>
                        <xsl:when test="$nouveautype!='mng' and $type!='mpeg' and (not($redim) or $localisation='icne')">
                            <img src="{$grandeimage}" width="{$largeur1}" height="{$hauteur1}" border="0" alt="{$nouveaunom}"/>
                        </xsl:when>
                        <xsl:when test="$nouveautype!='mng' and $type!='mpeg' and $redim and $localisation!='icne'">
                        <!-- on utilise des fichiers HTML pour voir les images PNG  cause d'un bug de IE -->
                            <xsl:variable name="grandeimagehtml"><xsl:choose>
                                <xsl:when test="contains($grandeimage,'.png')"><xsl:value-of select="concat(substring-before($grandeimage,'.png'),'.html')"/></xsl:when>
                                <xsl:otherwise><xsl:value-of select="$grandeimage"/></xsl:otherwise>
                            </xsl:choose></xsl:variable>
                            <a href="{$grandeimagehtml}" target="_blank" onclick="window.open('{$grandeimagehtml}', '', 'scrollbars=yes,scrolling=auto,toolbar=no,directories=no,menubar=no,status=no,resizable=no,height={$hauteur1+25},width={$largeur1+25}'); return false"><img src="{$petiteimage}" width="{$largeur2}" height="{$hauteur2}" border="0" alt="{$nouveaunom}"/></a>
                        </xsl:when>
                        <xsl:when test="$nouveautype='mng' and (($localisation='icne' and $icone!='petite') or not($redim))">
                            <applet code="MNG_LC_Player.class" width="{$largeur1}" height="{$hauteur1}" codebase="{$prefixe}" archive="applets/mngplay.jar">
                                <param name="src" value="{$grandeimage}"/>
                                <param name="bgcolor" value="#FFFFFF"/>
                                <param name="caching" value="on"/>
                                Il faut Java 1.1 pour afficher cette animation
                            </applet>
                        </xsl:when>
                        <xsl:when test="$nouveautype='mng' and $localisation='page' and $redim">
                            <applet code="MNG_LC_Player.class" width="{$largeur2}" height="{$hauteur2}" codebase="{$prefixe}" archive="applets/mngplay.jar">
                                <param name="src" value="{$petiteimage}"/>
                                <param name="bgcolor" value="#FFFFFF"/>
                                <param name="caching" value="on"/>
                                <param name="href" value="{substring-before($grandeimage,'.mng')}.html"/>
                                <param name="target" value="animation"/>
                                Il faut Java 1.1 pour afficher cette animation
                            </applet>
                        </xsl:when>
                        <xsl:when test="$nouveautype='mng' and $icone='petite' and $redim">
                            <applet code="MNG_LC_Player.class" width="{$largeur2}" height="{$hauteur2}" codebase="{$prefixe}" archive="applets/mngplay.jar" style="border: solid thin blue">
                                <param name="src" value="{$petiteimage}"/>
                                <param name="bgcolor" value="#FFFFFF"/>
                                <param name="caching" value="on"/>
                                <param name="href" value="{$lienicone}"/>
                                <param name="target" value="animation"/>
                                Il faut Java 1.1 pour afficher cette animation
                            </applet>
                        </xsl:when>
                        <xsl:when test= "$type='mpeg' and ($localisation!='icne' or $icone!='petite')">
                            <embed src="{$grandeimage}" width="{$largeur1}" height="{$hauteur1}">
                                <noembed>Erreur: ce navigateur ne gre pas EMBED</noembed>
                            </embed>
                        </xsl:when>
                        <xsl:when test= "$type='mpeg' and $icone='petite'">
                            <a href="{$lienicone}" target="_blank" onclick="window.open('{$lienicone}', '', 'scrollbars=yes,scrolling=auto,toolbar=no,directories=no,menubar=no,status=no, width={$largeur1+25},height={$hauteur1+200}'); return 
    false"><img src="{$prefixe}interface/video.gif" width="50" height="50" alt="vido MPEG" align="right"/></a>
                        </xsl:when>
                    </xsl:choose>
                </xsl:if>
                <xsl:if test="$carte='oui'">
                    <xsl:choose>
                        <xsl:when test="$icone='petite'">
                            <a href="{$lienicone}" target="_blank" onclick="window.open('{$lienicone}', '', 'scrollbars=yes,scrolling=auto,toolbar=no,directories=no,menubar=no,status=no, width={$largeur1+25},height={$hauteur1+200}'); return 
    false"><img src="{$petiteimage}" width="{$largeur2}" height="{$hauteur2}" border="2" alt="{$nouveaunom}" align="right"/></a>
                        </xsl:when>
                        <xsl:when test="$localisation='page' and $redim">
                            <applet codebase="{$prefixe}" archive="applets/ImageCarte.jar" code="ImageCarte" width="{$largeur2}" height="{$hauteur2+70}">
                                <!--<param name="image" value="{$petiteimage}"/>-->
                                <!-- avec codebase=prefix, il faut un chemin absolu -->
                                <param name="image" value="{concat('images_page/',$contrib,'/',$nouveaunom)}"/>
                                <!--<param name="grandeimage" value="{concat('images/',$contrib,'/',$nouveaunom)}"/>-->
                                <!-- la grande image avec un clic pose problme car certains navigateurs
                                     ncessitent un clic pour slectionner l'applet -->
                                <img src="{$petiteimage}" width="{$largeur2}" height="{$hauteur2}" border="0" alt="{$nom}"/>
                            </applet>
                        </xsl:when>
                        <xsl:otherwise>
                            <applet codebase="{$prefixe}" archive="applets/ImageCarte.jar" code="ImageCarte" width="{$largeur1}" height="{$hauteur1+70}">
                                <param name="image" value="{concat('images/',$contrib,'/',$nouveaunom)}"/>
                                <img src="{$grandeimage}" width="{$largeur1}" height="{$hauteur1}" border="0" alt="{$nom}"/>
                            </applet>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:if>
            </xsl:for-each>
        </xsl:if> <!-- @type='png' or @type='jpeg' or @type='gif' or @type='mng' or @type='mpeg' -->
        
        <xsl:apply-templates/>
    </xsl:when>
    
    <xsl:otherwise> <!-- si localisation = texte ou affichage != web -->
        <xsl:if test="@type='png' or @type='jpeg' or @type='gif'">
            <xsl:choose>
                <xsl:when test="$affichage='web'">
                    <xsl:choose>
                        <xsl:when test="$temp='symboles'">
                            <xsl:variable name="nomlettre"><xsl:call-template name="nomfichier"><xsl:with-param name="chemin" select="@nom"/></xsl:call-template></xsl:variable>
                            <xsl:variable name="nomsansext" select="substring-before($nomlettre,'.')"/>
                            <xsl:choose>
                                <!-- phi = unicode 03A6 != 03D5, invers dans Safari -->
                                <xsl:when test="$nomsansext!='phi' and $nomsansext!='phi2' and $nomsansext!='sigmaf' and $nomsansext!='thetasym' and $nomsansext!='piv' and $nomsansext!='upsih'"><xsl:text disable-output-escaping='yes'>&amp;</xsl:text><xsl:value-of select="$nomsansext"/>;</xsl:when>
                                 <xsl:otherwise>
                                     <img src="{$prefixe}{@nom}" border="0" alt="{$nomlettre}"/>
                                 </xsl:otherwise>
                             </xsl:choose>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:if test="@label!=''"><a name="{@label}"/></xsl:if>
                            <xsl:variable name="alt"><xsl:choose>
                                <xsl:when test="@alt!=''"><xsl:value-of select="normalize-space(@alt)"/></xsl:when>
                                <xsl:otherwise><xsl:value-of select="@nom"/></xsl:otherwise>
                            </xsl:choose></xsl:variable>
                            <img src="{$prefixe}images/{$contrib}/{@nom}" border="0" alt="{$alt}"><xsl:if test="@class"><xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute></xsl:if></img>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="$affichage='impression'">
                    <xsl:choose>
                        <xsl:when test="$temp='symboles'">
                            <img src="{@nom}" border="0" alt="{@nom}"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:if test="@label!=''"><a name="{@label}"/></xsl:if>
                            <img src="images/{$contrib}/{@nom}" border="0" alt="{normalize-space(@alt)}"><xsl:if test="@class"><xsl:attribute name="class"><xsl:value-of select="@class"/></xsl:attribute></xsl:if></img>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:when>
                <xsl:when test="$affichage='jaxe'">
                    <xsl:if test="@label!=''"><a name="{@label}"/></xsl:if>
                    <img src="{@nom}" border="0" alt="{@nom}"/>
                </xsl:when>
            </xsl:choose>
            <xsl:apply-templates/>
        </xsl:if>
        <xsl:if test= "@type='mpeg'">
            <xsl:variable name="src"><xsl:choose>
                <xsl:when test="$affichage='web'"><xsl:value-of select="concat($prefixe, 'images/', $contrib, '/', @nom)"/></xsl:when>
                <xsl:when test="$affichage='impression'"><xsl:value-of select="concat('images/', $contrib, '/', @nom)"/></xsl:when>
                <xsl:when test="$affichage='jaxe'"><xsl:value-of select="@nom"/></xsl:when>
            </xsl:choose></xsl:variable>
            <xsl:variable name="nom" select="@nom"/>
            <xsl:for-each select="document($imagespage2)/html/body/table/tr[td[1]=$nom and td[2]=$contrib and td[10]='texte'][position()=1]">
                <xsl:variable name="largeur1" select="number(td[3])"/>
                <xsl:variable name="hauteur1" select="number(td[4])"/>
                <embed src="{$src}" width="{$largeur1}" height="{$hauteur1}">
                    <noembed>Erreur: ce navigateur ne gre pas EMBED</noembed>
                </embed>
            </xsl:for-each>
        </xsl:if>
        <xsl:if test="@type='mng'">
            <!-- en esprant qu'il n'y ait pas de . dans le nom: -->
            <xsl:if test="@label!=''"><a name="{@label}"/></xsl:if>
            <xsl:choose><xsl:when test="$affichage='impression'">
                <xsl:variable name="nouveaunom" select="substring-before(@nom, '.')"/>
                <img src="images_anims/{$contrib}/{$nouveaunom}.png" border="0" alt="{$nouveaunom}.png"/>
            </xsl:when>
            <xsl:when test="$affichage='jaxe'">
                <img src="{@nom}" border="0" alt="{@nom}"/>
            </xsl:when></xsl:choose>
        </xsl:if>
    </xsl:otherwise>
</xsl:choose>
</xsl:template>
 
<!--...........................................................................................................................................-->

<xsl:template match="EQUATION | EQUATEX">
    <xsl:if test="@label"><a name="{@label}"/></xsl:if>
    <xsl:variable name="contrib" select="ancestor::*[CONTRIB!='']/CONTRIB"/>
    <xsl:choose>
        <xsl:when test="$affichage='web'">
            <xsl:variable name="prefixe"><xsl:if test="$affichage='web'"><xsl:value-of select="ancestor::PAGEWEB/PREFIXE"/></xsl:if></xsl:variable>
            <img src="{$prefixe}images/{$contrib}/{@image}" border="0" alt="{@texte}" class="maths"/>
        </xsl:when>
        <xsl:when test="$affichage='impression'">
            <img src="images/{$contrib}/{@image}" border="0" alt="{@texte}" class="maths"/>
        </xsl:when>
        <xsl:otherwise>
            <img src="{@image}" border="0" alt="{@texte}" class="maths"/>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<!--...........................................................................................................................................-->

<!--GESTION DES TABLEAUX-->
<xsl:template match="TABLEAU">
    <xsl:choose>
        <xsl:when test="@localisation='icne' and $affichage='web'">
            <xsl:variable name="rep"><xsl:call-template name="repfichier"><xsl:with-param name="chemin" select="ancestor::PAGEWEB/@nom"/></xsl:call-template></xsl:variable>
            <xsl:variable name="nomfichier">tableau_<xsl:choose>
                <xsl:when test="@label!=''"><xsl:value-of select="@label"/></xsl:when>
                <xsl:otherwise>sanslabel</xsl:otherwise>
            </xsl:choose><xsl:if test="/SITEASM/PROJET='UEL'">_<xsl:value-of select="ancestor::PAGEWEB/THEMEUEL"/></xsl:if>.html</xsl:variable>
            <xsl:variable name="prefixe"><xsl:if test="$affichage='web'"><xsl:value-of select="ancestor::PAGEWEB/PREFIXE"/></xsl:if></xsl:variable>
            <xalanredirect:write file="{concat($rep, '/', $nomfichier)}">
                <html>
                <head>
                    <title><xsl:value-of select="@titre"/></title>
                    <link type="text/css" rel="stylesheet" href="{$prefixe}feuillesdestyle/style.css"/>
                </head>
                <body>
                    <div align="center">
                        <xsl:apply-templates select="." mode="contenu"/>
                    </div>
                </body>
                </html>
            </xalanredirect:write>
            <a href="{$nomfichier}" target="_blank"><img src="{$prefixe}interface/tableau.png" width="50" height="33" align="right" alt="tableau" border="2"/></a>
        </xsl:when>
        <xsl:otherwise>
            <xsl:apply-templates select="." mode="contenu"/>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<xsl:template match="TABLEAU" mode="contenu">
    <br/><xsl:if test="@localisation='texte'"><br/></xsl:if>
    <xsl:if test="@label">
        <a name="{normalize-space(@label)}"/>
    </xsl:if>
    <xsl:if test="@titre!=''">
        <b class="titretable"><xsl:value-of select="@titre"/></b><br/>
    </xsl:if>
    <xsl:apply-templates select="TABLE"/><br/>
    <div class="legende"><xsl:value-of select="LEGENDE"/></div><br/>
    <br/>
</xsl:template>

<!--...........................................................................................................................................-->

<!--GESTION DES TABLES-->
<xsl:template match="TABLE">

    <table border="1" cellspacing="0" cellpadding="2"  class="tableaux1">
        <xsl:apply-templates select="TR"/>
    </table>
</xsl:template>


<xsl:template match="TR">

    <tr><xsl:apply-templates/></tr>
</xsl:template>


<xsl:template match="TH" >

  <th class="entete"><xsl:apply-templates/></th>
</xsl:template>


<xsl:template match="TD" >

  <xsl:variable name="trpos"><xsl:number from="TABLE" count="TR"/></xsl:variable>
  <td class="tableaux{1+($trpos mod 2)}">
  <xsl:if test="@colspan"><xsl:attribute name="colspan"><xsl:value-of select="@colspan"/></xsl:attribute></xsl:if>
  <xsl:if test="@rowspan"><xsl:attribute name="rowspan"><xsl:value-of select="@rowspan"/></xsl:attribute></xsl:if>
  <xsl:if test="@align"><xsl:attribute name="align"><xsl:value-of select="@align"/></xsl:attribute></xsl:if>
  <xsl:apply-templates/></td>
</xsl:template>

<!--...........................................................................................................................................-->

<!--GESTION DES EXERCICES-->
<xsl:template match="EXERCICE">

<div class="exercice">
<xsl:if test="@label">
    <a name="{@label}"/>
</xsl:if>

<xsl:variable name="prefixe"><xsl:if test="$affichage='web'"><xsl:value-of select="ancestor::PAGEWEB/PREFIXE"/></xsl:if></xsl:variable>

<xsl:if test="$affichage='web'">
    <applet codebase="{$prefixe}" archive="applets/Calcotron.jar" code="calcotron.CalcoApplet" width="33" height="50" style="float: right">
        Java doit tre activ
    </applet>
</xsl:if>

<h3>Exercice
<xsl:if test="@titre!=''">
    <xsl:text> </xsl:text>'<xsl:value-of select="@titre"/>'
</xsl:if>
</h3>
<xsl:if test="DIFFICULTE">
    <a class="niveau">Niveau <xsl:value-of select="DIFFICULTE"/></a><br/>
</xsl:if>
<xsl:if test="TEMPS">
    <a class="niveau">Dure ncessaire&#xA0;: <xsl:value-of select="TEMPS"/></a><br/>
</xsl:if>
<br/>

<xsl:variable name="enonce"><xsl:apply-templates select="node()[not(self::QUESTION) and not(self::DIFFICULTE)]"/></xsl:variable>
<xsl:if test="normalize-space($enonce)!='' or count(*[not(self::QUESTION) and not(self::DIFFICULTE)])!=0">
    <div class="paragraphe"><xsl:apply-templates select="node()[not(self::QUESTION) and not(self::DIFFICULTE)]"/></div>
</xsl:if>

<xsl:for-each select="QUESTION">
    <xsl:choose>
        <xsl:when test=".//PARAGRAPHE">
            <xsl:if test="count(../QUESTION) &gt; 1">
                <xsl:value-of select="position()"/>)
            </xsl:if>
            <xsl:apply-templates/><br/>
        </xsl:when>
        <xsl:otherwise>
            <div class="paragraphe"><xsl:if test="count(../QUESTION) &gt; 1">
                <xsl:value-of select="position()"/>)
            </xsl:if>
            <xsl:apply-templates/></div>
        </xsl:otherwise>
    </xsl:choose>
</xsl:for-each>

<xsl:if test="(/SITEASM/PROJET='IUFM' or (/SITEASM/PROJET='UEL' and ancestor::SEVALUER)) and $commentaires='non' and ($public='non')">
<!--    <form name="form1" method="get" action="{$prefixe}reponse.html">-->
    <div class="spacer"></div>
    <form name="form1" method="post" action="{$prefixe}../CetteServlet">
      <table cellpadding="0" cellspacing="0" border="0">
      <tr><td>
        <textarea name="reponse" cols="70" rows="10"></textarea>
        <input type="hidden" name="labelexo" value="{@label}"/>
        <input type="hidden" name="titreexo" value="{@titre}"/>
        <input type="hidden" name="cheminpage" value="{ancestor::PAGEWEB/@nom}"/>
      </td></tr>
     
      <tr><td align="right"> 
        <input type="submit" name="Submit" value="Envoyer"/>
      </td></tr>
      </table>
    </form>
</xsl:if>
<div class="spacer"> </div>
</div>
<br/>
</xsl:template>

<!--...........................................................................................................................................-->

<!--GESTION DES QUESTION-->
<xsl:template match="QUESTION">

<xsl:value-of select="."/>
<!--<xsl:apply-templates/>-->
</xsl:template>

<!--...........................................................................................................................................-->

<!--GESTION DES TEMPS-->
<!-- TEMPS se trouve  la fois sous QCM, EXERCICE et TP -->
<xsl:template match="TEMPS">

</xsl:template>

<!--...........................................................................................................................................-->

<!--GESTION DES DIFFICULTE-->
<xsl:template match="DIFFICULTE">

</xsl:template>

<!--...........................................................................................................................................-->

<!--GESTION DES SOLUTION-->
<xsl:template match="SOLUTION">

<xsl:param name="mode"></xsl:param>

<xsl:choose>
<xsl:when test="$mode='aide'">
    <xsl:apply-templates/>
</xsl:when>
<xsl:when test="$affichage='jaxe'">
    <br/><i>Solution&#xA0;: </i>
    <xsl:apply-templates/><br/>
</xsl:when>
<xsl:when test="$affichage='web'">
    <xsl:if test="(/SITEASM/PROJET='UEL' and not(ancestor::SEVALUER)) or $commentaires='oui'">
        <xsl:variable name="numaide">
        <xsl:number level="any" from="ZONETEXTE" count="AIDE | SOLUTION"/>
        </xsl:variable>
        <xsl:variable name="partieUEL"><xsl:if test="ancestor::SEXERCER">SEXERCER</xsl:if><xsl:if test="ancestor::SEVALUER">SEVALUER</xsl:if></xsl:variable>
        <a href="aide{$partieUEL}{$numaide - 1}.html" class="liensolution" onclick="window.open('aide{$partieUEL}{$numaide - 1}.html','','scrollbars=yes,scrolling=auto,toolbar=no,directories=no,menubar=no,status=no,resizable=no,height=400,width=600'); return false">solution</a>
        <br/>
    </xsl:if>
</xsl:when>
</xsl:choose>
</xsl:template>


<xsl:template match="POINTS">
    <xsl:text> </xsl:text>[<em>Points</em>&#xA0;:&#xA0;<xsl:apply-templates/>]
</xsl:template>

<!--...........................................................................................................................................-->

<!--GESTION DES AIDE-->
<xsl:template match="AIDE">
<xsl:param name="mode"></xsl:param>

<xsl:variable name="prefixe"><xsl:if test="$affichage='web'"><xsl:value-of select="ancestor::PAGEWEB/PREFIXE"/></xsl:if></xsl:variable>

<xsl:choose>
<xsl:when test="$mode='aide'">
    <xsl:apply-templates/>
</xsl:when>
<xsl:when test="$affichage='jaxe'">
    <br/><i>Aide&#xA0;: </i>
    <xsl:apply-templates/><br/>
</xsl:when>
<xsl:when test="$affichage='web' and (/SITEASM/PROJET!='UEL' or not(ancestor::SEVALUER))"> <!-- on n'affiche jamais les aides sous SEVALUER -->
    <xsl:variable name="aide">
    <xsl:apply-templates/>
    </xsl:variable>

    <xsl:variable name="numaide">
    <xsl:number level="any" from="ZONETEXTE" count="AIDE | SOLUTION"/>
    </xsl:variable>
    
    
    <xsl:if test="$aide!=''">
        <xsl:variable name="partieUEL"><xsl:if test="ancestor::SEXERCER">SEXERCER</xsl:if><xsl:if test="ancestor::SEVALUER">SEVALUER</xsl:if></xsl:variable>
<!--
        newWindow = window.open("","","scrollbars=yes,scrolling=auto,toolbar=no,directories=no,menubar=no,status=no,resizable=no,left=200,top=30,height=400,width=600")
-->
        <a href="aide{$partieUEL}{$numaide - 1}.html" class="lienaide" onclick="window.open('aide{$partieUEL}{$numaide - 1}.html','','scrollbars=yes,scrolling=auto,toolbar=no,directories=no,menubar=no,status=no,resizable=no,height=400,width=600'); return false">aide</a>
    </xsl:if>
</xsl:when>
</xsl:choose>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="QCM">
    <div class="qcm">
    <h3>Questionnaire  choix multiples</h3>
    <xsl:if test="TEMPS">
        Dure ncessaire&#xA0;: <xsl:value-of select="TEMPS"/><br/>
    </xsl:if>
    <xsl:if test="$affichage!='impression'">
        <xsl:variable name="numqcm"><xsl:number level="any" from="ZONETEXTE" count="QCM" /></xsl:variable>
        <!-- remarque: form n'est pas valide, il faudrait spcifier l'attribut action
             et utiliser onsubmit pour le javascript, et renvoyer false pour ne pas
             que l'action soit appele. Mais est-ce que cela marcherait sur de
             vieux navigateurs ? (netscape 4) -->
        <form name="qcm{$numqcm}">
            <xsl:apply-templates/>
            <input value="Solution" type="submit"  onclick="resultat({$numqcm - 1}); return false"/>
        </form>
    </xsl:if>
    
    <xsl:if test="$affichage='impression'">
        <xsl:apply-templates/>
    </xsl:if>
    
    </div>
    <br/>
</xsl:template>

<xsl:template name="script-qcm">
<!-- remarque: on a ajout  "&& formulaire.elements[irep].name!=''" pour contourner un bug de netscape 4
     qui mettait checked==true pour l'input avec le bouton Solution -->
    <xsl:if test="$affichage!='impression'">
    <script language="JavaScript" type="text/javascript">
    <xsl:comment>
    function resultat(numqcm)
    {
        var reponses='';
        var valrep='';
        var numq='';
        
        <xsl:variable name="reponses">
        var formulaire = document.forms[numqcm];
        for (var irep=0; irep &lt; formulaire.elements.length; irep++) {
            if (formulaire.elements[irep].checked &amp;&amp; formulaire.elements[irep].name!='') {
                valrep = formulaire.elements[irep].value;
                numq = formulaire.elements[irep].name.substring(4);
                if (valrep.substring(0,1)=='V')
                    reponses = reponses + 'Question ' + numq + ' : juste : ' + valrep.substring(1) + '\n';
                else
                    reponses = reponses + 'Question ' + numq + ' : faux : ' + valrep.substring(1) + '\n';
            }
        }
        </xsl:variable>
        
        <xsl:value-of select="$reponses"/>
        
        alert(reponses);
    }
    //</xsl:comment>
    <xsl:text>
</xsl:text>
    </script>
    </xsl:if>
</xsl:template>
<!--...........................................................................................................................................-->

<xsl:template match="QUESTIONQCM">

    <xsl:choose>
    <xsl:when test="$affichage='impression'">
        <div class="questionqcm">
            <xsl:variable name="enonce"><xsl:apply-templates select="node()[not(self::REPONSE)]"/></xsl:variable>
            <xsl:if test="normalize-space($enonce)!=''">
                <div class="paragraphe"><xsl:apply-templates select="node()[not(self::REPONSE)]"/></div>
            </xsl:if>
            <ul>
                <xsl:apply-templates select="REPONSE"/>
            </ul>
        </div>
    </xsl:when>
    <xsl:otherwise>
        <div class="questionqcm">
            <xsl:apply-templates/>
        </div>
        <br/>
    </xsl:otherwise>
    </xsl:choose>

</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="REPONSE">
    <xsl:choose>
    <xsl:when test="$affichage='impression'">
        <li><xsl:apply-templates/></li>
    </xsl:when>
    <xsl:otherwise>
        <br/>
        <xsl:variable name="vraifaux"><xsl:choose>
            <xsl:when test="@bonne='oui'">V</xsl:when>
            <xsl:when test="@bonne='non'">F</xsl:when>
            <xsl:otherwise><xsl:choose>
                <xsl:when test="COMMENTAIREREP='ok'">V</xsl:when>
                <xsl:otherwise>F</xsl:otherwise>
            </xsl:choose></xsl:otherwise>
        </xsl:choose></xsl:variable>
        <xsl:variable name="numquestion"><xsl:number level="any" from="QCM" count="QUESTIONQCM" /></xsl:variable>
        <input type="radio" name="repq{$numquestion}" value="{$vraifaux}{normalize-space(COMMENTAIREREP)}"/>
        <xsl:apply-templates/>
    </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="REPTEXTE">
    <span class="reptexte"><xsl:apply-templates/></span>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="COMMENTAIREREP">

  <!--<xsl:apply-templates/>-->
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template name="nomfichier">
<!-- renvoit le nom d'un fichier  partir du chemin-->
<xsl:param name="chemin"/>
<xsl:choose>
    <xsl:when test="contains($chemin,'/')">
        <xsl:call-template name="nomfichier"><xsl:with-param name="chemin" select="substring-after($chemin,'/')"/></xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
        <xsl:value-of select="$chemin"/>
    </xsl:otherwise>
</xsl:choose>
</xsl:template>

<xsl:template name="repfichier">
<!-- renvoit le chemin du rpertoire d'un fichier  partir du chemin complet-->
<xsl:param name="chemin"/>
<xsl:choose>
    <xsl:when test="contains($chemin,'/') and contains(substring-after($chemin,'/'),'/')">
        <xsl:value-of select="substring-before($chemin,'/')"/>/<xsl:call-template name="repfichier"><xsl:with-param name="chemin" select="substring-after($chemin,'/')"/></xsl:call-template>
    </xsl:when>
    <xsl:otherwise>
        <xsl:value-of select="substring-before($chemin,'/')"/>
    </xsl:otherwise>
</xsl:choose>
</xsl:template>


<xsl:template name="fichiers-aide">

<xsl:variable name="rep"><xsl:call-template name="repfichier"><xsl:with-param name="chemin" select="ancestor::PAGEWEB/@nom"/></xsl:call-template></xsl:variable>
<xsl:variable name="partieUEL"><xsl:if test="SEXERCER">SEXERCER</xsl:if><xsl:if test="SEVALUER">SEVALUER</xsl:if></xsl:variable>
<xsl:for-each select=".//AIDE |.//SOLUTION">
    <xalanredirect:write file="{concat($rep,'/aide',$partieUEL,position()-1,'.html')}">
        <html>
        <head>
            <title><xsl:value-of select="name()"/></title>
            <link type="text/css" rel="stylesheet" href="../../../../feuillesdestyle/style.css"/>
            <script language="JavaScript" type="text/javascript">
                window.onblur = fermeture;
                function fermeture() { window.close(); }
            </script>
        </head>
        <body>
            <br/>
            <xsl:apply-templates/>
        </body>
        </html>
    </xalanredirect:write>
</xsl:for-each>

</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template name="reponses-exercices">
<!-- pour l'impression -->
    <h2>Rponses aux QCM</h2>
    <xsl:for-each select="//QCM">
        <xsl:for-each select="ancestor::PAGEWEB">
            <tt>page <xsl:value-of select="concat(LABELCHAPITRE, '_', LABELSOUSCHAPITRE, '_', LABELSECTION, '_', LABELPAGE)"/></tt><br/>
        </xsl:for-each>
        <b>QCM
        <xsl:if test="@titre!=''">
            <xsl:text> </xsl:text>'<xsl:value-of select="@titre"/>'
        </xsl:if>
        </b>
        <ul>
        <xsl:for-each select="QUESTIONQCM">
            <li>Question <xsl:value-of select="position()"/><br/>
            <xsl:for-each select="REPONSE[@bonne='oui']">
                <i>Solution : </i> rponse <xsl:number from="QCM" count="REPONSE"/>)
                <xsl:if test="COMMENTAIREREP!=''">
                    <xsl:text> </xsl:text>(<xsl:value-of select="COMMENTAIREREP"/>)
                </xsl:if>
                <br/>
            </xsl:for-each>
            </li>
        </xsl:for-each>
        </ul>
    </xsl:for-each>
    
    <xsl:comment>PAGE BREAK</xsl:comment> <!-- pour htmldoc -->
    <div style="page-break-after: always"/> <!-- pour les navigateurs comprenant CSS 2 -->
    
    <h2>Rponses aux exercices</h2>
    <xsl:for-each select="//EXERCICE[count(QUESTION/SOLUTION) &gt; 0]">
        <xsl:if test="position() &gt; 1">
            <hr/>
        </xsl:if>
        <xsl:for-each select="ancestor::PAGEWEB">
            <tt>page <xsl:value-of select="concat(LABELCHAPITRE, '_', LABELSOUSCHAPITRE, '_', LABELSECTION, '_', LABELPAGE)"/></tt><br/>
        </xsl:for-each>
        <h3>Exercice
        <xsl:if test="@titre!=''">
            <xsl:text> </xsl:text>'<xsl:value-of select="@titre"/>'
        </xsl:if>
        </h3>
        <ul>
        <xsl:for-each select="QUESTION">
            <xsl:if test="(/SITEASM/PROJET='UEL' and not(ancestor::SEVALUER)) or $commentaires='oui'">
                <li><b>Question <xsl:value-of select="position()"/></b><br/>
                <xsl:for-each select="AIDE">
                    <i>Aide : </i> <xsl:apply-templates/><br/>
                </xsl:for-each>
                <xsl:for-each select="SOLUTION">
                    <i>Solution : </i> <xsl:apply-templates/><br/>
                </xsl:for-each>
                </li>
            </xsl:if>
        </xsl:for-each>
        </ul>
    </xsl:for-each>
</xsl:template>

<!--...........................................................................................................................................-->

  <xsl:template match="SUP">

  <sup><xsl:apply-templates/></sup>
  </xsl:template>

<!--...........................................................................................................................................-->

  <xsl:template match="SUB">

  <sub><xsl:apply-templates/></sub>
  </xsl:template>

<!--...........................................................................................................................................-->

  <xsl:template match="LEGENDE">
    <xsl:variable name="alignement"><xsl:choose>
        <xsl:when test="../@localisation='page' or parent::APPLET or parent::TABLEAU">left</xsl:when>
        <xsl:otherwise>center</xsl:otherwise>
    </xsl:choose></xsl:variable>
    <br/><div align="{$alignement}" class="legende"><b><xsl:apply-templates/></b></div>
  </xsl:template>

<!--...........................................................................................................................................-->

  <xsl:template match="MATH">

  <i><xsl:apply-templates/></i>
  </xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="BR">
<br/>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="NBSP">&#xA0;</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="GLOSSAIRE">
<xsl:param name="mode"> </xsl:param>


<!--<xsl:variable name="mot" select="concat(normalize-space(text()[1]), normalize-space(text()[2]))"/>-->
<xsl:variable name="motref"><xsl:choose>
    <xsl:when test="@ref!=''"><xsl:value-of select="@ref"/></xsl:when>
    <xsl:otherwise><xsl:value-of select="@mot"/></xsl:otherwise>
</xsl:choose></xsl:variable>
<xsl:variable name="motreftrans" select="translate($motref,' ','_aaeeeiioouu')"/>

<xsl:choose>
    <xsl:when test="$mode='fichier'">
        <xsl:if test="$motref != ''">
            <!--<xsl:if test="normalize-space(DEFGLOSSAIRE)!=''">-->
            <xsl:if test="normalize-space(.)!=''">
                <dt><a name="{$motreftrans}"><b><xsl:value-of select="$motref"/></b></a></dt>
                <!--<dd><xsl:value-of select="normalize-space(DEFGLOSSAIRE)"/><br/><br/></dd>-->
                <dd><xsl:apply-templates/><br/><br/></dd>
            </xsl:if>
        </xsl:if>
    </xsl:when>
    <xsl:otherwise>
        <xsl:variable name="definition"><xsl:choose>
            <xsl:when test="normalize-space(.)!=''"><xsl:value-of select="normalize-space(.)"/></xsl:when>
            <!-- un peu long... -->
            <xsl:otherwise><xsl:value-of select="normalize-space(//GLOSSAIRE[@mot=$motref or @ref=$motref][normalize-space(.)!=''][1])"/></xsl:otherwise>
        </xsl:choose></xsl:variable>
        <a href="{ancestor::PAGEWEB/PREFIXE}glossaire/glossaire.html#{$motreftrans}" title="{$definition}" class="glossaire" target="_blank"><!--<xsl:apply-templates/>--><xsl:value-of select="@mot"/></a>
    </xsl:otherwise>
</xsl:choose>
</xsl:template>

<!--...........................................................................................................................................-->

<!--
<xsl:template match="DEFGLOSSAIRE">

</xsl:template>
-->

<!--...........................................................................................................................................-->

<xsl:template match="LISTEPOINTS">
    <xsl:if test="@titre!=''">
        <h3><xsl:value-of select="@titre"/></h3>
    </xsl:if>
    
    <ul>
        <xsl:apply-templates/>
    </ul>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="LISTENUM">
    <xsl:if test="@titre!=''">
        <h3><xsl:value-of select="@titre"/></h3>
    </xsl:if>
    
    <ol type="1">
        <xsl:apply-templates/>
    </ol>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="LISTEDEF">
    <xsl:if test="@titre!=''">
        <h3><xsl:value-of select="@titre"/></h3>
    </xsl:if>
    
    <dl>
        <xsl:apply-templates/>
    </dl>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="ITEM">

    <li><xsl:apply-templates/></li>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="ITEMDEF">

    <dt><b><xsl:value-of select="@nom"/></b></dt>
    <dd><xsl:apply-templates/></dd>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="TT">

    <tt><xsl:apply-templates/></tt>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="I">

    <i><xsl:apply-templates/></i>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="B">

    <b><xsl:apply-templates/></b>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="EM">

    <em><xsl:apply-templates/></em>
</xsl:template>

<!--...........................................................................................................................................-->


<xsl:template match="CENTER">

    <div align="center"><xsl:apply-templates/></div>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="BIBLIOGRAPHIE">

    <a name="bibliographie"></a><h3>Bibliographie</h3>
    <xsl:apply-templates/>
</xsl:template>

<!--Balises pour les differentes parties des TPs-->

<!--...........................................................................................................................................-->

<xsl:template match="CHAMP">

</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="NIVEAU">

</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="NIVEAULMD">
    Niveau&#xA0;:<xsl:apply-templates/><br/>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="INTRODUCTION">
    <div class="introconlu">
    <h3><a name="intro"></a>Introduction</h3>
    <xsl:apply-templates/><br/>
    </div>
    <br/>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="CONCLUSION">
    <div class="introconlu">
    <h3><a name="conclusion"></a>Conclusion</h3>
    <xsl:apply-templates/>
    <br/>
    </div>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="OBJECTIFS">

<a name="objectifs"></a>
<div class="fondclair">
<dl>
    <dt><h3>Objectifs</h3></dt>
    <dd><xsl:apply-templates/></dd>
</dl>
</div>
<br/>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="DEFINITION">

<div class="fondclair">
<dl>
    <dt><h3>Dfinition</h3></dt>
    <dd><xsl:apply-templates/></dd>
</dl>
</div>
<br/>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="COMMENTAIRE">
<xsl:param name="liste">non</xsl:param>
<xsl:choose>
    <xsl:when test="$liste='oui'">
        <li><xsl:apply-templates/> - page <a href="{substring-after(ancestor::PAGEWEB/@nom,'site/')}"><xsl:value-of select="ancestor::PAGEWEB/TITREFICHIER"/></a></li>
    </xsl:when>
    <xsl:otherwise>
        <xsl:if test="$commentaires='oui'">
            <div style="color: #FF0000">
                <xsl:apply-templates/>
                <br/>
            </div>
        </xsl:if>
    </xsl:otherwise>
</xsl:choose>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="PREREQUIS">
<div class="fondclair">
    <a name="prerequis"></a><h3>Prrequis</h3>
    <xsl:apply-templates/>
</div>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="DEMONSTRATION">
<div class="fondclair">
    <dl>
    <dt><h3>Dmonstration</h3></dt>
    <dd><xsl:apply-templates/></dd>
    </dl>
</div>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="DOCUMENTS">

<br/><a name="documents"></a><h3>Documents et/ou matriel</h3>
<xsl:apply-templates/><br/>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="DEROULEMENT">

<br/><a name="deroulement"></a><h3>Droulement dtaill</h3>
<table><tr>
<xsl:choose>
    <xsl:when test="ZONEFIGURES">
        <td valign="top" width="300" align="center">
        <!--l'image centrale avec son commentaire--> 
        <xsl:apply-templates select="ZONEFIGURES/*"/>
        </td>
    </xsl:when>
    <xsl:otherwise>
        <td width="10">
        </td>
    </xsl:otherwise>
</xsl:choose>
<td>
<xsl:apply-templates/><br/>
</td></tr></table>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="CONSEILS">

<br/><a name="conseil"></a><h3>Conseils</h3>
<xsl:apply-templates/><br/>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="EXEMPLE">
<div class="fondclair">
    <dl>
    <dt><h3>Exemple</h3></dt>
    <dd><xsl:apply-templates/></dd>
    </dl>
</div>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="REMARQUE">
<br/><b><i>Remarque&#xA0;:</i></b><xsl:apply-templates/><br/>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="RESUME">
    <br/><h3>Rsum</h3><xsl:apply-templates/><br/><br/>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="CREDIT">

<br/><i>Crdit&#xA0;: </i><xsl:choose>
    <xsl:when test="normalize-space(.)='ASM'"><a href="{ancestor::PAGEWEB/PREFIXE}credit_asm.html" target="_blank">Astrophysique sur Mesure</a></xsl:when>
    <xsl:otherwise><xsl:apply-templates/></xsl:otherwise>
</xsl:choose><br/>
</xsl:template>

<!--...........................................................................................................................................-->

<xsl:template match="APPLET">
    <br/>
    <xsl:if test="@label!=''">
        <a name="{@label}"/>
    </xsl:if>
    <xsl:choose>
        <xsl:when test="@localisation='icne' and $affichage='web'">
            <xsl:variable name="rep"><xsl:call-template name="repfichier"><xsl:with-param name="chemin" select="ancestor::PAGEWEB/@nom"/></xsl:call-template></xsl:variable>
            <xsl:variable name="numero"><xsl:number level="any" from="PAGEWEB" count="APPLET"/></xsl:variable>
            <xsl:variable name="nomfichierapplet"><xsl:value-of select="concat('applet',$numero)"/><xsl:if test="/SITEASM/PROJET='UEL'">_<xsl:value-of select="ancestor::PAGEWEB/THEMEUEL"/></xsl:if>.html</xsl:variable>
            <xsl:variable name="fichierapplet"><xsl:value-of select="concat($rep,'/',$nomfichierapplet)"/></xsl:variable>
            <a href="{$nomfichierapplet}" target="_blank"><img src="{ancestor::PAGEWEB/PREFIXE}interface/applet.gif" width="50" height="50" border="0" alt="applet"/></a>
            <xalanredirect:write file="{$fichierapplet}">
                <html>
                <head>
                <title><xsl:value-of select="concat('applet ',@label)"/></title>
                </head>
                <body bgcolor="#FFFFFF">
                    <xsl:call-template name="contenu-applet"/>
                </body>
                </html>
            </xalanredirect:write>
        </xsl:when>
        <xsl:otherwise>
            <xsl:call-template name="contenu-applet"/>
        </xsl:otherwise>
    </xsl:choose>
    <br/>
</xsl:template>

<xsl:template name="contenu-applet">
    <xsl:if test="@titre!=''">
        <b class="titretable"><xsl:value-of select="@titre"/></b><br/>
    </xsl:if>
    <xsl:choose>
        <xsl:when test="$affichage='web'">
            <applet code="{@classe}" codebase="{ancestor::PAGEWEB/PREFIXE}" archive="{@archive}" width="{@largeur}" height="{@hauteur}">
                <xsl:apply-templates select="PARAM"/>
            </applet>
        </xsl:when>
        <xsl:otherwise>
            <img src="interface/applet.gif" width="50" height="50" border="0" alt="applet"/>
        </xsl:otherwise>
    </xsl:choose>
    <xsl:apply-templates select="LEGENDE"/>
</xsl:template>

<xsl:template match="PARAM">
    <!-- pour que les applets retrouvent les fichiers donns en paramtres -->
    <xsl:choose>
        <!-- Tablographe, Fit, Filtrage, SimuLab -->
        <!-- l'applet utilise Applet.getDocumentBase() -->
        <xsl:when test="@nom='fichierXML' or @nom='dataurl' or @nom='dossier' or @nom='fond'">
            <xsl:variable name="contrib" select="ancestor::*[CONTRIB!='']/CONTRIB"/>
            <param name="{@nom}" value="{ancestor::PAGEWEB/PREFIXE}images/{$contrib}/{@valeur}"/>
        </xsl:when>
        <!-- AstroImage, VisImage, CoordImage, Coupes -->
        <!-- l'applet utilise Applet.getCodeBase() -->
        <xsl:when test="@nom='image'">
            <xsl:variable name="contrib" select="ancestor::*[CONTRIB!='']/CONTRIB"/>
            <param name="{@nom}" value="images/{$contrib}/{@valeur}"/>
        </xsl:when>
        <!-- Traitement, Diaporama -->
        <!-- l'applet utilise Applet.getDocumentBase() -->
        <xsl:when test="string-length(@nom) &gt; string-length('image') and starts-with(@nom, 'image')">
            <xsl:variable name="contrib" select="ancestor::*[CONTRIB!='']/CONTRIB"/>
            <param name="{@nom}" value="{ancestor::PAGEWEB/PREFIXE}images/{$contrib}/{@valeur}"/>
        </xsl:when>
        <!-- autre cas, on suppose que le paramtre ne correspond pas  un fichier -->
        <xsl:otherwise>
            <param name="{@nom}" value="{@valeur}"/>
        </xsl:otherwise>
    </xsl:choose>
</xsl:template>

<!--...........................................................................................................................................-->
<!-- POUR APPLETDOC -->

<xsl:template match="FONCTIONNEMENT">
    <br/><a name="fonctionnement"></a><h2>Mode d'emploi de l'applet</h2>
    <xsl:apply-templates/><br/>
</xsl:template>

<xsl:template match="EXCOMMENTE">
    <br/><a name="excommente"></a><h2>Exemple d'utilisation</h2>
    <xsl:apply-templates/><br/>
</xsl:template>

<xsl:template match="REFCOURS">
    <br/><i>Module&#xA0;: </i> <xsl:value-of select="./@module"/> ; <i>cours&#xA0;: </i> <xsl:value-of select="./@cours"/><br/>
</xsl:template>


<xsl:template match="RAPPEL">
    <br/><a name="rappel"></a><h2>Rappels de cours</h2>
    <xsl:apply-templates/><br/>
</xsl:template>

<xsl:template match="LISTEPARAMS">
    <h3>Liste des paramtres de l'applet</h3>
    <ul><xsl:apply-templates/></ul>
</xsl:template>

<xsl:template match="PARAMETRE">
    <li>
        <b>label&#xA0;: </b><xsl:value-of select="@label"/><br/>
        <b>type&#xA0;: </b><xsl:value-of select="@type"/><br/>
        <b>titre&#xA0;: </b><xsl:value-of select="@titre"/><br/>
        <xsl:if test="@unite!=''">
            <b>units&#xA0;: </b><xsl:value-of select="@unite"/><br/>
        </xsl:if>
        <xsl:apply-templates/>
    </li>
</xsl:template>

<xsl:template match="EXPLICATIONS">
    <br/><a name="explications"></a><h2>Explications</h2>
    <xsl:apply-templates/><br/>
</xsl:template>

</xsl:stylesheet>

