/*
 * Decompiled with CFR 0.152.
 */
package moulinette;

import MNGDecoder.MNGLib;
import MNGDecoder.MNGObject;
import MNGDecoder.MNGParam;
import com.keypoint.PngEncoderB;
import java.awt.AlphaComposite;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.geom.AffineTransform;
import java.awt.image.AffineTransformOp;
import java.awt.image.BufferedImage;
import java.awt.image.ImageObserver;
import java.awt.image.IndexColorModel;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Hashtable;
import java.util.zip.CRC32;
import moulinette.ImAnim;

public class MNGAnim
implements ImAnim {
    private static final int PROFILE_TRANS = 8;
    private MNGLib mng = null;
    private MNGParam param = null;
    private Image screen = null;
    private int nbimages = -1;
    protected byte[] pngBytes;
    protected int bytePos;

    public static void main(String[] stringArray) {
        int n;
        int n2;
        if (stringArray.length != 4) {
            System.err.println("il faut 4 arguments");
            return;
        }
        File file = new File(stringArray[0]);
        if (!file.exists()) {
            System.err.println("le fichier n'existe pas");
            return;
        }
        File file2 = new File(stringArray[1]);
        try {
            n2 = new Integer(stringArray[2]);
            n = new Integer(stringArray[3]);
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return;
        }
        MNGAnim mNGAnim = new MNGAnim();
        try {
            mNGAnim.open(file);
            mNGAnim.rescale(file2, n2, n);
        }
        catch (IOException iOException) {
            System.err.println("IOException : " + iOException.getMessage());
            return;
        }
    }

    public void open(File file) throws IOException {
        if (!MNGLib.checkSignature(file)) {
            throw new IOException("Ce n'est pas la signature d'un MNG");
        }
        this.mng = new MNGLib(file);
        this.mng.openStream();
        if (!this.mng.existsStream()) {
            throw new IOException("!mng.existsStream()");
        }
        if (!this.mng.readInfo()) {
            this.mng.closeStream();
            throw new IOException("!mng.readInfo()");
        }
        this.param = this.mng.getInfo();
    }

    public void close() throws IOException {
        this.mng.closeStream();
    }

    public int getWidth() {
        if (this.param == null) {
            return -1;
        }
        return this.param.width;
    }

    public int getHeight() {
        if (this.param == null) {
            return -1;
        }
        return this.param.height;
    }

    public int getImageCount() {
        if (this.nbimages != -1) {
            return this.nbimages;
        }
        if (this.param == null) {
            return 0;
        }
        if (this.param.frames != 0) {
            this.nbimages = this.param.frames;
            return this.nbimages;
        }
        int n = 0;
        try {
            while (!this.mng.isEOS()) {
                Image image;
                MNGObject mNGObject = this.mng.getMNGObject();
                this.param = this.mng.getInfo();
                if (mNGObject == null || (image = mNGObject.getImage()) == null) break;
                ++n;
                image.getWidth(null);
            }
            this.mng.reopenStream();
        }
        catch (IOException iOException) {
            System.err.println("IOException: " + iOException.getMessage());
        }
        this.nbimages = n;
        return this.nbimages;
    }

    public Image getImage(int n) throws IOException {
        BufferedImage bufferedImage = new BufferedImage(this.getWidth(), this.getHeight(), 1);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        for (int i = 0; i < n && !this.mng.isEOS(); ++i) {
            Image image;
            MNGObject mNGObject = this.mng.getMNGObject();
            this.param = this.mng.getInfo();
            if (mNGObject == null || (image = mNGObject.getImage()) == null) break;
            int n2 = this.param.x_location;
            int n3 = this.param.y_location;
            graphics2D.drawImage(image, n2, n3, null);
        }
        graphics2D.dispose();
        this.mng.reopenStream();
        return bufferedImage;
    }

    public Image rescaleImage(Image image, int n, int n2) {
        return image.getScaledInstance(n, n2, 4);
    }

    public BufferedImage getMyScaledBufferedImage(Image image, int n, int n2, int n3, int n4, IndexColorModel indexColorModel) {
        BufferedImage bufferedImage;
        double d = (double)n3 * 1.0 / (double)n;
        double d2 = (double)n4 * 1.0 / (double)n2;
        BufferedImage bufferedImage2 = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage2.createGraphics();
        graphics2D.drawImage(image, 0, 0, null);
        graphics2D.dispose();
        int n5 = 0;
        boolean bl = false;
        int n6 = -1;
        if (indexColorModel != null) {
            n6 = indexColorModel.getTransparentPixel();
            if (n6 == -1) {
                System.out.println("pas de transparence(2)!");
            } else {
                n5 = indexColorModel.getRGB(n6);
                bl = true;
            }
        }
        int[] nArray = null;
        Hashtable<Integer, Integer> hashtable = null;
        if (indexColorModel == null) {
            bufferedImage = new BufferedImage(n3, n4, 2);
        } else {
            bufferedImage = new BufferedImage(n3, n4, 13, indexColorModel);
            nArray = new int[indexColorModel.getMapSize()];
            indexColorModel.getRGBs(nArray);
            hashtable = new Hashtable<Integer, Integer>();
        }
        int[] nArray2 = bufferedImage2.getRGB(0, 0, n, n2, null, 0, n);
        int[] nArray3 = new int[n3 * n4];
        for (int i = 0; i < n3; ++i) {
            for (int j = 0; j < n4; ++j) {
                int n7;
                int n8;
                int n9;
                int n10;
                int n11;
                int n12;
                int n13;
                double d3 = ((double)i + 0.5) / d - 0.5;
                double d4 = ((double)j + 0.5) / d2 - 0.5;
                double d5 = d3 - 1.0 / (2.0 * d);
                double d6 = d3 + 1.0 / (2.0 * d);
                double d7 = d4 - 1.0 / (2.0 * d2);
                double d8 = d4 + 1.0 / (2.0 * d2);
                int n14 = (int)Math.floor(d5 + 0.5);
                if (n14 < 0) {
                    n14 = 0;
                }
                if ((n13 = (int)Math.floor(d6 + 0.5)) > n - 1) {
                    n13 = n - 1;
                }
                if ((n12 = (int)Math.floor(d7 + 0.5)) < 0) {
                    n12 = 0;
                }
                if ((n11 = (int)Math.floor(d8 + 0.5)) > n2 - 1) {
                    n11 = n2 - 1;
                }
                double d9 = (double)n14 + 0.5 - d5;
                double d10 = d6 - (double)n13 + 0.5;
                double d11 = (double)n12 + 0.5 - d7;
                double d12 = d8 - (double)n11 + 0.5;
                double d13 = 0.0;
                double d14 = 0.0;
                double d15 = 0.0;
                double d16 = 0.0;
                for (n10 = n14; n10 <= n13; ++n10) {
                    for (n9 = n12; n9 <= n11; ++n9) {
                        n8 = nArray2[n9 * n + n10];
                        double d17 = 1.0;
                        if (n10 == n14) {
                            d17 *= d9;
                        }
                        if (n10 == n13) {
                            d17 *= d10;
                        }
                        if (n9 == n12) {
                            d17 *= d11;
                        }
                        if (n9 == n11) {
                            d17 *= d12;
                        }
                        d13 += d17 * (double)(n8 >> 16 & 0xFF);
                        d14 += d17 * (double)(n8 >> 8 & 0xFF);
                        d15 += d17 * (double)(n8 & 0xFF);
                        d16 += d17;
                    }
                }
                n10 = (int)(d13 /= d16);
                n9 = (int)(d14 /= d16);
                int n15 = (int)(d15 /= d16);
                n8 = 0xFF000000 | n10 << 16 | n9 << 8 | n15;
                if (indexColorModel != null) {
                    Integer n16 = (Integer)hashtable.get(new Integer(n8));
                    if (n16 != null) {
                        n8 = n16;
                    } else {
                        int n17 = -1;
                        long l = -1L;
                        for (int k = 0; k < nArray.length; ++k) {
                            if (bl && k == n6) continue;
                            int n18 = nArray[k];
                            int n19 = n18 >> 16 & 0xFF;
                            int n20 = n18 >> 8 & 0xFF;
                            int n21 = n18 & 0xFF;
                            long l2 = (n19 - n10) * (n19 - n10) + (n20 - n9) * (n20 - n9) + (n21 - n15) * (n21 - n15);
                            if (n17 != -1 && l2 >= l) continue;
                            n17 = k;
                            l = l2;
                        }
                        if (n17 != -1) {
                            hashtable.put(new Integer(n8), new Integer(nArray[n17]));
                            n8 = nArray[n17];
                        }
                    }
                }
                if (((n7 = nArray2[(int)Math.round(d4) * n + (int)Math.round(d3)]) & 0xFF000000) == 0) {
                    n8 = bl ? n5 : (n8 &= 0xFFFFFF);
                }
                nArray3[j * n3 + i] = n8;
            }
        }
        bufferedImage.setRGB(0, 0, n3, n4, nArray3, 0, n3);
        return bufferedImage;
    }

    public BufferedImage getScaledBufferedImage(Image image, int n, int n2, int n3, int n4, double d, double d2, IndexColorModel indexColorModel) {
        WaitingObserver waitingObserver;
        BufferedImage bufferedImage = new BufferedImage(n, n2, 2);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        if (!graphics2D.drawImage(image, 0, 0, waitingObserver = new WaitingObserver())) {
            waitingObserver.attendre();
            graphics2D.setComposite(AlphaComposite.Src);
            graphics2D.drawImage(image, 0, 0, null);
        }
        graphics2D.dispose();
        AffineTransformOp affineTransformOp = new AffineTransformOp(AffineTransform.getScaleInstance(d, d2), new RenderingHints(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_BICUBIC));
        BufferedImage bufferedImage2 = indexColorModel == null ? new BufferedImage(n3, n4, 2) : new BufferedImage(n3, n4, 13, indexColorModel);
        affineTransformOp.filter(bufferedImage, bufferedImage2);
        return bufferedImage2;
    }

    public void rescale(File file, int n, int n2) throws IOException {
        System.out.println("rescale " + file.getName() + " " + n + " " + n2);
        CRC32 cRC32 = new CRC32();
        boolean bl = true;
        try {
            int n3;
            int n4;
            int n5;
            DataOutputStream dataOutputStream = new DataOutputStream(new FileOutputStream(file));
            dataOutputStream.writeByte(138);
            dataOutputStream.writeBytes("MNG\r\n");
            dataOutputStream.writeByte(26);
            dataOutputStream.writeByte(10);
            int n6 = this.getImageCount();
            int n7 = this.param.tps;
            int n8 = this.getWidth();
            int n9 = this.getHeight();
            boolean bl2 = this.param.f_mode == 3;
            boolean bl3 = this.param.p_len > 0;
            System.out.println("palette globale: " + bl3);
            this.pngBytes = new byte[1000];
            this.bytePos = 0;
            dataOutputStream.writeInt(28);
            this.writeString("MHDR");
            this.writeInt4(n);
            this.writeInt4(n2);
            this.writeInt4(n7);
            this.writeInt4(0);
            this.writeInt4(n6);
            this.writeInt4(0);
            if (bl2 || bl) {
                this.writeInt4(459);
            } else {
                this.writeInt4(457);
            }
            dataOutputStream.write(this.pngBytes, 0, this.bytePos);
            cRC32.reset();
            cRC32.update(this.pngBytes, 0, this.bytePos);
            dataOutputStream.writeInt((int)cRC32.getValue());
            this.bytePos = 0;
            dataOutputStream.writeInt(10);
            this.writeString("TERM");
            this.writeByte(this.param.action);
            this.writeByte(this.param.after);
            this.writeInt4(this.param.delay);
            this.writeInt4(this.param.limit);
            dataOutputStream.write(this.pngBytes, 0, this.bytePos);
            cRC32.reset();
            cRC32.update(this.pngBytes, 0, this.bytePos);
            dataOutputStream.writeInt((int)cRC32.getValue());
            IndexColorModel indexColorModel = null;
            if (bl3) {
                this.writePLTE(dataOutputStream, this.param.pallet);
                if (this.param.t_len > 0) {
                    System.out.print("couleur trans: " + (this.param.t_len - 1) + "  ");
                    indexColorModel = new IndexColorModel(8, this.param.pallet[0].length, this.param.pallet[0], this.param.pallet[1], this.param.pallet[2], this.param.t_len - 1);
                    System.out.println("rgb=" + Long.toString((long)indexColorModel.getRGB(this.param.t_len - 1) & 0xFFFFFFFFL, 16).toUpperCase());
                    this.writetRNS(dataOutputStream, this.param.trans, this.param.t_len);
                } else {
                    indexColorModel = new IndexColorModel(8, this.param.pallet[0].length, this.param.pallet[0], this.param.pallet[1], this.param.pallet[2]);
                    if (bl) {
                        System.out.println("Cr\u00e9ation d'une palette avec un pixel transparent...");
                        indexColorModel = this.icmTrans(indexColorModel);
                        n5 = indexColorModel.getTransparentPixel();
                        if (n5 == -1) {
                            System.err.println("Erreur: impossible de trouver un volontaire pour devenir transparent");
                        } else {
                            int n10 = n5 + 1;
                            byte[] byArray = new byte[n10];
                            for (n4 = 0; n4 < n10 - 1; ++n4) {
                                byArray[n4] = -1;
                            }
                            byArray[n10 - 1] = 0;
                            this.writetRNS(dataOutputStream, byArray, n10);
                        }
                    }
                }
            }
            if (bl2 && !bl) {
                this.writeFRAMmode(dataOutputStream, 3);
            }
            n5 = (this.param.profile & 8) != 0 ? 1 : 0;
            System.out.println("encode_alpha: " + (n5 != 0));
            if (bl) {
                n5 = 1;
            }
            BufferedImage bufferedImage = null;
            int n11 = 0;
            if (bl && this.param.back != null && this.param.back.length == 3) {
                n4 = this.param.back[0] >> 8 & 0xFF;
                int n12 = this.param.back[1] >> 8 & 0xFF;
                n3 = this.param.back[2] >> 8 & 0xFF;
                n11 = n4 << 16 | n12 << 8 | n3;
                System.out.println("backrgb: " + Long.toString((long)n11 & 0xFFFFFFFFL, 16).toUpperCase());
            }
            BufferedImage bufferedImage2 = new BufferedImage(n8, n9, 1);
            Graphics2D graphics2D = bufferedImage2.createGraphics();
            n3 = -1;
            while (!this.mng.isEOS()) {
                Object object;
                MNGObject mNGObject = this.mng.getMNGObject();
                this.param = this.mng.getInfo();
                if (mNGObject == null) break;
                Image image = mNGObject.getImage();
                if (image == null) continue;
                System.out.print(".");
                double d = (double)n * 1.0 / (double)this.param.width;
                double d2 = (double)n2 * 1.0 / (double)this.param.height;
                int n13 = this.param.x_location;
                int n14 = this.param.y_location;
                graphics2D.drawImage(image, n13, n14, null);
                BufferedImage bufferedImage3 = this.getMyScaledBufferedImage(bufferedImage2, this.param.width, this.param.height, n, n2, indexColorModel);
                if (this.param.f_delay != 0 && this.param.f_delay != n3) {
                    this.writeFRAMdelay(dataOutputStream, bl2 && !bl ? 3 : 1, this.param.f_delay);
                    n3 = this.param.f_delay;
                }
                if (bl) {
                    object = this.optimiser(bufferedImage3, bufferedImage, n11, indexColorModel, false, dataOutputStream);
                    bufferedImage = bufferedImage3;
                    bufferedImage3 = object;
                }
                PngEncoderB pngEncoderB = new PngEncoderB(bufferedImage3, n5 != 0, 0, 9);
                pngEncoderB.setPasDePalette(bl3);
                object = pngEncoderB.pngEncode();
                if (object == null) {
                    System.out.println("image vide");
                    continue;
                }
                dataOutputStream.write((byte[])object, 8, ((Object)object).length - 8);
            }
            System.out.println();
            dataOutputStream.writeInt(0);
            this.bytePos = 0;
            this.writeString("MEND");
            dataOutputStream.write(this.pngBytes, 0, this.bytePos);
            cRC32.reset();
            cRC32.update(this.pngBytes, 0, this.bytePos);
            dataOutputStream.writeInt((int)cRC32.getValue());
            dataOutputStream.flush();
            dataOutputStream.close();
            this.mng.reopenStream();
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
        }
    }

    public IndexColorModel icmTrans(IndexColorModel indexColorModel) {
        IndexColorModel indexColorModel2;
        if (indexColorModel.getMapSize() < 256) {
            int n = indexColorModel.getMapSize() + 1;
            System.out.print("ajout couleur (count=" + n + ")");
            byte[] byArray = new byte[n];
            byte[] byArray2 = new byte[n];
            byte[] byArray3 = new byte[n];
            indexColorModel.getReds(byArray);
            indexColorModel.getGreens(byArray2);
            indexColorModel.getBlues(byArray3);
            for (int i = n - 1; i > 0; --i) {
                byArray[i] = byArray[i - 1];
                byArray2[i] = byArray2[i - 1];
                byArray3[i] = byArray3[i - 1];
            }
            byArray[0] = -1;
            byArray2[0] = -1;
            byArray3[0] = -1;
            indexColorModel2 = new IndexColorModel(8, n, byArray, byArray2, byArray3, 0);
        } else {
            int n = indexColorModel.getMapSize();
            int n2 = -1;
            long l = -1L;
            for (int i = 0; i < n; ++i) {
                int n3 = indexColorModel.getRGB(i);
                int n4 = n3 >> 16 & 0xFF;
                int n5 = n3 >> 8 & 0xFF;
                int n6 = n3 & 0xFF;
                for (int j = i + 1; j < n; ++j) {
                    int n7 = indexColorModel.getRGB(j);
                    int n8 = n7 >> 16 & 0xFF;
                    int n9 = n7 >> 8 & 0xFF;
                    int n10 = n7 & 0xFF;
                    long l2 = (n4 - n8) * (n4 - n8) + (n5 - n9) * (n5 - n9) + (n6 - n10) * (n6 - n10);
                    if (l != -1L && l2 >= l) continue;
                    l = l2;
                    n2 = i;
                }
            }
            System.out.print("volontaire transparent: " + n2 + " dist=" + l + " ");
            System.out.println("rgb=" + Long.toString((long)indexColorModel.getRGB(n2) & 0xFFFFFFFFL, 16).toUpperCase());
            byte[] byArray = new byte[n];
            byte[] byArray4 = new byte[n];
            byte[] byArray5 = new byte[n];
            indexColorModel.getReds(byArray);
            indexColorModel.getGreens(byArray4);
            indexColorModel.getBlues(byArray5);
            indexColorModel2 = new IndexColorModel(indexColorModel.getPixelSize(), n, byArray, byArray4, byArray5, n2);
        }
        return indexColorModel2;
    }

    public BufferedImage optimiser(BufferedImage bufferedImage, BufferedImage bufferedImage2, int n, IndexColorModel indexColorModel, boolean bl, DataOutputStream dataOutputStream) throws IOException {
        int n2 = bufferedImage.getWidth();
        int n3 = bufferedImage.getHeight();
        if (bufferedImage2 != null) {
            BufferedImage bufferedImage3;
            int n4;
            int n5;
            int n6 = -1;
            int n7 = -1;
            int n8 = -1;
            int n9 = -1;
            for (n5 = 0; n5 < n2; ++n5) {
                for (n4 = 0; n4 < n3; ++n4) {
                    if (bufferedImage.getRGB(n5, n4) == bufferedImage2.getRGB(n5, n4)) continue;
                    if (n6 == -1 || n6 > n5) {
                        n6 = n5;
                    }
                    if (n7 == -1 || n7 > n4) {
                        n7 = n4;
                    }
                    if (n8 == -1 || n8 < n5) {
                        n8 = n5;
                    }
                    if (n9 != -1 && n9 >= n4) continue;
                    n9 = n4;
                }
            }
            if (n6 == -1) {
                n6 = 0;
                n7 = 0;
                n8 = 0;
                n9 = 0;
            }
            n5 = n8 - n6 + 1;
            n4 = n9 - n7 + 1;
            int n10 = -1;
            if (indexColorModel == null) {
                bufferedImage3 = new BufferedImage(n5, n4, 2);
            } else {
                int n11 = indexColorModel.getTransparentPixel();
                if (n11 != -1) {
                    n10 = indexColorModel.getRGB(n11);
                }
                bufferedImage3 = new BufferedImage(n5, n4, 13, indexColorModel);
            }
            int[] nArray = bufferedImage.getRGB(n6, n7, n5, n4, null, 0, n5);
            for (int i = 0; i < n5; ++i) {
                for (int j = 0; j < n4; ++j) {
                    int n12 = nArray[j * n5 + i];
                    int n13 = bufferedImage2.getRGB(i + n6, j + n7);
                    if (n12 == n13) {
                        if (n10 == -1) {
                            nArray[j * n5 + i] = n12 & 0xFFFFFF;
                            continue;
                        }
                        nArray[j * n5 + i] = n10;
                        continue;
                    }
                    if ((n12 & 0xFF000000) != 0) continue;
                    nArray[j * n5 + i] = n12 | 0xFF000000;
                }
            }
            bufferedImage3.setRGB(0, 0, n5, n4, nArray, 0, n5);
            this.writeDEFI(dataOutputStream, n6, n7);
            return bufferedImage3;
        }
        BufferedImage bufferedImage4 = indexColorModel == null ? new BufferedImage(n2, n3, 2) : new BufferedImage(n2, n3, 13, indexColorModel);
        Graphics2D graphics2D = bufferedImage4.createGraphics();
        if (System.getProperty("os.name").startsWith("Windows")) {
            graphics2D.setComposite(AlphaComposite.Src);
        }
        graphics2D.drawImage((Image)bufferedImage, 0, 0, null);
        return bufferedImage4;
    }

    public static BufferedImage getBufferedImage(Image image, IndexColorModel indexColorModel) {
        int n = image.getWidth(null);
        int n2 = image.getHeight(null);
        BufferedImage bufferedImage = indexColorModel == null ? new BufferedImage(n, n2, 2) : new BufferedImage(n, n2, 13, indexColorModel);
        Graphics2D graphics2D = bufferedImage.createGraphics();
        graphics2D.setComposite(AlphaComposite.Src);
        graphics2D.drawImage(image, 0, 0, null);
        return bufferedImage;
    }

    protected void writePLTE(DataOutputStream dataOutputStream, byte[][] byArray) throws IOException {
        byte[] byArray2 = new byte[byArray.length * byArray[0].length];
        for (int i = 0; i < byArray[0].length; ++i) {
            byArray2[i * 3] = byArray[0][i];
            byArray2[i * 3 + 1] = byArray[1][i];
            byArray2[i * 3 + 2] = byArray[2][i];
        }
        this.bytePos = 0;
        this.writeInt4(byArray2.length);
        this.writeString("PLTE");
        CRC32 cRC32 = new CRC32();
        cRC32.update("PLTE".getBytes());
        this.writeBytes(byArray2);
        cRC32.update(byArray2);
        this.writeInt4((int)cRC32.getValue());
        dataOutputStream.write(this.pngBytes, 0, this.bytePos);
    }

    protected void writetRNS(DataOutputStream dataOutputStream, byte[] byArray, int n) throws IOException {
        this.bytePos = 0;
        this.writeInt4(n);
        this.writeString("tRNS");
        CRC32 cRC32 = new CRC32();
        cRC32.update("tRNS".getBytes());
        for (int i = 0; i < n; ++i) {
            this.writeByte(byArray[i]);
            cRC32.update(byArray[i]);
        }
        this.writeInt4((int)cRC32.getValue());
        dataOutputStream.write(this.pngBytes, 0, this.bytePos);
    }

    protected void writeFRAMmode(DataOutputStream dataOutputStream, int n) throws IOException {
        this.bytePos = 0;
        dataOutputStream.writeInt(1);
        this.writeString("FRAM");
        this.writeByte(n);
        dataOutputStream.write(this.pngBytes, 0, this.bytePos);
        CRC32 cRC32 = new CRC32();
        cRC32.reset();
        cRC32.update(this.pngBytes, 0, this.bytePos);
        dataOutputStream.writeInt((int)cRC32.getValue());
    }

    protected void writeFRAMdelay(DataOutputStream dataOutputStream, int n, int n2) throws IOException {
        this.bytePos = 0;
        dataOutputStream.writeInt(10);
        this.writeString("FRAM");
        this.writeByte(n);
        this.writeByte(0);
        this.writeByte(2);
        this.writeByte(0);
        this.writeByte(0);
        this.writeByte(0);
        this.writeInt4(n2);
        dataOutputStream.write(this.pngBytes, 0, this.bytePos);
        CRC32 cRC32 = new CRC32();
        cRC32.reset();
        cRC32.update(this.pngBytes, 0, this.bytePos);
        dataOutputStream.writeInt((int)cRC32.getValue());
    }

    protected void writeDEFI(DataOutputStream dataOutputStream, int n, int n2) throws IOException {
        dataOutputStream.writeInt(12);
        this.bytePos = 0;
        this.writeString("DEFI");
        this.writeInt2(0);
        this.writeByte(0);
        this.writeByte(0);
        this.writeInt4(n);
        this.writeInt4(n2);
        CRC32 cRC32 = new CRC32();
        cRC32.reset();
        cRC32.update(this.pngBytes, 0, this.bytePos);
        this.writeInt4((int)cRC32.getValue());
        dataOutputStream.write(this.pngBytes, 0, this.bytePos);
    }

    protected byte[] resizeByteArray(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n];
        int n2 = byArray.length;
        System.arraycopy(byArray, 0, byArray2, 0, Math.min(n2, n));
        return byArray2;
    }

    protected void writeBytes(byte[] byArray) {
        int n = this.bytePos;
        if (byArray.length + n > this.pngBytes.length) {
            this.pngBytes = this.resizeByteArray(this.pngBytes, this.pngBytes.length + Math.max(1000, byArray.length));
        }
        System.arraycopy(byArray, 0, this.pngBytes, n, byArray.length);
        this.bytePos = n + byArray.length;
    }

    protected void writeBytes(byte[] byArray, int n) {
        int n2 = this.bytePos;
        if (n + n2 > this.pngBytes.length) {
            this.pngBytes = this.resizeByteArray(this.pngBytes, this.pngBytes.length + Math.max(1000, n));
        }
        System.arraycopy(byArray, 0, this.pngBytes, n2, n);
        this.bytePos = n2 + n;
    }

    protected void writeInt2(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        this.writeBytes(byArray);
    }

    protected void writeInt4(int n) {
        byte[] byArray = new byte[]{(byte)(n >> 24 & 0xFF), (byte)(n >> 16 & 0xFF), (byte)(n >> 8 & 0xFF), (byte)(n & 0xFF)};
        this.writeBytes(byArray);
    }

    protected void writeByte(int n) {
        byte[] byArray = new byte[]{(byte)n};
        this.writeBytes(byArray);
    }

    protected void writeString(String string) {
        this.writeBytes(string.getBytes());
    }

    class WaitingObserver
    implements ImageObserver {
        boolean stillwaiting = true;

        WaitingObserver() {
        }

        public void attendre() {
            while (this.stillwaiting) {
                try {
                    Thread.currentThread();
                    Thread.sleep(100L);
                }
                catch (InterruptedException interruptedException) {
                    System.err.println("InterruptedException: " + interruptedException.getMessage());
                }
            }
        }

        public boolean imageUpdate(Image image, int n, int n2, int n3, int n4, int n5) {
            if ((n & 0x20) != 0) {
                this.stillwaiting = false;
                return false;
            }
            if ((n & 0x40) != 0) {
                System.err.println("imageUpdate: ERROR");
            }
            if ((n & 0x80) != 0) {
                System.err.println("imageUpdate: ABORT");
                this.stillwaiting = false;
                return false;
            }
            return true;
        }
    }
}

