/*
 * Decompiled with CFR 0.152.
 */
package com.fmsware;

import java.io.IOException;
import java.io.OutputStream;

class LZWEncoder {
    private static final int EOF = -1;
    private int imgW;
    private int imgH;
    private byte[] pixAry;
    private int initCodeSize;
    private int remaining;
    private int curPixel;
    static final int BITS = 12;
    static final int HSIZE = 5003;
    int n_bits;
    int maxbits = 12;
    int maxcode;
    int maxmaxcode = 4096;
    int[] htab = new int[5003];
    int[] codetab = new int[5003];
    int hsize = 5003;
    int free_ent = 0;
    boolean clear_flg = false;
    int g_init_bits;
    int ClearCode;
    int EOFCode;
    int cur_accum = 0;
    int cur_bits = 0;
    int[] masks = new int[]{0, 1, 3, 7, 15, 31, 63, 127, 255, 511, 1023, 2047, 4095, 8191, 16383, Short.MAX_VALUE, 65535};
    int a_count;
    byte[] accum = new byte[256];

    LZWEncoder(int n, int n2, byte[] byArray, int n3) {
        this.imgW = n;
        this.imgH = n2;
        this.pixAry = byArray;
        this.initCodeSize = Math.max(2, n3);
    }

    void char_out(byte by, OutputStream outputStream) throws IOException {
        this.accum[this.a_count++] = by;
        if (this.a_count >= 254) {
            this.flush_char(outputStream);
        }
    }

    void cl_block(OutputStream outputStream) throws IOException {
        this.cl_hash(this.hsize);
        this.free_ent = this.ClearCode + 2;
        this.clear_flg = true;
        this.output(this.ClearCode, outputStream);
    }

    void cl_hash(int n) {
        for (int i = 0; i < n; ++i) {
            this.htab[i] = -1;
        }
    }

    void compress(int n, OutputStream outputStream) throws IOException {
        int n2;
        int n3;
        this.g_init_bits = n;
        this.clear_flg = false;
        this.n_bits = this.g_init_bits;
        this.maxcode = this.MAXCODE(this.n_bits);
        this.ClearCode = 1 << n - 1;
        this.EOFCode = this.ClearCode + 1;
        this.free_ent = this.ClearCode + 2;
        this.a_count = 0;
        int n4 = this.nextPixel();
        int n5 = 0;
        for (n3 = this.hsize; n3 < 65536; n3 *= 2) {
            ++n5;
        }
        n5 = 8 - n5;
        int n6 = this.hsize;
        this.cl_hash(n6);
        this.output(this.ClearCode, outputStream);
        block1: while ((n2 = this.nextPixel()) != -1) {
            int n7 = n2 << n5 ^ n4;
            n3 = (n2 << this.maxbits) + n4;
            if (this.htab[n7] == n3) {
                n4 = this.codetab[n7];
                continue;
            }
            if (this.htab[n7] >= 0) {
                int n8 = n6 - n7;
                if (n7 == 0) {
                    n8 = 1;
                }
                do {
                    if ((n7 -= n8) < 0) {
                        n7 += n6;
                    }
                    if (this.htab[n7] != n3) continue;
                    n4 = this.codetab[n7];
                    continue block1;
                } while (this.htab[n7] >= 0);
            }
            this.output(n4, outputStream);
            n4 = n2;
            if (this.free_ent < this.maxmaxcode) {
                ++this.free_ent;
                this.htab[n7] = n3;
                continue;
            }
            this.cl_block(outputStream);
        }
        this.output(n4, outputStream);
        this.output(this.EOFCode, outputStream);
    }

    void encode(OutputStream outputStream) throws IOException {
        outputStream.write(this.initCodeSize);
        this.remaining = this.imgW * this.imgH;
        this.curPixel = 0;
        this.compress(this.initCodeSize + 1, outputStream);
        outputStream.write(0);
    }

    void flush_char(OutputStream outputStream) throws IOException {
        if (this.a_count > 0) {
            outputStream.write(this.a_count);
            outputStream.write(this.accum, 0, this.a_count);
            this.a_count = 0;
        }
    }

    final int MAXCODE(int n) {
        return (1 << n) - 1;
    }

    private int nextPixel() {
        if (this.remaining == 0) {
            return -1;
        }
        --this.remaining;
        byte by = this.pixAry[this.curPixel++];
        return by & 0xFF;
    }

    void output(int n, OutputStream outputStream) throws IOException {
        this.cur_accum &= this.masks[this.cur_bits];
        this.cur_accum = this.cur_bits > 0 ? (this.cur_accum |= n << this.cur_bits) : n;
        this.cur_bits += this.n_bits;
        while (this.cur_bits >= 8) {
            this.char_out((byte)(this.cur_accum & 0xFF), outputStream);
            this.cur_accum >>= 8;
            this.cur_bits -= 8;
        }
        if (this.free_ent > this.maxcode || this.clear_flg) {
            if (this.clear_flg) {
                this.n_bits = this.g_init_bits;
                this.maxcode = this.MAXCODE(this.n_bits);
                this.clear_flg = false;
            } else {
                ++this.n_bits;
                this.maxcode = this.n_bits == this.maxbits ? this.maxmaxcode : this.MAXCODE(this.n_bits);
            }
        }
        if (n == this.EOFCode) {
            while (this.cur_bits > 0) {
                this.char_out((byte)(this.cur_accum & 0xFF), outputStream);
                this.cur_accum >>= 8;
                this.cur_bits -= 8;
            }
            this.flush_char(outputStream);
        }
    }
}

