/*
 * Decompiled with CFR 0.152.
 */
package MNGDecoder;

import MNGDecoder.MNGLib;
import MNGDecoder.PNGFamily;
import MNGDecoder.PNGParam;
import MNGDecoder.PNGParamOp;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.util.zip.DataFormatException;
import java.util.zip.Inflater;

public class PNGLib
extends PNGFamily {
    private final boolean debug_flag = false;
    private final int debug_lv = 0;
    public static final byte[] SIGNATURE = new byte[]{-119, 80, 78, 71, 13, 10, 26, 10};
    private PNGParamOp param;
    private byte[] idat_prior;
    private Inflater z;

    public PNGLib(URL uRL) {
        super(uRL, SIGNATURE);
        this.initialize();
        this.param = new PNGParamOp();
    }

    public PNGLib(File file) {
        super(file, SIGNATURE);
        this.initialize();
        this.param = new PNGParamOp();
    }

    public PNGLib(MNGLib mNGLib) {
        super(mNGLib, SIGNATURE);
        this.initialize();
        this.param = new PNGParamOp(mNGLib);
    }

    private void initialize() {
        this.idat_prior = null;
        this.z = null;
    }

    public void closeStream() throws IOException {
        this.initialize();
        super.closeStream();
    }

    public static boolean checkSignature(URL uRL) {
        return new PNGLib(uRL).checkSignature();
    }

    public static boolean checkSignature(File file) {
        return new PNGLib(file).checkSignature();
    }

    public boolean isSupported() {
        if (this.param.compress != 0) {
            return false;
        }
        if (this.param.filter != 0) {
            return false;
        }
        return this.param.interace == 0;
    }

    public PNGParam getInfo() {
        return this.param.getParameter();
    }

    public boolean readInfo() throws IOException {
        return this.readChunkLoop();
    }

    public int encounterChunk() throws IOException {
        byte[] byArray = this.getChunkType();
        int n = this.getChunkLength();
        if (this.compareChunkType("IEND", byArray, 0)) {
            return 1;
        }
        if (this.compareChunkType("IDAT", byArray, 0)) {
            return 2;
        }
        byte[] byArray2 = new byte[n];
        int n2 = this.readChunkData(byArray2, 0, n);
        if (n2 < n) {
            return 0;
        }
        if (this.compareChunkType("IHDR", byArray, 0)) {
            this.param.readIHDR(n, byArray2);
        } else if (this.compareChunkType("PLTE", byArray, 0)) {
            this.param.readPLTE(n, byArray2);
        } else if (this.compareChunkType("tRNS", byArray, 0)) {
            this.param.readtRNS(n, byArray2);
        }
        return 0;
    }

    public byte[] readLine() throws IOException, DataFormatException {
        int n = this.getBytePerLine();
        if (this.idat_prior == null || this.z == null) {
            this.idat_prior = new byte[n];
            this.z = new Inflater();
            for (int i = 0; i < n; ++i) {
                this.idat_prior[i] = 0;
            }
        }
        byte[] byArray = new byte[n + 1];
        int n2 = 0;
        while (n2 < byArray.length) {
            int n3;
            if ((this.z.needsInput() && this.getChunkRemain() <= 0 || !this.compareChunkType("IDAT", this.getChunkType(), 0)) && ((n3 = this.readChunkLoop()) == 0 || this.isEOS())) {
                this.z.end();
                this.idat_prior = null;
                this.z = null;
                return null;
            }
            n3 = this.readIDAT(byArray, n2, byArray.length - n2);
            if (n3 <= 0) continue;
            n2 += n3;
        }
        byte[] byArray2 = this.reverseFilter(byArray[0], byArray, 1, n);
        return byArray2;
    }

    private int readIDAT(byte[] byArray, int n, int n2) throws IOException, DataFormatException {
        int n3;
        if (this.isEOS()) {
            return -1;
        }
        for (n3 = 0; n3 < n2; n3 += this.z.inflate(byArray, n3 + n, n2 - n3)) {
            if (!this.z.needsInput()) continue;
            byte[] byArray2 = new byte[1024];
            int n4 = this.readChunkData(byArray2, 0, byArray2.length);
            if (n4 <= 0) {
                return n3;
            }
            this.z.setInput(byArray2, 0, n4);
        }
        return n3;
    }

    private byte[] reverseFilter(byte by, byte[] byArray, int n, int n2) {
        byte[] byArray2 = new byte[n2];
        int n3 = this.getBytePerPixel();
        switch (by) {
            case 0: {
                System.arraycopy(byArray, n, byArray2, 0, n2);
                break;
            }
            case 1: {
                int n4;
                for (n4 = 0; n4 < n3; ++n4) {
                    byArray2[n4] = byArray[n4 + n];
                }
                for (n4 = n3; n4 < n2; ++n4) {
                    byArray2[n4] = (byte)((byArray[n4 + n] & 0xFF) + (byArray2[n4 - n3] & 0xFF));
                }
                break;
            }
            case 2: {
                for (int i = 0; i < n2; ++i) {
                    byArray2[i] = (byte)((byArray[i + n] & 0xFF) + (this.idat_prior[i] & 0xFF));
                }
                break;
            }
            case 3: {
                for (int i = 0; i < n2; ++i) {
                    byte by2 = i < n3 ? (byte)((this.idat_prior[i] & 0xFF) >>> 1) : (byte)((byArray2[i - n3] & 0xFF) + (this.idat_prior[i] & 0xFF) >>> 1);
                    byArray2[i] = (byte)((byArray[i + n] & 0xFF) + (by2 & 0xFF));
                }
                break;
            }
            case 4: {
                for (int i = 0; i < n2; ++i) {
                    byte by3;
                    if (i < n3) {
                        by3 = this.idat_prior[i];
                    } else {
                        int n5 = byArray2[i - n3] & 0xFF;
                        int n6 = this.idat_prior[i] & 0xFF;
                        int n7 = this.idat_prior[i - n3] & 0xFF;
                        by3 = this.peathFilter(n5, n6, n7);
                    }
                    byArray2[i] = (byte)((byArray[i + n] & 0xFF) + (by3 & 0xFF));
                }
                break;
            }
            default: {
                return null;
            }
        }
        System.arraycopy(byArray2, 0, this.idat_prior, 0, n2);
        return byArray2;
    }

    private byte peathFilter(int n, int n2, int n3) {
        int n4 = n + n2 - n3;
        int n5 = n4 - n;
        n5 = n5 < 0 ? -n5 : n5;
        int n6 = n4 - n2;
        n6 = n6 < 0 ? -n6 : n6;
        int n7 = n4 - n3;
        int n8 = n7 = n7 < 0 ? -n7 : n7;
        byte by = n5 <= n6 && n5 <= n7 ? (byte)n : (n6 <= n7 ? (byte)n2 : (byte)n3);
        return by;
    }

    public int getSamplePerPixel() {
        switch (this.param.color) {
            case 0: {
                return 1;
            }
            case 2: {
                return 3;
            }
            case 3: {
                return 1;
            }
            case 4: {
                return 2;
            }
            case 6: {
                return 4;
            }
        }
        return 0;
    }

    private int getBytePerPixel() {
        int n = this.param.depth * this.getSamplePerPixel();
        n = n % 8 == 0 ? (n /= 8) : n / 8 + 1;
        return n;
    }

    private int getBytePerLine() {
        int n = this.param.depth * this.getSamplePerPixel();
        n = n % 8 == 0 ? n / 8 * this.param.width : (n * this.param.width % 8 == 0 ? n * this.param.width / 8 : n * this.param.width / 8 + 1);
        return n;
    }
}

