/*
 * Decompiled with CFR 0.152.
 */
package MNGDecoder;

import MNGDecoder.MNGParam;
import MNGDecoder.PNGFamily;

public class MNGParamOp
extends MNGParam {
    private final boolean debug_flag = false;

    public boolean readMHDR(int n, byte[] byArray) {
        this.width = PNGFamily.byte2int(byArray, 0);
        this.height = PNGFamily.byte2int(byArray, 4);
        this.tps = PNGFamily.byte2int(byArray, 8);
        this.layers = PNGFamily.byte2int(byArray, 12);
        this.frames = PNGFamily.byte2int(byArray, 16);
        this.times = PNGFamily.byte2int(byArray, 20);
        this.profile = PNGFamily.byte2int(byArray, 24);
        return true;
    }

    public boolean readBACK(int n, byte[] byArray) {
        this.back = new short[3];
        this.back[0] = PNGFamily.byte2short(byArray, 0);
        this.back[1] = PNGFamily.byte2short(byArray, 2);
        this.back[2] = PNGFamily.byte2short(byArray, 4);
        if (n > 6) {
            this.back_flag = byArray[6];
        }
        return true;
    }

    public boolean readTERM(int n, byte[] byArray) {
        this.action = byArray[0];
        if (byArray[0] == 3) {
            this.after = byArray[1];
            this.delay = PNGFamily.byte2int(byArray, 2);
            this.limit = PNGFamily.byte2int(byArray, 6);
        }
        return true;
    }

    public boolean readPLTEg(int n, byte[] byArray) {
        if (n % 3 != 0) {
            return false;
        }
        this.p_len = n / 3;
        this.pallet = new byte[3][this.p_len];
        for (int i = 0; i < this.p_len; ++i) {
            this.pallet[0][i] = byArray[i * 3];
            this.pallet[1][i] = byArray[i * 3 + 1];
            this.pallet[2][i] = byArray[i * 3 + 2];
        }
        return true;
    }

    public boolean readtRNSg(int n, byte[] byArray) {
        int n2;
        this.t_len = n;
        this.trans = new byte[this.p_len > n ? this.p_len : n];
        for (n2 = 0; n2 < n; ++n2) {
            this.trans[n2] = byArray[n2];
        }
        for (n2 = n; n2 < this.p_len; ++n2) {
            this.trans[n2] = -1;
        }
        return true;
    }

    public boolean readDEFI(int n, byte[] byArray) {
        this.setDefaultDEFI();
        this.oid = PNGFamily.byte2short(byArray, 0);
        if (n > 2) {
            this.invisible = byArray[2];
        }
        if (n > 3) {
            this.delta_png = byArray[3];
        }
        if (n > 4) {
            this.x_location = PNGFamily.byte2int(byArray, 4);
            this.y_location = PNGFamily.byte2int(byArray, 8);
        }
        if (n > 12) {
            this.cb_left = PNGFamily.byte2int(byArray, 12);
            this.cb_right = PNGFamily.byte2int(byArray, 16);
            this.cb_top = PNGFamily.byte2int(byArray, 20);
            this.cb_bottom = PNGFamily.byte2int(byArray, 24);
        }
        return true;
    }

    public boolean readFRAM(int n, byte[] byArray) {
        int n2;
        if (byArray[0] != 0) {
            this.before_f_mode = this.f_mode;
            this.f_mode = byArray[0];
        }
        if (n <= 1) {
            this.sf_name = null;
            return true;
        }
        int n3 = 0;
        for (n2 = 1; byArray[n2] != 0 && n2 < n; ++n2) {
            ++n3;
        }
        if (n3 > 80) {
            return false;
        }
        if (n3 > 0) {
            this.sf_name = new byte[n3];
            System.arraycopy(byArray, 1, this.sf_name, 0, n3);
        } else {
            this.sf_name = null;
        }
        if (n <= n3 + 1) {
            return true;
        }
        n2 = n3 + 2;
        this.flag_f_delay = byArray[n2];
        this.flag_term = byArray[n2 + 1];
        this.flag_sfb = byArray[n2 + 2];
        this.flag_sync_id = byArray[n2 + 3];
        n2 += 4;
        if (this.flag_f_delay != 0) {
            this.f_delay = PNGFamily.byte2int(byArray, n2);
            n2 += 4;
        }
        if (this.flag_term != 0) {
            this.timeout = PNGFamily.byte2int(byArray, n2);
            n2 += 4;
        }
        if (this.flag_sfb != 0) {
            this.flag_diff_sfb = byArray[n2];
            this.sfb_left = PNGFamily.byte2int(byArray, n2 + 1);
            this.sfb_right = PNGFamily.byte2int(byArray, n2 + 5);
            this.sfb_top = PNGFamily.byte2int(byArray, n2 + 9);
            this.sfb_bottom = PNGFamily.byte2int(byArray, n2 + 13);
            n2 += 17;
            if (this.flag_diff_sfb == 1) {
                this.cb_left += this.sfb_left;
                this.cb_right += this.sfb_right;
                this.cb_top += this.sfb_top;
                this.cb_bottom += this.sfb_bottom;
            } else {
                this.cb_left = this.sfb_left;
                this.cb_right = this.sfb_right;
                this.cb_top = this.sfb_top;
                this.cb_bottom = this.sfb_bottom;
            }
        }
        if (this.flag_sync_id != 0) {
            int n4 = n - n2 / 4;
            if (n4 == 0) {
                this.sync_id = null;
                return true;
            }
            this.sync_id = new int[n4];
            for (int i = 0; i < n4; ++i) {
                this.sync_id[i] = PNGFamily.byte2int(byArray, n2);
                n2 += 4;
            }
        }
        return true;
    }

    public void setDefaultDEFI() {
        this.oid = 0;
        this.invisible = 0;
        this.delta_png = 0;
        this.x_location = 0;
        this.y_location = 0;
        this.cb_left = 0;
        this.cb_right = this.width;
        this.cb_top = 0;
        this.cb_bottom = this.height;
    }

    public void setDefaultFRAM() {
        this.f_mode = 1;
        this.sf_name = null;
        this.f_delay = 1;
        this.sfb_left = 0;
        this.sfb_right = this.width;
        this.sfb_top = 0;
        this.sfb_bottom = this.height;
        this.flag_term = 1;
        this.timeout = Integer.MAX_VALUE;
        this.sync_id = null;
    }

    public MNGParam getParameter() {
        MNGParam mNGParam = new MNGParam();
        this.copyParameter(this, mNGParam);
        return mNGParam;
    }

    protected void copyParameter(MNGParam mNGParam, MNGParam mNGParam2) {
        this.copyMHDR(mNGParam, mNGParam2);
        this.copyBACK(mNGParam, mNGParam2);
        this.copyTERM(mNGParam, mNGParam2);
        this.copyPLTEg(mNGParam, mNGParam2);
        this.copytRNSg(mNGParam, mNGParam2);
        this.copyDEFI(mNGParam, mNGParam2);
        this.copyFRAM(mNGParam, mNGParam2);
        mNGParam2.before_f_mode = mNGParam.before_f_mode;
    }

    protected void copyMHDR(MNGParam mNGParam, MNGParam mNGParam2) {
        mNGParam2.width = mNGParam.width;
        mNGParam2.height = mNGParam.height;
        mNGParam2.tps = mNGParam.tps;
        mNGParam2.layers = mNGParam.layers;
        mNGParam2.frames = mNGParam.frames;
        mNGParam2.times = mNGParam.times;
        mNGParam2.profile = mNGParam.profile;
    }

    protected void copyBACK(MNGParam mNGParam, MNGParam mNGParam2) {
        if (mNGParam.back == null) {
            mNGParam2.back = null;
        } else {
            mNGParam2.back = new short[mNGParam.back.length];
            System.arraycopy(mNGParam.back, 0, mNGParam2.back, 0, mNGParam.back.length);
            mNGParam2.back_flag = mNGParam.back_flag;
        }
    }

    protected void copyTERM(MNGParam mNGParam, MNGParam mNGParam2) {
        mNGParam2.action = mNGParam.action;
        mNGParam2.after = mNGParam.after;
        mNGParam2.delay = mNGParam.delay;
        mNGParam2.limit = mNGParam.limit;
    }

    protected void copyPLTEg(MNGParam mNGParam, MNGParam mNGParam2) {
        mNGParam2.p_len = mNGParam.p_len;
        if (mNGParam.p_len > 0) {
            mNGParam2.pallet = new byte[3][mNGParam.p_len];
            for (int i = 0; i < 3; ++i) {
                System.arraycopy(mNGParam.pallet[i], 0, mNGParam2.pallet[i], 0, mNGParam.p_len);
            }
        } else {
            mNGParam2.pallet = null;
        }
    }

    protected void copytRNSg(MNGParam mNGParam, MNGParam mNGParam2) {
        mNGParam2.t_len = mNGParam.t_len;
        if (mNGParam.t_len > 0) {
            mNGParam2.trans = new byte[mNGParam.trans.length];
            System.arraycopy(mNGParam.trans, 0, mNGParam2.trans, 0, mNGParam.trans.length);
        } else {
            mNGParam2.trans = null;
        }
    }

    protected void copyDEFI(MNGParam mNGParam, MNGParam mNGParam2) {
        mNGParam2.oid = mNGParam.oid;
        mNGParam2.invisible = mNGParam.invisible;
        mNGParam2.delta_png = mNGParam.delta_png;
        mNGParam2.x_location = mNGParam.x_location;
        mNGParam2.y_location = mNGParam.y_location;
        mNGParam2.cb_left = mNGParam.cb_left;
        mNGParam2.cb_right = mNGParam.cb_right;
        mNGParam2.cb_top = mNGParam.cb_top;
        mNGParam2.cb_bottom = mNGParam.cb_bottom;
    }

    protected void copyFRAM(MNGParam mNGParam, MNGParam mNGParam2) {
        mNGParam2.f_mode = mNGParam.f_mode;
        if (mNGParam.sf_name == null) {
            mNGParam2.sf_name = null;
        } else {
            mNGParam2.sf_name = new byte[mNGParam.sf_name.length];
            System.arraycopy(mNGParam.sf_name, 0, mNGParam2.sf_name, 0, mNGParam.sf_name.length);
        }
        mNGParam2.flag_f_delay = mNGParam.flag_f_delay;
        mNGParam2.flag_term = mNGParam.flag_term;
        mNGParam2.flag_sfb = mNGParam.flag_sfb;
        mNGParam2.flag_sync_id = mNGParam.flag_sync_id;
        mNGParam2.f_delay = mNGParam.f_delay;
        mNGParam2.timeout = mNGParam.timeout;
        mNGParam2.flag_diff_sfb = mNGParam.flag_diff_sfb;
        mNGParam2.sfb_left = mNGParam.sfb_left;
        mNGParam2.sfb_right = mNGParam.sfb_right;
        mNGParam2.sfb_top = mNGParam.sfb_top;
        mNGParam2.sfb_bottom = mNGParam.sfb_bottom;
        if (mNGParam.sync_id == null) {
            mNGParam2.sync_id = null;
        } else {
            mNGParam2.sync_id = new int[mNGParam.sync_id.length];
            System.arraycopy(mNGParam.sync_id, 0, mNGParam2.sync_id, 0, mNGParam.sync_id.length);
        }
    }
}

