/*
 * Decompiled with CFR 0.152.
 */
package MNGDecoder;

import MNGDecoder.MNGLib;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageProducer;
import java.io.File;
import java.lang.reflect.Constructor;
import java.lang.reflect.Method;
import java.net.URL;

public class MNGObject {
    private static final boolean debug_flag = false;
    public static final int UNKNOWN = 0;
    public static final int PNG = 1;
    public static final int JNG = 2;
    private Object obj;
    private int type;

    protected MNGObject() {
    }

    public static MNGObject getInstance(int n, MNGLib mNGLib) {
        MNGObject mNGObject = new MNGObject();
        Object object = MNGObject.newInstance(n, mNGLib);
        if (object != null) {
            mNGObject.obj = object;
            mNGObject.type = n;
        }
        return mNGObject;
    }

    protected static Object newInstance(int n, Object object) {
        String string = new String();
        switch (n) {
            case 1: {
                string = "PNGLib";
                break;
            }
            case 2: {
                string = "JNGLib";
                break;
            }
            default: {
                return null;
            }
        }
        try {
            Class<?> clazz = Class.forName("MNGDecoder." + string);
            Class[] classArray = new Class[1];
            Object[] objectArray = new Object[1];
            classArray[0] = Class.forName("MNGDecoder.MNGLib");
            objectArray[0] = object;
            Constructor<?> constructor = clazz.getConstructor(classArray);
            return constructor.newInstance(objectArray);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    public Object getMNGObject() {
        return this.obj;
    }

    public Image getImage() {
        switch (this.type) {
            case 1: {
                return MNGObject.getPNGImage(this.obj);
            }
            case 2: {
                return MNGObject.getJNGImage(this.obj);
            }
        }
        return null;
    }

    protected static Image getPNGImage(Object object) {
        try {
            Class<?> clazz = Class.forName("MNGDecoder.PNGImageProducer");
            Class[] classArray = new Class[1];
            Object[] objectArray = new Object[1];
            classArray[0] = Class.forName("MNGDecoder.PNGLib");
            objectArray[0] = object;
            Constructor<?> constructor = clazz.getConstructor(classArray);
            Object obj = constructor.newInstance(objectArray);
            ImageProducer imageProducer = (ImageProducer)obj;
            return Toolkit.getDefaultToolkit().createImage(imageProducer);
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return null;
        }
    }

    protected static Image getJNGImage(Object object) {
        try {
            Class<?> clazz = Class.forName("MNGDecoder.JNGImageDecoder");
            Class[] classArray = new Class[1];
            Object[] objectArray = new Object[1];
            classArray[0] = Class.forName("MNGDecoder.JNGLib");
            objectArray[0] = object;
            Method method = clazz.getMethod("getImage", classArray);
            Object object2 = method.invoke(null, objectArray);
            if (object2 != null) {
                return (Image)object2;
            }
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
        }
        return null;
    }

    public static Image getImage(File file) {
        return MNGObject.getImage((Object)file);
    }

    public static Image getImage(URL uRL) {
        return MNGObject.getImage((Object)uRL);
    }

    protected static Image getImage(Object object) {
        Class[] classArray = new Class[1];
        Object[] objectArray = new Object[1];
        classArray[0] = object.getClass();
        objectArray[0] = object;
        try {
            switch (MNGObject.detectType(object)) {
                case 1: {
                    Class<?> clazz = Class.forName("MNGDecoder.PNGLib");
                    Constructor<?> constructor = clazz.getConstructor(classArray);
                    Object obj = constructor.newInstance(objectArray);
                    return MNGObject.getPNGImage(obj);
                }
                case 2: {
                    Class<?> clazz = Class.forName("MNGDecoder.JNGLib");
                    Constructor<?> constructor = clazz.getConstructor(classArray);
                    Object obj = constructor.newInstance(objectArray);
                    return MNGObject.getJNGImage(obj);
                }
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return null;
    }

    protected static int detectType(Object object) {
        boolean bl;
        Object object2;
        Method method;
        Class<?> clazz;
        if (!(object instanceof File) && !(object instanceof URL)) {
            return 0;
        }
        Class[] classArray = new Class[1];
        Object[] objectArray = new Object[1];
        classArray[0] = object.getClass();
        objectArray[0] = object;
        try {
            clazz = Class.forName("MNGDecoder.PNGLib");
            method = clazz.getMethod("checkSignature", classArray);
            object2 = method.invoke(null, objectArray);
            bl = (Boolean)object2;
            if (bl) {
                return 1;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            clazz = Class.forName("MNGDecoder.JNGLib");
            method = clazz.getMethod("checkSignature", classArray);
            object2 = method.invoke(null, objectArray);
            bl = (Boolean)object2;
            if (bl) {
                return 2;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return 0;
    }
}

