/*
 * Decompiled with CFR 0.152.
 */
package MNGDecoder;

import MNGDecoder.MNGObject;
import MNGDecoder.MNGParam;
import MNGDecoder.MNGParamOp;
import MNGDecoder.PNGFamily;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class MNGLib
extends PNGFamily {
    private final boolean debug_flag = false;
    public static final byte[] SIGNATURE = new byte[]{-118, 77, 78, 71, 13, 10, 26, 10};
    private static final int PROFILE_VLC = 1;
    private static final int PROFILE_LC = 2;
    private static final int PROFILE_FULL = 4;
    private static final int PROFILE_TRANS = 8;
    private static final int PROFILE_JNG = 16;
    private static final int PROFILE_DELTA = 32;
    private static final int PROFILE_RESERVE = 65472;
    private static final int PROFILE_EXPERIM = 0x7FFF0000;
    private MNGParamOp param;
    private boolean flag_info;
    private boolean flag_fram;
    private boolean flag_defi;

    public MNGLib(URL uRL) {
        super(uRL, SIGNATURE);
        this.initialize();
    }

    public MNGLib(File file) {
        super(file, SIGNATURE);
        this.initialize();
    }

    private void initialize() {
        this.param = new MNGParamOp();
        this.flag_info = false;
        this.flag_fram = false;
        this.flag_defi = false;
    }

    public static boolean checkSignature(URL uRL) {
        return new MNGLib(uRL).checkSignature();
    }

    public static boolean checkSignature(File file) {
        return new MNGLib(file).checkSignature();
    }

    public boolean isSupported() {
        if (this.param.profile < 0) {
            return false;
        }
        if ((this.param.profile & 3) == 0) {
            return false;
        }
        if ((this.param.profile & 4) != 0) {
            return false;
        }
        if ((this.param.profile & 0x10) != 0) {
            return false;
        }
        if ((this.param.profile & 0x20) != 0) {
            return false;
        }
        return (this.param.profile & 0xFFC0) == 0;
    }

    public int encounterChunk() throws IOException {
        int n = this.getChunkLength();
        byte[] byArray = this.getChunkType();
        if (this.compareChunkType("MEND", byArray, 0)) {
            return 1;
        }
        if (this.compareChunkType("IHDR", byArray, 0)) {
            return 2;
        }
        if (this.compareChunkType("JHDR", byArray, 0)) {
            return 2;
        }
        byte[] byArray2 = new byte[n];
        int n2 = this.readChunkData(byArray2, 0, n);
        if (n2 < n) {
            return 0;
        }
        if (this.compareChunkType("DEFI", byArray, 0)) {
            this.flag_defi = true;
            this.param.readDEFI(n, byArray2);
        } else if (this.compareChunkType("FRAM", byArray, 0)) {
            this.flag_fram = true;
            this.param.readFRAM(n, byArray2);
        } else {
            if (this.flag_info) {
                return 0;
            }
            if (this.compareChunkType("MHDR", byArray, 0)) {
                this.param.readMHDR(n, byArray2);
            } else if (this.compareChunkType("BACK", byArray, 0)) {
                this.param.readBACK(n, byArray2);
            } else if (this.compareChunkType("TERM", byArray, 0)) {
                this.param.readTERM(n, byArray2);
            } else if (this.compareChunkType("PLTE", byArray, 0)) {
                this.param.readPLTEg(n, byArray2);
            } else if (this.compareChunkType("tRNS", byArray, 0)) {
                this.param.readtRNSg(n, byArray2);
            }
        }
        return 0;
    }

    public void reopenStream() throws IOException {
        if (this.flag_info) {
            this.param.setDefaultDEFI();
            this.param.setDefaultFRAM();
        }
        super.reopenStream();
    }

    public boolean wasFRAM() {
        return this.flag_fram;
    }

    public MNGParam getInfo() {
        return this.param.getParameter();
    }

    public boolean readInfo() throws IOException {
        this.unsetEmbeded();
        this.flag_defi = false;
        this.flag_fram = false;
        this.flag_info = this.readChunkLoop();
        if (this.flag_info) {
            if (!this.flag_defi) {
                this.param.setDefaultDEFI();
            }
            if (!this.flag_fram) {
                this.param.setDefaultFRAM();
            }
        }
        return this.flag_info;
    }

    public MNGObject getMNGObject() throws IOException {
        this.unsetEmbeded();
        if (!this.flag_info && !this.readInfo()) {
            return null;
        }
        while (!this.isEOS()) {
            MNGObject mNGObject = null;
            if (this.compareChunkType("IHDR", this.getChunkType(), 0)) {
                mNGObject = MNGObject.getInstance(1, this);
            } else if (this.compareChunkType("JHDR", this.getChunkType(), 0)) {
                mNGObject = MNGObject.getInstance(2, this);
            }
            if (mNGObject != null) {
                Object object = mNGObject.getMNGObject();
                this.setEmbeded((PNGFamily)object);
                return mNGObject;
            }
            this.flag_defi = false;
            this.flag_fram = false;
            if (this.readChunkLoop() && !this.isEOS()) continue;
            return null;
        }
        return null;
    }
}

