/*
 * Decompiled with CFR 0.152.
 */
package MNGDecoder;

import MNGDecoder.JNGParam;
import MNGDecoder.JNGParamOp;
import MNGDecoder.MNGLib;
import MNGDecoder.PNGFamily;
import java.io.File;
import java.io.IOException;
import java.net.URL;

public class JNGLib
extends PNGFamily {
    private final boolean debug_flag = false;
    public static final byte[] SIGNATURE = new byte[]{-117, 74, 78, 71, 13, 10, 26, 10};
    private JNGParamOp param;
    private boolean flag_jsep;

    public JNGLib(URL uRL) {
        super(uRL, SIGNATURE);
        this.initialize();
    }

    public JNGLib(File file) {
        super(file, SIGNATURE);
        this.initialize();
    }

    public JNGLib(MNGLib mNGLib) {
        super(mNGLib, SIGNATURE);
        this.initialize();
    }

    private void initialize() {
        this.param = new JNGParamOp();
        this.flag_jsep = false;
    }

    public static boolean checkSignature(URL uRL) {
        return new JNGLib(uRL).checkSignature();
    }

    public static boolean checkSignature(File file) {
        return new JNGLib(file).checkSignature();
    }

    public boolean isSupported() {
        if (this.param.width < 0 || this.param.width > 65535) {
            return false;
        }
        if (this.param.height < 0 || this.param.height > 65535) {
            return false;
        }
        if (this.param.color != 8 && this.param.color != 10) {
            return false;
        }
        if (this.param.depth != 8) {
            return false;
        }
        if (this.param.compress != 8) {
            return false;
        }
        return this.param.interace == 0;
    }

    public JNGParam getInfo() {
        return this.param.getParameter();
    }

    public boolean readInfo() throws IOException {
        return this.readChunkLoop();
    }

    public int encounterChunk() throws IOException {
        byte[] byArray = this.getChunkType();
        int n = this.getChunkLength();
        if (this.compareChunkType("IEND", byArray, 0)) {
            return 1;
        }
        if (this.flag_jsep) {
            return 0;
        }
        if (this.compareChunkType("JDAT", byArray, 0)) {
            return 2;
        }
        byte[] byArray2 = new byte[n];
        int n2 = this.readChunkData(byArray2, 0, n);
        if (n2 < n) {
            return 0;
        }
        if (this.compareChunkType("JSEP", byArray, 0)) {
            this.flag_jsep = true;
        } else if (this.compareChunkType("JHDR", byArray, 0)) {
            this.param.readJHDR(n, byArray2);
        }
        return 0;
    }

    public int readJDAT(byte[] byArray, int n, int n2) throws IOException {
        int n3 = 0;
        while (n3 < n2) {
            if (!this.compareChunkType("JDAT", this.getChunkType(), 0)) {
                if (this.readChunkLoop() && !this.isEOS()) continue;
                break;
            }
            if (this.getChunkRemain() <= 0) {
                if (this.readChunkLoop() && !this.isEOS()) continue;
                break;
            }
            int n4 = this.readChunkData(byArray, n + n3, n2 - n3);
            if (n4 <= 0) continue;
            n3 += n4;
        }
        if (n3 == 0 && n2 != 0) {
            n3 = -1;
        }
        return n3;
    }
}

