/*
 * Decompiled with CFR 0.152.
 */
package jaxe.elements;

import java.util.ArrayList;
import java.util.List;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TableHelper {
    private static final Logger LOG = Logger.getLogger(TableHelper.class);
    int nblignes;
    int nbcolonnes;
    String TRtag;
    String TDtag;
    String THtag;
    String colspanAttr;
    String rowspanAttr;
    Element[][] grille;
    ArrayList<Element> tableRows;

    public TableHelper(Node node, String string, String string2, String string3, String string4, String string5) {
        this.TRtag = string;
        this.TDtag = string2;
        this.THtag = string3;
        this.colspanAttr = string4;
        this.rowspanAttr = string5;
        this.grille = this.creerGrille(node);
    }

    public Element[][] getGrille() {
        return this.grille;
    }

    public Element[][] updateGrille(Node node) {
        return this.creerGrille(node);
    }

    private Element[][] creerGrille(Node node) {
        int n;
        int n2;
        this.tableRows = this.updateTableRows(node);
        this.nblignes = this.calculerNbLignes(node);
        this.nbcolonnes = this.calculerNbColonnes(node);
        this.grille = new Element[this.nblignes][this.nbcolonnes];
        for (n2 = 0; n2 < this.nblignes; ++n2) {
            for (n = 0; n < this.nbcolonnes; ++n) {
                this.grille[n2][n] = null;
            }
        }
        n2 = 0;
        n = 0;
        Element element = this.premiereLigne((Element)node);
        while (element != null) {
            for (Node node2 = element.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                String string;
                String string2;
                String string3;
                if (node2.getNodeType() != 1 || !(string3 = node2.getNodeName()).equals(this.TDtag) && !string3.equals(this.THtag)) continue;
                while (n < this.nbcolonnes && this.grille[n2][n] != null) {
                    ++n;
                }
                int n3 = 1;
                if (this.colspanAttr != null && !"".equals(string2 = ((Element)node2).getAttribute(this.colspanAttr))) {
                    try {
                        n3 = Math.max(Integer.parseInt(string2), 1);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                int n4 = 1;
                if (this.rowspanAttr != null && !"".equals(string = ((Element)node2).getAttribute(this.rowspanAttr))) {
                    try {
                        n4 = Math.max(Integer.parseInt(string), 1);
                    }
                    catch (NumberFormatException numberFormatException) {
                        // empty catch block
                    }
                }
                for (int i = 0; i < n4; ++i) {
                    for (int j = 0; j < n3; ++j) {
                        if (n + j >= this.nbcolonnes || n2 + i >= this.nblignes) {
                            LOG.error("creerGrille(Node) - Erreur: nombre de cellules dans la ligne " + n2 + " du tableau");
                            continue;
                        }
                        this.grille[n2 + i][n + j] = (Element)node2;
                    }
                }
                n += n3;
            }
            ++n2;
            n = 0;
            element = this.ligneSuivante(element);
        }
        return this.grille;
    }

    public int calculerNbLignes(Node node) {
        int n = 0;
        Element element = (Element)node;
        Element element2 = this.premiereLigne(element);
        while (element2 != null) {
            if (this.rowspanAttr != null) {
                String string = element2.getAttribute(this.rowspanAttr);
                if ("".equals(string)) {
                    ++n;
                } else {
                    int n2;
                    try {
                        n2 = Math.max(Integer.parseInt(string), 1);
                    }
                    catch (NumberFormatException numberFormatException) {
                        n2 = 1;
                    }
                    n += n2;
                }
            } else {
                ++n;
            }
            element2 = this.ligneSuivante(element2);
        }
        return n;
    }

    public int calculerNbColonnes(Node node) {
        int n = 0;
        for (int i = 0; i < this.nblignes; ++i) {
            int n2 = 0;
            Element element = this.trouverLigne(i, node);
            if (element != null) {
                for (Node node2 = element.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
                    String string;
                    if (node2.getNodeType() != 1 || !(string = node2.getNodeName()).equals(this.TDtag) && !string.equals(this.THtag)) continue;
                    if (this.colspanAttr != null) {
                        int n3;
                        String string2 = ((Element)node2).getAttribute(this.colspanAttr);
                        if ("".equals(string2)) {
                            ++n2;
                            continue;
                        }
                        try {
                            n3 = Math.max(Integer.parseInt(string2), 1);
                        }
                        catch (NumberFormatException numberFormatException) {
                            n3 = 1;
                        }
                        n2 += n3;
                        continue;
                    }
                    ++n2;
                }
            }
            n = Math.max(n, n2);
        }
        return n;
    }

    public Element premiereLigne(Element element) {
        if (this.tableRows.size() > 0) {
            return this.tableRows.get(0);
        }
        return null;
    }

    public Element ligneSuivante(Node node) {
        int n = this.tableRows.indexOf(node);
        if (n >= 0 && n < this.tableRows.size() - 1) {
            return this.tableRows.get(n + 1);
        }
        return null;
    }

    private ArrayList<Element> updateTableRows(Node node) {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        for (Node node2 = node.getFirstChild(); node2 != null; node2 = node2.getNextSibling()) {
            if (node2.getNodeType() != 1 || !node2.getNodeName().equals(this.TRtag)) continue;
            arrayList.add((Element)node2);
        }
        return arrayList;
    }

    public List<Element> getTableRows() {
        return this.tableRows;
    }

    public Element trouverLigne(int n, Node node) {
        Element element = (Element)node;
        int n2 = 0;
        Element element2 = this.premiereLigne(element);
        while (element2 != null) {
            if (n2 == n) {
                return element2;
            }
            ++n2;
            element2 = this.ligneSuivante(element2);
        }
        return null;
    }

    public int numeroLigne(Element element) {
        return this.tableRows.indexOf(element);
    }

    public Element trouverCellule(Element element, int n) {
        int n2 = this.numeroLigne(element);
        if (n2 >= this.nblignes || n >= this.nbcolonnes) {
            return null;
        }
        return this.grille[n2][n];
    }

    public boolean inTable(Node node) {
        while (node != null) {
            if (node.getNodeName().equals(this.TDtag) || node.getNodeName().equals(this.THtag)) {
                return true;
            }
            node = node.getParentNode();
        }
        return false;
    }

    public List<Element> getAllNodes() {
        ArrayList<Element> arrayList = new ArrayList<Element>();
        Element[][] elementArray = this.grille;
        int n = elementArray.length;
        for (int i = 0; i < n; ++i) {
            Element[] elementArray2;
            for (Element element : elementArray2 = elementArray[i]) {
                arrayList.add(element);
            }
        }
        return arrayList;
    }
}

