/*
 * Decompiled with CFR 0.152.
 */
package jaxe.elements;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.FlowLayout;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import javax.swing.AbstractAction;
import javax.swing.AbstractButton;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import javax.swing.border.TitledBorder;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.Document;
import javax.swing.text.JTextComponent;
import jaxe.Config;
import jaxe.DialogueAttributs;
import jaxe.ImageKeeper;
import jaxe.JaxeDocument;
import jaxe.JaxeElement;
import jaxe.VerifTypeSimple;
import org.apache.log4j.Logger;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class AffichageFormulaire
implements DocumentListener,
ActionListener,
ItemListener {
    private static final Logger LOG = Logger.getLogger(AffichageFormulaire.class);
    private static final Color couleurErreur = new Color(200, 0, 0);
    private static final Color couleurObligatoire = new Color(150, 0, 0);
    private static final Color couleurFacultatif = new Color(0, 100, 0);
    private static final ImageIcon iconeAttributs = new ImageIcon(ImageKeeper.loadImage("images/attributs.gif", true));
    private static final int profondeurMax = 10;
    private final Element defbalise;
    private Element el;
    private final AffichageFormulaire affParent;
    private final JaxeDocument doc;
    private final Config cfg;
    private ArrayList<Element> enfants;
    private JComponent comp = null;
    private final VerifTypeSimple verif;
    private final ArrayList<Element> defEnfantsPossibles;
    private final String expreg;
    private final boolean avecSchema;
    private JLabel labelTitre = null;
    private JPanel panelElement = null;
    private JPanel panelEnfants = null;
    private JPanel panelGauche = null;
    private JPanel panelDroite = null;
    private int profondeur;
    private ArrayList<AffichageFormulaire> affEnfants = null;

    public AffichageFormulaire(Element element, Element element2, AffichageFormulaire affichageFormulaire, JaxeDocument jaxeDocument) {
        this.defbalise = element;
        this.el = element2;
        this.affParent = affichageFormulaire;
        this.doc = jaxeDocument;
        this.cfg = jaxeDocument.cfg;
        this.profondeur = affichageFormulaire == null ? 0 : affichageFormulaire.getProfondeur() + 1;
        ArrayList<String> arrayList = this.cfg.listeSousbalises(element);
        this.defEnfantsPossibles = new ArrayList();
        for (String string : arrayList) {
            Element element3 = this.cfg.getBaliseDef(string);
            if (element3 == null) {
                LOG.error("Erreur : pas de d\u00e9finition pour " + string);
                continue;
            }
            this.defEnfantsPossibles.add(element3);
        }
        this.lireEnfants();
        Element element4 = this.cfg.schemaBaliseDef(this.cfg.nomBalise(element));
        this.verif = element4 != null ? this.cfg.getVerifTypeSimple(jaxeDocument, element4) : null;
        this.avecSchema = element4 != null;
        this.expreg = this.avecSchema ? this.cfg.expressionReguliere(element) : null;
    }

    private void lireEnfants() {
        if (this.el == null) {
            this.enfants = null;
            return;
        }
        this.enfants = new ArrayList();
        NodeList nodeList = this.el.getChildNodes();
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            if (node.getNodeType() != 1) continue;
            this.enfants.add((Element)node);
        }
    }

    private boolean avecEnfants() {
        return this.defEnfantsPossibles.size() > 0;
    }

    public JPanel getPanel() {
        return this.getPanel(false);
    }

    private JPanel getPanel(boolean bl) {
        Serializable serializable;
        Serializable serializable2;
        Object object;
        this.panelEnfants = new JPanel(new GridBagLayout());
        if (this.affParent != null && this.affParent.enfantsMultiples(this.defbalise) && bl) {
            this.panelElement = new JPanel(new BorderLayout());
            object = new JPanel(new BorderLayout());
            serializable2 = new JButton("+");
            ((AbstractButton)serializable2).setAction(new AbstractAction("+"){

                public void actionPerformed(ActionEvent actionEvent) {
                    AffichageFormulaire.this.affParent.ajouterAffichageEnfant(AffichageFormulaire.this);
                }
            });
            ((Container)object).add((Component)serializable2, "West");
            serializable = new JButton("-");
            ((AbstractButton)serializable).setAction(new AbstractAction("-"){

                public void actionPerformed(ActionEvent actionEvent) {
                    AffichageFormulaire.this.affParent.retirerAffichageEnfant(AffichageFormulaire.this);
                }
            });
            ((Container)object).add((Component)serializable, "East");
            this.panelElement.add((Component)object, "East");
            this.panelElement.add((Component)this.panelEnfants, "Center");
        } else {
            this.panelElement = this.panelEnfants;
        }
        object = this.cfg.titreBalise(this.defbalise);
        serializable2 = this.affParent != null ? (this.affParent.elementObligatoire(this.defbalise) ? couleurObligatoire : couleurFacultatif) : this.panelEnfants.getForeground();
        serializable = BorderFactory.createTitledBorder((String)object);
        ((TitledBorder)serializable).setTitleColor((Color)serializable2);
        this.panelEnfants.setBorder((Border)((Object)serializable));
        this.majPanel(null);
        if (this.affParent == null) {
            this.panelEnfants.setFocusCycleRoot(true);
            this.panelElement = new JPanel(new BorderLayout());
            this.panelElement.setOpaque(false);
            this.panelElement.setBorder(BorderFactory.createEmptyBorder(0, 5, 0, 5));
            this.panelElement.add((Component)this.panelEnfants, "Center");
        }
        return this.panelElement;
    }

    private void majPanel(Element element) {
        this.lireEnfants();
        if (this.profondeur > 10) {
            return;
        }
        this.panelEnfants.removeAll();
        this.affEnfants = new ArrayList();
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        int n = 0;
        if (this.aDesAttributs()) {
            JButton jButton = new JButton(iconeAttributs);
            if (System.getProperty("os.name").startsWith("Mac OS")) {
                jButton.putClientProperty("JButton.buttonType", "toolbar");
            } else {
                jButton.setMargin(new Insets(1, 2, 1, 2));
            }
            jButton.addActionListener(this);
            jButton.setActionCommand("attributs");
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n++;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            this.panelEnfants.add((Component)jButton, gridBagConstraints);
        }
        for (Element element2 : this.defEnfantsPossibles) {
            boolean bl = false;
            if (this.enfants != null) {
                int n2 = this.enfants.size();
                for (int i = 0; i < n2; ++i) {
                    Element element3 = this.enfants.get(i);
                    Element element4 = this.cfg.getElementDef(element3);
                    if (element4 != element2) continue;
                    AffichageFormulaire affichageFormulaire = new AffichageFormulaire(element4, element3, this, this.doc);
                    this.affEnfants.add(affichageFormulaire);
                    this.placerAffichage(affichageFormulaire, this.panelEnfants, gridBagConstraints, n++, element == null && i == n2 - 1);
                    bl = true;
                }
            }
            if (bl && element2 != element) continue;
            AffichageFormulaire affichageFormulaire = new AffichageFormulaire(element2, null, this, this.doc);
            this.affEnfants.add(affichageFormulaire);
            this.placerAffichage(affichageFormulaire, this.panelEnfants, gridBagConstraints, n++, true);
        }
    }

    private void placerAffichage(AffichageFormulaire affichageFormulaire, JPanel jPanel, GridBagConstraints gridBagConstraints, int n, boolean bl) {
        if (affichageFormulaire.avecEnfants()) {
            JPanel jPanel2 = affichageFormulaire.getPanel(bl);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            jPanel.add((Component)jPanel2, gridBagConstraints);
        } else {
            JPanel jPanel3 = affichageFormulaire.getPanelGauche();
            gridBagConstraints.weightx = 0.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 0;
            gridBagConstraints.anchor = 17;
            jPanel.add((Component)jPanel3, gridBagConstraints);
            JPanel jPanel4 = affichageFormulaire.getPanelDroite(bl);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.gridwidth = 1;
            gridBagConstraints.gridx = 1;
            gridBagConstraints.gridy = n;
            gridBagConstraints.fill = 2;
            gridBagConstraints.anchor = 10;
            jPanel.add((Component)jPanel4, gridBagConstraints);
        }
    }

    private String getStringLabelTitre() {
        ArrayList<String> arrayList;
        String string = "";
        if (this.el != null && (arrayList = this.cfg.getValeursParam(this.defbalise, "titreAtt")) != null) {
            for (String string2 : arrayList) {
                String string3 = this.el.getAttribute(string2);
                if ("".equals(string3)) continue;
                string = " '" + string3 + "'";
                break;
            }
        }
        return this.cfg.titreBalise(this.defbalise) + string;
    }

    private JPanel getPanelGauche() {
        this.panelGauche = new JPanel(new FlowLayout(0));
        if (this.aDesAttributs()) {
            JButton jButton = new JButton(iconeAttributs);
            if (System.getProperty("os.name").startsWith("Mac OS")) {
                jButton.putClientProperty("JButton.buttonType", "toolbar");
            } else {
                jButton.setMargin(new Insets(1, 2, 1, 2));
            }
            jButton.addActionListener(this);
            jButton.setActionCommand("attributs");
            this.panelGauche.add(jButton);
        }
        this.labelTitre = new JLabel(this.getStringLabelTitre());
        if (this.affParent != null) {
            if (this.affParent.elementObligatoire(this.defbalise)) {
                this.labelTitre.setForeground(couleurObligatoire);
            } else {
                this.labelTitre.setForeground(couleurFacultatif);
            }
        }
        this.panelGauche.add(this.labelTitre);
        return this.panelGauche;
    }

    private JPanel getPanelDroite(boolean bl) {
        JComponent jComponent;
        Serializable serializable;
        Object object;
        this.panelDroite = new JPanel(new BorderLayout());
        String string = "";
        if (this.el != null && (object = this.el.getFirstChild()) != null && object.getNodeType() == 3) {
            string = object.getNodeValue();
        }
        if (this.cfg.contientDuTexte(this.defbalise)) {
            object = null;
            serializable = null;
            if (this.verif != null) {
                object = this.verif.getBaseType();
                serializable = this.verif.getEnumeration();
            }
            if ("boolean".equals(object)) {
                jComponent = this.cfg.titreBalise(this.defbalise);
                JCheckBox jCheckBox = new JCheckBox((String)((Object)jComponent));
                if (string != null && ("true".equals(string.trim()) || "1".equals(string.trim()))) {
                    jCheckBox.setSelected(true);
                }
                jCheckBox.addItemListener(this);
                this.comp = jCheckBox;
            } else if (serializable != null) {
                if (string != null && !((ArrayList)serializable).contains(string)) {
                    serializable = new ArrayList<String>((Collection<String>)((Object)serializable));
                    ((ArrayList)serializable).add((String)string);
                }
                jComponent = new JComboBox<Object>(((ArrayList)serializable).toArray());
                ((JComboBox)jComponent).setSelectedItem(string);
                ((JComboBox)jComponent).addItemListener(this);
                this.comp = jComponent;
            } else {
                jComponent = new JTextField(string);
                ((JTextComponent)jComponent).getDocument().addDocumentListener(this);
                this.comp = jComponent;
            }
            this.panelDroite.add((Component)this.comp, "Center");
        }
        if (this.affParent != null && this.affParent.enfantsMultiples(this.defbalise) && bl) {
            object = new JPanel();
            serializable = new JButton("+");
            ((AbstractButton)serializable).setAction(new AbstractAction("+"){

                public void actionPerformed(ActionEvent actionEvent) {
                    AffichageFormulaire.this.affParent.ajouterAffichageEnfant(AffichageFormulaire.this);
                }
            });
            ((Container)object).add((Component)serializable);
            jComponent = new JButton("-");
            ((AbstractButton)jComponent).setAction(new AbstractAction("-"){

                public void actionPerformed(ActionEvent actionEvent) {
                    AffichageFormulaire.this.affParent.retirerAffichageEnfant(AffichageFormulaire.this);
                }
            });
            ((Container)object).add(jComponent);
            this.panelDroite.add((Component)object, "East");
        }
        return this.panelDroite;
    }

    public void insertUpdate(DocumentEvent documentEvent) {
        this.enregistrerChangement();
    }

    public void removeUpdate(DocumentEvent documentEvent) {
        this.enregistrerChangement();
    }

    public void changedUpdate(DocumentEvent documentEvent) {
        this.enregistrerChangement();
    }

    private void enregistrerChangement() {
        String string = this.getValeur();
        if (string == null) {
            string = "";
        }
        if (!this.doc.modif) {
            this.doc.modif = true;
        }
        if (this.el == null && !"".equals(string)) {
            this.creerElement();
        } else if (this.el != null && "".equals(string) && this.affParent != null) {
            this.effacerElement();
            return;
        }
        Node node = this.el.getFirstChild();
        if (node == null) {
            Text text = this.el.getOwnerDocument().createTextNode(string);
            this.el.appendChild(text);
        } else if (node.getNodeType() == 3) {
            node.setNodeValue(string);
        } else {
            LOG.error("AffichageFormulaire.enregistrerChangement : pas de noeud texte pour enregistrer le champ");
        }
        if (this.verif != null) {
            this.setValidite(this.verif.estValide(string));
        }
    }

    private String getValeur() {
        String string;
        if (this.comp instanceof JTextField) {
            Document document = ((JTextField)this.comp).getDocument();
            try {
                string = document.getText(0, document.getLength());
            }
            catch (BadLocationException badLocationException) {
                LOG.error("lecture du champ texte", badLocationException);
                return null;
            }
        } else {
            string = this.comp instanceof JCheckBox ? (((JCheckBox)this.comp).isSelected() ? "true" : "false") : (this.comp instanceof JComboBox ? (String)((JComboBox)this.comp).getSelectedItem() : null);
        }
        return string;
    }

    private void setValidite(boolean bl) {
        if (this.comp == null) {
            LOG.error("AffichageFormulaire.setValidite : pas de champ ?");
        }
        if (bl) {
            this.comp.setForeground(Color.black);
        } else {
            this.comp.setForeground(couleurErreur);
        }
    }

    private Element getElement() {
        return this.el;
    }

    private Element getElementDef() {
        return this.defbalise;
    }

    private int getProfondeur() {
        return this.profondeur;
    }

    private void creerElement() {
        this.el = JaxeElement.nouvelElementDOM(this.doc, this.defbalise);
        Element element = this.affParent.getElement();
        if (element == null) {
            this.affParent.creerElement();
            element = this.affParent.getElement();
            element.appendChild(this.el.getOwnerDocument().createTextNode("\n"));
        }
        Element element2 = this.affParent.trouverSuivant(this.defbalise);
        Text text = this.el.getOwnerDocument().createTextNode("\n");
        if (element2 == null) {
            element.appendChild(this.el);
            element.appendChild(text);
        } else {
            element.insertBefore(this.el, element2);
            element.insertBefore(text, element2);
        }
        this.affParent.lireEnfants();
        this.doc.textPane.miseAJourArbre();
    }

    private Element trouverSuivant(Element element) {
        int n = this.defEnfantsPossibles.indexOf(element);
        if (n == this.defEnfantsPossibles.size() - 1) {
            return null;
        }
        if (this.enfants == null) {
            return null;
        }
        for (Element element2 : this.enfants) {
            Element element3 = this.cfg.getElementDef(element2);
            int n2 = this.defEnfantsPossibles.indexOf(element3);
            if (n2 <= n) continue;
            return element2;
        }
        return null;
    }

    private void effacerElement() {
        Node node = this.el.getNextSibling();
        this.affParent.getElement().removeChild(this.el);
        if (node.getNodeType() == 3) {
            this.affParent.getElement().removeChild(node);
        }
        this.el = null;
        this.affParent.testEffacementParent();
        this.doc.textPane.miseAJourArbre();
    }

    private void testEffacementParent() {
        this.lireEnfants();
        if (this.enfants.size() == 0 && this.el != null && this.affParent != null) {
            this.effacerElement();
        }
    }

    private boolean enfantsMultiples(Element element) {
        if (!this.avecSchema) {
            return true;
        }
        if (this.expreg == null) {
            return false;
        }
        String string = "(" + this.cfg.nomBalise(element) + ")";
        return this.expreg.indexOf(string + "+") != -1 || this.expreg.indexOf(string + "*") != -1;
    }

    private boolean elementObligatoire(Element element) {
        if (!this.avecSchema) {
            return false;
        }
        if (this.expreg == null) {
            return false;
        }
        String string = "(" + this.cfg.nomBalise(element) + ")";
        return this.expreg.indexOf(string + "?") == -1 && this.expreg.indexOf(string + "*") == -1;
    }

    private boolean aDesAttributs() {
        ArrayList<Element> arrayList = this.cfg.listeAttributs(this.defbalise);
        return arrayList != null && arrayList.size() > 0;
    }

    private void ajouterAffichageEnfant(AffichageFormulaire affichageFormulaire) {
        this.majPanel(affichageFormulaire.getElementDef());
    }

    private void retirerAffichageEnfant(AffichageFormulaire affichageFormulaire) {
        if (affichageFormulaire.getElement() != null) {
            affichageFormulaire.effacerElement();
        }
        this.majPanel(null);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        String string = actionEvent.getActionCommand();
        if ("attributs".equals(string)) {
            this.afficherDialogueAttributs();
        }
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        this.enregistrerChangement();
    }

    public void afficherDialogueAttributs() {
        boolean bl;
        if (this.el == null) {
            this.creerElement();
            bl = true;
        } else {
            bl = false;
        }
        DialogueAttributs dialogueAttributs = new DialogueAttributs(this.doc.jframe, this.doc, this.cfg.titreBalise(this.defbalise), this.defbalise, this.el);
        if (dialogueAttributs.afficher()) {
            dialogueAttributs.enregistrerReponses();
            if (this.labelTitre != null) {
                this.labelTitre.setText(this.getStringLabelTitre());
            }
        } else if (bl) {
            this.effacerElement();
        }
        dialogueAttributs.dispose();
    }

    public Point getPointEnfant(Element element) {
        if (this.el == element) {
            return this.getPoint();
        }
        if (this.affEnfants != null) {
            for (AffichageFormulaire affichageFormulaire : this.affEnfants) {
                Point point = affichageFormulaire.getPointEnfant(element);
                if (point == null) continue;
                Point point2 = this.getPoint();
                if (point2 != null) {
                    point.translate(point2.x, point2.y);
                }
                return point;
            }
        }
        return null;
    }

    public Point getPoint() {
        if (this.panelElement != null) {
            return this.panelElement.getLocation();
        }
        if (this.panelGauche != null) {
            return this.panelGauche.getLocation();
        }
        return null;
    }

    public void selection(boolean bl) {
        if (bl) {
            this.panelEnfants.setBackground(JaxeElement.getMonBoutonCouleurs()[0][1]);
        } else {
            this.panelEnfants.setBackground(null);
        }
    }

    public void majAffichage() {
    }
}

