/*
 * Decompiled with CFR 0.152.
 */
package jaxe;

import com.swabunga.spell.engine.SpellDictionaryDichoDisk;
import com.swabunga.spell.engine.SpellDictionaryHashMap;
import com.swabunga.spell.swing.JTextComponentSpellChecker;
import java.awt.FileDialog;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FilenameFilter;
import java.util.ResourceBundle;
import javax.swing.AbstractAction;
import javax.swing.JFrame;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JRadioButtonMenuItem;
import javax.swing.JTextPane;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.text.JTextComponent;
import javax.swing.text.TextAction;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.UndoManager;
import jaxe.AboutBox;
import jaxe.EcouteurMAJ;
import jaxe.Jaxe;
import jaxe.JaxeFrame;
import jaxe.JaxeResourceBundle;
import jaxe.JaxeTextPane;
import jaxe.Preferences;
import jaxe.SourceFrame;
import jaxe.ValidationFrame;
import org.apache.log4j.Logger;

public class JaxeMenuBar
extends JMenuBar
implements ActionListener,
EcouteurMAJ {
    static final Logger LOG = Logger.getLogger(JaxeMenuBar.class);
    static ResourceBundle rb;
    private AboutBox aboutBox;
    private static JMenu fileMenu;
    private JMenuItem miNew;
    private JMenuItem miOpen;
    private JMenuItem miOpenConf;
    private JMenuItem miClose;
    private JMenuItem miSave;
    private JMenuItem miSaveAs;
    private JMenuItem miPrint;
    private JMenuItem miPref;
    private JMenuItem miQuitter;
    private static JMenu editMenu;
    private JMenuItem miUndo;
    private JMenuItem miRedo;
    private JMenuItem miCut;
    private JMenuItem miCopy;
    private JMenuItem miPaste;
    private JMenuItem miSelectAll;
    private JMenuItem miFind;
    private JMenuItem miAgain;
    private JMenuItem miSpelling;
    private static JMenu windowMenu;
    private static JMenu helpMenu;
    private JRadioButtonMenuItem menuArbre;
    private JRadioButtonMenuItem menuAllowed;
    private JRadioButtonMenuItem menuAttributs;
    private static int cmdMenu;
    private TextAction aColler;
    private TextAction aCopier;
    private TextAction aCouper;
    UndoAction undoAction;
    private final RedoAction redoAction;
    JaxeFrame jaxeframe;
    JFrame jframe;

    public JaxeMenuBar(JaxeFrame jaxeFrame) {
        this.jaxeframe = jaxeFrame;
        this.jframe = jaxeFrame;
        rb = JaxeResourceBundle.getRB();
        cmdMenu = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.aboutBox = null;
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
        this.addMenus();
    }

    public JaxeMenuBar(JFrame jFrame, JaxeFrame jaxeFrame) {
        this.jaxeframe = jaxeFrame;
        this.jframe = jFrame;
        rb = JaxeResourceBundle.getRB();
        cmdMenu = Toolkit.getDefaultToolkit().getMenuShortcutKeyMask();
        this.aboutBox = null;
        this.undoAction = new UndoAction();
        this.redoAction = new RedoAction();
        this.addMenus();
    }

    public void addMenus() {
        this.addFileMenuItems();
        this.addEditMenuItems();
        this.addWindowMenuItems();
        if (!System.getProperty("os.name").startsWith("Mac OS")) {
            this.addHelpMenuItems();
        }
    }

    public void addFileMenuItems() {
        fileMenu = new JMenu(rb.getString("menus.Fichier"));
        this.miNew = new JMenuItem(rb.getString("menus.Nouveau"));
        this.miNew.setAccelerator(KeyStroke.getKeyStroke(78, cmdMenu));
        fileMenu.add(this.miNew).setEnabled(true);
        this.miNew.addActionListener(this);
        this.miOpen = new JMenuItem(rb.getString("menus.Ouvrir"));
        this.miOpen.setAccelerator(KeyStroke.getKeyStroke(79, cmdMenu));
        fileMenu.add(this.miOpen).setEnabled(true);
        this.miOpen.addActionListener(this);
        this.miOpenConf = new JMenuItem(rb.getString("menus.OuvrirConf"));
        fileMenu.add(this.miOpenConf).setEnabled(true);
        this.miOpenConf.addActionListener(this);
        this.miClose = new JMenuItem(rb.getString("menus.Fermer"));
        this.miClose.setAccelerator(KeyStroke.getKeyStroke(87, cmdMenu));
        fileMenu.add(this.miClose).setEnabled(true);
        this.miClose.addActionListener(this);
        this.miSave = new JMenuItem(rb.getString("menus.Enregistrer"));
        this.miSave.setAccelerator(KeyStroke.getKeyStroke(83, cmdMenu));
        fileMenu.add(this.miSave).setEnabled(true);
        this.miSave.addActionListener(this);
        this.miSaveAs = new JMenuItem(rb.getString("menus.EnregistrerSous"));
        fileMenu.add(this.miSaveAs).setEnabled(true);
        this.miSaveAs.addActionListener(this);
        this.miPrint = new JMenuItem(rb.getString("menus.Imprimer"));
        fileMenu.add(this.miPrint).setEnabled(true);
        this.miPrint.addActionListener(this);
        if (!System.getProperty("os.name").startsWith("Mac OS")) {
            this.miPref = new JMenuItem(rb.getString("menus.Preferences"));
            fileMenu.add(this.miPref).setEnabled(true);
            this.miPref.addActionListener(this);
            this.miQuitter = new JMenuItem(rb.getString("menus.Quitter"));
            this.miQuitter.setAccelerator(KeyStroke.getKeyStroke(81, cmdMenu));
            fileMenu.add(this.miQuitter).setEnabled(true);
            this.miQuitter.addActionListener(this);
        }
        this.add(fileMenu);
    }

    public void addEditMenuItems() {
        editMenu = new JMenu(rb.getString("menus.Edition"));
        this.miUndo = editMenu.add(this.undoAction);
        this.miUndo.setAccelerator(KeyStroke.getKeyStroke(90, cmdMenu));
        this.miRedo = editMenu.add(this.redoAction);
        this.miRedo.setAccelerator(KeyStroke.getKeyStroke(82, cmdMenu));
        editMenu.addSeparator();
        this.aCouper = new ActionCouper();
        this.miCut = editMenu.add(this.aCouper);
        this.miCut.setAccelerator(KeyStroke.getKeyStroke(88, cmdMenu));
        if (this.jframe != this.jaxeframe) {
            this.miCut.setEnabled(false);
        }
        this.aCopier = new ActionCopier();
        this.miCopy = editMenu.add(this.aCopier);
        this.miCopy.setAccelerator(KeyStroke.getKeyStroke(67, cmdMenu));
        this.aColler = new ActionColler();
        this.miPaste = editMenu.add(this.aColler);
        this.miPaste.setAccelerator(KeyStroke.getKeyStroke(86, cmdMenu));
        if (this.jframe != this.jaxeframe) {
            this.miPaste.setEnabled(false);
        }
        this.miSelectAll = editMenu.add(new ActionToutSelectionner());
        this.miSelectAll.setAccelerator(KeyStroke.getKeyStroke(65, cmdMenu));
        editMenu.addSeparator();
        this.miFind = editMenu.add(new ActionRechercher());
        this.miFind.setAccelerator(KeyStroke.getKeyStroke(70, cmdMenu));
        if (this.jframe instanceof ValidationFrame) {
            this.miFind.setEnabled(false);
        }
        this.miAgain = editMenu.add(new ActionSuivant());
        this.miAgain.setAccelerator(KeyStroke.getKeyStroke(71, cmdMenu));
        if (this.jframe instanceof ValidationFrame) {
            this.miAgain.setEnabled(false);
        }
        editMenu.addSeparator();
        this.miSpelling = editMenu.add(new ActionOrthographe());
        this.add(editMenu);
    }

    public void addWindowMenuItems() {
        windowMenu = new JMenu(rb.getString("menus.Fenetres"));
        windowMenu.add(new ShowWindowAction(rb.getString("menus.FenetreHTML")));
        windowMenu.add(new ShowWindowAction(rb.getString("menus.FenetreXML")));
        windowMenu.add(new ShowWindowAction(rb.getString("menus.Validation")));
        windowMenu.add(new ShowWindowAction(rb.getString("menus.Source")));
        UIManager.put("RadioButtonMenuItem.checkIcon", UIManager.get("CheckBoxMenuItem.checkIcon"));
        this.menuArbre = new JRadioButtonMenuItem(rb.getString("menus.FenetreArbre"), this.jaxeframe.getAffichageArbre());
        this.menuArbre.addActionListener(this);
        windowMenu.add(this.menuArbre);
        this.menuAllowed = new JRadioButtonMenuItem(rb.getString("menus.FenetreAllowed"), this.jaxeframe.getAffichageAllowed());
        this.menuAllowed.addActionListener(this);
        windowMenu.add(this.menuAllowed);
        this.menuAttributs = new JRadioButtonMenuItem(rb.getString("menus.FenetreAttributs"), this.jaxeframe.getAffichageAttributs());
        this.menuAttributs.addActionListener(this);
        windowMenu.add(this.menuAttributs);
        this.add(windowMenu);
    }

    public void addHelpMenuItems() {
        helpMenu = new JMenu("?");
        helpMenu.add(new AboutAction(rb.getString("menus.APropos")));
        this.add(helpMenu);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals(this.miNew.getActionCommand())) {
            this.doNew();
        } else if (actionEvent.getActionCommand().equals(this.miOpen.getActionCommand())) {
            this.doOpen();
        } else if (actionEvent.getActionCommand().equals(this.miOpenConf.getActionCommand())) {
            this.doOpenConf();
        } else if (actionEvent.getActionCommand().equals(this.miClose.getActionCommand())) {
            this.doClose(false);
        } else if (actionEvent.getActionCommand().equals(this.miSave.getActionCommand())) {
            this.doSave();
        } else if (actionEvent.getActionCommand().equals(this.miSaveAs.getActionCommand())) {
            this.doSaveAs();
        } else if (actionEvent.getActionCommand().equals(this.miPrint.getActionCommand())) {
            this.doPrint();
        } else if (this.miPref != null && actionEvent.getActionCommand().equals(this.miPref.getActionCommand())) {
            this.doPreferences();
        } else if (this.miQuitter != null && actionEvent.getActionCommand().equals(this.miQuitter.getActionCommand())) {
            this.doQuitter();
        } else if (actionEvent.getActionCommand().equals(this.menuArbre.getActionCommand())) {
            this.jaxeframe.setAffichageArbre(!this.jaxeframe.getAffichageArbre());
        } else if (actionEvent.getActionCommand().equals(this.menuAllowed.getActionCommand())) {
            this.jaxeframe.setAffichageAllowed(!this.jaxeframe.getAffichageAllowed());
        } else if (actionEvent.getActionCommand().equals(this.menuAttributs.getActionCommand())) {
            this.jaxeframe.setAffichageAttributs(!this.jaxeframe.getAffichageAttributs());
        }
    }

    public void doNew() {
        Jaxe.dialogueNouveau(this.jaxeframe);
    }

    public void doOpen() {
        FileDialog fileDialog = new FileDialog(this.jframe);
        fileDialog.setVisible(true);
        String string = fileDialog.getFile();
        if (string != null) {
            File file = new File(fileDialog.getDirectory(), string);
            Jaxe.ouvrir(file, this.jaxeframe);
        }
    }

    public void doOpenConf() {
        FileDialog fileDialog = new FileDialog(this.jframe);
        fileDialog.setFilenameFilter(new ExtFilter("xml"));
        fileDialog.setDirectory(System.getProperty("user.dir") + File.separator + "config");
        fileDialog.setVisible(true);
        String string = fileDialog.getFile();
        if (string != null) {
            File file = new File(fileDialog.getDirectory(), string);
            Jaxe.ouvrirConf(file, this.jaxeframe);
        }
    }

    public boolean doClose(boolean bl) {
        if (this.jframe == this.jaxeframe) {
            this.jaxeframe.fermer(bl);
        } else {
            this.jframe.setVisible(false);
        }
        return true;
    }

    public void doSave() {
        this.jaxeframe.enregistrer();
    }

    public void doSaveAs() {
        this.jaxeframe.enregistrerSous();
    }

    public void doPrint() {
        if (this.jframe == this.jaxeframe) {
            this.jaxeframe.imprimer();
        } else if (this.jframe instanceof SourceFrame) {
            ((SourceFrame)this.jframe).imprimer();
        } else if (this.jframe instanceof ValidationFrame) {
            ((ValidationFrame)this.jframe).imprimer();
        }
    }

    public void doQuitter() {
        Jaxe.quitter();
    }

    public void doAbout() {
        if (this.aboutBox == null) {
            this.aboutBox = new AboutBox(this.jframe);
        }
        this.aboutBox.setResizable(false);
        this.aboutBox.setVisible(true);
    }

    public void doPreferences() {
        Preferences preferences = new Preferences(this.jframe);
        preferences.setVisible(true);
    }

    public void miseAJour() {
        this.undoAction.updateUndoState();
        this.redoAction.updateRedoState();
    }

    class RedoAction
    extends AbstractAction {
        public RedoAction() {
            super(JaxeResourceBundle.getRB().getString("menus.Retablir"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JaxeTextPane jaxeTextPane = JaxeMenuBar.this.jaxeframe.getTextPane();
            UndoManager undoManager = jaxeTextPane.getUndo();
            try {
                undoManager.redo();
            }
            catch (CannotRedoException cannotRedoException) {
                LOG.error(rb.getString("annulation.ImpossibleRetablir") + ": " + cannotRedoException, cannotRedoException);
            }
            this.updateRedoState();
            JaxeMenuBar.this.undoAction.updateUndoState();
        }

        protected void updateRedoState() {
            JaxeTextPane jaxeTextPane = JaxeMenuBar.this.jaxeframe.getTextPane();
            UndoManager undoManager = jaxeTextPane.getUndo();
            if (undoManager.canRedo()) {
                this.setEnabled(true);
                this.putValue("Name", undoManager.getRedoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", rb.getString("menus.Retablir"));
            }
        }
    }

    class UndoAction
    extends AbstractAction {
        public UndoAction() {
            super(JaxeResourceBundle.getRB().getString("menus.Annuler"));
            this.setEnabled(false);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JaxeMenuBar.this.jaxeframe.getTextPane().undo();
        }

        protected void updateUndoState() {
            JaxeTextPane jaxeTextPane = JaxeMenuBar.this.jaxeframe.getTextPane();
            UndoManager undoManager = jaxeTextPane.getUndo();
            if (undoManager.canUndo()) {
                this.setEnabled(true);
                this.putValue("Name", undoManager.getUndoPresentationName());
            } else {
                this.setEnabled(false);
                this.putValue("Name", rb.getString("menus.Annuler"));
            }
        }
    }

    class ActionOrthographe
    extends AbstractAction {
        public ActionOrthographe() {
            super(rb.getString("menus.Orthographe"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            String string = Preferences.getPref().getProperty("dictionnaire");
            if (string == null || "".equals(string)) {
                JOptionPane.showMessageDialog(JaxeMenuBar.this.jframe, JaxeResourceBundle.getRB().getString("erreur.Dictionnaire"));
                return;
            }
            int n = string.lastIndexOf(46);
            String string2 = n != -1 ? string.substring(0, n + 1) + "phon" : string + ".phon";
            try {
                File file = new File(string2);
                SpellDictionaryDichoDisk spellDictionaryDichoDisk = file.exists() ? new SpellDictionaryDichoDisk(new File(string), file, "ISO-8859-1") : new SpellDictionaryDichoDisk(new File(string));
                JTextComponentSpellChecker jTextComponentSpellChecker = new JTextComponentSpellChecker(spellDictionaryDichoDisk);
                String string3 = System.getProperty("user.home");
                String string4 = System.getProperty("os.name");
                String string5 = string4.indexOf("Windows") != -1 ? "jaxe_pers_dict" : string3 + File.separator + ".jaxe_pers_dict";
                File file2 = new File(string5);
                if (!file2.exists()) {
                    file2.createNewFile();
                }
                SpellDictionaryHashMap spellDictionaryHashMap = new SpellDictionaryHashMap(file2, file, "ISO-8859-1");
                jTextComponentSpellChecker.setUserDictionary(spellDictionaryHashMap);
                JaxeTextPane jaxeTextPane = JaxeMenuBar.this.jaxeframe.getTextPane();
                int n2 = jTextComponentSpellChecker.spellCheck(jaxeTextPane);
                if (n2 == -1) {
                    JOptionPane.showMessageDialog(JaxeMenuBar.this.jaxeframe, JaxeResourceBundle.getRB().getString("orthographe.aucuneErreur"));
                }
            }
            catch (Exception exception) {
                LOG.error("actionPerformed(ActionEvent)", exception);
            }
        }
    }

    class ActionSuivant
    extends TextAction {
        public ActionSuivant() {
            super(rb.getString("menus.RechercherSuivant"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof JaxeTextPane) {
                ((JaxeTextPane)jTextComponent).suivant();
            } else if (jTextComponent instanceof JTextPane && JaxeMenuBar.this.jframe instanceof SourceFrame) {
                ((SourceFrame)JaxeMenuBar.this.jframe).suivant();
            }
        }
    }

    class ActionRechercher
    extends TextAction {
        public ActionRechercher() {
            super(rb.getString("menus.Rechercher"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof JaxeTextPane) {
                ((JaxeTextPane)jTextComponent).rechercher();
            } else if (jTextComponent instanceof JTextPane && JaxeMenuBar.this.jframe instanceof SourceFrame) {
                ((SourceFrame)JaxeMenuBar.this.jframe).rechercher();
            }
        }
    }

    static class ActionToutSelectionner
    extends TextAction {
        public ActionToutSelectionner() {
            super(rb.getString("menus.ToutSelectionner"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof JaxeTextPane) {
                ((JaxeTextPane)jTextComponent).toutSelectionner();
            } else if (jTextComponent != null) {
                jTextComponent.selectAll();
            }
        }
    }

    protected class ActionColler
    extends TextAction {
        public ActionColler() {
            super(rb.getString("menus.Coller"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof JaxeTextPane) {
                ((JaxeTextPane)jTextComponent).coller();
            } else if (jTextComponent != null) {
                jTextComponent.paste();
            }
        }
    }

    protected class ActionCopier
    extends TextAction {
        public ActionCopier() {
            super(rb.getString("menus.Copier"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof JaxeTextPane) {
                ((JaxeTextPane)jTextComponent).copier();
            } else if (jTextComponent != null) {
                jTextComponent.copy();
            }
        }
    }

    protected class ActionCouper
    extends TextAction {
        public ActionCouper() {
            super(rb.getString("menus.Couper"));
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JTextComponent jTextComponent = this.getTextComponent(actionEvent);
            if (jTextComponent instanceof JaxeTextPane) {
                ((JaxeTextPane)jTextComponent).couper();
            } else if (jTextComponent != null) {
                jTextComponent.cut();
            }
        }
    }

    protected class AboutAction
    extends AbstractAction {
        public AboutAction(String string) {
            super(string);
        }

        public void actionPerformed(ActionEvent actionEvent) {
            JaxeMenuBar.this.doAbout();
        }
    }

    protected class ShowWindowAction
    extends AbstractAction {
        String titre;

        public ShowWindowAction(String string) {
            super(string);
            this.titre = string;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.titre.equals(rb.getString("menus.FenetreHTML"))) {
                JaxeMenuBar.this.jaxeframe.activerHTMLFrame();
            } else if (this.titre.equals(rb.getString("menus.Validation"))) {
                JaxeMenuBar.this.jaxeframe.activerValidationFrame();
            } else if (this.titre.equals(rb.getString("menus.Source"))) {
                JaxeMenuBar.this.jaxeframe.activerSourceFrame();
            } else {
                JaxeMenuBar.this.jaxeframe.toFront();
            }
        }
    }

    class ExtFilter
    implements FilenameFilter {
        String[] exta;

        public ExtFilter(String string) {
            this.exta = new String[1];
            this.exta[0] = string;
        }

        public ExtFilter(String[] stringArray) {
            this.exta = stringArray;
        }

        public boolean accept(File file, String string) {
            for (String string2 : this.exta) {
                if (!string.endsWith("." + string2)) continue;
                return true;
            }
            return false;
        }
    }
}

